/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.utils;

import com.jamonapi.utils.ArraySorter;
import com.jamonapi.utils.ToArray;
import java.lang.reflect.Constructor;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class Misc {
    static final Date NULL_DATE = new Date(0L);
    private static Format monthFormat = new SimpleDateFormat("MM");
    private static Format dayOfWeekFormat = new SimpleDateFormat("E");
    private static Format shortDateFormat = new SimpleDateFormat("MM/dd/yy");

    public static String getClassName(Object object) {
        String className = object == null ? "null" : object.getClass().getName();
        return className.substring(className.lastIndexOf(".") + 1);
    }

    public static String getExceptionTrace(Throwable exception) {
        StackTraceElement[] elements = exception.getStackTrace();
        StringBuffer trace = new StringBuffer().append(exception).append("\n");
        int i = 0;
        while (i < elements.length) {
            trace.append(elements[i]).append("\n");
            ++i;
        }
        return trace.toString();
    }

    public static void addTo(Collection coll, Object objToAdd) {
        if (objToAdd instanceof Collection) {
            coll.addAll((Collection)objToAdd);
        } else if (objToAdd instanceof Object[]) {
            coll.addAll(Arrays.asList((Object[])objToAdd));
        } else if (objToAdd instanceof ToArray) {
            coll.addAll(Arrays.asList(((ToArray)objToAdd).toArray()));
        } else {
            coll.add(objToAdd);
        }
    }

    public static String getAsString(Object obj) {
        block7: {
            try {
                if (obj != null) break block7;
                return null;
            }
            catch (Throwable e) {
                return "???";
            }
        }
        if (obj instanceof Collection) {
            return Misc.getCollAsString((Collection)obj);
        }
        if (obj instanceof Object[]) {
            return Misc.getArrAsString((Object[])obj);
        }
        if (obj instanceof ToArray) {
            return Misc.getArrAsString(((ToArray)obj).toArray());
        }
        if (obj instanceof Throwable) {
            return Misc.getExceptionTrace((Throwable)obj);
        }
        return obj.toString();
    }

    private static String getCollAsString(Collection coll) {
        int currentElement = 1;
        int lastElement = coll.size();
        Iterator iter = coll.iterator();
        StringBuffer buff = new StringBuffer();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof Throwable) {
                obj = Misc.getExceptionTrace((Throwable)obj);
            }
            buff.append(obj);
            if (currentElement != lastElement) {
                buff.append(",\n");
            }
            ++currentElement;
        }
        return buff.toString();
    }

    private static String getArrAsString(Object[] arr) {
        int lastElement = arr.length - 1;
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < arr.length) {
            Object obj = arr[i];
            if (obj instanceof Throwable) {
                obj = Misc.getExceptionTrace((Throwable)obj);
            }
            buff.append(obj);
            if (i != lastElement) {
                buff.append(",\n");
            }
            ++i;
        }
        return buff.toString();
    }

    public static void isObjectString(Object arg) {
        if (!(arg instanceof String)) {
            throw new IllegalArgumentException("Illegal Argument exception: This object must be of type String.");
        }
    }

    public static Object[][] sort(Object[][] array, int sortCol, String sortOrder) {
        ArraySorter sorter = new ArraySorter(array, sortCol, sortOrder);
        return sorter.sort();
    }

    public static void disp(Object[][] data) {
        int i = 0;
        while (i < data.length) {
            System.out.println();
            System.out.print("row=" + i + ", data=");
            int j = 0;
            while (j < data[i].length) {
                System.out.print(String.valueOf(data[i][j]) + ",");
                ++j;
            }
            ++i;
        }
        System.out.println();
    }

    public static String[] trim(String[] array) {
        int len = array == null ? 0 : array.length;
        int i = 0;
        while (i < len) {
            array[i] = array[i].trim();
            ++i;
        }
        return array;
    }

    public static Object[][] allocateArray(int rows, int cols) {
        if (rows <= 0 || cols <= 0) {
            return null;
        }
        Object[][] data = new Object[rows][];
        int i = 0;
        while (i < cols) {
            data[i] = new Object[cols];
            ++i;
        }
        return data;
    }

    public static String getFormattedDateNow(String format) {
        return Misc.getFormattedDate(format, new Date());
    }

    public static String getFormattedDate(String format, Date date) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String getMonth(Date date) {
        return monthFormat.format(date);
    }

    public static String getMonth() {
        return Misc.getMonth(new Date());
    }

    public static String getDayOfWeek(Date date) {
        return dayOfWeekFormat.format(date);
    }

    public static String getDayOfWeek() {
        return Misc.getDayOfWeek(new Date());
    }

    public static String getShortDate(Date date) {
        return shortDateFormat.format(date);
    }

    public static String getShortDate() {
        return Misc.getShortDate(new Date());
    }

    public static Map createCaseInsensitiveMap() {
        return new TreeMap(String.CASE_INSENSITIVE_ORDER);
    }

    public static Map createConcurrentMap(int size) {
        Map map = null;
        try {
            Class<?> cls = Class.forName("java.util.concurrent.ConcurrentHashMap");
            Class[] constructorArgs = new Class[]{Integer.TYPE};
            Constructor<?> ct = cls.getConstructor(constructorArgs);
            Object[] params = new Object[]{new Integer(size)};
            map = (Map)ct.newInstance(params);
        }
        catch (Exception e) {
            map = Collections.synchronizedMap(new HashMap(size));
        }
        return map;
    }

    static int compare(Date date1, Date date2) {
        int BEFORE = -1;
        boolean AFTER = true;
        if (Misc.isDateNull(date1) && Misc.isDateNull(date2)) {
            return 0;
        }
        if (Misc.isDateNull(date1)) {
            return -1;
        }
        if (Misc.isDateNull(date2)) {
            return 1;
        }
        return date1.compareTo(date2);
    }

    private static boolean isDateNull(Date date) {
        return date == null || NULL_DATE.equals(date);
    }

    public static Date min(Date date1, Date date2) {
        if (Misc.isDateNull(date1)) {
            return date2;
        }
        if (Misc.isDateNull(date2)) {
            return date1;
        }
        return Misc.compare(date1, date2) <= 0 ? date1 : date2;
    }

    public static Date max(Date date1, Date date2) {
        if (Misc.isDateNull(date1)) {
            return date2;
        }
        if (Misc.isDateNull(date2)) {
            return date1;
        }
        return Misc.compare(date1, date2) >= 0 ? date1 : date2;
    }
}

