/*
 * Decompiled with CFR 0.152.
 */
package de.itu.bmu;

import de.itu.bmu.BMUAdresse;
import de.itu.bmu.BMUName;
import de.itu.bmu.BMUPostfachAdresse;
import de.itu.bmu.BMUStrassenAdresse;
import de.itu.xml.XPathFacade;
import de.itu.xml.XmlException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BMUNameUndAdresse {
    private static final Logger _logger = LogManager.getLogger(BMUNameUndAdresse.class);
    private BMUName _name;
    private BMUAdresse _adresse;

    public BMUNameUndAdresse(Element elem) {
        if (elem != null) {
            XPathFacade xpf = XPathFacade.getInstance();
            try {
                Node adresse;
                Node name = xpf.evaluateNode(elem, "lib:Name");
                if (name != null) {
                    this._name = new BMUName((Element)name);
                }
                if ((adresse = xpf.evaluateNode(elem, "lib:Adresse")) != null) {
                    this._adresse = new BMUStrassenAdresse((Element)adresse);
                } else {
                    adresse = xpf.evaluateNode(elem, "lib:Postfach");
                    if (adresse != null) {
                        this._adresse = new BMUPostfachAdresse((Element)adresse);
                    }
                }
            }
            catch (XmlException e) {
                _logger.error("Fehler bei der XPath-Auswertung", (Throwable)e);
            }
        }
    }

    public BMUName getName() {
        return this._name;
    }

    public BMUAdresse getAdresse() {
        return this._adresse;
    }
}

