/*
 * Decompiled with CFR 0.152.
 */
package de.itu.bmu;

import de.itu.bmu.BMURegCharge;
import de.itu.xml.XPathFacade;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;

public abstract class BMURegChargeBGS
extends BMURegCharge {
    private static final Logger _logger = LogManager.getLogger(BMURegChargeBGS.class);
    private String _bgsNummer;
    private ChargeBGSType _chargeBGSType;

    public BMURegChargeBGS(ChargeBGSType chargeType, Element charge, int index, Object parent) {
        super(BMURegCharge.ChargeType.BGSsolo, index, parent);
        this._chargeBGSType = chargeType;
        try {
            this._bgsNummer = XPathFacade.getInstance().evaluate(charge, "descendant::lib:PaginierNr[parent::bgs:BGSNummer][1]");
        }
        catch (Exception e) {
            _logger.error("Fehler beim ermitteln der Daten", (Throwable)e);
        }
    }

    @Override
    public String getNummer() {
        return this._bgsNummer;
    }

    public ChargeBGSType getBGSType() {
        return this._chargeBGSType;
    }

    @Override
    public String toString() {
        return String.valueOf((Object)this._chargeBGSType) + ": " + this._bgsNummer;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BMURegChargeBGS)) {
            return false;
        }
        if (this._bgsNummer == null) {
            return ((BMURegChargeBGS)obj)._bgsNummer == null;
        }
        return this._bgsNummer.equals(((BMURegChargeBGS)obj)._bgsNummer);
    }

    public static enum ChargeBGSType {
        BGSDokument,
        BGSExzerpt;

    }
}

