/*
 * Decompiled with CFR 0.152.
 */
package de.itu.bmu;

import de.itu.xml.GenericNamespaceContext;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;

public class XPathUtil {
    private static final Logger _logger = LogManager.getLogger(XPathUtil.class);
    public static final String URI_LIB = "uri:BMU_Waste_Interface/Bibliothek";
    public static final String URI_CAT = "uri:BMU_Waste_Interface/Kataloge";
    public static final String URI_MSG = "uri:BMU_Waste_Interface/Message";
    public static final String URI_BGS = "uri:BMU_Waste_Interface/BGS";
    public static final String URI_EN = "uri:BMU_Waste_Interface/EN";
    public static final String URI_NTZ = "uri:BMU_Waste_Interface/Ntz";
    public static final String URI_REG = "uri:BMU_Waste_Interface/Reg";
    public static final String URI_AGS = "uri:BMU_Waste_Interface/AGS";
    public static final String URI_ZKS = "uri:BMU_Waste_Interface/ZKS";
    public static final String URI_DS = "http://www.w3.org/2000/09/xmldsig#";
    public static final String XPATH_DOCTYPE = "local-name(/msg:Nachricht/msg:Nutzdaten/*)";
    public static final String XPATH_SENDER_BEHNR = "/msg:Nachricht/msg:Kopfdaten/msg:Absender/lib:Struktur/lib:BehoerdlicheNummer/lib:BehoerdlicheNr";
    public static final String XPATH_SENDER_PZ = "/msg:Nachricht/msg:Kopfdaten/msg:Absender/lib:Struktur/lib:BehoerdlicheNummer/lib:Pruefziffer";
    public static final String XPATH_SENDER_ROLLE = "/msg:Nachricht/msg:Kopfdaten/msg:Absender/lib:Struktur/lib:BehoerdlicheNummer/@lib:ATBRolle";
    public static final String XPATH_RECEIVER_BEHNR = "/msg:Nachricht/msg:Kopfdaten/msg:Empfaenger/lib:Struktur/lib:BehoerdlicheNummer/lib:BehoerdlicheNr";
    public static final String XPATH_RECEIVER_PZ = "/msg:Nachricht/msg:Kopfdaten/msg:Empfaenger/lib:Struktur/lib:BehoerdlicheNummer/lib:Pruefziffer";
    public static final String XPATH_RECEIVER_ROLLE = "/msg:Nachricht/msg:Kopfdaten/msg:Empfaenger/lib:Struktur/lib:BehoerdlicheNummer/@lib:ATBRolle";
    public static final String XPATH_BGSUNS_KFZ = "descendant::bgs:Zugmaschine[ancestor::bgs:Befoerderer[bgs:LfdNrBefoerderer=1]][last()]";
    private static XPathUtil _theInstance = null;
    private XPathFactory _xf = XPathFactory.newInstance();
    private GenericNamespaceContext _ctx = new GenericNamespaceContext();

    private XPathUtil() {
        this._ctx.setNamespace("msg", URI_MSG);
        this._ctx.setNamespace("bgs", URI_BGS);
        this._ctx.setNamespace("en", URI_EN);
        this._ctx.setNamespace("ntz", URI_NTZ);
        this._ctx.setNamespace("reg", URI_REG);
        this._ctx.setNamespace("zks", URI_ZKS);
        this._ctx.setNamespace("ags", URI_AGS);
        this._ctx.setNamespace("lib", URI_LIB);
        this._ctx.setNamespace("cat", URI_CAT);
        this._ctx.setNamespace("ds", URI_DS);
    }

    public static XPathUtil getInstance() {
        if (_theInstance == null) {
            _theInstance = new XPathUtil();
        }
        return _theInstance;
    }

    public String evaluate(String xPath, Document doc) {
        String retVal = null;
        XPath xp = this._xf.newXPath();
        xp.setNamespaceContext(this._ctx);
        try {
            retVal = xp.evaluate(xPath, doc);
            _logger.debug("evaluating " + xPath + ", result=" + retVal);
        }
        catch (XPathExpressionException e) {
            _logger.error("Fehler bei der Auswertung von " + xPath, (Throwable)e);
        }
        return retVal;
    }

    public String getDocNummer(DocType docType, Document doc) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.evaluate(docType.getXPathNr(), doc));
        if (docType.getXPathPZ() != null) {
            buf.append(this.evaluate(docType.getXPathPZ(), doc));
        }
        while (buf.length() < 15) {
            buf.append(' ');
        }
        return buf.substring(0, 15);
    }

    public String getAbsender(Document doc) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.evaluate(XPATH_SENDER_BEHNR, doc));
        buf.append(this.evaluate(XPATH_SENDER_PZ, doc));
        buf.append(this.evaluate(XPATH_SENDER_ROLLE, doc));
        while (buf.length() < 16) {
            buf.append(' ');
        }
        return buf.substring(0, 16);
    }

    public String getEmpfaenger(Document doc) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.evaluate(XPATH_RECEIVER_BEHNR, doc));
        buf.append(this.evaluate(XPATH_RECEIVER_PZ, doc));
        buf.append(this.evaluate(XPATH_RECEIVER_ROLLE, doc));
        while (buf.length() < 16) {
            buf.append(' ');
        }
        return buf.substring(0, 16);
    }

    public String getKfz(Document doc) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.evaluate(XPATH_BGSUNS_KFZ, doc));
        while (buf.length() < 10) {
            buf.append(' ');
        }
        return buf.substring(0, 10);
    }

    public String getSubject(Document doc) {
        StringBuffer buf = new StringBuffer();
        String documentType = this.evaluate(XPATH_DOCTYPE, doc);
        if (documentType != null && documentType.length() > 0) {
            DocType docType = DocType.valueOf(documentType);
            buf.append(this.getEmpfaenger(doc));
            buf.append(this.getAbsender(doc));
            buf.append(docType.getType());
            buf.append(this.getDocNummer(docType, doc));
            if (docType == DocType.BGSDokument || docType == DocType.UNSDokument) {
                buf.append(this.getKfz(doc));
            }
        }
        return buf.toString();
    }

    public String getSubject(File f) {
        String subject = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(f);
            subject = this.getSubject(doc);
        }
        catch (Exception ex) {
            _logger.error("Fehler beim Parsen von " + f.getAbsolutePath(), (Throwable)ex);
        }
        return subject;
    }

    public static enum DocType {
        ENSNDokument("ENS", "descendant::lib:NachweisNr[ancestor::en:Nachweisnummer][1]", "descendant::lib:Pruefziffer[ancestor::en:Nachweisnummer][1]"),
        FRDokument("FR ", "descendant::lib:FreistellungsNr[ancestor::en:Freistellungsnummer][1]", "descendant::lib:Pruefziffer[ancestor::en:Freistellungsnummer][1]"),
        BGSDokument("BGS", "descendant::lib:PaginierNr[ancestor::bgs:BGSNummer][1]", "descendant::lib:Pruefziffer[ancestor::bgs:BGSNummer][1]"),
        UNSDokument("UNS", "descendant::lib:PaginierNr[ancestor::bgs:UNSNummer][1]", "descendant::lib:PaginierNr[ancestor::bgs:UNSNummer][1]"),
        RegisterAnforderung("RA ", "descendant::lib:RegisterNr[ancestor::reg:Registerauszugsnummer]", "descendant::lib:Pruefziffer[ancestor::reg:Registerauszugsnummer]"),
        RegisterAuszug("RG ", "descendant::lib:RegisterNr[ancestor::reg:Registerauszugsnummer]", "descendant::lib:Pruefziffer[ancestor::reg:Registerauszugsnummer]"),
        Abfallverbringungsdokument("AVD", "msg:Nachricht/@msg:MsgUUID", null),
        Quittung("QT ", "msg:Nachricht/@msg:MsgUUID", null),
        Mitteilung("MT ", "msg:Nachricht/@msg:MsgUUID", null),
        BGSNrAnforderung("NRA", "msg:Nachricht/@msg:MsgUUID", null),
        BGSNrZuteilung("NRZ", "msg:Nachricht/@msg:MsgUUID", null),
        Registrierungsantrag("RAN", "descendant::zks:AntragUUID", ""),
        RegistrierungsantragZKS("ANI", "descendant::zks:AntragUUID", ""),
        Registrierungsauftrag("RAU", "descendant::zks:AntragUUID", null),
        RegistrierungsauftragZKS("AUI", "descendant::zks:AntragUUID", null),
        Zertifikatsuebermittlung("RZT", "msg:Nachricht/@msg:MsgUUID", null),
        Registrierungsquittung("RQT", "descendant::zks:AntragUUID", null),
        Adressanfrage("ASA", "descendant::zks:AnfrageUUID", null),
        Adressantwort("ASL", "descendant::zks:AnfrageUUID", null),
        Adressanforderung("AST", "descendant::zks:AnforderungUUID", null),
        Adressauskunft("ASZ", "descendant::zks:AnforderungUUID", null),
        ZKSAuftrag("ZBA", "descendant::zks:AuftragUUID", null),
        ZKSErgebnis("ZBE", "descendant::zks:AuftragUUID", null),
        ZKSParameterAnfrage("ZPA", "msg:Nachricht/@msg:MsgUUID", null),
        ZKSParameterErgebnis("ZPE", "msg:Nachricht/@msg:MsgUUID", null),
        Nachweisliste("NWL", "descendant::lib:PaginierNr[ancestor::zks:Nachweislistennummer]", "descendant::lib:Pruefziffer[ancestor::zks:Nachweislistennummer]"),
        EGFDokument("EGF", "descendant::lib:NachweisNr[ancestor::en:ENSNNummer]", "descendant::lib:Pruefziffer[ancestor::en:ENSNNummer]"),
        AGSBescheid("EGB", "descendant::lib:NachweisNr[ancestor::ags:ENSNNummer]", "descendant::lib:Pruefziffer[ancestor::ags:ENSNNummer]"),
        DADokument("DA ", "descendant::lib:NachweisNr[ancestor::en:Nachweisnummer]", "descendant::lib:Pruefziffer[ancestor::en:Nachweisnummer]");

        private final String _type;
        private final String _xPathNr;
        private final String _xPathPZ;

        private DocType(String type, String xPathNr, String xPathPZ) {
            this._type = type;
            this._xPathNr = xPathNr;
            this._xPathPZ = xPathPZ;
        }

        public String getType() {
            return this._type;
        }

        public String getXPathNr() {
            return this._xPathNr;
        }

        public String getXPathPZ() {
            return this._xPathPZ;
        }
    }

    public static enum Rolle {
        ERZ,
        BEF,
        ENT,
        ZWL,
        BEH,
        MAK,
        BEVERZ,
        PROV,
        SONST;

    }
}

