/*
 * Decompiled with CFR 0.152.
 */
package de.itu.util;

import de.focus_shift.jollyday.core.HolidayCalendar;
import de.focus_shift.jollyday.core.HolidayManager;
import de.focus_shift.jollyday.core.ManagerParameter;
import de.focus_shift.jollyday.core.ManagerParameters;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JollyDayUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    private static HolidayManager holidayManager = HolidayManager.getInstance((ManagerParameter)ManagerParameters.create((HolidayCalendar)HolidayCalendar.GERMANY));
    static final Set<DayOfWeek> businessDays = Set.of(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);

    public static long calcWorkingDays(LocalDate beginDate, LocalDate endDate, String ... args) {
        endDate = endDate.plusDays(1L);
        long retVal = -1L;
        if (LOGGER.isDebugEnabled()) {
            long days = ChronoUnit.DAYS.between(beginDate, endDate);
            long businessdays = beginDate.datesUntil(endDate).filter(t -> businessDays.contains(t.getDayOfWeek())).count();
            List workdays = beginDate.datesUntil(endDate).filter(t -> businessDays.contains(t.getDayOfWeek())).filter(t -> !holidayManager.isHoliday(t, args)).collect(Collectors.toList());
            ArrayList holidays = new ArrayList(holidayManager.getHolidays(beginDate, endDate.minusDays(1L), args));
            Collections.sort(holidays);
            LOGGER.debug("beginDate: " + String.valueOf(beginDate) + ", endDate: " + String.valueOf(endDate) + ", days: " + days + ", business days: " + businessdays + ", holidays: " + String.valueOf(holidays) + ", working days: " + workdays.size());
            retVal = workdays.size();
        } else {
            retVal = beginDate.datesUntil(endDate).filter(t -> businessDays.contains(t.getDayOfWeek())).filter(t -> !holidayManager.isHoliday(t, args)).count();
        }
        return retVal;
    }

    public static LocalDate calcEndDateAfterXWorkingDays(LocalDate beginDate, long workdays, String ... args) {
        int founddays = 0;
        LocalDate endDate = beginDate;
        while ((long)founddays < workdays) {
            if (businessDays.contains(endDate.getDayOfWeek()) && !holidayManager.isHoliday(endDate, args)) {
                ++founddays;
            }
            if ((long)founddays >= workdays) continue;
            endDate = ChronoUnit.DAYS.addTo(endDate, 1L);
        }
        return endDate;
    }
}

