/*
 * Decompiled with CFR 0.152.
 */
package de.itu.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSLCertHelper {
    private static final Logger _logger = LogManager.getLogger(SSLCertHelper.class);
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    public static boolean checkSSLCert(String host, int port) {
        File file = new File("jssecacerts");
        if (!file.isFile()) {
            char SEP = File.separatorChar;
            File dir = new File(System.getProperty("java.home") + SEP + "lib" + SEP + "security");
            file = new File(dir, "jssecacerts");
            if (!file.isFile()) {
                file = new File(dir, "cacerts");
            }
        }
        _logger.info("Loading KeyStore " + String.valueOf(file) + "...");
        try {
            System.setProperty("javax.net.ssl.trustStore", file.getAbsolutePath());
            System.setProperty("javax.net.ssl.trustStorePassword", "changeit");
            FileInputStream in = new FileInputStream(file);
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            char[] pw = new char[]{'c', 'h', 'a', 'n', 'g', 'e', 'i', 't'};
            ks.load(in, pw);
            ((InputStream)in).close();
            SSLContext context = SSLContext.getInstance("TLS");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
            SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
            context.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory factory = context.getSocketFactory();
            _logger.info("Opening connection to " + host + ":" + port + "...");
            SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
            socket.setSoTimeout(10000);
            try {
                _logger.info("Starting SSL handshake...");
                socket.startHandshake();
                socket.close();
                System.setProperty("javax.net.ssl.trustStore", file.getAbsolutePath());
                System.setProperty("javax.net.ssl.trustStorePassword", "changeit");
                _logger.info("No errors, certificate is already trusted");
                return true;
            }
            catch (SSLException e) {
                _logger.info(e.getMessage());
                X509Certificate[] chain = tm.chain;
                if (chain == null) {
                    _logger.warn("Could not obtain server certificate chain");
                    return false;
                }
                _logger.info("Server sent " + chain.length + " certificate(s):");
                MessageDigest sha1 = MessageDigest.getInstance("SHA1");
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                for (int i = 0; i < chain.length; ++i) {
                    X509Certificate cert = chain[i];
                    _logger.debug(" " + (i + 1) + " Subject " + cert.getSubjectX500Principal().getName());
                    _logger.debug("   Issuer  " + cert.getIssuerX500Principal().getName());
                    sha1.update(cert.getEncoded());
                    _logger.debug("   sha1    " + SSLCertHelper.toHexString(sha1.digest()));
                    md5.update(cert.getEncoded());
                    _logger.debug("   md5     " + SSLCertHelper.toHexString(md5.digest()));
                }
                X509Certificate cert = chain[0];
                String alias = host + "-1";
                ks.setCertificateEntry(alias, cert);
                file = new File("jssecacerts");
                FileOutputStream out = new FileOutputStream(file);
                ks.store(out, pw);
                ((OutputStream)out).close();
                System.setProperty("javax.net.ssl.trustStore", file.getAbsolutePath());
                System.setProperty("javax.net.ssl.trustStorePassword", "changeit");
                _logger.debug((Object)cert);
                _logger.info("Added certificate to keystore '" + file.getAbsolutePath() + "' using alias '" + alias + "'");
                return true;
            }
        }
        catch (Exception e) {
            _logger.error("Fehler", (Throwable)e);
            return false;
        }
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int n : bytes) {
            sb.append(HEXDIGITS[(n &= 0xFF) >> 4]);
            sb.append(HEXDIGITS[n & 0xF]);
            sb.append(' ');
        }
        return sb.toString();
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }
    }
}

