/*
 * Decompiled with CFR 0.152.
 */
package de.itu.util;

import de.consist.bmu.rule.util.CertUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class X509CertHelper {
    public static final String SYSCONF_CHARMAP = "X509CertHelper.charMapFile";
    private static final String T_61_ENCODING_FILE = "/de/itu/res/t.61.enc";
    private static Logger _logger = LogManager.getLogger(X509CertHelper.class);
    private static Map<Byte, Map<Byte, Character>> _t61_encoding_map = null;

    public static String extractCommonName(String cert) {
        String retVal = "no name";
        try {
            retVal = CertUtils.getSubjectCN((X509Certificate)CertUtils.getX509CertificateFromBase64((String)cert));
        }
        catch (Exception ex) {
            _logger.error("extractCommonName", (Throwable)ex);
        }
        return retVal;
    }

    public static String extractCommonName(byte[] cert) {
        String retVal = "no name";
        try {
            retVal = CertUtils.getSubjectCN((X509Certificate)CertUtils.getX509Certificate((byte[])cert));
        }
        catch (Exception ex) {
            _logger.error("extractCommonName", (Throwable)ex);
        }
        return retVal;
    }

    public static String extractCommonName(X509Certificate cert) {
        String retVal = "no name";
        try {
            retVal = CertUtils.getSubjectCN((X509Certificate)cert);
        }
        catch (Exception ex) {
            _logger.error("extractCommonName", (Throwable)ex);
        }
        return retVal;
    }

    public static String extractIssuerCommonName(X509Certificate cert) {
        Object retVal = null;
        try {
            retVal = CertUtils.getIssuerCN((X509Certificate)cert);
        }
        catch (Exception ex) {
            retVal = "#FEHLER: " + ex.getMessage();
            _logger.error("<extractIssuerCommonName>", (Throwable)ex);
        }
        return retVal;
    }

    public static String extractIssuerCommonName(byte[] cert) {
        Object retVal = null;
        try {
            retVal = CertUtils.getIssuerCN((X509Certificate)CertUtils.getX509Certificate((byte[])cert));
        }
        catch (Exception ex) {
            retVal = "#FEHLER: " + ex.getMessage();
            _logger.error("<extractIssuerCommonName>", (Throwable)ex);
        }
        return retVal;
    }

    public static String extractIssuerCommonName(String cert) {
        String retVal = "no name";
        try {
            retVal = CertUtils.getIssuerCN((X509Certificate)CertUtils.getX509CertificateFromBase64((String)cert));
        }
        catch (Exception ex) {
            _logger.error("extractCommonName", (Throwable)ex);
        }
        return retVal;
    }

    public static Map<Byte, Map<Byte, Character>> getT61CharMap() {
        InputStream is = X509CertHelper.class.getResourceAsStream(T_61_ENCODING_FILE);
        if (_t61_encoding_map == null) {
            _t61_encoding_map = new HashMap<Byte, Map<Byte, Character>>(57);
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String cl = br.readLine();
                while (cl != null) {
                    StringTokenizer st = new StringTokenizer(cl);
                    if (st.hasMoreElements()) {
                        String code = st.nextToken();
                        Byte escapeCode = Integer.decode(code).byteValue();
                        Map<Object, Object> temp = null;
                        if (!_t61_encoding_map.containsKey(escapeCode)) {
                            temp = new HashMap();
                            _t61_encoding_map.put(escapeCode, temp);
                        } else {
                            temp = _t61_encoding_map.get(escapeCode);
                        }
                        Byte charCode = Byte.decode(st.nextToken());
                        String destCode = st.nextToken();
                        Character val = Character.valueOf(destCode.charAt(0));
                        temp.put(charCode, val);
                    }
                    cl = br.readLine();
                }
            }
            catch (Exception ex) {
                _logger.error("error loading char map", (Throwable)ex);
            }
        }
        return _t61_encoding_map;
    }

    public static String decodeT61(String orgVal) {
        Map<Byte, Map<Byte, Character>> charMap = X509CertHelper.getT61CharMap();
        StringBuffer buf = new StringBuffer(orgVal.length());
        byte[] data = null;
        try {
            data = orgVal.getBytes("Cp1252");
        }
        catch (UnsupportedEncodingException e) {
            _logger.error("This should not be happening.", (Throwable)e);
        }
        for (int i = 0; i < data.length; ++i) {
            Map<Byte, Character> charcodeMap = charMap.get(data[i]);
            if (charcodeMap != null) {
                Character destCode = charcodeMap.get(data[i + 1]);
                buf.append(destCode.charValue());
                ++i;
                continue;
            }
            if (data[i] == -90) {
                buf.append('#');
                continue;
            }
            if (data[i] == -5) {
                buf.append('\u00df');
                continue;
            }
            buf.append((char)data[i]);
        }
        return buf.toString();
    }

    public static String extractSubjectEMail(X509Certificate cert) {
        String dn = cert.getSubjectX500Principal().getName();
        String retVal = X509CertHelper.extractAttributeFromDN(dn, "EMAILADDRESS");
        if (retVal.length() == 0) {
            retVal = X509CertHelper.extractAttributeFromDN(dn, "E");
        }
        return retVal;
    }

    public static String extractAttributeFromDN(String dn, String attr) {
        String retVal = "";
        StringTokenizer tokenizer = new StringTokenizer(dn, ",");
        while (tokenizer.hasMoreTokens()) {
            String pair = tokenizer.nextToken();
            int sep = pair.indexOf(61);
            String key = pair.substring(0, sep);
            String value = pair.substring(sep + 1);
            if (!key.equals(attr)) continue;
            retVal = value;
            break;
        }
        return retVal;
    }

    public static void main(String[] args) throws Exception {
    }
}

