/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.BMUMessageType;
import de.consist.bmu.rule.BMUMessageTypeEnum;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.SignatureVerificationResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.xmlsec.XmlSecFassade;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RuleImplSignatureVerification
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(RuleImplSignatureVerification.class);

    public RuleImplSignatureVerification(RuleDef ruleDef) {
        super(ruleDef);
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        int index = 1;
        BMUMessageType msgType = bmuDok.getMessageType();
        if (!BMUMessageTypeEnum.RegisterAuszug.equals((Object)msgType.getEnumType())) {
            for (SignatureVerificationResult svr : bmuDok.getMessageType().getSignatureVerificationResultList()) {
                try {
                    boolean valid = XmlSecFassade.getInstance().verifySignature(bmuDok.getDocument(), svr.getSignatureID());
                    if (valid) {
                        svr.setVerificationStatus(SignatureVerificationResult.VerificationStatus.VALID);
                        continue;
                    }
                    svr.setVerificationStatus(SignatureVerificationResult.VerificationStatus.INVALID);
                    ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, svr.getSignatureID()));
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Fehler bei der Pr\u00fcfung der Signatur mit der ID " + svr.getSignatureID()), (Throwable)e);
                    svr.setVerificationStatus(SignatureVerificationResult.VerificationStatus.INVALID);
                    ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, svr.getSignatureID()));
                }
            }
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        return "Die Signaturen werden mit der xmlsec-Implementierung von apache auf mathematische Unversehrtheit gepr\u00fcft.";
    }
}

