/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.schema;

import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.schema.SchemaValidator;
import de.consist.bmu.rule.util.XmlElementInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.TypeInfoProvider;
import javax.xml.validation.ValidatorHandler;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class TypeLister
extends DefaultHandler {
    private TypeInfoProvider provider;
    private Set<XmlElementInfo> typeList = new HashSet<XmlElementInfo>();

    public TypeLister(TypeInfoProvider provider) {
        this.provider = provider;
    }

    public static Set<XmlElementInfo> getDateTypes(Document doc) throws BMUException {
        TypeLister cHandler = null;
        try {
            Schema schema = SchemaValidator.getInstance().getSchema();
            ValidatorHandler vHandler = schema.newValidatorHandler();
            TypeInfoProvider provider = vHandler.getTypeInfoProvider();
            cHandler = new TypeLister(provider);
            vHandler.setContentHandler(cHandler);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DOMSource xmlSource = new DOMSource(doc);
            StreamResult outputTarget = new StreamResult(outputStream);
            TransformerFactory.newInstance().newTransformer().transform(xmlSource, outputTarget);
            ByteArrayInputStream is = new ByteArrayInputStream(outputStream.toByteArray());
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser saxParser = spf.newSAXParser();
            XMLReader parser = saxParser.getXMLReader();
            parser.setContentHandler(vHandler);
            InputSource source = new InputSource(is);
            parser.parse(source);
        }
        catch (Exception e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        return cHandler.typeList;
    }

    @Override
    public void startElement(String namespace, String localName, String qualifiedName, Attributes atts) throws SAXException {
        String type;
        if (this.provider.getElementTypeInfo() != null && ((type = this.provider.getElementTypeInfo().getTypeName()).equals("DatumTyp") || type.equals("date") || type.equals("dateTime"))) {
            XmlElementInfo info = new XmlElementInfo(namespace, localName);
            this.typeList.add(info);
        }
    }
}

