<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:html="http://www.w3c.org/TR/xhtml1/"
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:msg="uri:BMU_Waste_Interface/Message"
	xmlns:ags="uri:BMU_Waste_Interface/AGS"
	xmlns:b64="xalan://de.itu.util.Base64"
	xmlns:crc32="xalan://de.itu.util.CRC32Helper"
	xmlns:x509="xalan://de.itu.util.X509CertHelper"
	extension-element-prefixes="b64 crc32 x509"
	exclude-result-prefixes="xsl lib msg ags b64 crc32 x509">
	<xsl:import href="ZKS-Library.xsl" />
	<xsl:output method="html" />
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="msg:Nachricht">
				<xsl:for-each select="msg:Nachricht/msg:Nutzdaten">
					<xsl:apply-templates/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="ags:AGSBescheid">
		<html>
			<head>
				<title>AGSBescheid</title>
				<!-- CSS - Datei   -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf" />
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr>
						<th>
							<xsl:call-template name="Zeile0" />
							<br />
							<xsl:call-template name="Zeile1" />
							<br />
							<xsl:call-template name="Zeile2" />
							<br />
							<xsl:call-template name="Zeile3" />
							<br />
							<xsl:call-template name="Zeile4" />
							<br />
							<xsl:call-template name="Zeile5" />
							<br />
							<xsl:call-template name="Zeile6" />
						</th>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="Zeile0">
		<table width="100%" border="0">
			<tr>
				<td>
					<font id="Nummer">AGS Bescheid</font>
				</td>
			</tr>
			<tr height="3%">
				<td>
			</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile1">
		<table id="tabelle" width="100%" border="0">
			<tr>
				<td width="15%" id="Titel">Nachweis-Nummer</td>
				<td width="15%">
					<font id="Aktuell">
						<xsl:value-of select="//ags:ENSNNummer" />
					</font>
				</td>
				<td width="15%" id="Titel">Rücknahme</td>
				<td width="55%">
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:if test="//ags:IndicatorRuecknahme = 'true'">
									<font id="Aktuell">X</font>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile2">
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr height="10">
				<td/>
			</tr>
			<tr>
				<td id="Ueberschrift2">Angaben zum Abfallerzeuger/ -besitzer (Firma / Körperschaft / Betreiber)</td>
			</tr>
		</table>
		<xsl:call-template name="NameUndAdresse">
			<xsl:with-param name="prefix" select="//ags:Erzeugerfirma/ags:NameUndAdresse" />
			<xsl:with-param name="table_width" select="50" />
		</xsl:call-template>
		<xsl:call-template name="Ansprechpartner">
			<xsl:with-param name="prefix" select="//ags:Erzeugerfirma/ags:Ansprechpartner" />
			<xsl:with-param name="table_width" select="50" />
		</xsl:call-template>
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr height="10">
				<td/>
			</tr>
			<tr>
				<td id="Ueberschrift2">Erzeugerbetrieb</td>
			</tr>
			<tr>
				<td width="10%" id="Titel">Erzeugernummer</td>
				<td id="Aktuell" width="90%">
					<xsl:value-of select="//ags:Erzeugerbetrieb/ags:Erzeugernummer" />
				</td>
			</tr>
		</table>
		<xsl:call-template name="NameUndAdresse">
			<xsl:with-param name="prefix" select="//ags:Erzeugerbetrieb/ags:NameUndAdresse" />
			<xsl:with-param name="table_width" select="50" />
		</xsl:call-template>
		<table id="tabelle" width="100%" border="0">
			<tr>
				<td width="15%" id="Titel">Abfallschlüssel</td>
				<td id="Aktuell" width="85%">
					<xsl:value-of select="//ags:Erzeugerbetrieb/ags:Abfallschluessel" />
				</td>
			</tr>
			<tr>
				<td width="15%" id="Titel">Abfallbezeichnung</td>
				<td id="Aktuell" width="85%">
					<xsl:value-of select="//ags:Erzeugerbetrieb/ags:Abfallbezeichnung" />
				</td>
			</tr>
			<tr>
				<td width="15%" id="Titel">Interne Bezeichnung</td>
				<td id="Aktuell" width="85%">
					<xsl:value-of select="//ags:Erzeugerbetrieb/ags:InterneBezeichnung" />
				</td>
			</tr>
			<tr>
				<td width="15%" id="Titel">Menge</td>
				<td id="Aktuell" width="85%">
					<xsl:call-template name="formatDouble">
						<xsl:with-param name="wert" select="//ags:Erzeugerbetrieb/ags:Menge"/>
						<xsl:with-param name="unit" select="//@lib:Einheit"/>
					</xsl:call-template>
					<!--xsl:value-of select="//ags:Erzeugerbetrieb/ags:Menge" />
					&#173;
					<xsl:value-of select="//@lib:Einheit" /-->
				</td>
			</tr>
		</table>
		
	</xsl:template>
	<xsl:template name="Zeile3">
		<table  id="tabelle_nicht_unten" width="100%" border="0">
			<tr height="10">
				<td/>
			</tr>
			<tr>
				<td id="Ueberschrift2">Entsorgerfirma</td>
			</tr>
		</table>
		<xsl:call-template name="NameUndAdresse">
			<xsl:with-param name="prefix" select="//ags:Entsorger/ags:Entsorgerfirma/ags:NameUndAdresse" />
			<xsl:with-param name="table_width" select="50" />
		</xsl:call-template>
		<xsl:call-template name="Ansprechpartner">
			<xsl:with-param name="prefix" select="//ags:Entsorger/ags:Entsorgerfirma/ags:Ansprechpartner" />
			<xsl:with-param name="table_width" select="50" />
		</xsl:call-template>
		<table  id="tabelle_nicht_unten" width="100%" border="0">
			<tr height="10">
				<td/>
			</tr>
			<tr>
				<td id="Ueberschrift2">Entsorgerbetrieb</td>
			</tr>
			<tr>
				<td width="10%" id="Titel">Entsorgernummer</td>
				<td id="Aktuell" width="90%">
					<xsl:value-of select="//ags:Entsorger/ags:Entsorgerbetrieb/ags:Entsorgernummer"/>
				</td>
			</tr>
		</table>
		<xsl:call-template name="NameUndAdresse">
			<xsl:with-param name="prefix"
				select="//ags:Entsorger/ags:Entsorgerbetrieb/ags:NameUndAdresse" />
			<xsl:with-param name="table_width" select="50" />
		</xsl:call-template>
		<xsl:call-template name="Ansprechpartner">
			<xsl:with-param name="prefix"
				select="//ags:Entsorger/ags:Entsorgerbetrieb/ags:Ansprechpartner" />
			<xsl:with-param name="table_width" select="50" />
		</xsl:call-template>
		<table  id="tabelle" width="100%" border="0">
			<tr>
				<td id="Titel">Entsorgungsanlage</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="//ags:Entsorger/ags:Entsorgerbetrieb/ags:Entsorgungsanlage"/>
				</td>
			</tr>
			<tr>
				<td width="10%" id="Titel">RDVerfahren</td>
				<td width="90%" id="Aktuell">
					<xsl:value-of select="//ags:Entsorger/ags:Entsorgerbetrieb/ags:RDVerfahren" />
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile4">
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr height="10">
				<td/>
			</tr>
			<tr>
				<td id="Ueberschrift2">Bevollmächtiger</td>
			</tr>
		</table>
		<xsl:call-template name="NameUndAdresse">
			<xsl:with-param name="prefix" select="//ags:Bevollmaechtigter/ags:NameUndAdresse" />
			<xsl:with-param name="table_width" select="50" />
		</xsl:call-template>
		<xsl:call-template name="Ansprechpartner">
			<xsl:with-param name="prefix" select="//ags:Bevollmaechtigter/ags:Ansprechpartner" />
			<xsl:with-param name="table_width" select="50" />
		</xsl:call-template>
		<table id="tabelle_oben" width="100%">
			<tr height="10">
				<td/>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Zeile5">
		<table width="100%" border="0">
			<tr>
				<td>
					<font id="Nummer2">Bescheid</font>
				</td>
			</tr>
			<tr height="3%">
				<td>
			</td>
			</tr>
		</table>
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr>
				<td id="Ueberschrift2">Nutzbarkeit</td>
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%" border="0">
			<tr>
				<td id="Titel">Tenor</td>
				<td id="Aktuell">
					<xsl:value-of select="//ags:Bescheid/ags:Nutzbarkeit/ags:Tenor" />
				</td>
			</tr>
			<tr>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:if test="//ags:Bescheid/ags:Nutzbarkeit/ags:IndicatorPrivUntersagt = 'true'">
									<font id="Aktuell">X</font>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel">Nutzung priv. Verfahren untersagt</td>
			</tr>
			<tr>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:if test="//ags:Bescheid/ags:Nutzbarkeit/ags:IndicatorAndienungsantragAbgelehnt = 'true'">
									<font id="Aktuell">X</font>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel">Andienungsantrag abgelehnt</td>
			</tr>
			<tr>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:if test="//ags:Bescheid/ags:Nutzbarkeit/ags:IndicatorKeineZuweisungsentscheidung = 'true'">
									<font id="Aktuell">X</font>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel">
					Zuweisungsentscheidung nicht gefällt
				</td>
			</tr>
			<tr>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:if test="//ags:Bescheid/ags:Nutzbarkeit/ags:IndicatorZuweisung = 'true'">
									<font id="Aktuell">X</font>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel">Abfall ist zugewiesen</td>
			</tr>
			<tr>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:if test="//ags:Bescheid/ags:Nutzbarkeit/ags:IndicatorZuweisungGeaendert = 'true'">
									<font id="Aktuell">X</font>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel">Zuweisung wird geändert</td>
			</tr>
			<tr>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:if test="//ags:Bescheid/ags:Nutzbarkeit/ags:IndicatorZuweisungAufgehoben = 'true'">
									<font id="Aktuell">X</font>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel">Zuweisung wird aufgehoben</td>
			</tr>
			<tr>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:if test="//ags:Bescheid/ags:Nutzbarkeit/ags:IndicatorVerwertungAnerkannt = 'true'">
									<font id="Aktuell">X</font>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel">Verwertung wird anerkannt</td>
			</tr>
			<tr>
				<td id="Titel">Gültigkeit</td>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date">
							<xsl:value-of select="//ags:Bescheid/ags:Gueltigkeit/ags:DatumVon" />
						</xsl:with-param>
					</xsl:call-template>
					-
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date">
							<xsl:value-of select="//ags:Bescheid/ags:Gueltigkeit/ags:DatumBis" />
						</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td id="Titel">Aktenzeichen</td>
				<td id="Aktuell">
					<xsl:value-of select="//ags:Behoerde/ags:Aktenzeichen" />
				</td>
			</tr>
			<tr>
				<td id="Titel">Aktennummer</td>
				<td id="Aktuell">
					<xsl:value-of select="//ags:Behoerde/ags:Aktennummer" />
				</td>
			</tr>
		</table>
		<table id="tabelle_nicht_unten" width="100%">
			<tr>
				<td width="25%" id="Titel">Bundesland/Kreis Kennung </td>
				<td width="25%" id="Titel">Menge </td>
				<td width="25%" id="Titel"/>
				<td width="25%" id="Titel"/>
			</tr>
			<xsl:for-each select="//ags:Bescheid/ags:Nutzbarkeit/ags:Bundesland">
				<tr>
					<td width="25%" id="Aktuell">
						<xsl:value-of select="ags:Bundeslandkenner"/>
					</td>
					<td width="25%" id="Aktuell">
						<xsl:value-of select="ags:MengeBL"/>
						&#173;
						<xsl:value-of select="ags:MengeBL/@lib:Einheit" />
					</td>
				</tr>
				<xsl:for-each select="ags:Kreis">
					<tr>
						<td width="25%" id="Aktuell">
							<xsl:value-of select="ags:Kreiskennung"/>
						</td>
						<td width="25%" id="Aktuell">
							<xsl:value-of select="ags:Menge"/>
							&#173;
							<xsl:value-of select="ags:Menge/@lib:Einheit" />
						</td>
					</tr>
				</xsl:for-each>
			</xsl:for-each>
		</table>
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr>
				<td id="Ueberschrift2">Nebenbestimmungen</td>
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%" border="0">
			<tr>
				<td id="Titel">Nebenbestimmungen Memotext</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of
						select="//ags:Bescheid/ags:Nebenbestimmungen/ags:Text" />
				</td>
			</tr>
		</table>
		<xsl:if test="//ags:Bescheid/ags:Nebenbestimmungen/ags:Nebenbestimmung">
			<table id="tabelle_nicht_oben_unten" width="100%" border="0">
				<tr>
					<td id="Ueberschrift2">Nebenbestimmungen Liste</td>
				</tr>
			</table>
			<xsl:for-each select="//ags:Bescheid/ags:Nebenbestimmungen/ags:Nebenbestimmung">
				<table id="tabelle_nicht_oben_unten" width="100%" border="0">
				<tr>
					<td width="5%" id="Titel">Lfd-Nr.</td>
					<td width="70%" id="Titel">Bezeichnung</td>
					<td width="25%" id="Titel">Adressat</td>
				</tr>
				<tr>
					<td width="5%" valign="top" id="Aktuell">
						<xsl:value-of select="ags:LfdNr" />
					</td>
					<td width="70%" valign="top" id="Aktuell">
						<xsl:value-of select="ags:Bezeichnung" />
					</td>
					<td width="25%" valign="top" id="Aktuell">
						<xsl:for-each select="ags:Adressat">
							<xsl:value-of select="." />
							<xsl:if test="position() != last()"> / </xsl:if>
						</xsl:for-each>
					</td>
				</tr>
				</table>
				<table id="tabelle_nicht_oben_unten" width="100%" border="0">
				<tr>
					<td width="5%" id="Titel">Text</td>
					<td width="95%" id="Aktuell">
						<xsl:value-of select="ags:Text" />
					</td>
				</tr>
				</table>
			</xsl:for-each>
		</xsl:if>
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr>
				<td id="Ueberschrift2">Begründungen</td>
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%" border="0">
			<tr>
				<td id="Titel">Begründungen Memotext</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of
						select="//ags:Bescheid/ags:Begruendungen/ags:Text" />
				</td>
			</tr>
		</table>
		<xsl:if test="//ags:Bescheid/ags:Begruendungen/ags:Begruendung">
			<table id="tabelle_nicht_oben_unten" width="100%" border="0">
				<tr>
					<td id="Ueberschrift2">Begründungen Liste</td>
				</tr>
			</table>
			<xsl:for-each select="//ags:Bescheid/ags:Begruendungen/ags:Begruendung">
				<table id="tabelle_nicht_oben_unten" width="100%" border="0">
				<tr>
					<td width="5%" id="Titel">Lfd-Nr.</td>
					<td width="10%" id="Titel">Bezug NB</td>
					<td width="80%" id="Titel">Bezeichnung</td>
				</tr>
				<tr>
					<td width="5%" valign="top" id="Aktuell">
						<xsl:value-of select="ags:LfdNr" />
					</td>
					<td width="10%" valign="top" id="Aktuell">
						<xsl:value-of select="ags:BezugLfdNrNB" />
					</td>
					<td width="80%" valign="top" id="Aktuell">
						<xsl:value-of select="ags:Bezeichnung" />
					</td>
				</tr>
				</table>
				<table id="tabelle_nicht_oben_unten" width="100%" border="0">
				<tr>
					<td width="5%" id="Titel">Text</td>
					<td width="95%" id="Aktuell">
						<xsl:value-of select="ags:Text" />
					</td>
				</tr>
				</table>
			</xsl:for-each>
		</xsl:if>
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr>
				<td id="Ueberschrift2">Rechtsbehelfsbelehrungen</td>
			</tr>
			<tr>
				<td id="Titel">Rechtsbehelf Erzeuger</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="//ags:Bescheid/ags:Rechtsbehelf/ags:RechtsbehelfERZ" />
				</td>
			</tr>
			<tr>
				<td id="Titel">Rechtsbehelf Befoerderer</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="//ags:Bescheid/ags:Rechtsbehelf/ags:RechtsbehelfBEF" />
				</td>
			</tr>
			<tr>
				<td id="Titel">Rechtsbehelf Entsorger</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="//ags:Bescheid/ags:Rechtsbehelf/ags:RechtsbehelfENT" />
				</td>
			</tr>
		</table>
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr>
				<td id="Ueberschrift2">Weitere Hinweise</td>
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%" border="0">
			<tr>
				<td id="Titel">Hinweise Memotext</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of
						select="//ags:Bescheid/ags:Hinweise/ags:Text" />
				</td>
			</tr>
		</table>
		<xsl:if test="//ags:Bescheid/ags:Hinweise/ags:Hinweis">
			<table id="tabelle_nicht_oben_unten" width="100%" border="0">
				<tr>
					<td id="Ueberschrift2">Hinweise Liste</td>
				</tr>
			</table>
			<xsl:for-each select="//ags:Bescheid/ags:Hinweise/ags:Hinweis">
				<table id="tabelle_nicht_oben_unten" width="100%" border="0">
				<tr>
					<td width="5%" id="Titel">Lfd-Nr.</td>
					<td width="70%" id="Titel">Bezeichnung</td>
					<td width="25%" id="Titel">Adressat</td>
				</tr>
				<tr>
					<td width="5%" valign="top" id="Aktuell">
						<xsl:value-of select="ags:LfdNr" />
					</td>
					<td width="70%" valign="top" id="Aktuell">
						<xsl:value-of select="ags:Bezeichnung" />
					</td>
					<td width="25%" valign="top" id="Aktuell">
						<xsl:for-each select="ags:Adressat">
							<xsl:value-of select="." />
							<xsl:if test="position() != last()"> / </xsl:if>
						</xsl:for-each>
					</td>
				</tr>
				</table>
				<table id="tabelle_nicht_oben_unten" width="100%" border="0">
					<tr>
						<td width="5%" id="Titel">Text</td>
						<td width="95%" id="Aktuell">
							<xsl:value-of select="ags:Text" />
						</td>
					</tr>
				</table>
				<table id="tabelle_nicht_oben_unten" width="100%" border="0">
					<tr>
						<td width="5%" id="Titel">Erläuterung</td>
						<td width="95%" id="Aktuell">
							<xsl:value-of select="ags:Erlaeuterung" />
						</td>
					</tr>
				</table>
			</xsl:for-each>
		</xsl:if>
		<table id="tabelle_oben" width="100%">
			<tr height="10">
				<td/>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile6">
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr height="10">
				<td/>
			</tr>
			<tr>
				<td id="Ueberschrift2">Behörde</td>
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%" border="0">
			<td>
				<tr>
					<td width="5%">
						<table id="Tabelle_indikator">
							<tr>
								<td>
									<xsl:if test="//ags:Behoerde/ags:IndicatorErzeugerbehoerde = 'true'">
										<font id="Aktuell">X</font>
									</xsl:if>
								</td>
							</tr>
						</table>
					</td>
					<td width="20%" id="Titel">Erzeugerbehörde</td>
					<td width="5%">
						<table id="Tabelle_indikator">
							<tr>
								<td>
									<xsl:if test="//ags:Behoerde/ags:IndicatorEntsorgerbehoerde = 'true'">
										<font id="Aktuell">X</font>
									</xsl:if>
								</td>
							</tr>
						</table>
					</td>
					<td width="70%" id="Titel">Entsorgerbehörde</td>
				</tr>
				<tr>
				</tr>
			</td>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%" border="0">
			<tr>
				<td width="10%" id="Titel">Behördennummer</td>
				<td id="Aktuell" width="90%">
					<xsl:value-of select="//ags:Behoerde/ags:Behoerdennummer"/>
				</td>
			</tr>
		</table>
		<xsl:call-template name="NameUndAdresse">
			<xsl:with-param name="prefix" select="//ags:Behoerde/ags:NameUndAdresse" />
			<xsl:with-param name="table_width" select="50" />
		</xsl:call-template>
		<xsl:call-template name="Ansprechpartner">
			<xsl:with-param name="prefix" select="//ags:Behoerde/ags:Ansprechpartner" />
			<xsl:with-param name="table_width" select="50" />
		</xsl:call-template>
		<table id="tabelle_oben" width="100%">
			<tr height="10">
				<td/>
			</tr>
		</table>
		<br />
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr height="10">
				<td/>
			</tr>
			<tr>
				<td id="Ueberschrift2">Gesellschaft</td>
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%" border="0">
			<td>
				<tr>
					<td id="Titel">Gerichtsstand</td>
				</tr>
				<tr>
					<td id="Aktuell">
						<xsl:value-of select="//ags:Behoerde/ags:Gesellschaft/ags:Gerichtsstand" />
					</td>
				</tr>
				<tr>
					<td id="Titel">Geschaeftsfuehrer</td>
				</tr>
				<tr>
					<td id="Aktuell">
						<xsl:value-of select="//ags:Behoerde/ags:Gesellschaft/ags:Geschaeftsfuehrer" />
					</td>
				</tr>
				<tr>
					<td id="Titel">Aufsichtsratsvorsitzender</td>
				</tr>
				<tr>
					<td id="Aktuell">
						<xsl:value-of select="//ags:Behoerde/ags:Gesellschaft/ags:Aufsichtsratsvorsitzender" />
					</td>
				</tr>
				<tr>
					<td id="Titel">UStIDoderSteuerNr</td>
				</tr>
				<tr>
					<td id="Aktuell">
						<xsl:value-of select="//ags:Behoerde/ags:Gesellschaft/ags:UStIDoderSteuerNr" />
					</td>
				</tr>
			</td>
		</table>
		<table id="tabelle_oben" width="100%">
			<tr height="10">
				<td/>
			</tr>
		</table>
		<br />
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr height="10">
				<td/>
			</tr>
			<tr>
				<td id="Ueberschrift2">Erklärung</td>
			</tr>
		</table>
		<table id="tabelle_nicht_oben" width="100%">
			<tr>
				<td width="40%" id="Titel">Ort </td>
				<td width="20%" id="Titel">Datum </td>
				<td width="40%" id="Titel">Unterschrift</td>
			</tr>
			<tr>
				<td width="40%" id="Aktuell">
					<xsl:value-of select="//ags:Behoerde/ags:Erklaerung/lib:Ort"/>
				</td>
				<td width="20%" id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="//ags:Behoerde/ags:Erklaerung/lib:Datum"/>
					</xsl:call-template>
				</td>
				<td width="40%" id="Aktuell">
					<xsl:call-template name="Sig1NameNoLayer"/>
				</td>
			</tr>
		</table>

		<xsl:call-template name="Anhang">
			<xsl:with-param name="prefix" select="//ags:AGSBescheid/ags:Dateianhang" />
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="Anhang">
		<xsl:param name="prefix" />
		<xsl:if test="boolean($prefix)">
			<table width="100%" cellspacing="15" cellpadding="15">
				<tr>
					<td>
						<font id="Nummer2">Im signierten Bereich angehängt wurden:</font>
						<br />
						<br />
						<ul>
							<xsl:for-each select="$prefix">
								<font id="Aktuell">
									<li>
										<xsl:value-of select="@lib:dateiname" />
									</li>
								</font>
							</xsl:for-each>
						</ul>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>