<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:msg="uri:BMU_Waste_Interface/Message" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:xades="http://uri.etsi.org/01903/v1.3.2#"
	xmlns:b64="xalan://de.itu.util.Base64" 
	xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
	xmlns:x509="xalan://de.itu.util.X509CertHelper" 
	extension-element-prefixes="b64 crc32 x509" 
	exclude-result-prefixes="xsl lib msg ds en b64 crc32 x509 xades">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:param name="layerName" select="'ENSNErzLayer'"/>
	<xsl:param name="layerID" select="'ERZ-01-e6f6d730-0dbe-45b7-857c-0b7474c9ee07'"/>
	<xsl:template match="/">
		<html>
			<head>
				<title>Entsorgungsnachweis/Sammelentsorgungsnachweis</title>
				<!-- CSS - Datei   -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<xsl:call-template name="EGFDa"/>
				<xsl:call-template name="showSigLayer"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="EGFDa">
		<xsl:for-each select="//*[(starts-with(local-name(), 'ENSN')) and (contains(local-name(), 'Layer'))]">
			<xsl:if test="position()=$positionsnummer">
				<xsl:choose>
					<xsl:when test="not (boolean(en:EGFDokument))">
						<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
							<tr>
								<td>
									<font id="Nummer">
							  			In dieser Sicht ist kein EGF-Formular vorhanden.
						  			</font>
									<br/>
									<font id="Nummer2">
							  			Ein EGF-Formular befindet sich in der Sicht:
							  		</font>
									<font id="FormPosition">
										<!--xsl:call-template name="EGF_Position">
					            			</xsl:call-template-->
										<xsl:call-template name="CHILD_POSITION">
											<xsl:with-param name="DocTyp" select="'ENSN'"/>
											<xsl:with-param name="ChildTyp" select="'en:EGFDokument'"/>
				            			</xsl:call-template>
									</font>
								</td>
							</tr>
						</table>
					</xsl:when>
					<xsl:otherwise>
						<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
							<xsl:for-each select="en:EGFDokument">
								<xsl:call-template name="EGF"/>
		            			</xsl:for-each>
						</table>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="EGF">
		<tr>
			<th>
				<xsl:call-template name="Zeile0"/>
			</th>
		</tr>
		<tr>
			<th>
				<xsl:call-template name="Zeile1"/>
				<br/>
				<xsl:call-template name="Zeile2"/>
				<br/>
				<xsl:call-template name="Zeile3"/>
				<br/>
				<xsl:call-template name="Zeile4"/>
				<br/>
				<xsl:call-template name="Zeile5"/>
			</th>
		</tr>
	</xsl:template>
	<xsl:template name="Zeile0">
		<table width="100%" border="0">
			<tr>
				<td>
					<font id="Nummer">
						Ergänzendes Formblatt
					</font>
					<font id="Ueberschrift2">
							(<xsl:value-of select="concat(local-name(parent::node()),': ',../@lib:LayerID)"/>)								
					</font>
				</td>
			</tr>
			<tr height="3%">
				<td>
			</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile1">
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr>
				<td width="25%" id="Titel"> (Sammel-)Entsorgungsnachweis-Nr. </td>
				<td width="25%" id="Titel"> Abfallschlüssel </td>
				<td width="25%" id="Titel"> Erzeuger-Nummer </td>
				<td width="25%" id="Titel"> Rücknahme </td>
			</tr>
			<tr>
				<td>
					<font id="Aktuell">
						<xsl:value-of select="en:Nummer1_Antrag/en:Kopfdaten/en:ENSNNummer"/>
					</font>
				</td>
				<td>
					<font id="Aktuell">
						<xsl:value-of select="en:Nummer1_Antrag/en:Kopfdaten/en:Abfallschluessel"/>
					</font>
				</td>
				<td>
					<font id="Aktuell">
						<xsl:value-of select="en:Nummer1_Antrag/en:Erzeugerbetrieb/en:Erzeugernummer"/>
					</font>
				</td>
				<td>
					<font id="Aktuell">
						<xsl:if test="en:Nummer1_Antrag/en:Kopfdaten/en:IndicatorRuecknahme = 'true'">
							Ja
						</xsl:if>
						<xsl:if test="en:Nummer1_Antrag/en:Kopfdaten/en:IndicatorRuecknahme = 'false'">
							Nein
						</xsl:if>
					</font>
				</td>
			</tr>
		</table>
		<table id="tabelle" width="100%" border="0">
			<tr>
				<td width="25%" id="Titel">Antrag Rechnungsbeauftragung</td>
				<td width="25%">
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:if test="en:Nummer1_Antrag/en:IndicatorRechnungsbeauftragung = 'true'">
									<font id="Aktuell">X</font>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
				<td width="50%" id="Titel"></td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile2">
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr align="left">
				<td id="Ueberschrift2"> 1. Angaben zum Abfallerzeuger/ -besitzer (Firma / Körperschaft / Betreiber)</td>
			</tr>
		</table>
		<xsl:call-template name="NameUndAdresse">
			<xsl:with-param name="prefix" select="en:Nummer1_Antrag/en:Abfallerzeuger/en:NameUndAdresse"/>
			<xsl:with-param name="table_width" select="40"/>
		</xsl:call-template>
		<xsl:call-template name="Ansprechpartner">
			<xsl:with-param name="prefix" select="en:Nummer1_Antrag/en:Abfallerzeuger/en:Ansprechpartner"/>
			<xsl:with-param name="table_width" select="40"/>
		</xsl:call-template>
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr height="10">
				<td/>
			</tr>
			<tr align="left">
				<td id="Ueberschrift2"> Erzeugerbetrieb </td>
			</tr>
		</table>
		<xsl:call-template name="NameUndAdresse">
			<xsl:with-param name="prefix" select="en:Nummer1_Antrag/en:Erzeugerbetrieb/en:NameUndAdresse"/>
			<xsl:with-param name="table_width" select="40"/>
		</xsl:call-template>
		<table id="tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td id="Titel">Anfallstelle</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="en:Nummer1_Antrag/en:Erzeugerbetrieb/en:Anfallstelle/en:Name1"/>&#173;
			            <xsl:value-of select="en:Nummer1_Antrag/en:Erzeugerbetrieb/en:Anfallstelle/en:Name2"/>
				</td>
			</tr>
		</table>
		<table id="tabelle_nicht_unten" width="100%">
			<tr>
				<td width="30%" id="Titel">Beantragte Laufzeit </td>
				<td width="70%" id="Titel">Betriebsinterne Abfallbezeichnung</td>
			</tr>
			<tr>
				<td width="30%" id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date">
							<xsl:value-of select="en:Nummer1_Antrag/en:Sonstiges/en:BeantragteLaufzeit/en:DatumVon"/>
						</xsl:with-param>
					</xsl:call-template>
			-
			<xsl:call-template name="formatDate">
						<xsl:with-param name="date">
							<xsl:value-of select="en:Nummer1_Antrag/en:Sonstiges/en:BeantragteLaufzeit/en:DatumBis"/>
						</xsl:with-param>
					</xsl:call-template>
				</td>
				<td width="70%" id="Aktuell">
					<xsl:value-of select="en:Nummer1_Antrag/en:Sonstiges/en:BetriebsinterneAbfallbezeichnung"/>
				</td>
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td id="Titel">Aktennummer</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="en:Nummer1_Antrag/en:Sonstiges/en:AktenNummer"/>
				</td>
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td id="Titel">Sonstiges Text</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="en:Nummer1_Antrag/en:Sonstiges/en:SonstigesText"/>
				</td>
			</tr>
		</table>
		<table id="tabelle_nicht_unten" width="100%">
			<tr>
				<td width="25%" id="Titel">Bundesland/Kreis Kennung </td>
				<td width="25%" id="Titel">Menge </td>
				<td width="25%" id="Titel"/>
				<td width="25%" id="Titel"/>
			</tr>
			<xsl:for-each select="en:Nummer1_Antrag/en:Sonstiges/en:Bundesland">
				<tr>
					<td width="25%" id="Aktuell">
						<xsl:value-of select="en:Bundeslandkenner"/>
					</td>
					<td width="25%" id="Aktuell">
						<xsl:value-of select="en:MengeBL"/>
					</td>
				</tr>
				<xsl:for-each select="en:Kreis">
					<tr>
						<td width="25%" id="Aktuell">
							<xsl:value-of select="en:Kreiskennung"/>
						</td>
						<td width="25%" id="Aktuell">
							<xsl:value-of select="en:Menge"/>
						</td>
					</tr>
				</xsl:for-each>
			</xsl:for-each>
		</table>
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr height="10">
				<td/>
			</tr>
			<tr align="left">
				<td id="Ueberschrift2"> Entsorger </td>
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td id="Titel">Entsorgernummer</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="en:Nummer1_Antrag/en:Sonstiges/en:Entsorger/en:Entsorgernummer"/>
				</td>
			</tr>
		</table>
		<xsl:call-template name="NameUndAdresse">
			<xsl:with-param name="prefix" select="en:Nummer1_Antrag/en:Sonstiges/en:Entsorger/en:NameUndAdresse"/>
			<xsl:with-param name="table_width" select="40"/>
		</xsl:call-template>
		<table id="tabelle_nicht_unten" width="100%">
			<tr>
				<td width="100%" id="Text_kleiner">
					<xsl:value-of select="en:Nummer1_Antrag/en:Text"/>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td width="5%">
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:if test="en:Nummer1_Antrag/en:IndicatorVerfahrensbevollmaechtigung = 'false'">
									<font id="Aktuell">X</font>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
				<td width="95%" id="Text_kleiner">
					Die Vollmacht unter Nr. 2 ist auf die Abgabe der Verantwortlichen Erklärung (§3 Abs. 4 NachwV) beschränkt (siehe Formblatt DEN).
					<!--xsl:value-of select="//en:Nummer1_Antrag/en:TextVollmacht"/-->
				</td>
			</tr>
		</table>
		<xsl:call-template name="Nummer23">
			<xsl:with-param name="prefix" select="en:Nummer1_Antrag"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="Zeile3">
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr align="left">
				<td id="Ueberschrift2"> 2. Angaben zum Bevollmächtigten </td>
			</tr>
		</table>
		<xsl:call-template name="NameUndAdresse">
			<xsl:with-param name="prefix" select="en:Nummer1_Antrag/en:Nummer2_Bevollmaechtigung/en:Bevollmaechtigter/en:NameUndAdresse"/>
			<xsl:with-param name="table_width" select="40"/>
		</xsl:call-template>
		<xsl:call-template name="Ansprechpartner">
			<xsl:with-param name="prefix" select="en:Nummer1_Antrag/en:Nummer2_Bevollmaechtigung/en:Bevollmaechtigter/en:Ansprechpartner"/>
			<xsl:with-param name="table_width" select="40"/>
		</xsl:call-template>
		<table id="tabelle_nicht_unten" width="100%">
			<tr>
				<td id="Text_kleiner">
					<xsl:value-of select="en:Nummer1_Antrag/en:Nummer2_Bevollmaechtigung/en:Text"/>
				</td>
			</tr>
		</table>
		<xsl:call-template name="Nummer23">
			<xsl:with-param name="prefix" select="en:Nummer1_Antrag/en:Nummer2_Bevollmaechtigung"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="Zeile4">
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr align="left">
				<td id="Ueberschrift2"> 3. Angaben zum Beauftragten </td>
			</tr>
		</table>
		<xsl:call-template name="NameUndAdresse">
			<xsl:with-param name="prefix" select="en:Nummer1_Antrag/en:Nummer3_Beauftragung/en:Beauftragter/en:NameUndAdresse"/>
			<xsl:with-param name="table_width" select="40"/>
		</xsl:call-template>
		<xsl:call-template name="Ansprechpartner">
			<xsl:with-param name="prefix" select="en:Nummer1_Antrag/en:Nummer3_Beauftragung/en:Beauftragter/en:Ansprechpartner"/>
			<xsl:with-param name="table_width" select="40"/>
		</xsl:call-template>
		<table id="tabelle_nicht_unten" width="100%">
			<tr>
				<td id="Text_kleiner">
					<xsl:value-of select="en:Nummer1_Antrag/en:Nummer3_Beauftragung/en:Text"/>
				</td>
			</tr>
		</table>
		<xsl:call-template name="Nummer23">
			<xsl:with-param name="prefix" select="en:Nummer1_Antrag/en:Nummer3_Beauftragung"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="Zeile5">
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr align="left">
				<td id="Ueberschrift2"> Entscheidung der Behörde </td>
			</tr>
		</table>
		<xsl:call-template name="NameUndAdresse">
			<xsl:with-param name="prefix" select="en:Entscheidung/en:Behoerde/en:NameUndAnschrift"/>
			<xsl:with-param name="table_width" select="40"/>
		</xsl:call-template>
		<xsl:call-template name="Ansprechpartner">
			<xsl:with-param name="prefix" select="en:Entscheidung/en:Behoerde/en:Ansprechpartner"/>
			<xsl:with-param name="table_width" select="40"/>
		</xsl:call-template>
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr>
				<td width="25%" id="Titel">Bevollmächtigung genehmigt</td>
				<td width="25%">
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:if test="en:Entscheidung/en:IndicatorBevollmaechtigung = 'true'">
									<font id="Aktuell">X</font>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
				<td width="25%" id="Titel">Rechnungsbeauftragung genehmigt</td>
				<td width="25%">
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:if test="en:Entscheidung/en:IndicatorBeauftragung = 'true'">
									<font id="Aktuell">X</font>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
				<!--td width="50%" id="Titel"></td-->
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%" border="0">
			<tr>
				<td id="Titel">
					Begründung bei Ablehnung der Bevollmächtigung
				</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="en:Entscheidung/en:BevollmaechtigungGrundAblehnung"/>
				</td>
			</tr>
			<tr>
				<td id="Titel">
					Begründung bei Ablehnung der Beauftragung
				</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="en:Entscheidung/en:BeauftragungGrundAblehnung"/>
				</td>
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%" border="0">
			<tr>
				<td id="Titel">Aktenzeichen</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="en:Entscheidung/en:Aktenzeichen"/>
				</td>
			</tr>
			<tr>
				<td id="Titel">Laufzeit Bevollmächtigung</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date">
							<xsl:value-of select="en:Entscheidung/en:LaufzeitBevollmaechtigung/en:BevDatumVon"/>
						</xsl:with-param>
					</xsl:call-template>
					-
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date">
							<xsl:value-of select="en:Entscheidung/en:LaufzeitBevollmaechtigung/en:BevDatumBis"/>
						</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td id="Titel">Laufzeit Beauftragung</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date">
							<xsl:value-of select="en:Entscheidung/en:LaufzeitBeauftragung/en:BeaufDatumVon"/>
						</xsl:with-param>
					</xsl:call-template>
					-
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date">
							<xsl:value-of select="en:Entscheidung/en:LaufzeitBeauftragung/en:BeaufDatumBis"/>
						</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
		</table>
		<table id="tabelle" width="100%">
			<tr>
				<td width="20%" id="Titel">Ort </td>
				<td width="20%" id="Titel">Datum </td>
				<td width="30%" id="Titel">Unterschrift (Signatur)</td>
				<td width="30%" id="Titel">2. Unterschrift (Signatur)</td>
			</tr>
			<tr>
				<td width="20%" id="Aktuell">
					<xsl:value-of select="en:Entscheidung/en:Erklaerung/lib:Ort"/>
				</td>
				<td width="20%" id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="en:Entscheidung/en:Erklaerung/lib:Datum"/>
					</xsl:call-template>
				</td>
				<td width="30%" id="Aktuell">
					<xsl:if test="count(ds:Signature/ds:KeyInfo/ds:X509Data/ds:X509Certificate) > 0">
						<xsl:value-of select="x509:extractCommonName(b64:decode(ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
						<xsl:variable name="SIG_DATE">
							<xsl:call-template name="formatDate">
								<xsl:with-param name="date" select="ds:Signature[1]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:value-of select="concat(' (', $SIG_DATE, ')')"/>
					</xsl:if>
				</td>
				<td width="30%" id="Aktuell">
					<xsl:if test="count(ds:Signature/ds:KeyInfo/ds:X509Data/ds:X509Certificate) > 1">
						<xsl:value-of select="x509:extractCommonName(b64:decode(ds:Signature[2]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
						<xsl:variable name="SIG_DATE3">
							<xsl:call-template name="formatDate">
								<xsl:with-param name="date" select="ds:Signature[2]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:value-of select="concat(' (', $SIG_DATE3, ')')"/>
					</xsl:if>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Nummer23">
		<xsl:param name="prefix"/>
		<table id="Tabelle_nicht_oben" width="100%">
			<tr>
				<td id="titel" width="20%">Ort</td>
				<td id="titel" width="10%">Datum</td>
				<td id="titel" width="20%">Name</td>
				<td id="titel" width="25%">Rechtsverbindliche Unterschrift (Signatur)</td>
				<td id="titel" width="25%">Rechtsverbindliche Unterschrift (2. Signatur)</td>
			</tr>
			<tr>
				<td width="20%" id="Aktuell">
					<xsl:value-of select="$prefix/en:Erklaerung/lib:Ort"/>
				</td>
				<td width="10%" id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="$prefix/en:Erklaerung/lib:Datum"/>
					</xsl:call-template>
				</td>
				<td width="20%" id="Aktuell">
					<xsl:value-of select="$prefix/en:Erklaerung/lib:Name"/>
				</td>
				<td width="25%" id="Aktuell">
					<xsl:if test="count($prefix/ds:Signature/ds:KeyInfo/ds:X509Data/ds:X509Certificate) > 0">
						<xsl:value-of select="x509:extractCommonName(b64:decode($prefix/ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
						<xsl:variable name="SIG_DATE2">
							<xsl:call-template name="formatDate">
								<xsl:with-param name="date" select="$prefix//ds:Signature[1]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:value-of select="concat(' (', $SIG_DATE2, ')')"/>
					</xsl:if>
				</td>
				<td width="25%" id="Aktuell">
					<xsl:if test="count($prefix/ds:Signature/ds:KeyInfo/ds:X509Data/ds:X509Certificate) > 1">
						<xsl:value-of select="x509:extractCommonName(b64:decode($prefix/ds:Signature[2]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
						<xsl:variable name="SIG_DATE4">
							<xsl:call-template name="formatDate">
								<xsl:with-param name="date" select="$prefix//ds:Signature[2]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:value-of select="concat(' (', $SIG_DATE4, ')')"/>
					</xsl:if>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="EGF_Position">
		<xsl:variable name="CNTLAYER">
			<xsl:value-of select="count(//*[(starts-with(local-name(), 'ENSN')) and (contains(local-name(), 'Layer'))])"></xsl:value-of>
		</xsl:variable>
		<xsl:for-each select="//*[(starts-with(local-name(), 'ENSN')) and (contains(local-name(), 'Layer'))]">
			<xsl:if test="en:EGFDokument">
				<xsl:choose>
					<xsl:when test="$CNTLAYER - position() + 1 > 9">
						<xsl:value-of select="concat($CNTLAYER - position() + 1,'. ',local-name())"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('0', $CNTLAYER - position() + 1,'. ',local-name())"/>
					</xsl:otherwise>
				</xsl:choose> 
				<xsl:if test="position() != last()"> / </xsl:if>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>
