<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:dyn="http://exslt.org/dynamic" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#"
	xmlns:makst="uri:MaklerStammdaten/MakStamm"
	xmlns:btrlib="uri:BetriebStammdaten/BtrStammTypBibliothek"
	xmlns:kop="uri:AnzeigeErlaubnis/Kopie_TypBibliothek"
	xmlns:abf="uri:AnzeigeErlaubnis/AbfAEV" 
	extension-element-prefixes="dyn"
	exclude-result-prefixes="xsl dyn lib ds en">
	<xsl:import href="ZKS-Library_fx.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>
	
	<xsl:variable name="MAX_ZEICHEN_MEMO" select="2400"/>

	<xsl:template match="/">
		<xsl:for-each select="//makst:Makler">
			<xsl:if test="position()=$positionsnummer">
				<html>
					<head>
						<title>Makler, Händler</title>
						<!-- CSS - Datei -->
						<xsl:call-template name="Style"/>
					</head>
					<body>
						<xsl:call-template name="Kopf"/>
						<xsl:call-template name="ZeileMakler"/>
					</body>
				</html>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="ZeileMakler">
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr>
				<td/>
			</tr>
			<tr>
				<td>
					<xsl:call-template name="Verwaltung"/>
					<xsl:call-template name="Betrieb"/>
					<xsl:call-template name="ZustBehoerde"/>
					<xsl:call-template name="WeiteresBetrieb"/>
					<xsl:call-template name="PersonenBetrieb"/>
					<xsl:call-template name="Details"/>
					<xsl:call-template name="EndeBetrieb"/>
				</td>
			</tr>
		</table>
		<p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p>
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr>
				<td>
					<xsl:call-template name="FkbZuBetrieb"/>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Verwaltung">
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td>
					<font id="Nummer">
						Makler, Händler
					</font>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td id="Titel">Verwaltungsinformationen</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="20%"/>
				<col width="30%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Gestrichen</td>
				<td id="Titel_klein">Streichgrund</td>
				<td id="Titel_klein">Aktenzeichen</td>
			</tr>
			<tr>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'makst:MaklerBetrieb/makst:Gestrichen'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="makst:MaklerBetrieb/makst:Streichgrund"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="makst:MaklerBetrieb/makst:Aktenzeichen"/>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td>
					<font id="Titel_klein">Notizen</font>
				</td>
			</tr>
			<tr>
				<td>
					<font id="Aktuell">
						<xsl:value-of select="makst:MaklerBetrieb/makst:Bemerkungen"/>
						&#173;
					</font>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Betrieb">
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td>
					<font id="Titel">Betriebsstätte</font>
				</td>
			</tr>
		</table>
		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="80%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Makler-, Händlernr.</td>
				<td id="Titel_klein">Registriernummer im Heimatland</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="makst:MaklerBetrieb/makst:BehoerdlicheNummer/btrlib:BehoerdlicheNr"/>
					&#173;
					<xsl:value-of select="makst:MaklerBetrieb/makst:BehoerdlicheNummer/btrlib:Pruefziffer"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="makst:MaklerBetrieb/makst:RegistriernummerHeimatland"/>
				</td>
			</tr>
		</table>
		
		<xsl:call-template name="NameUndAdresseBtr">
			<xsl:with-param name="prefix" select="'makst:MaklerBetrieb/makst:'"/>
		</xsl:call-template>
		
		<table width="100%" id="tabelle_nicht_oben_unten">
			<colgroup>
				<col width="20%"/>
				<col width="80%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Schlüssel</td>
				<td id="Titel_klein">Gemeindebezeichnung</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="makst:MaklerBetrieb/makst:Gemeindeschluessel"/>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:value-of select="makst:MaklerBetrieb/makst:Gemeindename"/>
				</td>
			</tr>
			<tr>
				<td id="Titel_klein">East-Wert</td>
				<td id="Titel_klein">North-Wert</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="makst:MaklerBetrieb/makst:Koordinaten/makst:East"/>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:value-of select="makst:MaklerBetrieb/makst:Koordinaten/makst:North"/>
				</td>
			</tr>
		</table>

		<xsl:call-template name="KontaktBtr">
			<xsl:with-param name="prefix" select="'makst:MaklerBetrieb/makst:Kontaktdaten/btrlib:'"/>
		</xsl:call-template>

		<table id="tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td id="Titel_klein">Homepage</td>
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="makst:MaklerBetrieb/makst:InternetAdresse"/>
					&#173;
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="ZustBehoerde">
		<xsl:if test="count(makst:MaklerBetrieb/makst:ZustBehoerden)>0">
			<table id="Tabelle_nicht_unten" width="100%">
				<tr>
					<td>
						<font id="Titel">Zuständige Behörden</font>
					</td>
				</tr>
			</table>
			<xsl:for-each select="makst:MaklerBetrieb/makst:ZustBehoerden">
				<xsl:sort select="makst:LfdNr" data-type="number" order="ascending"/>
				<xsl:call-template name="ZustBehoerdeBtr">
					<xsl:with-param name="prefix" select="'makst:'"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="WeiteresBetrieb">
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td>
					<font id="Titel">Eigenschaften</font>
				</td>
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="10%"/>
				<col width="10%"/>
				<col width="10%"/>
				<col width="10%"/>
				<col width="10%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Makler</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'makst:MaklerBetrieb/makst:MaklerEigenschaften/makst:Makler'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>					
				<td id="Titel_klein">Händler</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'makst:MaklerBetrieb/makst:MaklerEigenschaften/makst:Haendler'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>					
				<td id="Titel_klein">Gebührenbefreit</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'makst:MaklerBetrieb/makst:MaklerEigenschaften/makst:Gebuehrenbefreit'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>					
			</tr>
		</table>
		<xsl:if test="count(makst:MaklerBetrieb/makst:Branchen)>0">
			<table id="Tabelle_nicht_unten" width="100%">
				<tr>
					<td>
						<font id="Titel">Branchen</font>
					</td>
				</tr>
			</table>
			<xsl:for-each select="makst:MaklerBetrieb/makst:Branchen">
				<xsl:call-template name="BrancheBtr">
					<xsl:with-param name="prefix" select="'makst:'"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="PersonenBetrieb">
		<xsl:if test="count(makst:MaklerBetrieb/makst:Ansprechpartner)>0">
			<table id="Tabelle_nicht_unten" width="100%">
				<tr>
					<td>
						<font id="Titel">Personen zu Makler, Händler</font>
					</td>
				</tr>
			</table>
			<xsl:for-each select="makst:MaklerBetrieb/makst:Ansprechpartner">
				<xsl:call-template name="PersonBtr">
					<xsl:with-param name="prefix" select="'makst:'"/>
					<xsl:with-param name="verantwortPerson" select="true()"/>
					<xsl:with-param name="fachkunde" select="true()"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="Details">
		<xsl:if test="count(makst:MaklerBetrieb/makst:Detailangaben)>0">
			<table id="Tabelle_nicht_unten" width="100%">
				<tr>
					<td>
						<font id="Titel">Detailangaben zu Makler, Händler</font>
					</td>
				</tr>
			</table>
			<xsl:for-each select="makst:MaklerBetrieb/makst:Detailangaben">
				<xsl:sort select="makst:LfdNr" data-type="number" order="ascending"/>
				<xsl:call-template name="Detailangabe">
					<xsl:with-param name="prefix" select="'makst:'"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="EndeBetrieb">
		<!-- Tabelle mit unterer Linie versehen -->
		<table id="Tabelle_oben" width="100%">
			<tr>
				<td>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="FkbZuBetrieb">
		<xsl:for-each select="makst:FKB">
			<xsl:call-template name="Fkb">
				<xsl:with-param name="prefix" select="'makst:'"/>
				<xsl:with-param name="prefixLib" select="'btrlib:'"/>
			</xsl:call-template>
			<xsl:if test="count(makst:Branchen)>0">
				<table id="Tabelle_nicht_unten" width="100%">
					<tr>
						<td>
							<font id="Titel">Branchen</font>
						</td>
					</tr>
				</table>
				<xsl:for-each select="makst:Branchen">
					<xsl:call-template name="BrancheBtr">
						<xsl:with-param name="prefix" select="'makst:'"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:if>
			<xsl:if test="count(makst:Ansprechpartner)>0">
				<table id="Tabelle_nicht_unten" width="100%">
					<tr>
						<td>
							<font id="Titel">Personen zu Firma, Körperschaft, Betreiber</font>
						</td>
					</tr>
				</table>
				<xsl:for-each select="makst:Ansprechpartner">
					<xsl:call-template name="PersonBtr">
						<xsl:with-param name="prefix" select="'makst:'"/>
						<xsl:with-param name="betriebsinhaber" select="true()"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:if>
			<xsl:if test="count(makst:WeitereAdresseFirma)>0">
				<table id="Tabelle_nicht_unten" width="100%">
					<tr>
						<td>
							<font id="Titel">Weitere Adressen zu Firma, Körperschaft, Betreiber</font>
						</td>
					</tr>
				</table>
				<xsl:for-each select="makst:WeitereAdresseFirma">
					<xsl:call-template name="WeitereAdresse">
						<xsl:with-param name="prefix" select="'makst:'"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:if>
			<table id="Tabelle_oben" width="100%">
				<tr>
					<td>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
