<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
 	xmlns:msg="uri:BMU_Waste_Interface/Message" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns:reg="uri:BMU_Waste_Interface/Reg" 
	xmlns:xades="http://uri.etsi.org/01903/v1.3.2#"
	xmlns:b64="xalan://de.itu.util.Base64" 
	xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
	xmlns:x509="xalan://de.itu.util.X509CertHelper" 
	extension-element-prefixes="b64 crc32 x509" 
	exclude-result-prefixes="xsl lib ds reg b64 crc32 x509 xades">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="msg:Nachricht">
				<xsl:for-each select="msg:Nachricht/msg:Nutzdaten">
					<xsl:apply-templates/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="reg:RegisterAnforderung">
		<html>
			<head>
				<title>Registeranfrage</title>
				<!-- CSS - Datei   -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr>
						<th>
							<xsl:for-each select="//reg:RegisterAnforderung/reg:Angaben">
								<xsl:call-template name="Zeile0"/>
								<xsl:call-template name="Zeile1"/>
								<xsl:call-template name="Zeile2"/>
								<xsl:call-template name="Zeile3"/>
								<xsl:call-template name="Zeile4"/>
								<xsl:call-template name="Zeile5"/>
								<xsl:call-template name="Zeile6"/>
								<xsl:call-template name="Zeile7"/>
							</xsl:for-each>
						</th>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="Zeile0">
		<table width="100%" border="0">
			<tr>
				<td>
					<font id="Nummer">
				Registeranforderung 
				</font>
				</td>
			</tr>
			<tr height="3%">
				<td/>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile1">
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr>
				<td id="Titel"> Nummer Teilanforderung </td>
				<td id="Titel"> Registerauszugsnummer </td>
				<td id="Titel"> Zeitraum</td>
			</tr>
			<tr>
				<td>
					<font id="Aktuell">
						<xsl:value-of select="reg:LfdNrTeilanforderung"/>
					</font>
				</td>
				<td>
					<font id="Aktuell">
						<xsl:value-of select="reg:Registerauszugsnummer"/>
					</font>
				</td>
				<td>
					<font id="titel">von: </font>
					<font id="Aktuell">
						<xsl:call-template name="formatDate">
							<xsl:with-param name="date">
								<xsl:value-of select="reg:Zeitraum/reg:Anfang"/>
							</xsl:with-param>
						</xsl:call-template>
					</font>
					<font id="titel">      bis: </font>
					<font id="Aktuell">
						<xsl:call-template name="formatDate">
							<xsl:with-param name="date">
								<xsl:value-of select="reg:Zeitraum/reg:Ende"/>
							</xsl:with-param>
						</xsl:call-template>
					</font>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile2">
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr height="10">
				<td/>
			</tr>
			<tr align="left">
				<td id="Ueberschrift2"> Adressat </td>
			</tr>
			<tr width="100%">
				<td width="20%" id="Titel"> Beh&#246;rdlicheNummer </td>
				<td width="80%" id="Titel"></td>
			</tr>
			<tr width="100%">
				<td width="20%">
					<font id="Aktuell">
						<xsl:value-of select="reg:Addressat/reg:BehoerdlicheNummer"/>
						<xsl:value-of select="' '"/>
						<xsl:value-of select="reg:Addressat/reg:BehoerdlicheNummer/@lib:ATBRolle"/>
					</font>
				</td>
				<td width="80%">
					<font id="Aktuell">
					</font>
				</td>
			</tr>
		</table>
		<xsl:call-template name="NameUndAdresse">
			<xsl:with-param name="prefix" select="reg:Addressat/reg:NameUndAdresse"/>
			<xsl:with-param name="table_width" select="40"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="Zeile3">
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr height="10">
				<td/>
			</tr>
			<tr align="left">
				<td id="Ueberschrift2"> Filterkriterien </td>
				<xsl:for-each select="reg:FilterKriterien">
					<xsl:choose>
						<xsl:when test="reg:AND">
							<xsl:call-template name="Filterkriterien">
								<xsl:with-param name="parameter" select="'and'"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="reg:OR">
							<xsl:call-template name="Filterkriterien">
								<xsl:with-param name="parameter" select="'or'"/>
							</xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</xsl:for-each>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile4">
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr height="10">
				<td/>
			</tr>
			<tr>
				<td id="Titel"> Lieferfrist </td>
				<td id="Titel"> Exzerpte </td>
			</tr>
			<tr>
				<td>
					<font id="Aktuell">
						<xsl:call-template name="formatDate">
							<xsl:with-param name="date">
								<xsl:value-of select="reg:Lieferfrist"/>
							</xsl:with-param>
						</xsl:call-template>
					</font>
				</td>
				<td>
					<font id="Aktuell">
						<xsl:if test="reg:IndicatorVerzeichnisNachwpfl = 'true'">
						ja
						</xsl:if>
						<xsl:if test="reg:IndicatorVerzeichnisNachwpfl = 'false'">
						nein
						</xsl:if>
					</font>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile5">
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr height="10">
				<td/>
			</tr>
			<tr align="left">
				<td id="Ueberschrift2"> Behörde </td>
			</tr>
		</table>
		<xsl:call-template name="NameUndAdresse">
			<xsl:with-param name="prefix" select="reg:Behoerde/reg:NameUndAdresse"/>
			<xsl:with-param name="table_width" select="40"/>
		</xsl:call-template>
		<xsl:call-template name="Ansprechpartner">
			<xsl:with-param name="prefix" select="reg:Behoerde/reg:Ansprechpartner"/>
			<xsl:with-param name="table_width" select="40"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="Zeile6">
	</xsl:template>
	<xsl:template name="Zeile7">
		<xsl:if test="reg:Rechtsbehelfsbelehrung or reg:Erklaerung">
			<table id="tabelle_nicht_oben_unten" width="100%" border="0">
				<tr height="10">
					<td/>
				</tr>
				<xsl:if test="reg:Rechtsbehelfsbelehrung">
					<table id="tabelle" width="100%" border="0">
						<tr width="100%">
							<td width="100%" id="Titel"> Rechtsbehelfsbelehrung </td>
						</tr>
						<tr width="100%">
							<td width="100%">
								<font id="Aktuell">
									<xsl:value-of select="reg:Rechtsbehelfsbelehrung"/>
								</font>
							</td>
						</tr>
					</table>
				</xsl:if>
				<xsl:if test="reg:Erklaerung">
					<table id="tabelle" width="100%" border="0">
						<tr width="100%">
							<td width="33%" id="Titel"> Ort </td>
							<td width="33%" id="Titel"> Datum </td>
							<td width="33%" id="Titel"> Unterschrift (Signatur) </td>
						</tr>
						<tr width="100%">
							<td width="33%">
								<font id="Aktuell">
									<xsl:value-of select="reg:Erklaerung/lib:Ort"/>
								</font>
							</td>
							<td width="33%">
								<font id="Aktuell">
									<xsl:call-template name="formatDate">
										<xsl:with-param name="date">
											<xsl:value-of select="reg:Erklaerung/lib:Datum"/>
										</xsl:with-param>
									</xsl:call-template>
								</font>
							</td>
							<td width="33%">
								<xsl:call-template name="Sig1NameNoLayer"/>
							</td>
						</tr>
					</table>
				</xsl:if>
			</table>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Filterkriterien">
		<xsl:param name="parameter"/>
		<xsl:choose>
			<xsl:when test="$parameter = 'and'">
				<tr width="100%">
					<td valign="top" width="20%" id="Text_kleiner">UND-Verknüpfung:</td>
					<td width="80%" align="left">
						<xsl:call-template name="ausgabe_AND"/>
					</td>
				</tr>
				<xsl:for-each select="reg:AND">
					<xsl:if test="reg:OR">
						<xsl:call-template name="Filterkriterien">
							<xsl:with-param name="parameter" select="'or'"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="reg:AND">
						<xsl:call-template name="Filterkriterien">
							<xsl:with-param name="parameter" select="'and'"/>
						</xsl:call-template>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="$parameter = 'or'">
				<tr width="100%">
					<td valign="top" width="20%" id="Text_kleiner">ODER-Verknüpfung:</td>
					<td width="80%" align="left">
						<xsl:call-template name="ausgabe_OR"/>
					</td>
				</tr>
				<xsl:for-each select="reg:OR">
					<xsl:if test="reg:OR">
						<xsl:call-template name="Filterkriterien">
							<xsl:with-param name="parameter" select="'or'"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="reg:AND">
						<xsl:call-template name="Filterkriterien">
							<xsl:with-param name="parameter" select="'and'"/>
						</xsl:call-template>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="ausgabe_AND">
		<xsl:for-each select="reg:AND/reg:NachweisNummer">
			<font id="Aktuell"> 
					Nachweis Nummer: <xsl:value-of select="."/>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:for-each select="reg:AND/reg:BehoerdlicheNummerEntsorger">
			<font id="Aktuell"> 
					Beh&#246;rdliche Nummer Entsorger: <xsl:value-of select="."/>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:for-each select="reg:AND/reg:BehoerdlicheNummerBefoerderer">
			<font id="Aktuell"> 
					Beh&#246;rdliche Nummer Bef&#252;rderer: <xsl:value-of select="."/>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:for-each select="reg:AND/reg:BehoerdlicheNummerErzeuger">
			<font id="Aktuell"> 
					Beh&#246;rdliche Nummer Erzeuger: <xsl:value-of select="."/>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:for-each select="reg:AND/reg:BGSUNSNummer">
			<font id="Aktuell">
				<xsl:if test="reg:BGSNummer">
					BGS Nummer:  <xsl:value-of select="reg:BGSNummer"/>
				</xsl:if>
				<xsl:if test="reg:UNSNummer">
					UNS Nummer:  <xsl:value-of select="reg:UNSNummer"/>
				</xsl:if>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:for-each select="reg:AND/reg:Abfallschluesselnummer">
			<font id="Aktuell"> 
					Abfallschl&#252;sselnummer: <xsl:value-of select="."/>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:if test="reg:AND/reg:IndicatorGefaehrlich">
			<font id="Aktuell">
					Gef&#228;hrlich
			</font>
			<br/>
		</xsl:if>
		<xsl:if test="reg:AND/reg:IndicatorNichtGefaehrlich">
			<font id="Aktuell">
					Nicht Gef&#228;hrlich
			</font>
			<br/>
		</xsl:if>
		<xsl:if test="reg:AND/reg:IndicatorNachweispflichtig">
			<font id="Aktuell"> 
					Nachweispflichtig
			</font>
			<br/>
		</xsl:if>
		<xsl:if test="reg:AND/reg:IndicatorNichtNachweispflichtig">
			<font id="Aktuell"> 
					Nicht Nachweispflichtig
			</font>
			<br/>
		</xsl:if>
		<br/>
	</xsl:template>
	<xsl:template name="ausgabe_OR">
		<xsl:for-each select="reg:OR/reg:NachweisNummer">
			<font id="Aktuell"> 
					Nachweis Nummer: <xsl:value-of select="."/>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:for-each select="reg:OR/reg:BehoerdlicheNummerEntsorger">
			<font id="Aktuell"> 
					Beh&#246;rdliche Nummer Entsorger: <xsl:value-of select="."/>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:for-each select="reg:OR/reg:BehoerdlicheNummerBefoerderer">
			<font id="Aktuell"> 
					Beh&#246;rdliche Nummer Bef&#252;rderer: <xsl:value-of select="."/>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:for-each select="reg:OR/reg:BehoerdlicheNummerErzeuger">
			<font id="Aktuell"> 
					Beh&#246;rdliche Nummer Erzeuger: <xsl:value-of select="."/>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:for-each select="reg:OR/reg:BGSUNSNummer">
			<font id="Aktuell">
				<xsl:if test="reg:BGSNummer">
					BGS Nummer:  <xsl:value-of select="reg:BGSNummer"/>
				</xsl:if>
				<xsl:if test="reg:UNSNummer">
					UNS Nummer:  <xsl:value-of select="reg:UNSNummer"/>
				</xsl:if>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:for-each select="reg:OR/reg:Abfallschluesselnummer">
			<font id="Aktuell"> 
					Abfallschl&#252;sselnummer: <xsl:value-of select="."/>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:if test="reg:OR/reg:IndicatorGefaehrlich">
			<font id="Aktuell">
					Gef&#228;hrlich
			</font>
			<br/>
		</xsl:if>
		<xsl:if test="reg:OR/reg:IndicatorNichtGefaehrlich">
			<font id="Aktuell">
					Nicht Gef&#228;hrlich
			</font>
			<br/>
		</xsl:if>
		<xsl:if test="reg:OR/reg:IndicatorNachweispflichtig">
			<font id="Aktuell"> 
					Nachweispflichtig
			</font>
			<br/>
		</xsl:if>
		<xsl:if test="reg:OR/reg:IndicatorNichtNachweispflichtig">
			<font id="Aktuell"> 
					Nicht Nachweispflichtig
			</font>
			<br/>
		</xsl:if>
		<br/>
	</xsl:template>
</xsl:stylesheet>
