<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
 	xmlns:msg="uri:BMU_Waste_Interface/Message" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns:zks="uri:BMU_Waste_Interface/ZKS"
	xmlns:svc_zba="urn:de:bmu:eanv:ServiceModul:0:4"
	xmlns:b64="xalan://de.itu.util.Base64" 
	xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
	xmlns:x509="xalan://de.itu.util.X509CertHelper" 
	extension-element-prefixes="b64 crc32 x509" 
	exclude-result-prefixes="xsl lib ds zks b64 crc32 x509">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<xsl:param name="positionsnummer"/>
	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="msg:Nachricht">
				<xsl:for-each select="msg:Nachricht/msg:Nutzdaten">
					<xsl:apply-templates/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="zks:ZKSErgebnis">
		<html>
			<head>
				<title>ZKS Ergebnis</title>
				<!-- CSS - Datei   -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf">
         			</xsl:call-template>
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr>
						<th>
							<xsl:for-each select="//zks:ZKSErgebnis">
								<xsl:call-template name="Zeile0"/>
								<xsl:call-template name="Zeile1"/>
								<xsl:for-each select="//zks:Meldung">
									<xsl:call-template name="Meldung"/>
								</xsl:for-each>
							</xsl:for-each>
						</th>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="Zeile0">
		<table width="100%" border="0">
			<tr>
				<td>
					<font id="Nummer">
						ZKS Ergebnis 
					</font>
				</td>
			</tr>
			<tr height="3%">
				<td>
			</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile1">
		<table id="tabelle" width="100%" border="0">
			<tr>
				<td id="Titel"> Auftrag UUID </td>
			</tr>
			<tr>
				<td>
					<font id="Aktuell">
						<xsl:value-of select="zks:AuftragUUID"/>
					</font>
				</td>
			</tr>
			<tr>
				<td id="Titel"> Auftragsart </td>
			</tr>

			<tr>
				<td>
					<font id="Aktuell">
						<xsl:value-of select="zks:Auftrag/zks:Auftragsart"/>
					</font>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Meldung">
		<table width="100%" border="0">
			<tr height="10">
				<td>
			
			</td>
			</tr>
			<tr width="100%">
				<td id="Titel">Klasse</td>
			</tr>
			<tr width="100%">
				<td>
					<font id="Aktuell">
						<xsl:value-of select="zks:Klasse"/>
					</font>
				</td>
			</tr>
			<tr width="100%">
				<td width="20%" id="Titel">Stufe</td>
			</tr>
			<tr width="100%">
				<td width="100%">
					<font id="Aktuell">
						<xsl:value-of select="zks:Stufe"/>
					</font>
				</td>
			</tr>
			<tr width="100%">
				<td width="20%" id="Titel">Beschreibung</td>
			</tr>
			<tr width="100%">
				<td width="100%">
					<font id="Aktuell">
						<xsl:value-of select="zks:Beschreibung"/>
					</font>
				</td>
			</tr>
			<tr height="10">
				<td>
			
			</td>
			</tr>
		</table>
	</xsl:template>

</xsl:stylesheet>
