/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.BMUMessageType;
import de.consist.bmu.rule.Rule;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.util.DateUtils;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public abstract class RuleImpl
implements Rule,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(RuleImpl.class);
    private static boolean _jaMonEnabled = false;
    private RuleDef _ruleDef;
    protected static final String NL = "\n";

    protected RuleImpl(RuleDef ruleDef) {
        this._ruleDef = ruleDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<RuleResult> executeInternal(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        if (this.isEnabled(bmuDok)) {
            Monitor mon = null;
            if (_jaMonEnabled) {
                mon = MonitorFactory.getTimeMonitor((String)(this.getClass().getName() + "-" + this._ruleDef.getId() + ":" + bmuDok.getMessageType().getEnumType().toString()));
                mon.start();
            }
            try {
                Document document = bmuDok.getDocument();
                synchronized (document) {
                    ruleResultList = this.execute(bmuDok);
                }
            }
            finally {
                if (mon != null) {
                    mon.stop();
                }
            }
            if (mon != null) {
                LOGGER.debug((Object)mon);
            }
        }
        return ruleResultList;
    }

    public final RuleDef getRuleDef() {
        return this._ruleDef;
    }

    @Override
    public boolean isEnabled(BMUDokument bmuDok) {
        if (bmuDok != null) {
            BMUMessageType msgType = bmuDok.getMessageType();
            if (!this._ruleDef.isEnabled()) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Regel " + this._ruleDef.getName() + " ist deaktiviert."));
                }
                return false;
            }
            if (this._ruleDef.getDocTypes() != null && !this._ruleDef.getDocTypes().contains(msgType.getEnumType().toString())) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Regel " + this._ruleDef.getName() + " ist nicht f\u00fcr " + msgType.getEnumType().toString() + "."));
                }
                return false;
            }
            if (this._ruleDef.getUseSignatureDate() && this._ruleDef.getKeyDate().after(bmuDok.getMessageType().getLastSignTime())) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Regel " + this._ruleDef.getName() + " wird erst ab " + DateUtils.toDateTimeString(this._ruleDef.getKeyDate()) + " angewandt, das Datum der j\u00fcngsten Signatur ist " + DateUtils.toDateTimeString(bmuDok.getMessageType().getLastSignTime()) + "."));
                }
                return false;
            }
            if (this._ruleDef.getUseSignatureDate() && this._ruleDef.getKeyToDate().before(bmuDok.getMessageType().getFirstSignTime())) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Regel " + this._ruleDef.getName() + " wird erst ab " + DateUtils.toDateTimeString(this._ruleDef.getKeyDate()) + " angewandt, das Datum der \u00e4ltesten Signatur ist " + DateUtils.toDateTimeString(bmuDok.getMessageType().getFirstSignTime()) + "."));
                }
                return false;
            }
            if (!this._ruleDef.getUseSignatureDate() && this._ruleDef.getKeyDate().after(bmuDok.getMessageType().getFirstSignTime())) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Regel " + this._ruleDef.getName() + " wird erst ab " + DateUtils.toDateTimeString(this._ruleDef.getKeyDate()) + " angewandt, das Referenzdatum ist " + DateUtils.toDateTimeString(bmuDok.getMessageType().getFirstSignTime()) + "."));
                }
                return false;
            }
            if (!this._ruleDef.getUseSignatureDate() && this._ruleDef.getKeyToDate().before(bmuDok.getMessageType().getFirstSignTime())) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Regel " + this._ruleDef.getName() + " wird nur bis " + DateUtils.toDateTimeString(this._ruleDef.getKeyToDate()) + " angewandt, das Referenzdatum ist " + DateUtils.toDateTimeString(bmuDok.getMessageType().getFirstSignTime()) + "."));
                }
                return false;
            }
        } else {
            return this._ruleDef.isEnabled();
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Regel " + this._ruleDef.getName() + " wird angewandt!"));
        }
        return true;
    }

    public static RuleImpl newRuleImpl(RuleDef ruleDef) throws BMUException {
        RuleImpl ruleImpl = null;
        try {
            Object className = ruleDef.getName();
            if (!ruleDef.getName().contains(".")) {
                className = "de.consist.bmu.rule.impl.RuleImpl" + (String)className;
            }
            LOGGER.debug((Object)("creating instance of class '" + (String)className + "'"));
            Class<?> ruleClass = Class.forName((String)className);
            if (ruleClass != null && RuleImpl.class.isAssignableFrom(ruleClass)) {
                ruleImpl = (RuleImpl)ruleClass.getConstructor(RuleDef.class).newInstance(ruleDef);
            } else {
                LOGGER.error((Object)("Error instanciating RuleImpl from RuleDef: " + String.valueOf(ruleDef)));
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Object)("Error creating Rule from RuleDef: " + String.valueOf(ruleDef)), (Throwable)e);
            throw new BMUException("Error creating Rule from RuleDef: " + String.valueOf(ruleDef), e);
        }
        catch (SecurityException e) {
            LOGGER.error((Object)("Error creating Rule from RuleDef: " + String.valueOf(ruleDef)), (Throwable)e);
            throw new BMUException("Error creating Rule from RuleDef: " + String.valueOf(ruleDef), e);
        }
        catch (InstantiationException e) {
            LOGGER.error((Object)("Error creating Rule from RuleDef: " + String.valueOf(ruleDef)), (Throwable)e);
            throw new BMUException("Error creating Rule from RuleDef: " + String.valueOf(ruleDef), e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)("Error creating Rule from RuleDef: " + String.valueOf(ruleDef)), (Throwable)e);
            throw new BMUException("Error creating Rule from RuleDef: " + String.valueOf(ruleDef), e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error((Object)("Error creating Rule from RuleDef: " + String.valueOf(ruleDef)), (Throwable)e);
            throw new BMUException("Error creating Rule from RuleDef: " + String.valueOf(ruleDef), e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error((Object)("Error creating Rule from RuleDef: " + String.valueOf(ruleDef)), (Throwable)e);
            throw new BMUException("Error creating Rule from RuleDef: " + String.valueOf(ruleDef), e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)("Error creating Rule from RuleDef: " + String.valueOf(ruleDef)), (Throwable)e);
            throw new BMUException("Error creating Rule from RuleDef: " + String.valueOf(ruleDef), e);
        }
        return ruleImpl;
    }

    public static boolean isJaMonEnabled() {
        return _jaMonEnabled;
    }

    public static void setJaMonEnabled(boolean jaMonEnabled) {
        _jaMonEnabled = jaMonEnabled;
    }
}

