/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.NodeList;

public final class RuleImplBGSIndicatorQuittungsbeleg
extends RuleImpl {
    private static final long serialVersionUID = 1L;

    public RuleImplBGSIndicatorQuittungsbeleg(RuleDef ruleDef) {
        super(ruleDef);
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        int index = 1;
        for (XPathATB xPathATB : XPathATB.values()) {
            try {
                if (!XPathFassade.getInstance().evalBool(bmuDok.getDocument().getDocumentElement(), xPathATB._xPathQB)) continue;
                NodeList nl = XPathFassade.getInstance().evaluateNodeList(bmuDok.getDocument(), xPathATB._xPathData);
                boolean textfound = false;
                for (int i = 0; i < nl.getLength(); ++i) {
                    if (nl.item(i).getTextContent().equals("")) continue;
                    textfound = true;
                    break;
                }
                if (textfound) continue;
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, xPathATB.toString()));
            }
            catch (XPathExpressionException e) {
                throw new BMUException("Fehler beim Pr\u00fcfen", e);
            }
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPathes zur Ermittlung von Abfalltransportbeteiligten mit 'IndicatorQuittungsbeleg' ohne weitere Daten: ");
        for (XPathATB atbXPath : XPathATB.values()) {
            builder.append("\n");
            builder.append(atbXPath.toString());
            builder.append(", Quittungsbeleg gesetzt: ");
            builder.append(atbXPath._xPathQB);
            builder.append(", weitere Daten vorhanden: \"");
            builder.append(atbXPath._xPathData);
        }
        return builder.toString();
    }

    private static enum XPathATB {
        ERZ("count(/descendant::bgs:Erzeuger[bgs:IndicatorQuittungsbeleg]) > 0", "/descendant::bgs:Erzeuger/descendant::*[not(local-name()='IndicatorQuittungsbeleg') and not(local-name()='Versicherung')]"),
        BEF1("count(/descendant::bgs:Befoerderer[bgs:LfdNrBefoerderer=1 and bgs:IndicatorQuittungsbeleg]) > 0", "/descendant::bgs:Befoerderer[bgs:LfdNrBefoerderer=1]/descendant::*[not(local-name()='LfdNrBefoerderer') and not(local-name()='IndicatorQuittungsbeleg') and not(local-name()='VersicherungErsterBef') and not(local-name()='VersicherungWeitererBef')]"),
        BEF2("count(/descendant::bgs:Befoerderer[bgs:LfdNrBefoerderer=2 and bgs:IndicatorQuittungsbeleg]) > 0", "/descendant::bgs:Befoerderer[bgs:LfdNrBefoerderer=2]/descendant::*[not(local-name()='LfdNrBefoerderer') and not(local-name()='IndicatorQuittungsbeleg') and not(local-name()='VersicherungErsterBef') and not(local-name()='VersicherungWeitererBef')]"),
        BEF3("count(/descendant::bgs:Befoerderer[bgs:LfdNrBefoerderer=3 and bgs:IndicatorQuittungsbeleg]) > 0", "/descendant::bgs:Befoerderer[bgs:LfdNrBefoerderer=3]/descendant::*[not(local-name()='LfdNrBefoerderer') and not(local-name()='IndicatorQuittungsbeleg') and not(local-name()='VersicherungErsterBef') and not(local-name()='VersicherungWeitererBef')]"),
        ENT("count(/descendant::bgs:Entsorger[bgs:IndicatorQuittungsbeleg]) > 0", "/descendant::bgs:Entsorger/descendant::*[not(local-name()='IndicatorQuittungsbeleg') and not(local-name()='Versicherung')]"),
        ZWL("count(/descendant::bgs:Lager[bgs:IndicatorQuittungsbeleg]) > 0", "/descendant::bgs:Lager/descendant::*[not(local-name()='IndicatorQuittungsbeleg') and not(local-name()='Versicherung')]");

        private String _xPathQB;
        private String _xPathData;

        private XPathATB(String xPathQB, String xPathData) {
            this._xPathQB = xPathQB;
            this._xPathData = xPathData;
        }
    }
}

