/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.BMUMessageType;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public final class RuleImplListIndex
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final NameXPath[] XPATH_BGS_INDEX = new NameXPath[]{new NameXPath("Fehler", "bgs:Fehler"), new NameXPath("Sortiment", "bgs:Sortiment"), new NameXPath("UNSNummer", "bgs:UNSNummer"), new NameXPath("WeitereAbfgallschluessel", "bgs:WeitereAbfallschluessel"), new NameXPath("PCBFraktion", "bgs:PCBFraktion")};
    private static final NameXPath[] XPATH_ENS_INDEX = new NameXPath[]{new NameXPath("BImSchG", "en:BImSchG"), new NameXPath("Kreis", "en:Kreis"), new NameXPath("Bundesland", "en:Bundesland"), new NameXPath("Fehler", "en:Fehler"), new NameXPath("Nebenbestimmung BB", "en:Nebenbestimmung[parent::en:BB]"), new NameXPath("Begruendung BB", "en:Begruendung[parent::en:BB]"), new NameXPath("Adressat BB", "en:Adressat[ancestor::en:BB]"), new NameXPath("Nebenbestimmung ANO", "en:Nebenbestimmung[parent::en:Anordnung]"), new NameXPath("Begruendung ANO", "en:Begruendung[parent::en:Anordnung]"), new NameXPath("Adressat ANO", "en:Adressat[ancestor::en:Anordnung]")};
    private static final NameXPath[] XPATH_FR_INDEX = new NameXPath[]{new NameXPath("Abfall", "en:Abfall"), new NameXPath("Nebenbestimmung", "en:Nebenbestimmung[parent::en:BB]"), new NameXPath("Begruendung", "en:Begruendung[parent::en:BB]"), new NameXPath("Adressat", "en:Adressat[ancestor::en:BB]")};
    private static final NameXPath[] XPATH_EGF_INDEX = new NameXPath[]{new NameXPath("Bundesland", "en:Bundesland")};
    private static final Log LOGGER = LogFactory.getLog(RuleImplListIndex.class);

    public RuleImplListIndex(RuleDef ruleDef) {
        super(ruleDef);
    }

    private int getMaxValue(NodeList nl) {
        int maxValue = 0;
        for (int i = 0; i < nl.getLength(); ++i) {
            int indexValue = Integer.parseInt(nl.item(i).getTextContent());
            if (indexValue <= maxValue) continue;
            maxValue = indexValue;
        }
        return maxValue;
    }

    private List<RuleResult> checkIndex(NameXPath nx, Document doc, int index) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        String xPathIndex0 = "count(/descendant::" + nx._xPath + "[@lib:Index=0]) > 0";
        try {
            if (XPathFassade.getInstance().evalBool(doc.getDocumentElement(), xPathIndex0)) {
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, nx._name + " mit Index 0"));
            }
            NodeList nl = XPathFassade.getInstance().evaluateNodeList(doc, "/descendant::" + nx._xPath + "/@lib:Index");
            int maxValue = this.getMaxValue(nl);
            for (int i = 1; i <= maxValue; ++i) {
                String indexAttr = "[@lib:Index=" + i + "]";
                String indexXPath = "/descendant::" + nx._xPath + indexAttr;
                if (!XPathFassade.getInstance().evalBool(doc.getDocumentElement(), indexXPath)) {
                    ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, nx._name + " mit Index " + i + " fehlt"));
                    continue;
                }
                String multipleIndexXPath = indexXPath + "/preceding-sibling::" + nx._xPath + indexAttr;
                if (!XPathFassade.getInstance().evalBool(doc.getDocumentElement(), multipleIndexXPath)) continue;
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, nx._name + " mit Index " + i + " gibt es auf dieser Ebene schon"));
            }
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        return ruleResultList;
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        Document doc = bmuDok.getDocument();
        BMUMessageType msgType = bmuDok.getMessageType();
        int index = 1;
        NameXPath[] nxp = null;
        switch (msgType.getEnumType()) {
            case ENSNDokument: {
                nxp = XPATH_ENS_INDEX;
                break;
            }
            case BGSDokument: {
                nxp = XPATH_BGS_INDEX;
                break;
            }
            case EGFDokument: {
                nxp = XPATH_EGF_INDEX;
                break;
            }
            case FRDokument: {
                nxp = XPATH_FR_INDEX;
                break;
            }
            default: {
                LOGGER.warn((Object)("unexpected message-type: " + String.valueOf((Object)msgType.getEnumType())));
            }
        }
        if (nxp != null) {
            for (NameXPath nx : nxp) {
                List<RuleResult> rrl = this.checkIndex(nx, doc, index);
                index += rrl.size();
                ruleResultList.addAll(rrl);
            }
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("Rollbereiche in Nachweisdokumenten:");
        builder.append("\n");
        for (NameXPath nx : XPATH_ENS_INDEX) {
            builder.append(" Name: ");
            builder.append(nx._name);
            builder.append(", XPath: ");
            builder.append("/descendant::" + nx._xPath + "/@lib:Index");
            builder.append("\n");
        }
        builder.append(", Rollbereiche in Begleitscheinen:");
        builder.append("\n");
        for (NameXPath nx : XPATH_BGS_INDEX) {
            builder.append("Name: ");
            builder.append(nx._name);
            builder.append(", XPath: ");
            builder.append("/descendant::" + nx._xPath + "/@lib:Index");
            builder.append("\n");
        }
        builder.append(", Rollbereiche in EGFDokumenten:");
        builder.append("\n");
        for (NameXPath nx : XPATH_EGF_INDEX) {
            builder.append("Name: ");
            builder.append(nx._name);
            builder.append(", XPath: ");
            builder.append("/descendant::" + nx._xPath + "/@lib:Index");
            builder.append("\n");
        }
        builder.append(", Rollbereiche in Freistellungen:");
        builder.append("\n");
        for (NameXPath nx : XPATH_FR_INDEX) {
            builder.append("Name: ");
            builder.append(nx._name);
            builder.append(", XPath: ");
            builder.append("/descendant::" + nx._xPath + "/@lib:Index");
            builder.append("\n");
        }
        return builder.toString();
    }

    static class NameXPath {
        private String _name;
        private String _xPath;

        NameXPath(String name, String xPath) {
            this._name = name;
            this._xPath = xPath;
        }
    }
}

