/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-01-24 23:53:57 +0000 (Thu, 24 Jan 2013) $ $Rev: 979 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.error;

import org.w3c.dom.Document;

import de.consist.bmu.rule.RuleSetResult;

/**
 * Exception, die beim parsen eines XML-Dokuments geworfen werden kann.
 * @author srossbroich
 *
 */
public class BMUParseException extends Exception {

    private static final long serialVersionUID = 1L;
    private RuleSetResult _ruleSetResult;
    
    /**
     * @param meldung RuleSetResult
     */
    public BMUParseException(RuleSetResult meldung) {
        _ruleSetResult = meldung;
    }

    /**
     * @param message String
     * @param cause Throwable
     * @param meldung RuleSetResult
     */
    public BMUParseException(String message, Throwable cause, RuleSetResult meldung) {
        super(message, cause);
        _ruleSetResult = meldung;
    }

    /**
     * @param cause Throwable
     * @param meldung RuleSetResult
     */
    public BMUParseException(Throwable cause, RuleSetResult meldung) {
        super(cause);
        _ruleSetResult = meldung;
    }

    /**
     * @param msg String
     * @param meldung RuleSetResult
     */
    public BMUParseException(String msg, RuleSetResult meldung) {
        super(msg);
        _ruleSetResult = meldung;
    }

    /**
     * @return RuleSetResult
     */
    public final RuleSetResult getRuleSetResult() {
        return _ruleSetResult;
    }
    
    /**
     * @return Document
     * @throws BMUException BMUException
     */
    public final Document toQuittung() throws BMUException {
        if (_ruleSetResult != null) {
            return _ruleSetResult.toQuittung();
        } else {
            throw new BMUException("Kein RuleSetResult !");
        }
    }
}
