/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 08:24:11 +0000 (Fri, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;


import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplENSNachweisNr extends RuleImpl {

    private static final long serialVersionUID = 1L;

    /**
     * XPath fuer en:NachweisNr.
     */
    private static final String XPATH_NACHWEISNR = "count(/descendant::lib:NachweisNr[parent::en:Nachweisnummer])=0 and count(/descendant::en:VorlaeufigeENNr[parent::*[@lib:LayerID]])=0";

    /**
     * @param ruleDef RuleDef
     */
    public RuleImplENSNachweisNr(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        try {
            if (XPathFassade.getInstance().evalBool(bmuDok.getDocument().getDocumentElement(),
                    XPATH_NACHWEISNR)) {
                ruleResultList.add(new RuleResultImpl(getRuleDef(), 1, null));
            }
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        return "XPath fr die Prfung: " + XPATH_NACHWEISNR;
    }

}
