/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 08:24:11 +0000 (Fri, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplFXSNS extends RuleImpl {

    private static final long serialVersionUID = 1L;

    /**
     * XPath zur berprfung auf leeren Namespace in freien XML-Strukturen.
     */
    private static final String XPATH_FXS_NS_NULL = "/descendant::*[local-name()='FreieXMLStruktur' and @lib:NamespaceURI][descendant::*[namespace-uri()='']]";

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplFXSNS(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        NodeList nl;
        try {
            nl = XPathFassade.getInstance().evaluateNodeList(bmuDok.getDocument(),
                    XPATH_FXS_NS_NULL);
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        for (int i = 0; i < nl.getLength(); i++) {
            String id = ((Element) nl.item(i)).getAttributeNS(Namespace.TypenBibliothek.getUri(), "id");
            ruleResultList.add(new RuleResultImpl(getRuleDef(), i + 1, id));
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        return "XPath fr die Prfung: " + XPATH_FXS_NS_NULL;
    }

}
