/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2015-10-06 13:27:50 +0000 (Tue, 06 Oct 2015) $ $Rev: 1405 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.BMUMessageType;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.BMUMessageType.ENStatus;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.schema.BMUKopfdaten.Rolle;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplSignatureID extends RuleImpl {

    private static final long serialVersionUID = 1L;

    private static final String[] XPATH_BGS_SIG = {
        "/descendant::bgs:BGSVorlageLayer/ds:Signature",
        "/descendant::bgs:BGSErgaenzungsLayer/ds:Signature" };

    private static final String[] XPATH_BGS_SIG_ID = {
            "/descendant::bgs:BGSERZLayer/ds:Signature/@Id[not(starts-with(.,'ERZ'))]",
            "/descendant::bgs:BGSBEFLayer/ds:Signature/@Id[not(starts-with(.,'BEF'))]",
            "/descendant::bgs:BGSZWLLayer/ds:Signature/@Id[not(starts-with(.,'ZWL'))]",
            "/descendant::bgs:BGSENTLayer/ds:Signature/@Id[not(starts-with(.,'ENT'))]",
            "/descendant::bgs:BGSBEHLayer/ds:Signature/@Id[not(starts-with(.,'BEH'))]" };

    private static final String[] XPATH_ENSN_SIG = {
        "/descendant::en:ENSNVorlageLayer/ds:Signature",
        "/descendant::en:ENSNErgaenzungsLayer/ds:Signature" };

    private static final String[] XPATH_ENSN_SIG_ID = {
            "/descendant::en:ENSNENTLayer/ds:Signature/@Id[not(starts-with(.,'ENT'))]",
            "/descendant::en:ENSNBEHLayer/ds:Signature/@Id[not(starts-with(.,'BEH'))]" };

    private static final String XPATH_EN_SIG_ID = "/descendant::en:ENSNERZLayer/ds:Signature/@Id[not(starts-with(.,'ERZ')) and not(starts-with(.,'BVE'))]";

    private static final String XPATH_SN_SIG_ID = "/descendant::en:ENSNERZLayer/ds:Signature/@Id[not(starts-with(.,'BEF'))]";

    private static final String[] XPATH_UNS_SIG = {
            "/descendant::bgs:UNSVorlageLayer/ds:Signature",
            "/descendant::bgs:UNSBasisLayer/ds:Signature",
            "/descendant::bgs:UNSErgaenzungsLayer/ds:Signature" };

    private static final String[] XPATH_FR_SIG_ID = {
            "/descendant::en:FRENTLayer/ds:Signature/@Id[not(starts-with(.,'ENT'))]",
            "/descendant::en:FRBEHLayer/ds:Signature/@Id[not(starts-with(.,'BEH'))]" };

    private static final Log LOGGER = LogFactory
            .getLog(RuleImplSignatureID.class);

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplSignatureID(RuleDef ruleDef) {
        super(ruleDef);
    }

    private List<RuleResult> checkSignatureIdATBRolle(Document doc, String xPath, int index) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        NodeList sigNodeList;
        try {
            sigNodeList = XPathFassade.getInstance().evaluateNodeList(
                    doc, xPath);
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        int foundIndex = index;
        for (int i = 0; i < sigNodeList.getLength(); i++) {
            Element sigNode = (Element) sigNodeList.item(i);
            Element layerNode = (Element) sigNode.getParentNode();
            String sigID = sigNode.getAttribute("Id");
            String atbRolle = layerNode.getAttributeNS(Namespace.TypenBibliothek.getUri(), "ATBRolle");
            Rolle rolle = Rolle.valueOf(atbRolle);
            if (!sigID.startsWith(rolle.getIDRolle())) {
                ruleResultList.add(new RuleResultImpl(getRuleDef(), foundIndex++,
                        sigID));
            }
        }
        return ruleResultList;
    }

    private List<RuleResult> checkSignatureId(Document doc, String xPath, int index)
            throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        NodeList layerNodeList;
        try {
            layerNodeList = XPathFassade.getInstance().evaluateNodeList(
                    doc, xPath);
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        for (int i = 0; i < layerNodeList.getLength(); i++) {
            Node sigIdNode = layerNodeList.item(i);
            ruleResultList.add(new RuleResultImpl(getRuleDef(), index + i,
                    sigIdNode.getTextContent()));
        }
        return ruleResultList;
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        Document doc = bmuDok.getDocument();
        BMUMessageType msgType = bmuDok
                .getMessageType();
        int index = 1;
        switch (msgType.getEnumType()) {
        case BGSDokument:
            for (String xPath : XPATH_BGS_SIG) {
                ruleResultList.addAll(checkSignatureIdATBRolle(doc, xPath, index
                        + ruleResultList.size()));
            }
            for (String xPath : XPATH_BGS_SIG_ID) {
                ruleResultList.addAll(checkSignatureId(doc, xPath, index
                        + ruleResultList.size()));
            }
            break;
        case UNSDokument:
            for (String xPath : XPATH_UNS_SIG) {
                ruleResultList.addAll(checkSignatureIdATBRolle(doc, xPath, index
                        + ruleResultList.size()));
            }
            break;
        case ENSNDokument:
            for (String xPath : XPATH_ENSN_SIG) {
                ruleResultList.addAll(checkSignatureIdATBRolle(doc, xPath, index
                        + ruleResultList.size()));
            }
            for (String xPath : XPATH_ENSN_SIG_ID) {
                ruleResultList.addAll(checkSignatureId(doc, xPath, index
                        + ruleResultList.size()));
            }
            // FIXME Warum ist diese und nur diese Ausnahme notwendig?
            if (ENStatus.EN.equals(msgType.getENStatus())) {
                ruleResultList.addAll(checkSignatureId(doc, XPATH_EN_SIG_ID, index
                        + ruleResultList.size()));
            } else if (ENStatus.SN.equals(msgType.getENStatus())) {
                ruleResultList.addAll(checkSignatureId(doc, XPATH_SN_SIG_ID, index
                        + ruleResultList.size()));
            } else {
            	LOGGER.warn("Prfregel 'SignatureID' wird nicht vollstndig angewendet, weil nicht ermittelt werden konnte, ob es sich um einen EN oder SN handelt!");
//                ruleResultList.add(new RuleResultImpl(getRuleDef(), index
//                        + ruleResultList.size(),
//                        "Klassifizierung in EN/SN nicht mglich"));
            }
            break;
        case FRDokument:
            for (String xPath : XPATH_FR_SIG_ID) {
                ruleResultList.addAll(checkSignatureId(doc, xPath, index
                        + ruleResultList.size()));
            }
            break;
        default:
            LOGGER.warn("unexpected message-type: " + msgType.getEnumType());
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPathes fr die Prfung von Begleitscheinen");
        builder.append(RuleImpl.NL);
        builder.append("1. Rolle in der Signatur-ID muss der Rolle in ATBRolle des Layers entsprechen: ");
        builder.append(Arrays.deepToString(XPATH_BGS_SIG));
        builder.append(RuleImpl.NL);
        builder.append("2. Rolle in der Signatur-ID muss der fr diesen Layer zu erwartenden Rolle entsprechen: ");
        builder.append(Arrays.deepToString(XPATH_BGS_SIG_ID));
        builder.append(RuleImpl.NL);
        builder.append("XPathes fr die Prfung von bernahmescheinen (Rolle in der Signatur-ID muss der Rolle in ATBRolle des Layers entsprechen): ");
        builder.append(Arrays.deepToString(XPATH_UNS_SIG));
        builder.append(RuleImpl.NL);
        builder.append("XPathes fr die Prfung von Nachweisen");
        builder.append(RuleImpl.NL);
        builder.append("1. Rolle in der Signatur-ID muss der Rolle in ATBRolle des Layers entsprechen: ");
        builder.append(Arrays.deepToString(XPATH_ENSN_SIG));
        builder.append(RuleImpl.NL);
        builder.append("2. Rolle in der Signatur-ID muss der fr diesen Layer zu erwartenden Rolle entsprechen: ");
        builder.append(Arrays.deepToString(XPATH_ENSN_SIG_ID));
        builder.append(RuleImpl.NL);
        builder.append("XPath fr die Prfung von Entsorgungsnachweisen: ");
        builder.append(XPATH_EN_SIG_ID);
        builder.append(RuleImpl.NL);
        builder.append("XPath fr die Prfung von Sammelentsorgungsnachweisen: ");
        builder.append(XPATH_SN_SIG_ID);
        builder.append(RuleImpl.NL);
        builder.append("XPathes fr die Prfung von Freistellungen (Rolle in der Signatur-ID muss der fr diesen Layer zu erwartenden Rolle entsprechen): ");
        builder.append(Arrays.deepToString(XPATH_FR_SIG_ID));
        return builder.toString();
    }

}
