/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2024-02-06 14:29:28 +0000 (Tue, 06 Feb 2024) $ $Rev: 1787 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.io.Serializable;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;

import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.def.RuleDefImpl;

/**
 * Klasse mit dem Ergebnis einer Pruefregel.
 * 
 * @author srossbroich
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ruleresult", propOrder = { "_ruleDef", "_index", "_message" })
@XmlRootElement(name = "Regelergebnis")
public class RuleResultImpl implements RuleResult, Serializable {

    private static final long serialVersionUID = 1L;

    @XmlElement(name = "Regel", type = RuleDefImpl.class)
    private RuleDef _ruleDef;
    @XmlElement(name = "Index")
    private int _index;
    @XmlElement(name = "Message")
    private String _message;

    /**
     * Konstruktor.
     */
    public RuleResultImpl() {
    }

    /**
     * Adapter fuer JAXB.
     */
    public static class Adapter extends XmlAdapter<RuleResultImpl, RuleResult> {
        /**
         * {@inheritDoc}
         */
        @Override
        public final RuleResult unmarshal(RuleResultImpl ruleResultImpl) {
            return ruleResultImpl;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final RuleResultImpl marshal(RuleResult ruleResult) {
            return (RuleResultImpl) ruleResult;
        }
    }

    /**
     * @param ruleDef
     *            RuleDef
     * @param index
     *            Der Index des RuleResults
     * @param message
     *            String
     */
    public RuleResultImpl(RuleDef ruleDef, int index, String message) {
        this._ruleDef = ruleDef;
        this._message = message;
        this._index = index;
    }

    /**
     * {@inheritDoc}
     */
    public final RuleDef getRuleDef() {
        return _ruleDef;
    }

    /**
     * {@inheritDoc}
     */
    public final int getIndex() {
        return _index;
    }

    /**
     * {@inheritDoc}
     */
    public final String getMessage() {
        return _message;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RuleDef: " + _ruleDef);
        builder.append(", index: " + _index);
        builder.append(", Message=" + _message);
        return builder.toString();
    }

}
