package de.consist.bmu.rule.schema;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.TypeInfoProvider;
import javax.xml.validation.ValidatorHandler;

import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.util.XmlElementInfo;

public class TypeLister extends DefaultHandler {

    private TypeInfoProvider provider;
    
    public TypeLister(TypeInfoProvider provider) {
        typeList = new HashSet<XmlElementInfo>();
        this.provider = provider;
    }
    
    private Set<XmlElementInfo> typeList;

    public static Set<XmlElementInfo> getDateTypes(Document doc) throws BMUException {
    	ContentHandler cHandler = null;
    	try {
            Schema schema = SchemaValidator.getInstance().getSchema();
            ValidatorHandler vHandler = schema.newValidatorHandler();
            TypeInfoProvider provider = vHandler.getTypeInfoProvider();
            cHandler = new TypeLister(provider);
            vHandler.setContentHandler(cHandler);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Source xmlSource = new DOMSource(doc);
            Result outputTarget = new StreamResult(outputStream);
            TransformerFactory.newInstance().newTransformer()
                    .transform(xmlSource, outputTarget);
            InputStream is = new ByteArrayInputStream(
                    outputStream.toByteArray());
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser saxParser = spf.newSAXParser();
            XMLReader parser = saxParser.getXMLReader();
//            deprecated in Java 11
//            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(vHandler);
            InputSource source = new InputSource(is);
            parser.parse(source);
        } catch (Exception e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        return ((TypeLister) cHandler).typeList;
    }
    
    @Override
    public void startElement(String namespace, String localName,
            String qualifiedName, Attributes atts) throws SAXException {
        if (provider.getElementTypeInfo() != null) {
            String type = provider.getElementTypeInfo().getTypeName();
            if (type.equals("DatumTyp") || type.equals("date")
                    || type.equals("dateTime")) {
                XmlElementInfo info = new XmlElementInfo(namespace, localName);
                typeList.add(info);
            }
        }
    }

}
