/*
 * Decompiled with CFR 0.152.
 */
package seccommerce.secsignersigg;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import seccommerce.mobile.bo.CntReqStatusType;
import seccommerce.mobile.bo.ContactRequest;
import seccommerce.secsignersigg.ag;
import seccommerce.secsignersigg.aqt;
import seccommerce.secsignersigg.b2c;
import seccommerce.secsignersigg.b2e;
import seccommerce.secsignersigg.b2f;
import seccommerce.secsignersigg.b2h;
import seccommerce.secsignersigg.b_e;
import seccommerce.secsignersigg.bwo;
import seccommerce.secsignersigg.bxv;
import seccommerce.secsignersigg.bxx;
import seccommerce.secsignersigg.byn;
import seccommerce.secsignersigg.cbu;
import seccommerce.secsignersigg.cc;
import seccommerce.secsignersigg.ccz;
import seccommerce.secsignersigg.op;
import seccommerce.secsignersigg.xx;
import seccommerce.user.bo.IdProfile;
import seccommerce.user.bo.VisibilityType;

@b2e(a=b2f.IDSERVER, b=b2h.REQUEST)
public class bxw
implements bxv {
    @b2c
    private bwo a;
    @b2c
    private byn b;

    @Override
    public void a(@NotNull List<Long> list) throws aqt {
        Objects.requireNonNull(list, "acceptContactRequest: contactRequestIds must not be null");
        try {
            this.b.b(list);
        }
        catch (b_e b_e2) {
            throw new aqt("ContactRequestService: Could not accept contact request " + cc.a(list, ","), b_e2);
        }
    }

    @Override
    public void b(@NotNull List<Long> list) throws aqt {
        Objects.requireNonNull(list, "rejectContactRequest: contactRequestIds must not be null");
        try {
            this.b.c(list);
        }
        catch (b_e b_e2) {
            throw new aqt("ContactRequestService: Could not reject contact request " + cc.a(list, ","), b_e2);
        }
    }

    public void a(@NotNull Long l10, @NotNull Long l11, @NotNull IdProfile idProfile) throws aqt {
        Objects.requireNonNull(l10, "sendContactRequest: orgId must not be null");
        Objects.requireNonNull(l11, "Cannot sendContactRequest: requesterUserIdId is null");
        Objects.requireNonNull(idProfile, "Cannot sendContactRequest: recipient is null");
        if (VisibilityType.PRIVATE.equals(idProfile.getPrfVisibility())) {
            this.b(l10, l11, idProfile.getUserIdId());
            return;
        }
        this.a(l10, l11, idProfile.getUserIdId());
    }

    @Override
    public void a(@NotNull Long l10, @NotNull Long l11, @NotNull Long l12) throws aqt {
        Objects.requireNonNull(l10, "sendContactRequest: orgId must not be null");
        Objects.requireNonNull(l11, "Cannot sendContactRequest: requesterUserIdId is null");
        Objects.requireNonNull(l12, "Cannot sendContactRequest: recipientUserIdId is null");
        this.a(l10, l11, l12, bxx.a);
    }

    public void b(@NotNull Long l10, @NotNull Long l11, @NotNull Long l12) throws aqt {
        Objects.requireNonNull(l10, "sendHiddenContactRequest: orgId must not be null");
        Objects.requireNonNull(l11, "Cannot sendHiddenContactRequest: requesterUserIdId is null");
        Objects.requireNonNull(l12, "Cannot sendHiddenContactRequest: recipientUserIdId is null");
        this.a(l10, l11, l12, bxx.b);
    }

    @NotNull
    public List<cbu> a(@NotNull Set<Long> set) throws aqt {
        List list;
        Objects.requireNonNull(set, "get: contactRequestIds must not be null");
        try {
            list = this.b.a(set);
        }
        catch (b_e b_e2) {
            throw new aqt("Error while trying to get contact request with id " + set, b_e2);
        }
        if (list == null) {
            return Collections.emptyList();
        }
        return ccz.a(list, cbu::new);
    }

    private final void a(@NotNull Long l10, @NotNull Long l11, @NotNull Long l12, @NotNull bxx bxx2) throws aqt {
        Objects.requireNonNull(l10, "send: orgId must not be null");
        Objects.requireNonNull(l11, "Cannot send contact request: requesterUserIdId is null");
        Objects.requireNonNull(l12, "Cannot send contact request: recipientUserIdId is null");
        Objects.requireNonNull(bxx2, "Cannot send contact request: visibility is null");
        if (l11.equals(l12)) {
            throw new IllegalArgumentException("ContactRequestService Cannot create new contact request: userIdId " + l12 + " cannot be both requester and recipient");
        }
        if (this.b(l11, l12) != null) {
            op.f("ContactRequestService: Not sending a contact request from " + l11 + " to " + l12 + " because a request was already sent earlier.");
            return;
        }
        op.f("Sending contact request from userIdId " + l11 + " to userIdId " + l12);
        try {
            this.b.a(l10, l11, l12, CntReqStatusType.ah, bxx2);
        }
        catch (b_e b_e2) {
            throw new aqt("Error while sending contact request from userIdId " + l11 + " to userIdId " + l12, b_e2);
        }
        op.g("Sending notification to user " + l12 + " about received contact request");
        this.a.a(new xx(l12, l10));
    }

    @Nullable
    public cbu b(@NotNull Long l10, @NotNull Long l11) throws aqt {
        Objects.requireNonNull(l10, "Cannot findRequest: userIdIdA is null");
        Objects.requireNonNull(l11, "Cannot findRequest: userIdIdB is null");
        op.f("ContactRequestService: Searching if a contact request exists between " + l10 + " and " + l11);
        try {
            List<ContactRequest> list = this.b.a(l10, l11);
            if (list.isEmpty()) {
                op.f("ContactRequestService: Found no contact request between " + l10 + " and " + l11);
                return null;
            }
            if (list.size() > 1) {
                throw new aqt("Found " + list.size() + " ContactRequests from userIdId " + l10 + " to " + l11 + " in the database. Expected at most one");
            }
            op.f("ContactRequestService: Found contact request between " + l10 + " and " + l11 + ": " + list.get(0));
            return ccz.a((ag)list.get(0), new cbu());
        }
        catch (b_e b_e2) {
            throw new aqt("Error while finding contact requests between userIdId " + l10 + " and userIdId " + l11, b_e2);
        }
    }

    @Override
    @NotNull
    public List<cbu> a(@NotNull Long l10) throws aqt {
        Objects.requireNonNull(l10, "getAllRequests: userIdId must not be null");
        op.f("ContactRequestService: Getting all contact requests userIdId " + l10 + " is part of");
        try {
            return ccz.a(this.b.d(l10), cbu::new);
        }
        catch (b_e b_e2) {
            throw new aqt("ContactRequestService: Error while getting all contact requests of userIdId " + l10, b_e2);
        }
    }

    @Override
    @NotNull
    public List<cbu> b(@NotNull Long l10) throws aqt {
        Objects.requireNonNull(l10, "Cannot getAllAcceptedRequests: userIdId is null");
        op.f("ContactRequestService: Getting all accepted contact requests where userIdId " + l10 + " is a part of");
        try {
            return this.b.e(l10).stream().map(contactRequest -> ccz.a(contactRequest, new cbu())).collect(Collectors.toList());
        }
        catch (b_e b_e2) {
            throw new aqt("Error while querying getAllAccepted", b_e2);
        }
    }

    @Override
    @NotNull
    public List<cbu> c(@NotNull Long l10) throws aqt {
        Objects.requireNonNull(l10, "getAllPendingRequestsForRecipient: userIdId must not be null");
        op.f("ContactRequestService: Getting all pending contact requests where userIdId " + l10 + " is recipient");
        try {
            return this.b.g(l10).stream().map(contactRequest -> ccz.a(contactRequest, new cbu())).collect(Collectors.toList());
        }
        catch (b_e b_e2) {
            throw new aqt("Error while querying getAllPendingRequests", b_e2);
        }
    }

    @Override
    @NotNull
    public List<cbu> d(@NotNull Long l10) throws aqt {
        Objects.requireNonNull(l10, "getAllRejectedRequestsForRecipient: userIdId must not be null");
        op.f("ContactRequestService: Getting all rejected contact requests where userIdId " + l10 + " is recipient");
        try {
            return this.b.h(l10).stream().map(contactRequest -> ccz.a(contactRequest, new cbu())).collect(Collectors.toList());
        }
        catch (b_e b_e2) {
            throw new aqt("Error while querying getAllPendingRequests", b_e2);
        }
    }

    @Override
    public void a(@NotNull Long l10, @NotNull Long l11) throws aqt {
        Objects.requireNonNull(l10, "deleteContactRequest: userIdIdA must not be null");
        Objects.requireNonNull(l11, "deleteContactRequest: userIdIdB must not be null");
        cbu cbu2 = this.b(l10, l11);
        if (cbu2 == null) {
            throw new aqt("ContactRequestService: Cannot delete contact request: No request found between userIdId " + l10 + " and " + l11);
        }
        op.f("ContactRequestService: Deleting contact request " + cbu2.a());
        try {
            this.b.f(cbu2.a());
        }
        catch (b_e b_e2) {
            throw new aqt("ContactRequestService: Cannot delete contact request " + cbu2.a(), b_e2);
        }
    }

    @Override
    public long e(@NotNull Long l10) throws aqt {
        Objects.requireNonNull(l10, "deleteAllContactRequestsOfUserIdId: userIdId must not be null");
        op.f("ContactRequestService: Deleting all contact requests where userIdId " + l10 + " is either requester or recipient");
        try {
            return this.b.c(l10);
        }
        catch (b_e b_e2) {
            throw new aqt("ContactRequestService: Cannot delete all contact requests of userIdId " + l10, b_e2);
        }
    }
}

