/*
 * Decompiled with CFR 0.152.
 */
package seccommerce.secsignerext;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import seccommerce.mobile.bo.CntReqStatusType;
import seccommerce.mobile.bo.SecSignID;
import seccommerce.secpki.bo.ContactDirEntry;
import seccommerce.secpki.bo.ContactDirGroup;
import seccommerce.secpki.bo.IdentifiedUser;
import seccommerce.secsignerext.ajh;
import seccommerce.secsignerext.aqy;
import seccommerce.secsignerext.b2n;
import seccommerce.secsignerext.b2p;
import seccommerce.secsignerext.b2q;
import seccommerce.secsignerext.b2s;
import seccommerce.secsignerext.b_p;
import seccommerce.secsignerext.bv3;
import seccommerce.secsignerext.bw7;
import seccommerce.secsignerext.bwo;
import seccommerce.secsignerext.bwq;
import seccommerce.secsignerext.bx2;
import seccommerce.secsignerext.bx5;
import seccommerce.secsignerext.byn;
import seccommerce.secsignerext.byp;
import seccommerce.secsignerext.cb8;
import seccommerce.secsignerext.cb9;
import seccommerce.secsignerext.cca;
import seccommerce.secsignerext.cde;
import seccommerce.secsignerext.cp;
import seccommerce.secsignerext.cz;
import seccommerce.secsignerext.os;
import seccommerce.user.bo.IdProfile;
import seccommerce.user.bo.VisibilityType;

@b2p(a=b2q.IDSERVER, b=b2s.REQUEST)
public class bv_ {
    @b2n
    private bv3 a;
    @b2n
    private byn b;
    @b2n
    private byp c;
    @b2n
    private bwo d;
    @b2n
    private bw7 e;
    @b2n
    private bx5 f;
    @b2n
    private bwq g;

    public cca a(@NotNull Long l10, @NotNull Long l11, @NotNull Long l12) throws aqy, ajh {
        Objects.requireNonNull(l10, () -> "ContactDirEntryCollectorService: Cannot getContactDirEntryForUser: orgId is null");
        Objects.requireNonNull(l11, () -> "ContactDirEntryCollectorService: Cannot getContactDirEntryForUser: userIdId is null");
        Objects.requireNonNull(l12, () -> "ContactDirEntryCollectorService: Cannot getContactDirEntryForUser: contactDirEntryId is null");
        List<cca> list = this.a(bx2.a(l10, l11, l12));
        if (list.isEmpty()) {
            throw new aqy("ContactDirEntryCollectorService: Did not find any contact directory entry for contactDirEntryId " + l12);
        }
        if (list.size() > 1) {
            throw new aqy("ContactDirEntryCollectorService: Found " + list.size() + "  contact directory entries for contactDirEntryId " + l12 + " - Expected exactly one!");
        }
        return list.get(0);
    }

    public List<cca> a(@NotNull Long l10) throws aqy, ajh {
        Objects.requireNonNull(l10, "getAllAcceptedContacts: userIdId must not be null");
        List<cb9> list = this.f.b(l10);
        return this.a(l10, list);
    }

    public List<cca> b(@NotNull Long l10) throws aqy, ajh {
        Objects.requireNonNull(l10, "getAllContactsForRejectedContactRequest: userIdId must not be null");
        List<cb9> list = this.f.d(l10);
        this.a(list);
        return this.a(l10, list);
    }

    public List<cca> c(@NotNull Long l10) throws aqy, ajh {
        Objects.requireNonNull(l10, "getAllContactsForPendingContactRequests: userIdId must not be null");
        List<cb9> list = this.f.c(l10);
        this.a(list);
        return this.a(l10, list);
    }

    private final void a(@NotNull List<cb9> list) {
        Objects.requireNonNull(list, "setStatusToAccepted: contactRequests must not be null");
        list.forEach(cb92 -> cb92.a(CntReqStatusType.ai));
    }

    private final List<cca> a(@NotNull Long l11, @NotNull List<cb9> list) throws aqy, ajh {
        Objects.requireNonNull(l11, "readFromIdProfileWithoutContactDirEntry: userIdId must not be null");
        Objects.requireNonNull(list, "readFromIdProfileWithoutContactDirEntry: contactRequests must not be null");
        List<ContactDirEntry> list2 = list.stream().map(cb92 -> this.a(l11, (cb9)cb92)).map(l10 -> {
            ContactDirEntry contactDirEntry = new ContactDirEntry();
            contactDirEntry.e(1L);
            contactDirEntry.b((Long)l10);
            return contactDirEntry;
        }).collect(Collectors.toList());
        return this.a(l11, list2, list);
    }

    @NotNull
    private final Long a(@NotNull Long l10, @NotNull cb9 cb92) {
        Objects.requireNonNull(l10, "getContactUserIdId: userIdId must not be null");
        Objects.requireNonNull(cb92, "getContactUserIdId: contactRequest must not be null");
        if (cb92.b().equals(l10)) {
            return cb92.c();
        }
        return cb92.b();
    }

    public List<cca> b(@NotNull Long l10, @NotNull Long l11, @NotNull Long l12) throws aqy, ajh {
        Objects.requireNonNull(l10, () -> "ContactDirEntryCollectorService: Cannot getContactDirEntriesForUser orgId is null");
        Objects.requireNonNull(l11, () -> "ContactDirEntryCollectorService: Cannot getContactDirEntriesForUser userIdId is null");
        Objects.requireNonNull(l12, () -> "ContactDirEntryCollectorService: Cannot getContactDirEntriesForUser contactDirectoryId is null");
        return this.a(bx2.b(l10, l11, l12));
    }

    public List<cca> a(@NotNull Long l10, @NotNull Long l11) throws aqy, ajh {
        return this.a(bx2.a(l10, l11));
    }

    public List<cca> c(@NotNull Long l10, @NotNull Long l11, @NotNull Long l12) throws aqy, ajh {
        return this.a(bx2.c(l10, l11, l12));
    }

    private final List<cca> a(@NotNull bx2 bx22) throws aqy, ajh {
        Objects.requireNonNull(bx22, "Cannot getEntries: query is null");
        os.f("ContactDirEntryCollectorService: Getting all contact directories user " + bx22.b() + " is allowed to see");
        List<cb8> list = this.d(bx22);
        List<Long> list2 = list.stream().map(cb8::a).collect(Collectors.toList());
        List<ContactDirEntry> list3 = this.a(bx22, list2);
        List<cca> list4 = this.a(bx22.a(), bx22.b(), list3);
        for (cca cca2 : list4) {
            cb8 cb83 = list.stream().filter(cb82 -> cb82.a().equals(cca2.l())).findFirst().orElseThrow(() -> new aqy("ContactDirEntryCollectorService: Did not find contact directory for ContactDirEntry " + cca2.k()));
            cca2.h(cb83.b());
        }
        return list4;
    }

    @NotNull
    private final List<cca> a(@NotNull Long l10, @NotNull Long l11, @NotNull List<ContactDirEntry> list) throws aqy, ajh {
        Objects.requireNonNull(l10, () -> "ContactDirEntryCollectorService: enrichContactsWithIdProfileData: orgId must not be null");
        Objects.requireNonNull(l11, () -> "ContactDirEntryCollectorService: Cannot enrichContactsWithIdProfileData: contactResultTO is null");
        Objects.requireNonNull(list, () -> "ContactDirEntryCollectorService: Cannot enrichContactsWithIdProfileData: contactResultTO is null");
        Map<Boolean, List<ContactDirEntry>> map = list.stream().collect(Collectors.partitioningBy(contactDirEntry -> contactDirEntry.h() != null));
        List<ContactDirEntry> list2 = map.get(Boolean.FALSE);
        os.f("ContactDirEntryCollectorService: Found " + list2.size() + " external contacts for userIdId " + l11);
        List<ContactDirEntry> list3 = map.get(Boolean.TRUE);
        os.f("ContactDirEntryCollectorService: Found " + list3.size() + " internal contacts for userIdId " + l11);
        Supplier<cca> supplier = cde.a(list2, cca::new);
        this.c(l10, (List<cca>)((Object)supplier));
        if (!list3.isEmpty()) {
            List<cb9> list4 = this.f.a(l11);
            supplier.addAll(this.a(l11, list3, list4));
        }
        return supplier;
    }

    @NotNull
    private final List<ContactDirEntry> a(@NotNull bx2 bx22, @NotNull List<Long> list) throws aqy {
        List<ContactDirEntry> list2;
        Objects.requireNonNull(bx22, () -> "ContactDirEntryCollectorService: Cannot loadContactDirEntries: query is null");
        Objects.requireNonNull(list, () -> "ContactDirEntryCollectorService: Cannot loadContactDirEntries: contactDirectoryIds is null");
        switch (bx22.f()) {
            case a: {
                list2 = this.b(bx22);
                break;
            }
            case b: {
                list2 = this.c(bx22);
                break;
            }
            case c: 
            case d: {
                list2 = this.b(list);
                break;
            }
            default: {
                throw new IllegalStateException("ContactDirEntryCollectorService: Could not load contact directory entries: Given query object uses an unknown mode");
            }
        }
        os.f("ContactDirEntryCollectorService: Checking if a userIdId needs to be set for any found ContactDirEntry");
        this.d(bx22.a(), list2.stream().filter(contactDirEntry -> contactDirEntry.f() != null || contactDirEntry.h() != null).collect(Collectors.toList()));
        return list2;
    }

    @NotNull
    private final List<ContactDirEntry> b(@NotNull bx2 bx22) throws aqy {
        Objects.requireNonNull(bx22, "loadSingleContactDirEntry: query must not be null");
        try {
            os.f("ContactDirEntryCollectorService: Getting single ContactDirEntry " + bx22.d());
            if (bx22.d() == null) {
                throw new aqy("ContactDirEntryCollectorService: Unexpected error: query.getEntryId is null even though mode is ENTRY");
            }
            assert (bx22.d() != null);
            return Collections.singletonList(this.b.a(bx22.d()));
        }
        catch (b_p b_p2) {
            throw new aqy("ContactDirEntryCollectorService: Error while trying to get contactDirEntry " + bx22.d(), b_p2);
        }
    }

    @NotNull
    private final List<ContactDirEntry> c(@NotNull bx2 bx22) throws aqy {
        Objects.requireNonNull(bx22, "loadGroupContactDirEntries: query must not be null");
        try {
            os.g("ContactDirEntryCollectorService: Getting ContactDirEntries for group " + bx22.e());
            if (bx22.e() == null) {
                throw new aqy("ContactDirEntryCollectorService: Unexpected error: query.getGroupId is null even though mode is GROUP");
            }
            assert (bx22.e() != null);
            return this.b.b(Collections.singleton(bx22.e()));
        }
        catch (b_p b_p2) {
            throw new aqy("ContactDirEntryCollectorService: Error while trying to get ContactDirEntries for group " + bx22.e(), b_p2);
        }
    }

    @NotNull
    private final List<ContactDirEntry> b(@NotNull List<Long> list) throws aqy {
        Objects.requireNonNull(list, "loadDirectoryContactDirEntries: contactDirectoryIds must not be null");
        try {
            os.f("ContactDirEntryCollectorService: Getting all ContactDirEntries from directories " + list);
            return this.b.b(list);
        }
        catch (b_p b_p2) {
            throw new aqy("ContactDirEntryCollectorService: Error while trying to get contact directories", b_p2);
        }
    }

    @NotNull
    private final List<cb8> d(@NotNull bx2 bx22) throws aqy {
        Objects.requireNonNull(bx22, "Cannot getContactDirectory: query is null");
        switch (bx22.f()) {
            case c: {
                return this.e(bx22);
            }
            case a: {
                return this.f(bx22);
            }
            case b: {
                return this.g(bx22);
            }
            case d: {
                return this.h(bx22);
            }
        }
        throw new IllegalStateException("ContactDirEntryCollectorService: Could not load contact directories: Given query object uses an unknown mode");
    }

    @NotNull
    private final List<cb8> e(@NotNull bx2 bx22) throws aqy {
        Objects.requireNonNull(bx22, "getContactDirectoryById: query must not be null");
        Long l10 = Objects.requireNonNull(bx22.c(), () -> "ContactDirEntryCollectorService: Unexpected error: query.getDirectoryId is null even though mode is DIRECTORY");
        return Collections.singletonList(this.a.a(bx22.a(), bx22.b(), l10));
    }

    @NotNull
    private final List<cb8> f(@NotNull bx2 bx22) throws aqy {
        Objects.requireNonNull(bx22, "getContactDirectoryOfEntry: query must not be null");
        Long l10 = Objects.requireNonNull(bx22.d(), () -> "ContactDirEntryCollectorService: Unexpected error: query.getEntryId is null even though mode is ENTRY");
        return Collections.singletonList(this.a.b(bx22.a(), bx22.b(), l10));
    }

    @NotNull
    private final List<cb8> g(@NotNull bx2 bx22) throws aqy {
        ContactDirGroup contactDirGroup;
        Objects.requireNonNull(bx22, "getContactDirectoryOfGroup: query must not be null");
        if (bx22.e() == null) {
            throw new aqy("ContactDirEntryCollectorService: Unexpected error: query.getGroupId is null even though mode is GROUP");
        }
        assert (bx22.e() != null);
        try {
            contactDirGroup = (ContactDirGroup)this.c.a(bx22.e());
        }
        catch (b_p b_p2) {
            throw new aqy("Error while reading ContactDirGroup with id " + bx22.e(), b_p2);
        }
        return Collections.singletonList(this.a.a(bx22.a(), bx22.b(), contactDirGroup.c()));
    }

    @NotNull
    private final List<cb8> h(@NotNull bx2 bx22) throws aqy {
        Objects.requireNonNull(bx22, "getAllContactDirectories: query must not be null");
        List<cb8> list = this.a.a(bx22.a(), bx22.b());
        if (list.isEmpty()) {
            os.f("ContactDirEntryCollectorService: User " + bx22.b() + " is not allowed to see any contact directories");
            return Collections.emptyList();
        }
        return list;
    }

    private final List<cca> a(@NotNull Long l10, @NotNull List<ContactDirEntry> list, @NotNull List<cb9> list2) throws aqy, ajh {
        Objects.requireNonNull(l10, () -> "ContactDirEntryCollectorService: Cannot readFromIdProfile: userIdId is null");
        Objects.requireNonNull(list, () -> "ContactDirEntryCollectorService: Cannot readFromIdProfile: internalContacts is null");
        Objects.requireNonNull(list2, () -> "ContactDirEntryCollectorService: Cannot readFromIdProfile: contactRequestList is null");
        Map<Long, cb9> map = bv_.b(l10, list2);
        Set<Long> set = list.stream().map(ContactDirEntry::h).collect(Collectors.toSet());
        Map map2 = this.d.a(new HashSet<Long>(set)).stream().collect(Collectors.toMap(IdProfile::getUserIdId, Function.identity()));
        Map<Long, IdentifiedUser> map3 = this.g.a(set);
        ArrayList<cca> arrayList = new ArrayList<cca>();
        for (ContactDirEntry contactDirEntry : list) {
            cb9 cb92 = map.getOrDefault(contactDirEntry.h(), null);
            if (cb92 == null) {
                os.f("ContactDirEntryCollectorService: Found no accepted contactRequest between " + l10 + " and " + contactDirEntry.h() + " - using only public IdProfile data");
            } else {
                os.f("ContactDirEntryCollectorService: Found " + cb92 + " for ContactDirEntry " + contactDirEntry.v());
            }
            IdProfile idProfile = map2.getOrDefault(contactDirEntry.h(), null);
            if (idProfile == null) {
                throw new aqy("ContactDirEntryCollectorService: Expected to find IdProfile for ContactDirEntry " + contactDirEntry.v() + " with userIdId " + contactDirEntry.h());
            }
            os.f("ContactDirEntryCollectorService: Found IdProfile " + idProfile.getId() + " for ContactDirEntry " + contactDirEntry.v());
            IdentifiedUser identifiedUser = map3.getOrDefault(contactDirEntry.h(), null);
            cca cca2 = cde.a(contactDirEntry, new cca());
            if (bv_.a(idProfile, cb92) || l10.equals(contactDirEntry.h())) {
                bv_.a(cca2, idProfile, identifiedUser);
            }
            if (cb92 != null) {
                cca2.b(cb92.a());
                cca2.c(cb92.d());
                if (CntReqStatusType.ai.equals(cb92.d()) || l10.equals(contactDirEntry.h())) {
                    bv_.b(cca2, idProfile, identifiedUser);
                }
            }
            if (VisibilityType.PRIVATE.equals(idProfile.getPrfVisibility()) && (cb92 == null || !CntReqStatusType.ai.equals(cb92.d()))) {
                cca2.a((Long)null);
                cca2.a((String)null);
                cca2.b((Long)null);
                cca2.c((Long)null);
            }
            arrayList.add(cca2);
        }
        return arrayList;
    }

    private static Map<Long, cb9> b(Long l10, List<cb9> list) {
        HashMap<Long, cb9> hashMap = new HashMap<Long, cb9>();
        for (cb9 cb92 : list) {
            Long l11 = cb92.b().equals(l10) ? cb92.c() : cb92.b();
            hashMap.put(l11, cb92);
        }
        return hashMap;
    }

    private static boolean a(@NotNull IdProfile idProfile, @Nullable cb9 cb92) {
        Objects.requireNonNull(idProfile, () -> "ContactDirEntryCollectorService: Cannot isReadingPublicProfileDataAllowed: idProfile is null");
        return VisibilityType.PUBLIC.equals(idProfile.getPrfVisibility()) || cb92 != null && CntReqStatusType.ai.equals(cb92.d());
    }

    private static void a(@NotNull cca cca2, @NotNull IdProfile idProfile, @Nullable IdentifiedUser identifiedUser) {
        Objects.requireNonNull(cca2, () -> "ContactDirEntryCollectorService: Cannot setPublicProfileData: contactResultTO is null");
        Objects.requireNonNull(idProfile, () -> "ContactDirEntryCollectorService: Cannot setPublicProfileData: idProfile is null");
        os.f("ContactDirEntryCollectorService: Setting public values from IdProfile for ContactResultTO for ContactDirEntry " + cca2.k());
        cca2.a(Boolean.TRUE);
        cca2.b(Boolean.TRUE);
        cca2.c(Boolean.TRUE);
        cca2.d(Boolean.TRUE);
        cca2.e(Boolean.TRUE);
        cca2.f(Boolean.TRUE);
        cca2.g(Boolean.TRUE);
        if (cca2.b() != null && cca2.b().equals(idProfile.getEmailAddress())) {
            cca2.a(Boolean.FALSE);
        }
        if (VisibilityType.PUBLIC.equals(idProfile.getEmailAddrVisib()) && cz.t(idProfile.getEmailAddress())) {
            cca2.b(idProfile.getEmailAddress());
            cca2.a(Boolean.FALSE);
        }
        if (VisibilityType.PUBLIC.equals(idProfile.getTitleVisib()) && cz.t(idProfile.getTitle())) {
            cca2.c(idProfile.getTitle());
            cca2.b(Boolean.FALSE);
        }
        if (VisibilityType.PUBLIC.equals(idProfile.getFirstNameVisib()) && cz.t(idProfile.getFirstName())) {
            cca2.d(idProfile.getFirstName());
            cca2.c(Boolean.FALSE);
        }
        if (VisibilityType.PUBLIC.equals(idProfile.getLastNameVisib()) && cz.t(idProfile.getLastName())) {
            cca2.e(idProfile.getLastName());
            cca2.d(Boolean.FALSE);
        }
        if (VisibilityType.PUBLIC.equals(idProfile.getDepartmentVisi()) && cz.t(idProfile.getDepartment())) {
            cca2.f(idProfile.getDepartment());
            cca2.e(Boolean.FALSE);
        }
        if (VisibilityType.PUBLIC.equals(idProfile.getCompanyNamVisi()) && cz.t(idProfile.getCompanyName())) {
            cca2.g(idProfile.getCompanyName());
            cca2.f(Boolean.FALSE);
        }
        if (VisibilityType.PUBLIC.equals(idProfile.getMbilPhnNrVisi()) && cz.t(idProfile.getMobilePhoneNr()) && idProfile.getMobilPhoneNrVerifd().booleanValue()) {
            cca2.i(cp.b(idProfile.getMobilePhoneNr()).d());
            cca2.g(Boolean.FALSE);
        }
        if (identifiedUser != null && VisibilityType.PUBLIC.equals(idProfile.getIdentVisib()) && bv_.a(VisibilityType.PUBLIC, idProfile) && bwq.a(identifiedUser, idProfile)) {
            cca2.h(Boolean.TRUE);
        }
    }

    private final void c(@NotNull Long l10, @NotNull List<cca> list) throws ajh {
        Objects.requireNonNull(l10, "enrichExternalContactResults: orgId must not be null");
        Objects.requireNonNull(list, "enrichExternalContactResults: externalContacts must not be null");
        if (list.isEmpty()) {
            return;
        }
        List<IdentifiedUser> list2 = this.g.a(l10);
        Map map = list2.stream().collect(Collectors.toMap(IdentifiedUser::bp, Function.identity()));
        for (cca cca2 : list) {
            IdentifiedUser identifiedUser;
            if (cz.s(cca2.c()) || (identifiedUser = (IdentifiedUser)map.getOrDefault(cca2.c(), null)) == null || !bwq.a(identifiedUser, cca2)) continue;
            cca2.h(Boolean.TRUE);
        }
    }

    private static void b(@NotNull cca cca2, @NotNull IdProfile idProfile, @Nullable IdentifiedUser identifiedUser) {
        Objects.requireNonNull(cca2, () -> "ContactDirEntryCollectorService: Cannot setContactSharedProfileData: contactResultTO is null");
        Objects.requireNonNull(idProfile, () -> "ContactDirEntryCollectorService: Cannot setContactSharedProfileData: idProfile is null");
        os.f("ContactDirEntryCollectorService: Setting contact shared values from IdProfile for ContactResultTO for ContactDirEntry " + cca2.k());
        if (VisibilityType.CONTACTS.equals(idProfile.getEmailAddrVisib()) && cz.t(idProfile.getEmailAddress())) {
            cca2.b(idProfile.getEmailAddress());
            cca2.a(Boolean.FALSE);
        }
        if (VisibilityType.CONTACTS.equals(idProfile.getTitleVisib()) && cz.t(idProfile.getTitle())) {
            cca2.c(idProfile.getTitle());
            cca2.b(Boolean.FALSE);
        }
        if (VisibilityType.CONTACTS.equals(idProfile.getFirstNameVisib()) && cz.t(idProfile.getFirstName())) {
            cca2.d(idProfile.getFirstName());
            cca2.c(Boolean.FALSE);
        }
        if (VisibilityType.CONTACTS.equals(idProfile.getLastNameVisib()) && cz.t(idProfile.getLastName())) {
            cca2.e(idProfile.getLastName());
            cca2.d(Boolean.FALSE);
        }
        if (VisibilityType.CONTACTS.equals(idProfile.getDepartmentVisi()) && cz.t(idProfile.getDepartment())) {
            cca2.f(idProfile.getDepartment());
            cca2.e(Boolean.FALSE);
        }
        if (VisibilityType.CONTACTS.equals(idProfile.getCompanyNamVisi()) && cz.t(idProfile.getCompanyName())) {
            cca2.g(idProfile.getCompanyName());
            cca2.f(Boolean.FALSE);
        }
        if (VisibilityType.CONTACTS.equals(idProfile.getMbilPhnNrVisi()) && cz.t(idProfile.getMobilePhoneNr()) && idProfile.getMobilPhoneNrVerifd().booleanValue()) {
            cca2.i(cp.b(idProfile.getMobilePhoneNr()).d());
            cca2.g(Boolean.FALSE);
        }
        if (identifiedUser != null && VisibilityType.CONTACTS.equals(idProfile.getIdentVisib()) && bv_.a(VisibilityType.CONTACTS, idProfile) && bwq.a(identifiedUser, idProfile)) {
            cca2.h(Boolean.TRUE);
        }
    }

    private static boolean a(@NotNull Long l10, @NotNull IdProfile idProfile) {
        Objects.requireNonNull(l10, "isIdentRelevantDataVisible: targetVisibilityLevel must not be null");
        Objects.requireNonNull(idProfile, "isIdentRelevantDataVisible: idProfile must not be null");
        if (l10.equals(VisibilityType.PRIVATE)) {
            return VisibilityType.PRIVATE.equals(idProfile.getFirstNameVisib()) && VisibilityType.PRIVATE.equals(idProfile.getLastNameVisib()) && VisibilityType.PRIVATE.equals(idProfile.getEmailAddrVisib());
        }
        if (l10.equals(VisibilityType.PUBLIC)) {
            return VisibilityType.PUBLIC.equals(idProfile.getFirstNameVisib()) && VisibilityType.PUBLIC.equals(idProfile.getLastNameVisib()) && VisibilityType.PUBLIC.equals(idProfile.getEmailAddrVisib());
        }
        return !VisibilityType.PRIVATE.equals(idProfile.getFirstNameVisib()) && !VisibilityType.PRIVATE.equals(idProfile.getLastNameVisib()) && !VisibilityType.PRIVATE.equals(idProfile.getEmailAddrVisib());
    }

    private final void d(@NotNull Long l10, @NotNull List<ContactDirEntry> list) throws aqy {
        Objects.requireNonNull(l10, () -> "ContactDirEntryCollectorService: Cannot setUserIdIdForSecSignId: orgId is null");
        Objects.requireNonNull(list, () -> "ContactDirEntryCollectorService: Cannot setUserIdIdForSecSignId: entries is null");
        if (list.isEmpty()) {
            return;
        }
        for (ContactDirEntry contactDirEntry : list) {
            if (contactDirEntry.h() != null && cz.t(contactDirEntry.f())) {
                os.f("ContactDirEntryCollectorService: Not setting a userIdId/secSignId for ContactDirEntry " + contactDirEntry.v() + " because both are already set");
                continue;
            }
            if (contactDirEntry.h() == null && cz.s(contactDirEntry.f())) {
                os.f("ContactDirEntryCollectorService: Not setting a userIdId/secSignId for ContactDirEntry " + contactDirEntry.v() + " because both are not set");
                continue;
            }
            SecSignID secSignID = null;
            if (contactDirEntry.h() == null) {
                try {
                    secSignID = this.e.a(contactDirEntry.f(), l10, false);
                }
                catch (aqy aqy2) {
                    throw new aqy("Error while trying to get userIdId for SecSignId " + contactDirEntry.f(), aqy2);
                }
            }
            if (cz.s(contactDirEntry.f())) {
                try {
                    secSignID = this.e.a(contactDirEntry.h(), l10);
                }
                catch (SQLException sQLException) {
                    throw new aqy("Error while trying to get SecSignId for userIdId " + contactDirEntry.h(), sQLException);
                }
            }
            if (secSignID == null) {
                os.b("ContactDirEntryCollectorService: Could not find SecSignId for ContactDirEntry " + contactDirEntry.v() + " with userIdId " + contactDirEntry.h() + " and SecSignId " + contactDirEntry.f());
                continue;
            }
            contactDirEntry.b(secSignID.m());
            contactDirEntry.f(secSignID.b());
            try {
                os.f("ContactDirEntryCollectorService: Setting userIdId " + secSignID.m() + " for ContactDirEntry " + contactDirEntry.v());
                this.b.a(contactDirEntry.v(), secSignID.m(), secSignID.b());
            }
            catch (b_p b_p2) {
                throw new aqy("Error while trying to set userIdId " + secSignID.m() + " and SecSignId" + secSignID.b() + " for ContactDirEntry " + contactDirEntry.v(), b_p2);
            }
        }
    }
}

