/*
 * Decompiled with CFR 0.152.
 */
package de.itu.bmu;

import de.itu.bmu.BMURegCharge;
import de.itu.bmu.BMURegChargeBGS;
import de.itu.bmu.BMURegChargeBGSDok;
import de.itu.bmu.BMURegChargeBGSExzerpt;
import de.itu.bmu.BMURegChargeBGSMitUNS;
import de.itu.bmu.BMURegChargeUNS;
import de.itu.bmu.BMURegChargeUNSDok;
import de.itu.bmu.BMURegChargeUNSExzerpt;
import de.itu.bmu.BMURegDeckblatt;
import de.itu.bmu.BMURegDeckblattENDok;
import de.itu.bmu.BMURegDeckblattENExzerpt;
import de.itu.bmu.BMURegDeckblattIndikator;
import de.itu.bmu.BMURegDeckblattLayerRE;
import de.itu.xml.XPathFacade;
import de.itu.xml.XmlException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BMURegAuszug {
    private static final Logger _logger = LogManager.getLogger(BMURegAuszug.class);
    private BMURegDeckblatt _deckblatt;
    private SortedMap<String, BMURegCharge> _chargeMap = new TreeMap<String, BMURegCharge>();

    public BMURegAuszug(Element auszug) {
        try {
            String typeNodeName = XPathFacade.getInstance().evaluate(auszug, "local-name(reg:Deckblatt/*)");
            BMURegDeckblatt.DeckblattType deckblattType = BMURegDeckblatt.DeckblattType.valueOf(typeNodeName);
            switch (deckblattType) {
                case ENSNDokument: {
                    this._deckblatt = new BMURegDeckblattENDok(auszug);
                    break;
                }
                case ENSNExzerpt: {
                    this._deckblatt = new BMURegDeckblattENExzerpt(auszug);
                    break;
                }
                case ENSNVorlageLayerRE: {
                    this._deckblatt = new BMURegDeckblattLayerRE(auszug);
                    break;
                }
                default: {
                    boolean value = XPathFacade.getInstance().evalBool(auszug, "reg:Deckblatt/*");
                    this._deckblatt = new BMURegDeckblattIndikator(deckblattType, value);
                }
            }
            NodeList nl = XPathFacade.getInstance().evaluateNodeList(auszug, "reg:Charge");
            BMURegCharge regCharge = null;
            String sizeString = Integer.toString(nl.getLength());
            int digits = sizeString.length();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node chargeNode = nl.item(i);
                String chargeTypeNodeName = XPathFacade.getInstance().evaluate((Element)chargeNode, "local-name(*)");
                BMURegCharge.ChargeType chargeType = BMURegCharge.ChargeType.valueOf(chargeTypeNodeName);
                switch (chargeType) {
                    case BGSsolo: {
                        String bgsTypeNodeName = XPathFacade.getInstance().evaluate((Element)chargeNode, "local-name(reg:BGSsolo/*)");
                        BMURegChargeBGS.ChargeBGSType chargeTypeBGS = BMURegChargeBGS.ChargeBGSType.valueOf(bgsTypeNodeName);
                        if (BMURegChargeBGS.ChargeBGSType.BGSDokument.equals((Object)chargeTypeBGS)) {
                            regCharge = new BMURegChargeBGSDok((Element)chargeNode, i, (Object)this);
                            break;
                        }
                        if (!BMURegChargeBGS.ChargeBGSType.BGSExzerpt.equals((Object)chargeTypeBGS)) break;
                        regCharge = new BMURegChargeBGSExzerpt((Element)chargeNode, i, (Object)this);
                        break;
                    }
                    case UNSsolo: {
                        String unsTypeNodeName = XPathFacade.getInstance().evaluate((Element)chargeNode, "local-name(reg:UNSsolo/*)");
                        BMURegChargeUNS.ChargeUNSType chargeTypeUNS = BMURegChargeUNS.ChargeUNSType.valueOf(unsTypeNodeName);
                        if (BMURegChargeUNS.ChargeUNSType.UNSDokument.equals((Object)chargeTypeUNS)) {
                            regCharge = new BMURegChargeUNSDok((Element)chargeNode, i, (Object)this);
                            break;
                        }
                        if (!BMURegChargeUNS.ChargeUNSType.UNSExzerpt.equals((Object)chargeTypeUNS)) break;
                        regCharge = new BMURegChargeUNSExzerpt((Element)chargeNode, i, (Object)this);
                        break;
                    }
                    case BGSmitUNS: {
                        regCharge = new BMURegChargeBGSMitUNS((Element)chargeNode, i, (Object)this);
                    }
                }
                Object indexString = Integer.toString(i + 1);
                for (int j = ((String)indexString).length(); j < digits; ++j) {
                    indexString = "0" + (String)indexString;
                }
                this._chargeMap.put("Charge[" + (String)indexString + "]", regCharge);
            }
        }
        catch (XmlException e) {
            _logger.error("Fehler beim initialisieren des Registerauszugs");
        }
    }

    public BMURegDeckblatt getDeckblatt() {
        return this._deckblatt;
    }

    public SortedMap<String, BMURegCharge> getChargeMap() {
        return this._chargeMap;
    }

    public BMURegCharge getCharge(String nr) {
        BMURegCharge retVal = null;
        for (BMURegCharge charge : this._chargeMap.values()) {
            if (nr.equals(charge.getNummer())) {
                retVal = charge;
            } else if (charge instanceof BMURegChargeBGSMitUNS) {
                retVal = ((BMURegChargeBGSMitUNS)charge).getCharge(nr);
            }
            if (retVal == null) continue;
            break;
        }
        return retVal;
    }

    public String toString() {
        return "Registerauszug";
    }
}

