/*
 * Decompiled with CFR 0.152.
 */
package de.itu.util;

import de.itu.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZipUtils {
    private static final Logger _logger = LogManager.getLogger(ZipUtils.class);
    static byte[] buf = new byte[1024];

    public static boolean doZip(String zipFilePath, String[] filePathes, String[] rootPathes, boolean create) {
        _logger.debug("<doZip> start, zipFilePath=" + zipFilePath + ", filePathes=" + String.valueOf(filePathes) + ", rootPathes=" + String.valueOf(rootPathes) + ", create=" + create);
        boolean retVal = false;
        File zipFile = new File(zipFilePath);
        try {
            if (zipFile.exists()) {
                if (create && !FileUtil.deleteFile(zipFile)) {
                    _logger.error("Datei kann nicht gel\u00f6scht werden: " + zipFile.getAbsolutePath());
                    return false;
                }
            } else if (!create) {
                _logger.error("Datei nicht gefunden: " + zipFile.getAbsolutePath());
                return false;
            }
            _logger.debug("creating zip-file: " + zipFile.getAbsolutePath());
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
            HashMap<String, Integer> nameMap = new HashMap<String, Integer>();
            for (int i = 0; i < filePathes.length; ++i) {
                int len;
                File baseDir;
                String zipEntryPath = filePathes[i];
                File zipEntry = new File(zipEntryPath);
                if (!zipEntry.exists()) {
                    _logger.error("Datei nicht gefunden: " + zipEntry.getAbsolutePath());
                    out.close();
                    return false;
                }
                String zipEntryName = zipEntry.getName();
                String baseDirPath = null;
                if (rootPathes != null && rootPathes.length > i) {
                    baseDirPath = rootPathes[i];
                }
                if (baseDirPath != null && baseDirPath.length() > 0 && (baseDir = new File(baseDirPath)).exists() && zipEntryPath.startsWith(baseDir.getAbsolutePath())) {
                    zipEntryName = zipEntryPath.substring(baseDirPath.length());
                }
                FileInputStream in = new FileInputStream(zipEntry);
                Object indexedName = zipEntryName;
                int num = 0;
                if (nameMap.keySet().contains(zipEntryName)) {
                    num = (Integer)nameMap.get(zipEntryName) + 1;
                    int dotPos = zipEntryName.lastIndexOf(46);
                    indexedName = dotPos > 0 ? zipEntryName.substring(0, dotPos) + "(" + num + ")" + zipEntryName.substring(dotPos) : zipEntryName + "(" + num + ")";
                }
                nameMap.put(zipEntryName, num);
                out.putNextEntry(new ZipEntry((String)indexedName));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
                _logger.debug("zip entry added: " + (String)indexedName);
            }
            out.close();
            retVal = true;
        }
        catch (IOException e) {
            _logger.error("error writing zip-file: " + zipFile.getAbsolutePath(), (Throwable)e);
        }
        _logger.debug("<doZip> end (result=" + retVal + ").");
        return retVal;
    }

    public static boolean unZip(File zipFile, File outDir, String entryName, boolean overwrite) {
        _logger.debug("<unZip> start, zipFile=" + zipFile.getAbsolutePath() + ", outFile=" + outDir.getAbsolutePath() + ", entryName=" + entryName + ", overwrite=" + overwrite);
        boolean retVal = true;
        try {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (entryName == null || entryName.equals(entry.getName())) {
                    File outFile = new File(outDir, entry.getName());
                    if (entry.isDirectory()) {
                        if (outFile.exists()) {
                            if (!outFile.isDirectory()) {
                                _logger.error("file already exists: " + outFile.getAbsolutePath());
                                retVal = false;
                            }
                        } else if (!outFile.mkdir()) {
                            retVal = false;
                        }
                    } else {
                        int len;
                        if (outFile.exists()) {
                            if (overwrite) {
                                if (!FileUtil.deleteFile(outFile)) {
                                    _logger.error("error deleting file: " + outFile.getAbsolutePath());
                                    retVal = false;
                                    continue;
                                }
                                _logger.debug("file deleted: " + outFile.getAbsolutePath());
                            } else {
                                _logger.warn("file already exists: " + outFile.getAbsolutePath());
                                continue;
                            }
                        }
                        _logger.debug("extracting '" + entry.getName() + "' to '" + outFile.getAbsolutePath());
                        FileOutputStream fos = null;
                        for (int retryCount = 0; retryCount < 5; ++retryCount) {
                            try {
                                fos = new FileOutputStream(outFile);
                                break;
                            }
                            catch (IOException e) {
                                if (retryCount < 4) {
                                    _logger.debug("failed to open output stream, retryCount: " + retryCount);
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException e1) {
                                        _logger.error("Interrupted !!", (Throwable)e1);
                                    }
                                    continue;
                                }
                                _logger.error("Error opening output stream in last try");
                                throw e;
                            }
                        }
                        while ((len = zis.read(buf)) > 0) {
                            fos.write(buf, 0, len);
                        }
                        fos.close();
                    }
                }
                entry = zis.getNextEntry();
            }
            zis.close();
        }
        catch (Exception ex) {
            _logger.error("error extracting zip file: " + zipFile.getAbsolutePath(), (Throwable)ex);
            retVal = false;
        }
        return retVal;
    }

    public static boolean unZip(File zipFile, File outDir, boolean overwrite) {
        _logger.debug("<unZip> start (" + zipFile.getAbsolutePath() + ", " + outDir.getAbsolutePath() + ", " + overwrite + ")..");
        return ZipUtils.unZip(zipFile, outDir, null, overwrite);
    }

    public static InputStream getEntryInputStream(File zipFile, String entryName) {
        _logger.debug("<hasEntry> zipFile=" + zipFile.getAbsolutePath() + ", entryName=" + entryName);
        ZipInputStream is = null;
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (entry.getName().equals(entryName)) {
                    is = zis;
                    break;
                }
                entry = zis.getNextEntry();
            }
        }
        catch (Exception ex) {
            _logger.error("error extracting zip file: " + zipFile.getAbsolutePath(), (Throwable)ex);
        }
        return is;
    }

    public static boolean zipProtect(String zipFileName, List<File> files, char[] password) {
        boolean retVal = false;
        try {
            ZipParameters zipParameters = new ZipParameters();
            zipParameters.setEncryptFiles(true);
            zipParameters.setCompressionLevel(CompressionLevel.NO_COMPRESSION);
            zipParameters.setEncryptionMethod(EncryptionMethod.ZIP_STANDARD);
            ZipFile zipFile = new ZipFile(zipFileName, password);
            for (File f : files) {
                if (f.exists()) {
                    zipFile.addFile(f, zipParameters);
                    _logger.debug("File added: " + f.getAbsolutePath());
                    continue;
                }
                _logger.warn("Datei nicht vorhanden: " + f.getAbsolutePath());
            }
            zipFile.close();
            retVal = true;
        }
        catch (Exception e) {
            _logger.error("Fehler beim Erstellen des passwortgesch\u00fctzten Archivs: " + zipFileName, (Throwable)e);
        }
        return retVal;
    }
}

