/*
 * Decompiled with CFR 0.152.
 */
package de.itu.xmlsec;

import de.itu.error.ITUException;
import de.itu.xmlsec.RemoteSignService;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class LocalSignService
implements RemoteSignService {
    private static final Logger LOGGER = LogManager.getLogger();
    private X509Certificate cert;
    private PrivateKey privateKey;
    private String signatureAlgorithmName;

    @Override
    public X509Certificate getCert() {
        return this.cert;
    }

    public void setCert(X509Certificate cert) {
        this.cert = cert;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public String getSignatureAlgorithmName() {
        return this.signatureAlgorithmName;
    }

    public void setSignatureAlgorithmName(String signatureAlgorithmName) {
        this.signatureAlgorithmName = signatureAlgorithmName;
    }

    public byte[] signCMS(byte[] digestToSign, char[] certPin, String otp) throws ITUException {
        try {
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            CMSProcessableByteArray msg = new CMSProcessableByteArray(digestToSign);
            certList.add(this.cert);
            JcaCertStore certs = new JcaCertStore(certList);
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            ContentSigner signer = new JcaContentSignerBuilder(this.signatureAlgorithmName != null ? this.signatureAlgorithmName : this.cert.getSigAlgName()).build(this.privateKey);
            gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build()).build(signer, this.cert));
            gen.addCertificates((Store)certs);
            CMSSignedData signedData = gen.generate((CMSTypedData)msg, true);
            return signedData.getEncoded();
        }
        catch (Exception e) {
            throw new ITUException("error signing hash", e);
        }
    }

    public boolean verify(CMSSignedData cmsSignedData) {
        boolean retVal = false;
        Store certStore = cmsSignedData.getCertificates();
        SignerInformationStore signers = cmsSignedData.getSignerInfos();
        Collection c = signers.getSigners();
        for (SignerInformation signer : c) {
            Collection certCollection = certStore.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            try {
                if (!signer.verify(new JcaSimpleSignerInfoVerifierBuilder().build(cert))) continue;
                retVal = true;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retVal;
    }

    @Override
    public byte[] sign(byte[] dataToSign, char[] certPin, String otp) throws ITUException {
        try {
            Signature signature = Signature.getInstance(this.signatureAlgorithmName != null ? this.signatureAlgorithmName : this.cert.getSigAlgName());
            signature.initSign(this.privateKey);
            signature.update(dataToSign);
            byte[] sigData = signature.sign();
            return sigData;
        }
        catch (Exception e) {
            LOGGER.error("error signing data", (Throwable)e);
            throw new ITUException("error signing data", e);
        }
    }

    public boolean verify(byte[] dataToVerify, byte[] rawSignature) throws ITUException {
        boolean retVal = false;
        try {
            Signature signature = Signature.getInstance(this.signatureAlgorithmName != null ? this.signatureAlgorithmName : this.cert.getSigAlgName());
            signature.initVerify(this.cert);
            signature.update(dataToVerify);
            retVal = signature.verify(rawSignature);
        }
        catch (Exception e) {
            throw new ITUException("error signing data", e);
        }
        return retVal;
    }
}

