/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.aop.general;

import com.jamonapi.MonKeyImp;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import com.jamonapi.utils.Misc;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.InvocationContext;

public class JAMonInterceptor {
    protected static final String EXCEPTION_UNITS = "Exception";
    protected static final String NULL_STR = "<null>";
    protected static final String UNKNOWN = "???";
    protected static final int DEFAULT_ARG_STRING_MAX_LENGTH = 125;
    protected static final String DEFAULT_MAX_STRING_ENDING = "...";
    protected static final String MONITOR_PREFIX = "JAMonInterceptor.";
    protected String exceptionLabel = this.getClass().getName();
    private final String unknownTimeLabel = this.getClass().getName() + ".???";
    protected static final String LINE_SEPARATOR = "\n";
    private boolean useParametersInDetails = true;

    protected JAMonInterceptor(String exceptionLabel) {
        this.exceptionLabel = exceptionLabel;
    }

    public JAMonInterceptor() {
    }

    public boolean useParametersInDetails() {
        return this.useParametersInDetails;
    }

    public JAMonInterceptor setUseParametersInDetails(boolean useParametersInDetails) {
        this.useParametersInDetails = useParametersInDetails;
        return this;
    }

    @AroundInvoke
    public Object intercept(InvocationContext ctx) throws Exception {
        Monitor mon = null;
        MonKeyImp key = null;
        String label = null;
        if (!this.isMonitored(ctx)) {
            return ctx.proceed();
        }
        try {
            label = this.getJamonLabel(ctx);
            key = new MonKeyImp(label, "ms.");
            mon = MonitorFactory.start(key);
            Object object = ctx.proceed();
            return object;
        }
        catch (Exception e) {
            if (key != null) {
                key.setDetails(this.onException(ctx, label, e));
            }
            throw e;
        }
        finally {
            if (mon != null) {
                mon.stop();
            }
        }
    }

    protected String getJamonLabel(InvocationContext ctx) {
        String methodName = ctx.getMethod() != null ? ctx.getMethod().toString() : this.unknownTimeLabel;
        return MONITOR_PREFIX + methodName;
    }

    protected boolean isMonitored(InvocationContext ctx) {
        return true;
    }

    protected String onException(InvocationContext ctx, String label, Exception exception) throws Exception {
        Object[] parameters = ctx.getParameters();
        String details = this.createExceptionDetails(label, parameters, exception);
        MonitorFactory.add(new MonKeyImp("com.jamonapi.Exceptions", details, EXCEPTION_UNITS), 1.0);
        MonitorFactory.add(new MonKeyImp(this.exceptionLabel, details, EXCEPTION_UNITS), 1.0);
        if (exception != null) {
            MonitorFactory.add(new MonKeyImp(exception.getClass().getName(), details, EXCEPTION_UNITS), 1.0);
        }
        return details;
    }

    protected String createExceptionDetails(String label, Object[] parameters, Exception exception) {
        StringBuilder temp = new StringBuilder();
        this.addJamonLabelToDetails(temp, label);
        this.addParameterInfoToDetails(temp, parameters);
        this.addExceptionStackTraceToDetails(temp, exception);
        return temp.toString();
    }

    protected String toString(Object parameter) {
        if (parameter == null) {
            return NULL_STR;
        }
        try {
            Object result = Misc.getAsString(parameter);
            if (((String)result).length() > 125) {
                result = ((String)result).substring(0, 125) + DEFAULT_MAX_STRING_ENDING;
            }
            return result;
        }
        catch (Throwable e) {
            return UNKNOWN;
        }
    }

    private void addJamonLabelToDetails(StringBuilder temp, String label) {
        temp.append(label).append(",").append(LINE_SEPARATOR);
    }

    private void addExceptionStackTraceToDetails(StringBuilder temp, Exception exception) {
        if (exception != null) {
            temp.append("=== Stack Trace ===").append(LINE_SEPARATOR);
            temp.append(Misc.getExceptionTrace(exception));
        }
    }

    private void addParameterInfoToDetails(StringBuilder temp, Object[] parameters) {
        if (parameters != null && this.useParametersInDetails()) {
            temp.append("=== Parameters ===").append(LINE_SEPARATOR);
            int i = 0;
            while (i < parameters.length) {
                Object parameter = parameters[i];
                temp.append("[").append(i).append("]={");
                temp.append(this.toString(parameter));
                temp.append("}");
                temp.append(LINE_SEPARATOR);
                ++i;
            }
        }
    }
}

