/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class RuleImplAttachmentMaxSize
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(RuleImplAttachmentMaxSize.class);
    private static final String XPATH_DATEIANHANG = "/descendant::*[local-name()='Dateianhang' and @lib:id]";

    public RuleImplAttachmentMaxSize(RuleDef ruleDef) {
        super(ruleDef);
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        NodeList nl;
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        try {
            nl = XPathFassade.getInstance().evaluateNodeList(bmuDok.getDocument(), XPATH_DATEIANHANG);
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        int index = 1;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node nodeDateianhang = nl.item(i);
            if (!(nodeDateianhang instanceof Element)) continue;
            Element elemDateianhang = (Element)nodeDateianhang;
            String id = elemDateianhang.getAttributeNS(Namespace.TypenBibliothek.getUri(), "id");
            try {
                NodeList nodeListBinaerdaten = elemDateianhang.getElementsByTagNameNS(Namespace.TypenBibliothek.getUri(), "Binaerdaten");
                if (nodeListBinaerdaten.getLength() <= 0) continue;
                String binaerDaten = nodeListBinaerdaten.item(0).getTextContent();
                byte[] decodedBinaerdaten = Base64.decodeBase64((String)binaerDaten);
                int actualLength = decodedBinaerdaten.length;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("actual length: " + actualLength));
                }
                if (actualLength <= 0xA00000) continue;
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, id));
                continue;
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error decoding content of element 'Binaerdaten'", (Throwable)e);
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, id));
            }
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        return "XPath f\u00fcr die Ermittlung der Dateianh\u00e4nge: /descendant::*[local-name()='Dateianhang' and @lib:id]";
    }
}

