/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.schema.TypeLister;
import de.consist.bmu.rule.util.XmlElementInfo;
import de.consist.bmu.rule.util.XmlUtils;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class RuleImplDateInInterval
extends RuleImpl {
    private static final long serialVersionUID = 1L;

    public RuleImplDateInInterval(RuleDef ruleDef) {
        super(ruleDef);
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        Document document = bmuDok.getDocument();
        Set<XmlElementInfo> dateList = TypeLister.getDateTypes(document);
        for (XmlElementInfo info : dateList) {
            int index = 1;
            try {
                String xpath = "/descendant::*[local-name()='" + info.get_localName() + "' and namespace-uri()='" + info.get_uri() + "']";
                NodeList nl = XPathFassade.getInstance().evaluateNodeList(document, xpath);
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node node = nl.item(i);
                    String dateString = node.getTextContent();
                    try {
                        Date date;
                        if (dateString.contains("T")) {
                            dateString = dateString.replace("T", " ");
                            date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateString);
                        } else {
                            date = new SimpleDateFormat("yyyy-MM-dd").parse(dateString);
                        }
                        String path = XmlUtils.getNodePathShort(node);
                        if (this.dateInInterval(date)) continue;
                        ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, path));
                        continue;
                    }
                    catch (ParseException e) {
                        throw new BMUException("Fehler beim Pr\u00fcfen", e);
                    }
                }
            }
            catch (XPathExpressionException e1) {
                throw new BMUException("Fehler beim Pr\u00fcfen", e1);
            }
        }
        return ruleResultList;
    }

    private boolean dateInInterval(Date date) {
        boolean inInterval = true;
        GregorianCalendar gc_before = new GregorianCalendar(1753, 1, 1);
        Date notBefore = gc_before.getTime();
        GregorianCalendar gc_after = new GregorianCalendar(4711, 12, 31);
        Date notAfter = gc_after.getTime();
        if (date.after(notAfter) || date.before(notBefore)) {
            inInterval = false;
        }
        return inInterval;
    }

    public static String getTechDoc() {
        return "Zu pr\u00fcfende Typen: xs:Date, xs:DateTime, lib:DatumTyp";
    }
}

