/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;

public final class RuleImplENSConflictingContent
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final String XPATH_ERZ_VERMERKE = "(/descendant::en:IndicatorMitBB[last()]='false' or /descendant::en:IndicatorMitBB[last()]=0) and count(/descendant::en:Abfallerzeugervermerke) > 0";
    private static final String XPATH_SN_ERZEUGER = "(/descendant::en:IndicatorEN[last()]='false' or /descendant::en:IndicatorEN[last()]=0) and count(/descendant::en:Abfallherkunft[last()]/en:Erzeuger) > 0";
    private static final String XPATH_EN_SAMMLER = "(/descendant::en:IndicatorEN[last()]='true' or /descendant::en:IndicatorEN[last()]=1) and count(/descendant::en:Abfallherkunft[last()]/en:Sammler) > 0";
    private static final String XPATH_ABFALLART_DB = "(count(/descendant::en:Abfallschluessel[ancestor::en:Deckblatt]) > 0 and count(/descendant::en:Abfallschluessel[ancestor::en:VE]) > 0 and (not(/descendant::en:Abfallschluessel[ancestor::en:Deckblatt]=/descendant::en:Abfallschluessel[ancestor::en:VE]))) or (count(/descendant::en:Abfallbezeichnung[ancestor::en:Deckblatt]) > 0 and count(/descendant::en:Abfallbezeichnung[ancestor::en:VE]) > 0 and (not(/descendant::en:Abfallbezeichnung[ancestor::en:Deckblatt]=/descendant::en:Abfallbezeichnung[ancestor::en:VE])))";
    private static final String XPATH_ABFALLART_AE = "(count(/descendant::en:Abfallschluessel[ancestor::en:VE]) > 0 and count(/descendant::en:Abfallschluessel[ancestor::en:AE]) > 0 and (not(/descendant::en:Abfallschluessel[ancestor::en:VE]=/descendant::en:Abfallschluessel[ancestor::en:AE]))) or (count(/descendant::en:Abfallbezeichnung[ancestor::en:VE]) > 0 and count(/descendant::en:Abfallbezeichnung[ancestor::en:AE]) > 0 and (not(/descendant::en:Abfallbezeichnung[ancestor::en:VE]=/descendant::en:Abfallbezeichnung[ancestor::en:AE])))";
    private static final String XPATH_BB = "(/descendant::en:IndicatorMitBB[last()]='false' or /descendant::en:IndicatorMitBB[last()]=0) and count(/descendant::en:BB) > 0";
    private static final String XPATH_ANO = "(/descendant::en:IndicatorMitBB[last()]='true' or /descendant::en:IndicatorMitBB[last()]=1) and count(/descendant::en:Anordnung) > 0";

    public RuleImplENSConflictingContent(RuleDef ruleDef) {
        super(ruleDef);
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        int index = 1;
        try {
            if (XPathFassade.getInstance().evalBool(bmuDok.getDocument().getDocumentElement(), XPATH_ERZ_VERMERKE)) {
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, "Vermerke des Abfallerzeugers im Deckblatt: nur zul\u00e4ssig, wenn 'IndicatorMitBB' auf true gesetzt ist."));
            }
            if (XPathFassade.getInstance().evalBool(bmuDok.getDocument().getDocumentElement(), XPATH_SN_ERZEUGER)) {
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, "'Erzeuger': nur zul\u00e4ssig, wenn der ENS ein EN ist."));
            }
            if (XPathFassade.getInstance().evalBool(bmuDok.getDocument().getDocumentElement(), XPATH_EN_SAMMLER)) {
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, "'Sammler': nur zul\u00e4ssig, wenn der ENS ein SN ist."));
            }
            if (XPathFassade.getInstance().evalBool(bmuDok.getDocument().getDocumentElement(), XPATH_ABFALLART_DB)) {
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, "Die Angaben zur Abfallart in der VE widersprechen den Angaben im Deckblatt."));
            }
            if (XPathFassade.getInstance().evalBool(bmuDok.getDocument().getDocumentElement(), XPATH_ABFALLART_AE)) {
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, "Die Angaben zur Abfallart in der VE widersprechen den Angaben in der AE."));
            }
            if (XPathFassade.getInstance().evalBool(bmuDok.getDocument().getDocumentElement(), XPATH_BB)) {
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, "'BB': nur zul\u00e4ssig, wenn der 'IndicatorMitBB' in der obersten Sicht auf true gesetzt ist."));
            }
            if (XPathFassade.getInstance().evalBool(bmuDok.getDocument().getDocumentElement(), XPATH_ANO)) {
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, "'Anordnung': nur zul\u00e4ssig, wenn der 'IndicatorMitBB' in der obersten Sicht auf false gesetzt ist."));
            }
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPath fuer Vermerke des Abfallerzeugers, wenn IndicatorMitBB nicht true ist: ");
        builder.append(XPATH_ERZ_VERMERKE);
        builder.append("\n");
        builder.append("XPath fuer Erzeuger im SN: ");
        builder.append(XPATH_SN_ERZEUGER);
        builder.append("\n");
        builder.append("XPath fuer Sammler im EN: ");
        builder.append(XPATH_EN_SAMMLER);
        builder.append("\n");
        builder.append("XPath fuer abweichende Abfallart im Deckblatt: ");
        builder.append(XPATH_ABFALLART_DB);
        builder.append("\n");
        builder.append("XPath fuer abweichende Abfallart in der AE: ");
        builder.append(XPATH_ABFALLART_AE);
        builder.append("\n");
        builder.append("XPath fuer BB ohne IndicatorMitBB: ");
        builder.append(XPATH_BB);
        builder.append("\n");
        builder.append("XPath fuer Anordnung mit IndicatorMitBB: ");
        builder.append(XPATH_ANO);
        return builder.toString();
    }
}

