/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.parser.impl;

import de.focus_shift.jollyday.core.Holiday;
import de.focus_shift.jollyday.core.parser.HolidayParser;
import de.focus_shift.jollyday.core.parser.functions.CreateHoliday;
import de.focus_shift.jollyday.core.parser.functions.FixedToLocalDate;
import de.focus_shift.jollyday.core.parser.predicates.ValidLimitation;
import de.focus_shift.jollyday.core.spi.Holidays;
import de.focus_shift.jollyday.core.spi.Relation;
import de.focus_shift.jollyday.core.spi.RelativeToFixed;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Year;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.stream.Collectors;
import org.threeten.extra.Days;

public class RelativeToFixedParser
implements HolidayParser {
    @Override
    public List<Holiday> parse(Year year, Holidays holidays) {
        return holidays.relativeToFixed().stream().filter(new ValidLimitation(year)).map(relativeToFixed -> this.moveToRelativeDate(year, (RelativeToFixed)relativeToFixed)).collect(Collectors.toList());
    }

    private Holiday moveToRelativeDate(Year year, RelativeToFixed rf) {
        LocalDate fixed = new FixedToLocalDate(year).apply(rf.date());
        if (rf.weekday() != null) {
            fixed = this.moveToWeekday(fixed, rf.weekday(), rf.when());
        } else if (rf.days() != null) {
            fixed = this.moveByDays(fixed, rf.days(), rf.when());
        }
        return new CreateHoliday(fixed).apply(rf);
    }

    private LocalDate moveToWeekday(LocalDate date, DayOfWeek targetDay, Relation relation) {
        int direction = relation == Relation.BEFORE ? -1 : 1;
        int currentDayValue = date.getDayOfWeek().getValue();
        int targetDayValue = targetDay.getValue();
        int daysDifference = targetDayValue - currentDayValue;
        if (direction < 0 && daysDifference >= 0) {
            daysDifference -= 7;
        } else if (direction > 0 && daysDifference <= 0) {
            daysDifference += 7;
        }
        return date.plusDays(daysDifference);
    }

    private LocalDate moveByDays(LocalDate date, Days days, Relation relation) {
        return relation == Relation.BEFORE ? date.minus((TemporalAmount)days) : date.plus((TemporalAmount)days);
    }
}

