<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns:b64="xalan://de.itu.util.Base64" 
	xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
	xmlns:x509="xalan://de.itu.util.X509CertHelper" 
	extension-element-prefixes="b64 crc32 x509" 
	exclude-result-prefixes="xsl lib en ds b64 crc32 x509">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:import href="fr.xsl"/>
	<xsl:import href="bb_fr.xsl"/>
	<xsl:import href="anhang_fr.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:param name="layerName" select="'ENSNErzLayer'"/>
	<xsl:param name="layerID" select="'ERZ-01-e6f6d730-0dbe-45b7-857c-0b7474c9ee07'"/>
	<xsl:template match="/">
		<html>
			<head>
				<title>Freistellung</title>
				<!-- CSS - Datei -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<xsl:call-template name="Freistellung"/>
				<p style="page-break-after:always">
					<br style="height:0; line-height:0"/>
				</p>
				<br/>
				<xsl:call-template name="BBDa"/>
				<br/>
				<xsl:call-template name="AnhangFR"/>
				<xsl:call-template name="showSigLayer">
					<xsl:with-param name="Praefix" select="'FR'"/>
				</xsl:call-template>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
