<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns:xades="http://uri.etsi.org/01903/v1.3.2#"
	xmlns:b64="xalan://de.itu.util.Base64" 
	xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
	xmlns:x509="xalan://de.itu.util.X509CertHelper" 
	extension-element-prefixes="b64 crc32 x509" 
	exclude-result-prefixes="xsl lib en ds b64 crc32 x509 xades">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:param name="layerName" select="'ENSNErzLayer'"/>
	<xsl:param name="layerID" select="'ERZ-01-e6f6d730-0dbe-45b7-857c-0b7474c9ee07'"/>
	<xsl:template match="/">
		<html>
			<head>
				<title>Entsorgungsnachweis/Sammelentsorgungsnachweis</title>
				<!-- CSS - Datei -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<xsl:call-template name="BBDa"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="BBDa">
		<xsl:for-each select="//*[(starts-with(local-name(), 'ENSN')) and (contains(local-name(), 'Layer'))]">
			<xsl:if test="position()=$positionsnummer">
				<xsl:choose>
					<xsl:when test="not (boolean(en:BB)) and not (boolean(en:Anordnung))">
						<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
							<tr>
								<td>
									<font id="Nummer">
							  			In dieser Sicht ist keine Beh&#246;rdenbest&#228;tigung / Behördliche Anordnung vorhanden.
						  			</font>
									<br/>
									<font id="Nummer2">
							  			Eine Beh&#246;rdenbestätigung / Behördliche Anordnung befindet sich in der Sicht:
							  		</font>
									<font id="FormPosition">
										<!--xsl:call-template name="BB_Position">
					            			</xsl:call-template-->
										<xsl:call-template name="CHILD_POSITION">
											<xsl:with-param name="DocTyp" select="'ENSN'"/>
											<xsl:with-param name="ChildTyp" select="'en:BB or en:Anordnung'"/>
				            			</xsl:call-template>
									</font>
								</td>
							</tr>
						</table>
					</xsl:when>
					<xsl:when test="boolean(en:Anordnung)">
						<xsl:call-template name="Anordnung">
	            			</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="BB">
	            			</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="BB">
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr>
				<td>
					<table id="tabelle" width="100%">
						<tr>
							<td>
								<table width="100%">
									<colgroup>
										<col width="39%"/>
										<col width="22%"/>
										<col width="39%"/>
									</colgroup>
									<td>
										<table width="100%">
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td id="Ueberschrift2" width="98%">Best&#228;tigende Beh&#246;rde</td>
											</tr>
											<tr height="2%">
												<td width="5"/>
												<td width="98%"/>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Name</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<!-- Behörde - Name 1 -->
													<font id="Aktuell">
														<xsl:value-of select="en:BB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Name/lib:Name1"/>
													</font>
															&#173;
															<!-- Behörde- Name 2 -->
													<font id="Aktuell">
														<xsl:value-of select="en:BB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Name/lib:Name2"/>
													</font>
															&#173;
															<!-- Behörde - Name 3 -->
													<font id="Aktuell">
														<xsl:value-of select="en:BB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Name/lib:Name3"/>
													</font>
															&#173;
															<!-- Behörde - Name 4 -->
													<font id="Aktuell">
														<xsl:value-of select="en:BB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Name/lib:Name4"/>
													</font>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="90%">Straße</td>
															<td id="titel" width="10%">Hausnummer</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="90%">
																<!-- Behörde - Strasse 1-->
																<xsl:call-template name="getTextValuePostfachNoDesc">
																	<xsl:with-param name="TagName" select="'en:BB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Strasse_1'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:BB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Postfach/lib:Postfach'"/>
																</xsl:call-template>
																		&#173;
																		<!-- Behörde - Strasse 2-->
																<font id="Aktuell">
																	<xsl:value-of select="en:BB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Strasse_2"/>
																</font>
															</td>
															<td width="10%">
																<!-- Behörde - Hausnummer -->
																<font id="Aktuell">
																	<xsl:value-of select="en:BB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Hausnummer"/>
																</font>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="30%">Postleitzahl</td>
															<td id="titel" width="70%">Ort</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="30%">
																<!-- Behörde Postleitzahl -->
																<xsl:call-template name="getTextValuePostfachNoDesc">
																	<xsl:with-param name="TagName" select="'en:BB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Postleitzahl'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:BB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Postfach/lib:Postleitzahl'"/>
																</xsl:call-template>
															</td>
															<td width="70%">
																<!-- Behörde Ort1-->
																<xsl:call-template name="getTextValuePostfachNoDesc">
																	<xsl:with-param name="TagName" select="'en:BB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Ort_1'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:BB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Postfach/lib:Ort_1'"/>
																</xsl:call-template>
																		&#173;
																		<!-- Behörde Ort2-->
																<xsl:call-template name="getTextValuePostfachNoDesc">
																	<xsl:with-param name="TagName" select="'en:BB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Ort_2'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:BB/en:AbsenderBehoerde/en:NameUndAdresse/lib:Postfach/lib:Ort_2'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Ansprechpartner</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<!-- Behörde Ansprechpartner - Name-->
													<font id="Aktuell">
														<xsl:value-of select="en:BB/en:AbsenderBehoerde/en:Ansprechpartner/lib:Name"/>
													</font>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="30%">Telefon</td>
															<td id="titel" width="70%">Telefax</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="30%">
																<!-- Behörde Ansprechpartner - Telefon-->
																<font id="Aktuell">
																	<xsl:value-of select="en:BB/en:AbsenderBehoerde/en:Ansprechpartner/lib:Telefon"/>
																</font>
															</td>
															<td width="70%">
																<!-- Behörde Ansprechpartner - Telefax-->
																<font id="Aktuell">
																	<xsl:value-of select="en:BB/en:AbsenderBehoerde/en:Ansprechpartner/lib:Telefax"/>
																</font>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">E-Mail-Adresse</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<!-- Behörde Ansprechpartner - E-Mail-->
													<font id="Aktuell">
														<xsl:value-of select="en:BB/en:AbsenderBehoerde/en:Ansprechpartner/lib:EMail"/>
													</font>
												</td>
											</tr>
										</table>
									</td>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td>
					<div id="Nummer" align="right">Beh&#246;rdenbest&#228;tigung</div>
					<table id="tabelle_nicht_unten" width="100%">
						<xsl:call-template name="ESNKopfNummern"/>
					</table>
					<table id="Tabelle_nicht_oben_unten" width="100%">
						<tr>
							<td>
								<table width="100%">
									<colgroup>
										<col width="1%"/>
										<col width="2%"/>
										<col width="97%"/>
									</colgroup>
									<tr>
										<td id="titel_gross"/>
										<td>
											<table id="Tabelle_indikator">
												<tr>
													<td id="titel_gross">X</td>
												</tr>
											</table>
										</td>
										<td>
											<font id="Nummer">
														Beh&#246;rdliche Best&#228;tigung der Zul&#228;ssigkeit der Entsorgung
											</font>
											<font id="Ueberschrift2">
													(<xsl:value-of select="concat(local-name(),': ',@lib:LayerID)"/>)								
											</font>
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td>
								<table width="100%">
									<colgroup>
										<col width="1%"/>
										<col width="2%"/>
										<col width="97%"/>
									</colgroup>
									<tr>
										<td id="titel_gross"/>
										<td>
											<table id="Tabelle_indikator">
												<tr>
													<td/>
												</tr>
											</table>
										</td>
										<td id="Nummer">	Beh&#246;rdliche Freistellung nach § 7 NachwV </td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<table width="100%" id="tabelle">
						<colgroup>
							<col width="92%"/>
							<col width="8%"/>
						</colgroup>
						<tr>
							<td>
								<table width="100%">
									<tr>
										<td id="Ueberschrift2" width="5">1</td>
										<td id="Ueberschrift2" width="98%">Best&#228;tigung der Zul&#228;ssigkeit der Entsorgung / Freistellung nach § 7 NachwV</td>
									</tr>
									<tr height="1">
										<td width="5"/>
										<td width="98%"/>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5">1.1</td>
										<td id="Text_normal" width="98%">
									                        Die Zul&#228;ssigkeit der vorgesehenen Entsorgung des in der Verantwortlichen Erkl&#228;rung beschriebenen Abfalls        
								                        </td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5"/>
										<td id="Text_normal" width="98%">
											<table>
												<tr>
													<td id="Text_normal">
																in der in der Annahmeerkl&#228;rung beschriebenen Entsorgungsanlage wird best&#228;tigt: 
															</td>
													<td width="10">
															</td>
													<td>
														<table id="Tabelle_indikator">
															<tr>
																<td>
																	<xsl:if test="en:BB/en:IndicatorBestaetigung = 'true'">
																		<font id="Aktuell">			
																					X
																				</font>
																	</xsl:if>
																</td>
															</tr>
														</table>
													</td>
													<td id="Text_normal">Ja</td>
													<td width="10">
															</td>
													<td>
														<table id="Tabelle_indikator">
															<tr>
																<td>
																	<xsl:if test="en:BB/en:IndicatorBestaetigung = 'false'">
																		<font id="Aktuell">			
																					X
																				</font>
																	</xsl:if>
																</td>
															</tr>
														</table>
													</td>
													<td id="Text_normal">Nein</td>
												</tr>
											</table>
										</td>
									</tr>
									<tr height="3">
										<th/>
									</tr>
									<tr>
										<td valign="top" id="Ueberschrift2" width="5">1.2</td>
										<td id="Text_normal" width="98%">
Die im Antrag auf Freistellung gemäß § 7 NachwV beschriebene Entsorgungsanlage wird für die Annahme der im Beiblatt zum Antrag genannten Abfälle (Abfallschlüssel) von der Pflicht, nachweispflichtige Abfälle nur nach vorhergehender Bestätigung des Entsorgungsnachweises im Sinne des § 5 NachwV anzunehmen, freigestellt.
								                        </td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5"/>
										<td id="Text_normal" width="98%">
											<table>
												<tr>
													<td>
														<table id="Tabelle_indikator">
															<tr>
																<td>
										                		       			</td>
															</tr>
														</table>
														<td width="5">
																</td>
													</td>
													<td id="Text_normal">Die Freistellung wird unter Vorbehalt des Widerrufs erteilt.</td>
												</tr>
											</table>
										</td>
									</tr>
									<tr>
										<td valign="top" id="Ueberschrift2" width="5">1.3</td>
										<td id="Text_normal" width="98%">
									                       Die Best&#228;tigung / Freistellung ergeht mit folgender/n Nebenbestimmung(en):
												</td>
									</tr>
									<tr height="3">
										<th/>
									</tr>
									<tr>
										<td valign="top" id="Ueberschrift2" width="5"/>
										<td id="Text_normal" width="98%">
											<!-- Nebenbestimmungen -->
											<xsl:if test="boolean(en:BB/en:Nebenbestimmung)">
												<font id="Ueberschrift2">		
															Siehe Anhang
														</font>
											</xsl:if>
										</td>
									</tr>
									<tr height="3">
										<th/>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5">1.4</td>
										<td id="Text_normal" width="98%">Der Entsorgungsnachweis / Die Freistellung ist g&#252;ltig bis:</td>
									</tr>
									<tr height="1">
										<td width="5"/>
										<td width="98%"/>
									</tr>
									<tr>
										<td width="5"/>
										<td width="98%">
											<table width="100%">
												<tr>
													<td id="titel" width="4%"/>
													<td id="titel" width="15%">Datum</td>
													<td id="titel" width="4%"/>
													<td id="titel" width="15%">Datum</td>
													<td id="titel" width="62%"/>
												</tr>
											</table>
										</td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5"/>
										<td width="98%">
											<table width="100%">
												<tr>
													<td id="Text_normal" width="4%">von</td>
													<td width="15%">
														<!--  Datum von -->
														<font id="Aktuell">
															<xsl:call-template name="formatDate">
																<xsl:with-param name="date">
																	<xsl:value-of select="en:BB/en:Bestaetigungszeitraum/en:GueltigVon"/>
																</xsl:with-param>
															</xsl:call-template>
														</font>
													</td>
													<td id="Text_normal" width="4%">bis</td>
													<td width="15%">
														<!--  Datum bis -->
														<font id="Aktuell">
															<xsl:call-template name="formatDate">
																<xsl:with-param name="date">
																	<xsl:value-of select="en:BB/en:Bestaetigungszeitraum/en:GueltigBis"/>
																</xsl:with-param>
															</xsl:call-template>
														</font>
													</td>
													<td width="62%"/>
												</tr>
											</table>
										</td>
									</tr>
									<tr height="3">
										<th/>
									</tr>
									<tr>
										<td valign="top" id="Ueberschrift2" width="5">1.5</td>
										<td id="Text_normal" width="98%">
									                       Begr&#252;ndung, wenn nicht best&#228;tigt, unter 5 Jahre befristet, unter Vorbehalt des Widerrufs erteilt oder mit Nebenbestimmungen ergangen:
								                        </td>
									</tr>
									<tr height="3">
										<th/>
									</tr>
									<tr>
										<td valign="top" id="Ueberschrift2" width="5"/>
										<td id="Text_normal" width="98%">
											<!--  Begründung -->
											<xsl:if test="boolean(en:BB/en:Begruendung)">
												<font id="Ueberschrift2">
															Siehe Anhang
														</font>
											</xsl:if>
										</td>
									</tr>
									<tr height="3">
										<th/>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5">1.6</td>
										<td id="Text_normal" width="98%">
											<table>
												<tr>
													<td>
														<table id="Tabelle_indikator">
															<tr>
																<td>
																	<xsl:if test="en:BB/en:IndicatorAnVEErzeuger = 'true'">
																		<font id="Aktuell">			
																					X														
																				</font>
																	</xsl:if>
																</td>
															</tr>
														</table>
														<td width="5">
																</td>
													</td>
													<td id="Text_normal">Diese Best&#228;tigung ist an den in der Verantwortlichen Erkl&#228;rung (VE) genannten Abfallerzeuger gerichtet</td>
												</tr>
											</table>
										</td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5"/>
										<td id="Text_normal" width="98%">
											<table>
												<tr>
													<td>
														<table id="Tabelle_indikator">
															<tr>
																<td>
																	<xsl:if test="en:BB/en:IndicatorAnAEEntsorger = 'true'">
																		<font id="Aktuell">			
																					X														
																				</font>
																	</xsl:if>
																</td>
															</tr>
														</table>
														<td width="5">
															</td>
													</td>
													<td id="Text_normal">Diese Best&#228;tigung ist an den in der Annahmeerkl&#228;rung (AE) genannten Abfallentsorger gerichtet</td>
												</tr>
											</table>
										</td>
									</tr>
									<tr height="3">
										<th/>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5">1.7</td>
										<td width="98%">
											<font id="Aktuell">
												<xsl:value-of select="en:BB/en:HinweisGebuehr"/>
											</font>
										</td>
										<!--td id="Text_normal" width="98%">
                         									Dieser Bescheid ist geb&#252;hrenpfllichtig. Es ergeht ein gesonderter Geb&#252;hrenbescheid.
								                          </td-->
									</tr>
									<tr height="3">
										<th/>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5">1.8</td>
										<td width="98%">
											<font id="Aktuell">
												<xsl:value-of select="en:BB/en:HinweisRechtsbehelf"/>
											</font>
										</td>
										<!--td id="Text_normal" width="98%">
									                         Die beigef&#252;gte Rechtsbehelfsbelehrung ist Bestandteil dieses Bescheides.
								                          </td-->
									</tr>
									<tr height="3">
										<th/>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5">1.9</td>
										<td id="Text_normal" width="98%">
				                                                        Aktenzeichen
                        			                              </td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5"/>
										<td width="98%">
											<font id="Aktuell">
												<xsl:value-of select="en:BB/en:Aktenzeichen"/>
											</font>
										</td>
									</tr>
									<tr height="6">
										<th/>
									</tr>
									<tr>
										<td width="5"/>
										<td width="98%">
											<table width="100%">
												<tr>
													<td id="titel" width="33%">Ort</td>
													<td id="titel" width="33%">Datum</td>
													<td id="titel" width="33%">Rechtsverbindliche Unterschrift (Signatur)</td>
												</tr>
											</table>
										</td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5">1.10</td>
										<td width="98%">
											<table width="100%">
												<tr>
													<td width="33%">
														<!-- Ort Unterschrift  -->
														<font id="Aktuell">
															<xsl:value-of select="en:BB/en:Erklaerung/lib:Ort"/>
														</font>
													</td>
													<td width="33%">
														<!--  Datum -->
														<font id="Aktuell">
															<xsl:call-template name="formatDate">
																<xsl:with-param name="date">
																	<xsl:value-of select="en:BB/en:Erklaerung/lib:Datum"/>
																</xsl:with-param>
															</xsl:call-template>
														</font>
													</td>
													<td width="33%">
														<font id="Aktuell">
															<xsl:if test="ds:Signature/ds:KeyInfo/ds:X509Data/ds:X509Certificate">
																<xsl:value-of select="x509:extractCommonName(b64:decode(ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
																<xsl:variable name="SIG_DATE">
																	<xsl:call-template name="formatDate">
																		<xsl:with-param name="date" select="ds:Signature[1]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
																	</xsl:call-template>
																</xsl:variable>
																<xsl:value-of select="concat(' (', $SIG_DATE, ')')"/>
															</xsl:if>
														</font>
													</td>
												</tr>
											</table>
										</td>
									</tr>
								</table>
							</td>
							<td height="100%" id="tabelle_links">
								<table height="100%" width="100%">
									<tr height="3%">
										<td id="Ueberschrift2"> F&#252;r interne Vermerke der Beh&#246;rde   </td>
									</tr>
									<tr height="97%">
										<td/>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<!--p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p-->
		<table width="100%" id="Tabelle-Haupt" cellspacing="15" cellpadding="15">
			<tr>
				<td>
					<!--Nebenbestimmungen-->
					<table cellspacing="6" cellpadding="6" width="100%">
						<font id="Nummer">Nebenbestimmung(en):</font>
						<tr height="3">
							<th/>
						</tr>
						<tr>
							<td>
								<table id="Tabelle_unten" width="100%">
									<tr>
										<td id="Ueberschrift2" width="6%"> Lfd-Nr.	</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="10%"> Adressat		</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="25%"> Kurz-Beschreibung		</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="53%">Beschreibung	</td>
									</tr>
								</table>
								<xsl:for-each select="en:BB/en:Nebenbestimmung">
									<table id="Tabelle_unten" width="100%">
										<tr>
											<td id="Aktuell" valign="top" width="6%">
												<xsl:value-of select="@lib:Index"/>
											</td>
											<td width="2%"/>
											<td id="Aktuell" valign="top" width="10%">
												<xsl:for-each select="en:Adressat">
													<xsl:value-of select="."/>
													<xsl:if test="position() != last()"> / </xsl:if>
												</xsl:for-each>
											</td>
											<td width="2%"/>
											<td id="Aktuell" valign="top" width="25%">
												<xsl:value-of select="en:Kurz"/>
											</td>
											<td width="2%"/>
											<td id="Aktuell" valign="top" width="53%">
												<xsl:value-of select="en:Beschreibung"/>
											</td>
										</tr>
										<tr height="15">
											<th/>
										</tr>
									</table>
								</xsl:for-each>
							</td>
						</tr>
						<tr height="20">
							<th/>
						</tr>
					</table>
					<!--Ende Nebenbestimmungen-->
					<table cellspacing="6" cellpadding="6" width="100%">
						<font id="Nummer">Begr&#252;ndung:</font>
						<tr height="3">
							<th/>
						</tr>
						<tr>
							<td>
								<table id="Tabelle_unten" width="100%">
									<tr>
										<td id="Ueberschrift2" width="6%"> Lfd-Nr.</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="10%"> Bezug-NB</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="25%"> Kurz-Beschreibung</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="53%">Beschreibung</td>
									</tr>
								</table>
								<xsl:for-each select="en:BB/en:Begruendung">
									<table id="Tabelle_unten" width="100%">
										<tr>
											<td id="Aktuell" valign="top" width="6%">
												<xsl:value-of select="@lib:Index"/>
											</td>
											<td id="Aktuell" width="2%"/>
											<td id="Aktuell" valign="top" width="10%">
												<xsl:value-of select="en:BezugNebenbestimmung"/>
											</td>
											<td id="Aktuell" width="2%"/>
											<td id="Aktuell" valign="top" width="25%">
												<xsl:value-of select="en:Kurz"/>
											</td>
											<td id="Aktuell" width="2%"/>
											<td id="Aktuell" valign="top" width="53%">
												<xsl:value-of select="en:Beschreibung"/>
											</td>
										</tr>
										<tr height="15">
											<th/>
										</tr>
									</table>
								</xsl:for-each>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<br/>
		<!--p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p-->
		<table width="100%" id="Tabelle-Haupt" cellspacing="15" cellpadding="15">
			<tr>
				<td>
					<font id="Nummer">Rechtsbehelf - Erzeuger:</font>
					<br/>
					<br/>
					<font id="Aktuell">
						<xsl:value-of select="en:BB/en:Rechtsbehelf/en:Erzeuger"/>
					</font>
				</td>
			</tr>
			<tr>
				<td>
					<font id="Nummer">Rechtsbehelf - Bef&#246;rderer:</font>
					<br/>
					<br/>
					<font id="Aktuell">
						<xsl:value-of select="en:BB/en:Rechtsbehelf/en:Befoerderer"/>
					</font>
				</td>
			</tr>
			<tr>
				<td>
					<font id="Nummer">Rechtsbehelf - Entsorger:</font>
					<br/>
					<br/>
					<font id="Aktuell">
						<xsl:value-of select="en:BB/en:Rechtsbehelf/en:Entsorger"/>
					</font>
				</td>
			</tr>
		</table>
		<br/>
		<br/>
		<table width="100%" id="Tabelle-Haupt" cellspacing="15" cellpadding="15">
			<tr>
				<th>
					<xsl:call-template name="Dateianhang">
		            	</xsl:call-template>
				</th>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Anordnung">
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr>
				<td>
					<table id="tabelle" width="100%">
						<tr>
							<td>
								<table width="100%">
									<colgroup>
										<col width="39%"/>
										<col width="22%"/>
										<col width="39%"/>
									</colgroup>
									<td>
										<table width="100%">
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td id="Ueberschrift2" width="98%">Behördliche Anordnung</td>
											</tr>
											<tr height="2%">
												<td width="5"/>
												<td width="98%"/>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Name</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<!-- Behörde - Name 1 -->
													<font id="Aktuell">
														<xsl:value-of select="en:Anordnung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Name/lib:Name1"/>
													</font>
															&#173;
															<!-- Behörde- Name 2 -->
													<font id="Aktuell">
														<xsl:value-of select="en:Anordnung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Name/lib:Name2"/>
													</font>
															&#173;
															<!-- Behörde - Name 3 -->
													<font id="Aktuell">
														<xsl:value-of select="en:Anordnung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Name/lib:Name3"/>
													</font>
															&#173;
															<!-- Behörde - Name 4 -->
													<font id="Aktuell">
														<xsl:value-of select="en:Anordnung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Name/lib:Name4"/>
													</font>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="90%">Straße</td>
															<td id="titel" width="10%">Hausnummer</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="90%">
																<!-- Behörde - Strasse 1-->
																<xsl:call-template name="getTextValuePostfachNoDesc">
																	<xsl:with-param name="TagName" select="'en:Anordnung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Strasse_1'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:Anordnung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Postfach/lib:Postfach'"/>
																</xsl:call-template>
																		&#173;
																		<!-- Behörde - Strasse 2-->
																<font id="Aktuell">
																	<xsl:value-of select="en:Anordnung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Strasse_2"/>
																</font>
															</td>
															<td width="10%">
																<!-- Behörde - Hausnummer -->
																<font id="Aktuell">
																	<xsl:value-of select="en:Anordnung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Hausnummer"/>
																</font>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="30%">Postleitzahl</td>
															<td id="titel" width="70%">Ort</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="30%">
																<!-- Behörde Postleitzahl -->
																<xsl:call-template name="getTextValuePostfachNoDesc">
																	<xsl:with-param name="TagName" select="'en:Anordnung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Postleitzahl'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:Anordnung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Postfach/lib:Postleitzahl'"/>
																</xsl:call-template>
															</td>
															<td width="70%">
																<!-- Behörde Ort1-->
																<xsl:call-template name="getTextValuePostfachNoDesc">
																	<xsl:with-param name="TagName" select="'en:Anordnung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Ort_1'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:Anordnung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Postfach/lib:Ort_1'"/>
																</xsl:call-template>
																		&#173;
																		<!-- Behörde Ort2-->
																<xsl:call-template name="getTextValuePostfachNoDesc">
																	<xsl:with-param name="TagName" select="'en:Anordnung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Adresse/lib:Ort_2'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:Anordnung/en:AbsenderBehoerde/en:NameUndAdresse/lib:Postfach/lib:Ort_2'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Ansprechpartner</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<!-- Behörde Ansprechpartner - Name-->
													<font id="Aktuell">
														<xsl:value-of select="en:Anordnung/en:AbsenderBehoerde/en:Ansprechpartner/lib:Name"/>
													</font>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="30%">Telefon</td>
															<td id="titel" width="70%">Telefax</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="30%">
																<!-- Behörde Ansprechpartner - Telefon-->
																<font id="Aktuell">
																	<xsl:value-of select="en:Anordnung/en:AbsenderBehoerde/en:Ansprechpartner/lib:Telefon"/>
																</font>
															</td>
															<td width="70%">
																<!-- Behörde Ansprechpartner - Telefax-->
																<font id="Aktuell">
																	<xsl:value-of select="en:Anordnung/en:AbsenderBehoerde/en:Ansprechpartner/lib:Telefax"/>
																</font>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">E-Mail-Adresse</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5"/>
												<td width="98%">
													<!-- Behörde Ansprechpartner - E-Mail-->
													<font id="Aktuell">
														<xsl:value-of select="en:Anordnung/en:AbsenderBehoerde/en:Ansprechpartner/lib:EMail"/>
													</font>
												</td>
											</tr>
										</table>
									</td>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td>
					<div id="Nummer" align="right">Behördliche Anordnung</div>
					<table id="tabelle_nicht_unten" width="100%">
						<xsl:call-template name="ESNKopfNummern"/>
					</table>
					<table id="Tabelle_nicht_oben_unten" width="100%">
						<tr>
							<td>
								<table width="100%">
									<colgroup>
										<col width="1%"/>
										<col width="2%"/>
										<col width="97%"/>
									</colgroup>
									<tr>
										<td id="titel_gross"/>
										<td>
											<table id="Tabelle_indikator">
												<tr>
													<td id="titel_gross">X</td>
												</tr>
											</table>
										</td>
										<td>
											<font id="Nummer">
														Behördliche Anordnung
											</font>
											<font id="Ueberschrift2">
													(<xsl:value-of select="concat(local-name(),': ',@lib:LayerID)"/>)								
											</font>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<table width="100%" id="tabelle">
						<colgroup>
							<col width="92%"/>
							<col width="8%"/>
						</colgroup>
						<tr>
							<td>
								<table width="100%">
									<tr>
										<td id="Ueberschrift2" width="5">1</td>
										<td id="Ueberschrift2" width="98%">Anordnung zum privilegierten Entsorgungsnachweis / Sammelentsorgungsnachweis</td>
									</tr>
									<tr height="1">
										<td width="5"/>
										<td width="98%"/>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5">1.1</td>
										<td id="Text_normal" width="98%">
											<table>
												<tr>
													<td id="Text_normal">
													Die Nutzung des privilegierten Nachweises wird untersagt:
													</td>
													<td width="10">
															</td>
													<td>
														<table id="Tabelle_indikator">
															<tr>
																<td>
																	<xsl:if test="en:Anordnung/en:IndicatorENSNNutzungUntersagt= 'true'">
																		<font id="Aktuell">			
																					X
																				</font>
																	</xsl:if>
																</td>
															</tr>
														</table>
													</td>
													<td id="Text_normal">Ja</td>
													<td width="10">
															</td>
													<td>
														<table id="Tabelle_indikator">
															<tr>
																<td>
																	<xsl:if test="en:Anordnung/en:IndicatorENSNNutzungUntersagt= 'false'">
																		<font id="Aktuell">			
																					X
																				</font>
																	</xsl:if>
																</td>
															</tr>
														</table>
													</td>
													<td id="Text_normal">Nein</td>
												</tr>
											</table>
										</td>
									</tr>
									<tr height="3">
										<th/>
									</tr>
									<tr>
										<td valign="top" id="Ueberschrift2" width="5">1.3</td>
										<td id="Text_normal" width="98%">
									                       Die Anordnung ergeht mit folgender/n Nebenbestimmung(en):
												</td>
									</tr>
									<tr height="3">
										<th/>
									</tr>
									<tr>
										<td valign="top" id="Ueberschrift2" width="5"/>
										<td id="Text_normal" width="98%">
											<!-- Nebenbestimmungen -->
											<xsl:if test="boolean(en:Anordnung/en:Nebenbestimmung)">
												<font id="Ueberschrift2">		
															Siehe Anhang
														</font>
											</xsl:if>
										</td>
									</tr>
									<tr height="3">
										<th/>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5">1.4</td>
										<td id="Text_normal" width="98%">Der privilegierte Nachweis ist g&#252;ltig bis:</td>
									</tr>
									<tr height="1">
										<td width="5"/>
										<td width="98%"/>
									</tr>
									<tr>
										<td width="5"/>
										<td width="98%">
											<table width="100%">
												<tr>
													<td id="titel" width="4%"/>
													<td id="titel" width="15%">Datum</td>
													<td id="titel" width="4%"/>
													<td id="titel" width="15%">Datum</td>
													<td id="titel" width="62%"/>
												</tr>
											</table>
										</td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5"/>
										<td width="98%">
											<table width="100%">
												<tr>
													<td id="Text_normal" width="4%">von</td>
													<td width="15%">
														<!--  Datum von -->
														<font id="Aktuell">
															<xsl:call-template name="formatDate">
																<xsl:with-param name="date">
																	<xsl:value-of select="en:Anordnung/en:Laufzeit/en:GueltigVon"/>
																</xsl:with-param>
															</xsl:call-template>
														</font>
													</td>
													<td id="Text_normal" width="4%">bis</td>
													<td width="15%">
														<!--  Datum bis -->
														<font id="Aktuell">
															<xsl:call-template name="formatDate">
																<xsl:with-param name="date">
																	<xsl:value-of select="en:Anordnung/en:Laufzeit/en:GueltigBis"/>
																</xsl:with-param>
															</xsl:call-template>
														</font>
													</td>
													<td width="62%"/>
												</tr>
											</table>
										</td>
									</tr>
									<tr height="3">
										<th/>
									</tr>
									<tr>
										<td valign="top" id="Ueberschrift2" width="5">1.5</td>
										<td id="Text_normal" width="98%">
									                       Begr&#252;ndung, wenn Nutzung untersagt, unter 5 Jahre befristet oder mit Nebenbestimmungen ergangen:
								                        </td>
									</tr>
									<tr height="3">
										<th/>
									</tr>
									<tr>
										<td valign="top" id="Ueberschrift2" width="5"/>
										<td id="Text_normal" width="98%">
											<!--  Begründung -->
											<xsl:if test="boolean(en:Anordnung/en:Begruendung)">
												<font id="Ueberschrift2">
															Siehe Anhang
														</font>
											</xsl:if>
										</td>
									</tr>
									<tr height="3">
										<th/>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5">1.8</td>
										<td id="Text_normal" width="98%">
									                         Die beigef&#252;gte Rechtsbehelfsbelehrung ist Bestandteil dieser Anordnung.
								                          </td>
									</tr>
									<tr height="3">
										<th/>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5">1.9</td>
										<td id="Text_normal" width="98%">
				                                                        Aktenzeichen
                        			                              </td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5"/>
										<td width="98%">
											<font id="Aktuell">
												<xsl:value-of select="en:Anordnung/en:Aktenzeichen"/>
											</font>
										</td>
									</tr>
									<tr height="6">
										<th/>
									</tr>
									<tr>
										<td width="5"/>
										<td width="98%">
											<table width="100%">
												<tr>
													<td id="titel" width="33%">Ort</td>
													<td id="titel" width="33%">Datum</td>
													<td id="titel" width="33%">Rechtsverbindliche Unterschrift (Signatur)</td>
												</tr>
											</table>
										</td>
									</tr>
									<tr>
										<td id="Ueberschrift2" width="5">1.10</td>
										<td width="98%">
											<table width="100%">
												<tr>
													<td width="33%">
														<!-- Ort Unterschrift  -->
														<font id="Aktuell">
															<xsl:value-of select="en:Anordnung/en:Erklaerung/lib:Ort"/>
														</font>
													</td>
													<td width="33%">
														<!--  Datum -->
														<font id="Aktuell">
															<xsl:call-template name="formatDate">
																<xsl:with-param name="date">
																	<xsl:value-of select="en:Anordnung/en:Erklaerung/lib:Datum"/>
																</xsl:with-param>
															</xsl:call-template>
														</font>
													</td>
													<td width="33%">
														<font id="Aktuell">
															<xsl:if test="ds:Signature/ds:KeyInfo/ds:X509Data/ds:X509Certificate">
																<xsl:value-of select="x509:extractCommonName(b64:decode(ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
																<xsl:variable name="SIG_DATE">
																	<xsl:call-template name="formatDate">
																		<xsl:with-param name="date" select="ds:Signature[1]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
																	</xsl:call-template>
																</xsl:variable>
																<xsl:value-of select="concat(' (', $SIG_DATE, ')')"/>
															</xsl:if>
														</font>
													</td>
												</tr>
											</table>
										</td>
									</tr>
								</table>
							</td>
							<td height="100%" id="tabelle_links">
								<table height="100%" width="100%">
									<tr height="3%">
										<td id="Ueberschrift2"> F&#252;r interne Vermerke der Beh&#246;rde   </td>
									</tr>
									<tr height="97%">
										<td/>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<!--p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p-->
		<table width="100%" id="Tabelle-Haupt" cellspacing="15" cellpadding="15">
			<tr>
				<td>
					<!--Nebenbestimmungen-->
					<table cellspacing="6" cellpadding="6" width="100%">
						<font id="Nummer">Nebenbestimmung(en):</font>
						<tr height="3">
							<th/>
						</tr>
						<tr>
							<td>
								<table id="Tabelle_unten" width="100%">
									<tr>
										<td id="Ueberschrift2" width="6%"> Lfd-Nr.	</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="10%"> Adressat		</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="25%"> Kurz-Beschreibung		</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="53%">Beschreibung	</td>
									</tr>
								</table>
								<xsl:for-each select="en:Anordnung/en:Nebenbestimmung">
									<table id="Tabelle_unten" width="100%">
										<tr>
											<td id="Aktuell" valign="top" width="6%">
												<xsl:value-of select="@lib:Index"/>
											</td>
											<td width="2%"/>
											<td id="Aktuell" valign="top" width="10%">
												<xsl:for-each select="en:Adressat">
													<xsl:value-of select="."/>
													<xsl:if test="position() != last()"> / </xsl:if>
												</xsl:for-each>
											</td>
											<td width="2%"/>
											<td id="Aktuell" valign="top" width="25%">
												<xsl:value-of select="en:Kurz"/>
											</td>
											<td width="2%"/>
											<td id="Aktuell" valign="top" width="53%">
												<xsl:value-of select="en:Beschreibung"/>
											</td>
										</tr>
										<tr height="15">
											<th/>
										</tr>
									</table>
								</xsl:for-each>
							</td>
						</tr>
						<tr height="20">
							<th/>
						</tr>
					</table>
					<!--Ende Nebenbestimmungen-->
					<table cellspacing="6" cellpadding="6" width="100%">
						<font id="Nummer">Begr&#252;ndung:</font>
						<tr height="3">
							<th/>
						</tr>
						<tr>
							<td>
								<table id="Tabelle_unten" width="100%">
									<tr>
										<td id="Ueberschrift2" width="6%"> Lfd-Nr.</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="10%"> Bezug-NB</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="25%"> Kurz-Beschreibung</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="53%">Beschreibung</td>
									</tr>
								</table>
								<xsl:for-each select="en:Anordnung/en:Begruendung">
									<table id="Tabelle_unten" width="100%">
										<tr>
											<td id="Aktuell" valign="top" width="6%">
												<xsl:value-of select="@lib:Index"/>
											</td>
											<td id="Aktuell" width="2%"/>
											<td id="Aktuell" valign="top" width="10%">
												<xsl:value-of select="en:BezugNebenbestimmung"/>
											</td>
											<td id="Aktuell" width="2%"/>
											<td id="Aktuell" valign="top" width="25%">
												<xsl:value-of select="en:Kurz"/>
											</td>
											<td id="Aktuell" width="2%"/>
											<td id="Aktuell" valign="top" width="53%">
												<xsl:value-of select="en:Beschreibung"/>
											</td>
										</tr>
										<tr height="15">
											<th/>
										</tr>
									</table>
								</xsl:for-each>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<br/>
		<!--p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p-->
		<table width="100%" id="Tabelle-Haupt" cellspacing="15" cellpadding="15">
			<tr>
				<td>
					<font id="Nummer">Rechtsbehelf - Erzeuger:</font>
					<br/>
					<br/>
					<font id="Aktuell">
						<xsl:value-of select="en:Anordnung/en:Rechtsbehelf/en:Erzeuger"/>
					</font>
				</td>
			</tr>
			<tr>
				<td>
					<font id="Nummer">Rechtsbehelf - Bef&#246;rderer:</font>
					<br/>
					<br/>
					<font id="Aktuell">
						<xsl:value-of select="en:Anordnung/en:Rechtsbehelf/en:Befoerderer"/>
					</font>
				</td>
			</tr>
			<tr>
				<td>
					<font id="Nummer">Rechtsbehelf - Entsorger:</font>
					<br/>
					<br/>
					<font id="Aktuell">
						<xsl:value-of select="en:Anordnung/en:Rechtsbehelf/en:Entsorger"/>
					</font>
				</td>
			</tr>
		</table>
		<br/>
		<br/>
		<table width="100%" id="Tabelle-Haupt" cellspacing="15" cellpadding="15">
			<tr>
				<th>
					<xsl:call-template name="Dateianhang">
		            	</xsl:call-template>
				</th>
			</tr>
		</table>
	</xsl:template>

	<!--gebühren und anhänge-->
	<xsl:template name="Dateianhang">
		<table width="100%" border="0">
			<tr align="left">
				<td id="Text_normal "> Anhang: </td>
			</tr>
			<xsl:if test="count(en:Gebuehr/en:Dateianhang)>0">
				<xsl:call-template name="Anhang">
            		</xsl:call-template>
			</xsl:if>
		</table>
	</xsl:template>
	<xsl:template name="Anhang">
		<table width="100%" cellspacing="15" cellpadding="15">
			<tr>
				<td>
					<font id="Nummer2">Im signierten Gebührenbereich angehängt wurden:</font>
					<br/>
					<br/>
					<ul>
						<xsl:for-each select="en:Gebuehr/en:Dateianhang">
							<font id="Aktuell">
								<li>
									<xsl:value-of select="@lib:dateiname"/>
								</li>
							</font>
						</xsl:for-each>
					</ul>
					<!--font id="noprint">
						<a href="javascript:save_file();">Um die Geb&#252;hrenanhänge aus dem Dokument anzusehen, bitte hier klicken</a>
					</font-->
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="BB_Position">
		<xsl:variable name="CNTLAYER">
			<xsl:value-of select="count(//*[(starts-with(local-name(), 'ENSN')) and (contains(local-name(), 'Layer'))])"></xsl:value-of>
		</xsl:variable>
		<xsl:for-each select="//*[(starts-with(local-name(), 'ENSN')) and (contains(local-name(), 'Layer'))]">
			<xsl:if test="en:BB or en:Anordnung">
				<xsl:choose>
					<xsl:when test="$CNTLAYER - position() + 1 > 9">
						<xsl:value-of select="concat($CNTLAYER - position() + 1,'. ',local-name())"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('0', $CNTLAYER - position() + 1,'. ',local-name())"/>
					</xsl:otherwise>
				</xsl:choose> 
				<xsl:if test="position() != last()"> / </xsl:if>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
