<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:dyn="http://exslt.org/dynamic"
 	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
 	xmlns:bgs="uri:BMU_Waste_Interface/BGS" 
 	xmlns:reg="uri:BMU_Waste_Interface/Reg" 
 	xmlns:msg="uri:BMU_Waste_Interface/Message" 
	xmlns:zks="uri:BMU_Waste_Interface/ZKS"
 	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
 	xmlns:b64="xalan://de.itu.util.Base64" 
 	xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
 	xmlns:x509="xalan://de.itu.util.X509CertHelper" 
 	extension-element-prefixes="dyn b64 crc32 x509" 
 	exclude-result-prefixes="dyn b64 crc32 x509 bgs ds lib xsl fo">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:param name="positionsnummerCharge" select="2"/>
	<xsl:param name="positionsnummerUNS" select="0"/>
	<xsl:param name="nameXML"/>
	<xsl:param name="layerName" select="'ENSNErzLayer'"/>
	<xsl:param name="layerID" select="'ERZ-01-e6f6d730-0dbe-45b7-857c-0b7474c9ee07'"/>
	<xsl:template match="/">
	   <xsl:call-template name="BGSExzerpt"/>
	</xsl:template>
	<xsl:template name="BGSExzerpt">
		<html>
			<head>
				<title>BGS/UNS</title>
				<!-- CSS - Datei   -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<xsl:for-each select="//reg:Charge">
					<!-- jetzt unterscheiden wir nach bgs und uns dokumenten -->
					<xsl:choose>
						<xsl:when test="reg:BGSmitUNS">
							<xsl:for-each select="reg:BGSmitUNS/reg:BGS">
								<xsl:for-each select="descendant::*[(contains(local-name(), 'BGSExzerpt'))]">
									<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
										<tr>
											<th>
												<xsl:call-template name="ExzerptNummer"/>
												<xsl:call-template name="ExzerptAbfall"/>
												<xsl:call-template name="ExzerptATB"/>
												<xsl:call-template name="ExzerptATBWeitere"/>
											</th>
										</tr>
									</table>
									<xsl:if test="descendant::reg:UNSNummern">
										<xsl:call-template name="Uebernahmenr_Abfallschl"/>
									</xsl:if>
									<br></br>
								</xsl:for-each>
							</xsl:for-each>
							<xsl:for-each select="reg:BGSmitUNS/reg:UNS">
								<xsl:for-each select="descendant::*[(contains(local-name(), 'UNSExzerpt'))]">
									<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
										<tr>
											<th>
												<xsl:call-template name="ExzerptNummer"/>
												<xsl:call-template name="ExzerptAbfall"/>
												<xsl:call-template name="ExzerptATB"/>
											</th>
										</tr>
									</table>
									<br></br>
								</xsl:for-each>
							</xsl:for-each>
						</xsl:when>
						<xsl:when test="reg:UNSsolo">
									<xsl:for-each select="descendant::*[(contains(local-name(), 'UNSExzerpt'))]">
										<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
											<tr>
												<th>
													<xsl:call-template name="ExzerptNummer"/>
													<xsl:call-template name="ExzerptAbfall"/>
													<xsl:call-template name="ExzerptATB"/>
												</th>
											</tr>
										</table>
										<br></br>
									</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<xsl:for-each select="descendant::*[(contains(local-name(), 'BGSExzerpt'))]">
								<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
									<tr>
										<th>
											<xsl:call-template name="ExzerptNummer"/>
											<xsl:call-template name="ExzerptAbfall"/>
											<xsl:call-template name="ExzerptATB"/>
											<xsl:call-template name="ExzerptATBWeitere"/>
										</th>
									</tr>
								</table>
								<xsl:if test="descendant::reg:UNSNummern">
									<xsl:call-template name="Uebernahmenr_Abfallschl"/>
								</xsl:if>
								<br></br>
							</xsl:for-each>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="ExzerptNummer">
		<!-- erste Zeile im Dokument -->
		<table width="100%" border="0">
			<colgroup>
				<col width="60%"/>
				<col width="10%"/>
				<col width="30%"/>
			</colgroup>
			<tr>
				<td>
					<table width="100%" border="0">
						<tr id="Nummer">
							<td>
								<xsl:choose>
									<xsl:when test="local-name() = 'BGSExzerpt'">
										Begleitscheinauszug (BGSExzerpt)
									</xsl:when>
									<xsl:when test="local-name() = 'UNSExzerpt'">
										&#220;bernahmescheinauszug (UNSExzerpt)
									</xsl:when>
								</xsl:choose>
							</td>
						</tr>
						<tr id="Ueberschrift2">
							<td>Beleg zum Nachweis der Entsorgung von Abf&#228;llen 
							</td>
						</tr>
					</table>
				</td>
				<td> </td>
				<td id="Nummer"> 
					Nr: 
					 <xsl:choose>
						<xsl:when test="local-name() = 'BGSExzerpt'">
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'bgs:BGSNummer/lib:PaginierNr'"/>
							</xsl:call-template>
							&#173;
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'bgs:BGSNummer/lib:Pruefziffer'"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="local-name() = 'UNSExzerpt'">
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'bgs:UNSNummer/lib:PaginierNr'"/>
							</xsl:call-template>
							&#173;
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'bgs:UNSNummer/lib:Pruefziffer'"/>
							</xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</td>
			</tr>
		</table>
		<font id="noprint">
			<br/>
		</font>
	</xsl:template>
	<xsl:template name="ExzerptAbfall">
		<!-- zweite Zeile im Dokument -->
		<table width="100%" border="0">
			<colgroup>
				<col width="33%"/>
				<col width="33%"/>
				<col width="33%"/>
			</colgroup>
			<tr>
				<td id="Titel">Abfallschl&#252;ssel</td>
				<td id="Titel">Entsorgungsnachweis-Nummer</td>
				<td id="Titel">Menge in t</td>
			</tr>
			<tr>
				<td>
					<!-- Abfallschluessel -->
					<xsl:call-template name="getTextValue">
						<xsl:with-param name="TagName" select="'bgs:Abfall'"/>
					</xsl:call-template>
				</td>
				<td>
					<!-- NachweisNr -->
					<xsl:call-template name="getTextValue">
						<xsl:with-param name="TagName" select="'bgs:ENSNNummer/lib:NachweisNr'"/>
					</xsl:call-template>
					&#173;
					<!-- Pruefziffer -->
					<xsl:call-template name="getTextValue">
						<xsl:with-param name="TagName" select="'bgs:ENSNNummer/lib:Pruefziffer'"/>
					</xsl:call-template>
				</td>
				<td>
					<!--Menge  	-->
					<xsl:call-template name="getDoubleValue">
						<xsl:with-param name="TagName" select="'bgs:Menge'"/>
					</xsl:call-template>
					&#173;
					<xsl:call-template name="getTextValue">
						<xsl:with-param name="TagName" select="'bgs:Menge'"/>
						<xsl:with-param name="TagAttr" select="'@lib:Einheit'"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
		<font id="noprint">
			<br/>
		</font>
	</xsl:template>
	<xsl:template name="ExzerptATB">
		<!-- dritte Zeile im Dokument -->
		<table width="100%" border="0">
			<colgroup>
				<col width="33%"/>
				<col width="33%"/>
				<col width="33%"/>
			</colgroup>
			<td>
				<!-- Erzeuger -->
				<table width="100%" border="0" height="50">
					<tr>
						<td id="Titel">Erzeugernummer</td>
					</tr>
					<tr>
						<td>
							<!-- BehoerdlicheNummer	-->
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'bgs:Erzeuger/bgs:ErzeugerNr/lib:BehoerdlicheNr'"/>
							</xsl:call-template>
							&#173;
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'bgs:Erzeuger/bgs:ErzeugerNr/lib:Pruefziffer'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
				<table width="100%" border="0" height="50">
					<tr>
						<td id="Titel">Datum der &#220;bergabe</td>
					</tr>
					<tr>
						<td>
							<!-- Datum-->
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'bgs:Erzeuger/bgs:Uebergabedatum'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
			</td>
			<!-- Befoerderer 1-->
			<xsl:choose>
				<xsl:when test="local-name() = 'BGSExzerpt'">
					<td id="Tabelle_links">
						<table width="100%" border="0" height="50">
							<tr>
								<td id="Titel">Bef&#246;rderernummer</td>
							</tr>
							<tr>
								<td>
									<!-- BehoerdlicheNummer	-->
									<xsl:call-template name="getTextValue">
										<xsl:with-param name="TagName" select="'bgs:Befoerderer[@bgs:LfdNrBefoerderer=1]/bgs:BefoerdererNr/lib:BehoerdlicheNr'"/>
									</xsl:call-template>
									&#173;
									<xsl:call-template name="getTextValue">
										<xsl:with-param name="TagName" select="'bgs:Befoerderer[@bgs:LfdNrBefoerderer=1]/bgs:BefoerdererNr/lib:Pruefziffer'"/>
									</xsl:call-template>
								</td>
							</tr>
						</table>
						<table width="100%" border="0" height="50">
							<tr>
								<td id="Titel">Datum der &#220;bernahme</td>
							</tr>
							<tr>
								<td>
									<!-- Datum-->
									<xsl:call-template name="getDateValue">
										<xsl:with-param name="TagName" select="'bgs:Befoerderer[@bgs:LfdNrBefoerderer=1]/bgs:Uebernahmedatum'"/>
									</xsl:call-template>
								</td>
							</tr>
						</table>
					</td>
				</xsl:when>
				<xsl:otherwise>
					<td id="Tabelle_links">
						<table width="100%" border="0" height="50">
							<tr>
								<td id="Titel">Bef&#246;rderernummer</td>
							</tr>
							<tr>
								<td>
									<!-- BehoerdlicheNummer	-->
									<xsl:call-template name="getTextValue">
										<xsl:with-param name="TagName" select="'bgs:Befoerderer/bgs:BefoerdererNr/lib:BehoerdlicheNr'"/>
									</xsl:call-template>
									&#173;
									<xsl:call-template name="getTextValue">
										<xsl:with-param name="TagName" select="'bgs:Befoerderer/bgs:BefoerdererNr/lib:Pruefziffer'"/>
									</xsl:call-template>
								</td>
							</tr>
						</table>
						<table width="100%" border="0" height="50">
							<tr>
								<td id="Titel">Datum der &#220;bernahme</td>
							</tr>
							<tr>
								<td>
									<!-- Datum-->
									<xsl:call-template name="getDateValue">
										<xsl:with-param name="TagName" select="'bgs:Befoerderer/bgs:Uebernahmedatum'"/>
									</xsl:call-template>
								</td>
							</tr>
						</table>
					</td>
				</xsl:otherwise>
			</xsl:choose>
			<td id="Tabelle_links">
				<!-- Entsorger -->
				<table width="100%" border="0" height="50">
					<tr>
						<td id="Titel">Entsorgernummer</td>
					</tr>
					<tr>
						<td>
							<!-- BehoerdlicheNummer	-->
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'bgs:Entsorger/bgs:EntsorgerNr/lib:BehoerdlicheNr'"/>
							</xsl:call-template>
							&#173;
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'bgs:Entsorger/bgs:EntsorgerNr/lib:Pruefziffer'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
				<table width="100%" border="0" height="50">
					<tr>
						<td id="Titel">Datum der Annahme</td>
					</tr>
					<tr>
						<td>
							<!-- Datum-->
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'bgs:Entsorger/bgs:Annahmedatum'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
			</td>
		</table>
		<font id="noprint">
			<br/>
		</font>
	</xsl:template>
	<xsl:template name="ExzerptATBWeitere">
		<!-- fünfte Zeile im Dokument -->
		<table width="100%" border="0">
			<colgroup>
				<col width="33%"/>
				<col width="33%"/>
				<col width="33%"/>
			</colgroup>
			<div id="Ueberschrift3">
 			  Weitere an der Bef&#246;rderung beteiligte Firmen:
 			  </div>
			<tr>
				<!-- Befoerderer 2-->
				<td>
					<table width="100%" border="0" height="50">
						<tr>
							<td id="Titel">Bef&#246;rderernummer</td>
						</tr>
						<tr>
							<td>
								<!-- BehoerdlicheNummer	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Befoerderer[@bgs:LfdNrBefoerderer=2]/bgs:BefoerdererNr/lib:BehoerdlicheNr'"/>
								</xsl:call-template>
								&#173;
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Befoerderer[@bgs:LfdNrBefoerderer=2]/bgs:BefoerdererNr/lib:Pruefziffer'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table width="100%" border="0" height="50">
						<tr>
							<td id="Titel">Datum der &#220;bernahme</td>
						</tr>
						<tr>
							<td>
								<!-- Datum-->
								<xsl:call-template name="getDateValue">
									<xsl:with-param name="TagName" select="'bgs:Befoerderer[@bgs:LfdNrBefoerderer=2]/bgs:Uebernahmedatum'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<!-- Befoerderer 3-->
				<td id="Tabelle_links">
					<table width="100%" border="0" height="50">
						<tr>
							<td id="Titel">Bef&#246;rderernummer</td>
						</tr>
						<tr>
							<td>
								<!-- BehoerdlicheNummer	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Befoerderer[@bgs:LfdNrBefoerderer=3]/bgs:BefoerdererNr/lib:BehoerdlicheNr'"/>
								</xsl:call-template>
								&#173;
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Befoerderer[@bgs:LfdNrBefoerderer=3]/bgs:BefoerdererNr/lib:Pruefziffer'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table width="100%" border="0" height="50">
						<tr>
							<td id="Titel">Datum der &#220;bernahme</td>
						</tr>
						<tr>
							<td>
								<!-- Datum-->
								<xsl:call-template name="getDateValue">
									<xsl:with-param name="TagName" select="'bgs:Befoerderer[@bgs:LfdNrBefoerderer=3]/bgs:Uebernahmedatum'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<!-- Lager -->
				<td id="Tabelle_links">
					<table width="100%" border="0" height="50">
						<tr>
							<td id="Titel">Kurzfristige Lagerung / Umschlag</td>
						</tr>
						<tr>
							<td>
								<!-- BehoerdlicheNummer	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Lager/bgs:LagerNr/lib:BehoerdlicheNr'"/>
								</xsl:call-template>
								&#173;
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Lager/bgs:LagerNr/lib:Pruefziffer'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table width="100%" border="0" height="50">
						<tr>
							<td id="Titel">Datum der Annahme</td>
						</tr>
						<tr>
							<td>
								<!-- Datum-->
								<xsl:call-template name="getDateValue">
									<xsl:with-param name="TagName" select="'bgs:Lager/bgs:Uebernahmedatum'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table width="100%" border="0" height="70">
						<tr>
							<td id="Titel">Datum der Übergabe</td>
						</tr>
						<tr>
							<td>
								<!-- Datum-->
								<xsl:call-template name="getDateValue">
									<xsl:with-param name="TagName" select="'bgs:Lager/bgs:Uebergabedatum'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Uebernahmenr_Abfallschl">
		<p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p>
		<xsl:if test="boolean(descendant::bgs:UNSNummern)">
			<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
				<tr>
					<td>
						<font id="Nummer2">Übernahmescheinnummern:</font>
					</td>
				</tr>
				<tr>
					<td>
						<table width="20%">
							<xsl:for-each select="descendant::bgs:UNSNummern">
								<tr>
									<td id="Aktuell">
										<xsl:value-of select="lib:PaginierNr"/>
									&#173;
									<xsl:value-of select="lib:Pruefziffer"/>
									</td>
								</tr>
							</xsl:for-each>
						</table>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
