<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:dyn="http://exslt.org/dynamic"
 	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
 	xmlns:bgs="uri:BMU_Waste_Interface/BGS" 
 	xmlns:reg="uri:BMU_Waste_Interface/Reg" 
 	xmlns:msg="uri:BMU_Waste_Interface/Message" 
	xmlns:zks="uri:BMU_Waste_Interface/ZKS"
 	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
 	xmlns:xades="http://uri.etsi.org/01903/v1.3.2#"
 	xmlns:b64="xalan://de.itu.util.Base64" 
 	xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
 	xmlns:x509="xalan://de.itu.util.X509CertHelper" 
	xmlns:xalan="http://xml.apache.org/xalan"
 	extension-element-prefixes="dyn b64 crc32 x509 xalan xades" 
 	exclude-result-prefixes="dyn b64 crc32 x509 bgs ds lib xsl fo xalan">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:param name="positionsnummerCharge" select="1"/>
	<xsl:param name="positionsnummerUNS" select="1"/>
	<xsl:param name="selectUNS" select="1"/>
	<xsl:param name="nameXML"/>
	<xsl:param name="layerName" select="'ENSNErzLayer'"/>
	<xsl:param name="layerID" select="'ERZ-01-e6f6d730-0dbe-45b7-857c-0b7474c9ee07'"/>
	<xsl:template match="/">
	   <xsl:choose>
	       <xsl:when test="$positionsnummerCharge=-1">
               <xsl:call-template name="BGSOrgDokAll"/>
	       </xsl:when>
	       <xsl:otherwise>
               <xsl:call-template name="BGSOrgDok"/>
	       </xsl:otherwise>
	   </xsl:choose>
	</xsl:template>
	<xsl:template name="BGSOrgDok">
		<html>
			<head>
				<title>BGS/UNS</title>
				<!-- CSS - Datei   -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<xsl:for-each select="//reg:Charge">
					<xsl:if test="position()=$positionsnummerCharge">
						<!-- jetzt unterscheiden wir nach bgs und uns dokumenten -->
						<xsl:choose>
							<xsl:when test="$positionsnummerUNS = 0">
                                <!--xsl:for-each select="descendant::*[(contains(local-name(), 'BGSDokument'))]">
                                    <xsl:if test="position()=$positionsnummerUNS"-->
                                        <xsl:for-each select="descendant::*[((starts-with(local-name(), 'BGS') or starts-with(local-name(), 'UNS')) and contains(local-name(), 'Layer'))]">
                                            <xsl:if test="position()=$positionsnummer">
                                                <table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
                                                    <tr>
                                                        <th>
                                                            <xsl:call-template name="BGSUNSNummer"/>
                                                            <xsl:call-template name="BGSUNSAbfall"/>
                                                            <xsl:call-template name="BGSUNSMengen"/>
                                                            <xsl:call-template name="BGSUNSAtb"/>
                                                            <xsl:call-template name="BGSUNSVermerke"/>
                                                            <xsl:if test="boolean(ancestor::bgs:BGSDokument)">
	                                                            <xsl:call-template name="BGSUNSWeitereAtb"/>
                                                            </xsl:if>
                                                        </th>
                                                    </tr>
                                                </table>
                                                <xsl:if test="boolean(ancestor::bgs:BGSDokument/bgs:Dateianhang)">
                                                    <xsl:call-template name="Anhang"/>
                                                </xsl:if>
                                                <xsl:if test="descendant::bgs:Daten/bgs:UNSNummer or descendant::bgs:WeitereAbfallschluessel">
                                                    <xsl:call-template name="Uebernahmenr_Abfallschl"/>
                                                </xsl:if>
                                                <xsl:if test="boolean(bgs:AndereVerordnungen)">
                                                    <xsl:call-template name="AndereVerordnungen"/>
                                                </xsl:if>
                                                <xsl:choose>
                                                    <xsl:when test="not(boolean(bgs:Fehlerprotokoll))">
                                                        <table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
                                                            <tr>
                                                                <td>
                                                                    <font id="Nummer">
                                                                        In dieser Sicht ist kein Fehlerprotokoll vorhanden.
                                                                    </font>
                                                                    <br/>
                                                                    <font id="Nummer2">
                                                                        Ein Fehlerprotokoll befindet sich in der Sicht:
                                                                    </font>
                                                                    <font id="FormPosition">
                                                                        <xsl:call-template name="Fehler_Position">
                                                                            </xsl:call-template>
                                                                    </font>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <xsl:call-template name="FehlerProtBGS">
                                                            </xsl:call-template>
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                                <xsl:call-template name="showSigLayerRAuszug">
                                                    <!--xsl:with-param name="Praefix" select="'BGS'"/-->
                                                </xsl:call-template>
                                            </xsl:if>
                                        </xsl:for-each>
                                    <!--/xsl:if>
                                </xsl:for-each-->
							</xsl:when>
							<xsl:otherwise>
                                <!--xsl:for-each select="descendant::*[(contains(local-name(), 'UNSDokument'))]"-->
                                <xsl:choose>
                                    <xsl:when test="reg:BGSmitUNS">
                                        <xsl:for-each select="reg:BGSmitUNS/reg:UNS">
                                            <xsl:if test="position()=$positionsnummerUNS">
                                                <xsl:for-each select="descendant::*[((starts-with(local-name(), 'UNS'))) and (contains(local-name(), 'Layer'))]">
                                                    <xsl:if test="position()=$positionsnummer">
                                                        <table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
                                                            <tr>
                                                                <th>
                                                                    <xsl:call-template name="BGSUNSNummer"/>
                                                                    <xsl:call-template name="BGSUNSAbfall"/>
                                                                    <xsl:call-template name="BGSUNSMengen"/>
                                                                    <xsl:call-template name="BGSUNSAtb"/>
                                                                    <xsl:call-template name="BGSUNSVermerke"/>
                                                                    <!--xsl:call-template name="BGSUNSWeitereAtb"/-->
                                                                </th>
                                                            </tr>
                                                        </table>
                                                        <xsl:if test="boolean(ancestor::bgs:BGSDokument/bgs:Dateianhang)">
                                                            <xsl:call-template name="Anhang"/>
                                                        </xsl:if>
                                                        <xsl:if test="descendant::bgs:Daten/bgs:UNSNummer or descendant::bgs:WeitereAbfallschluessel">
                                                            <xsl:call-template name="Uebernahmenr_Abfallschl"/>
                                                        </xsl:if>
                                                        <xsl:if test="boolean(bgs:AndereVerordnungen)">
                                                            <xsl:call-template name="AndereVerordnungen"/>
                                                        </xsl:if>
                                                        <xsl:call-template name="showSigLayerRAuszug">
                                                            <!--xsl:with-param name="Praefix" select="'UNS'"/-->
                                                        </xsl:call-template>
                                                    </xsl:if>
                                                </xsl:for-each>
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:for-each select="descendant::*[((starts-with(local-name(), 'UNS'))) and (contains(local-name(), 'Layer'))]">
                                            <xsl:if test="position()=$positionsnummer">
                                                <table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
                                                    <tr>
                                                        <th>
                                                            <xsl:call-template name="BGSUNSNummer"/>
                                                            <xsl:call-template name="BGSUNSAbfall"/>
                                                            <xsl:call-template name="BGSUNSMengen"/>
                                                            <xsl:call-template name="BGSUNSAtb"/>
                                                            <xsl:call-template name="BGSUNSVermerke"/>
                                                            <!--xsl:call-template name="BGSUNSWeitereAtb"/-->
                                                        </th>
                                                    </tr>
                                                </table>
                                                <xsl:if test="boolean(ancestor::bgs:BGSDokument/bgs:Dateianhang)">
                                                    <xsl:call-template name="Anhang"/>
                                                </xsl:if>
                                                <xsl:if test="descendant::bgs:Daten/bgs:UNSNummer or descendant::bgs:WeitereAbfallschluessel">
                                                    <xsl:call-template name="Uebernahmenr_Abfallschl"/>
                                                </xsl:if>
                                                <xsl:if test="boolean(bgs:AndereVerordnungen)">
                                                    <xsl:call-template name="AndereVerordnungen"/>
                                                </xsl:if>
                                                <xsl:call-template name="showSigLayerRAuszug">
                                                    <!--xsl:with-param name="Praefix" select="'UNS'"/-->
                                                </xsl:call-template>
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:otherwise>
                                </xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
				</xsl:for-each>
			</body>
		</html>
	</xsl:template>

    <xsl:template name="BGSOrgDokAll">
        <html>
            <head>
                <title>BGS/UNS</title>
                <!-- CSS - Datei   -->
                <xsl:call-template name="Style"/>
            </head>
            <body>
                <xsl:call-template name="Kopf"/>
                <xsl:for-each select="//reg:Charge">
                    <!-- jetzt unterscheiden wir nach bgs und uns dokumenten -->
                    <xsl:choose>
                        <xsl:when test="reg:BGSmitUNS">
                            <xsl:for-each select="reg:BGSmitUNS/reg:BGS">
                                <xsl:for-each select="descendant::*[((starts-with(local-name(), 'BGS'))) and (contains(local-name(), 'Layer'))]">
                                    <xsl:if test="position()=$positionsnummer">
                                        <table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
                                            <tr>
                                                <th>
                                                    <xsl:call-template name="BGSUNSNummer"/>
                                                    <xsl:call-template name="BGSUNSAbfall"/>
                                                    <xsl:call-template name="BGSUNSMengen"/>
                                                    <xsl:call-template name="BGSUNSAtb"/>
                                                    <xsl:call-template name="BGSUNSVermerke"/>
                                                    <!--xsl:call-template name="BGSUNSWeitereAtb"/-->
                                                </th>
                                            </tr>
                                        </table>
                                        <xsl:if test="boolean(ancestor::bgs:BGSDokument/bgs:Dateianhang)">
                                            <xsl:call-template name="Anhang"/>
                                        </xsl:if>
                                        <xsl:if test="descendant::bgs:Daten/bgs:UNSNummer or descendant::bgs:WeitereAbfallschluessel">
                                            <xsl:call-template name="Uebernahmenr_Abfallschl"/>
                                        </xsl:if>
                                        <xsl:if test="boolean(bgs:AndereVerordnungen)">
                                            <xsl:call-template name="AndereVerordnungen"/>
                                        </xsl:if>
                                        <xsl:call-template name="showSigLayerRAuszug">
                                            <!--xsl:with-param name="Praefix" select="'UNS'"/-->
                                        </xsl:call-template>
                                        <br></br>
                                    </xsl:if>
                                </xsl:for-each>
                            </xsl:for-each>
                            <xsl:for-each select="reg:BGSmitUNS/reg:UNS">
                                <xsl:for-each select="descendant::*[((starts-with(local-name(), 'UNS'))) and (contains(local-name(), 'Layer'))]">
                                    <xsl:if test="position()=$positionsnummer">
                                        <table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
                                            <tr>
                                                <th>
                                                    <xsl:call-template name="BGSUNSNummer"/>
                                                    <xsl:call-template name="BGSUNSAbfall"/>
                                                    <xsl:call-template name="BGSUNSMengen"/>
                                                    <xsl:call-template name="BGSUNSAtb"/>
                                                    <xsl:call-template name="BGSUNSVermerke"/>
                                                    <!--xsl:call-template name="BGSUNSWeitereAtb"/-->
                                                </th>
                                            </tr>
                                        </table>
                                        <xsl:if test="boolean(ancestor::bgs:BGSDokument/bgs:Dateianhang)">
                                            <xsl:call-template name="Anhang"/>
                                        </xsl:if>
                                        <xsl:if test="descendant::bgs:Daten/bgs:UNSNummer or descendant::bgs:WeitereAbfallschluessel">
                                            <xsl:call-template name="Uebernahmenr_Abfallschl"/>
                                        </xsl:if>
                                        <xsl:if test="boolean(bgs:AndereVerordnungen)">
                                            <xsl:call-template name="AndereVerordnungen"/>
                                        </xsl:if>
                                        <xsl:call-template name="showSigLayerRAuszug">
                                            <!--xsl:with-param name="Praefix" select="'UNS'"/-->
                                        </xsl:call-template>
                                        <br></br>
                                    </xsl:if>
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:for-each select="descendant::*[((starts-with(local-name(), 'BGS') or starts-with(local-name(), 'UNS')) and contains(local-name(), 'Layer'))]">
                                <xsl:if test="position()=$positionsnummer">
                                    <table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
                                        <tr>
                                            <th>
                                                <xsl:call-template name="BGSUNSNummer"/>
                                                <xsl:call-template name="BGSUNSAbfall"/>
                                                <xsl:call-template name="BGSUNSMengen"/>
                                                <xsl:call-template name="BGSUNSAtb"/>
                                                <xsl:call-template name="BGSUNSVermerke"/>
                                                <!--xsl:call-template name="BGSUNSWeitereAtb"/-->
                                            </th>
                                        </tr>
                                    </table>
                                    <xsl:if test="boolean(ancestor::bgs:BGSDokument/bgs:Dateianhang)">
                                        <xsl:call-template name="Anhang"/>
                                    </xsl:if>
                                    <xsl:if test="descendant::bgs:Daten/bgs:UNSNummer or descendant::bgs:WeitereAbfallschluessel">
                                        <xsl:call-template name="Uebernahmenr_Abfallschl"/>
                                    </xsl:if>
                                    <xsl:if test="boolean(bgs:AndereVerordnungen)">
                                        <xsl:call-template name="AndereVerordnungen"/>
                                    </xsl:if>
                                    <xsl:call-template name="showSigLayerRAuszug">
                                        <!--xsl:with-param name="Praefix" select="'UNS'"/-->
                                    </xsl:call-template>
                                    <br></br>
                                </xsl:if>
                            </xsl:for-each>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </body>
        </html>
    </xsl:template>

	<xsl:template name="BGSUNSNummer">
		<!-- erste Zeile im Dokument -->
		<table width="100%" border="0">
			<colgroup>
				<col width="60%"/>
				<col width="10%"/>
				<col width="30%"/>
			</colgroup>
			<tr>
				<td>
					<table width="100%" border="0">
						<tr id="Nummer">
							<td>
								<xsl:choose>
									<xsl:when test="boolean(ancestor::bgs:BGSDokument)">
										Begleitschein 
									</xsl:when>
									<xsl:when test="boolean(ancestor::bgs:UNSDokument)">
										&#220;bernahmeschein
									</xsl:when>
								</xsl:choose>
								<font id="Ueberschrift2">
									(<xsl:value-of select="concat(local-name(),': ',@lib:LayerID)"/>)								
								</font>
							</td>
						</tr>
						<tr id="Ueberschrift2">
							<td>Beleg zum Nachweis der Entsorgung von Abf&#228;llen 
							</td>
						</tr>
					</table>
				</td>
				<td> </td>
				<td id="Nummer"> 
					Nr: 
					 <xsl:choose>
						<xsl:when test="boolean(ancestor::bgs:BGSDokument)">
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'bgs:BGSNummer/lib:PaginierNr'"/>
								<xsl:with-param name="first" select="true()"/>
							</xsl:call-template>
							&#173;
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'bgs:BGSNummer/lib:Pruefziffer'"/>
								<xsl:with-param name="first" select="true()"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="boolean(ancestor::bgs:UNSDokument)">
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'bgs:UNSNummer/lib:PaginierNr'"/>
								<xsl:with-param name="first" select="true()"/>
							</xsl:call-template>
							&#173;
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'bgs:UNSNummer/lib:Pruefziffer'"/>
								<xsl:with-param name="first" select="true()"/>
							</xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</td>
			</tr>
		</table>
		<font id="noprint">
			<br/>
		</font>
	</xsl:template>
	<xsl:template name="BGSUNSAbfall">
		<!-- erste Zeile im Dokument -->
		<table width="100%" border="0">
			<tr>
				<td id="Titel"> Abfallbezeichnung </td>
			</tr>
			<tr>
				<td>
					<!-- Abfallbezeichnung -->
					<xsl:call-template name="getTextValue">
						<xsl:with-param name="TagName" select="'bgs:Daten/bgs:Abfallbezeichnung'"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
		<font id="noprint">
			<br/>
		</font>
	</xsl:template>
	<xsl:template name="BGSUNSMengen">
		<!-- zweite Zeile im Dokument -->
		<table width="100%" border="0">
			<colgroup>
				<col width="33%"/>
				<col width="33%"/>
				<col width="13%"/>
				<col width="20%"/>
			</colgroup>
			<tr>
				<td id="Titel">Abfallschl&#252;ssel</td>
				<td id="Titel">Entsorgungsnachweis-Nummer</td>
				<td id="Titel">Menge in t</td>
				<td id="Titel">Volumen in cbm</td>
			</tr>
			<tr>
				<td>
					<!-- Abfallschluessel -->
					<xsl:call-template name="getTextValue">
						<xsl:with-param name="TagName" select="'bgs:Daten/bgs:Abfallschluessel'"/>
					</xsl:call-template>
				</td>
				<td>
					<!-- NachweisNr -->
					<xsl:call-template name="getTextValue">
						<xsl:with-param name="TagName" select="'bgs:Daten/bgs:Nachweisnummer/lib:NachweisNr'"/>
					</xsl:call-template>
					&#173;
					<!-- Pruefziffer -->
					<xsl:call-template name="getTextValue">
						<xsl:with-param name="TagName" select="'bgs:Daten/bgs:Nachweisnummer/lib:Pruefziffer'"/>
					</xsl:call-template>
				</td>
				<td>
					<!--Menge  	-->
					<xsl:call-template name="getDoubleValue">
						<xsl:with-param name="TagName" select="'bgs:Daten/bgs:Menge'"/>
					</xsl:call-template>
					&#173;
					<xsl:call-template name="getTextValue">
						<xsl:with-param name="TagName" select="'bgs:Daten/bgs:Menge'"/>
						<xsl:with-param name="TagAttr" select="'@lib:Einheit'"/>
					</xsl:call-template>
				</td>
				<td>
					<!-- Volumen  	-->
					<xsl:call-template name="getTextValue">
						<xsl:with-param name="TagName" select="'bgs:Daten/bgs:Volumen'"/>
					</xsl:call-template>
					&#173;
					<xsl:call-template name="getTextValue">
						<xsl:with-param name="TagName" select="'bgs:Daten/bgs:Volumen'"/>
						<xsl:with-param name="TagAttr" select="'@lib:Einheit'"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
		<font id="noprint">
			<br/>
		</font>
	</xsl:template>
	<xsl:template name="BGSUNSAtb">
		<!-- dritte Zeile im Dokument -->
		<table width="100%" border="0">
			<colgroup>
				<col width="33%"/>
				<col width="33%"/>
				<col width="33%"/>
			</colgroup>
			<td>
				<!-- Erzeuger -->
				<table width="100%" border="0" height="50">
					<tr>
						<td id="Titel">Erzeugernummer</td>
					</tr>
					<tr>
						<td>
							<!-- BehoerdlicheNummer	-->
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Erzeuger/bgs:Nummer/lib:BehoerdlicheNr'"/>
							</xsl:call-template>
							&#173;
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Erzeuger/bgs:Nummer/lib:Pruefziffer'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
				<table width="100%" border="0" height="50">
					<tr>
						<td id="Titel">Datum der &#220;bergabe</td>
					</tr>
					<tr>
						<td>
							<!-- Datum-->
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Erzeuger/bgs:Datum'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
				<table width="100%" border="0" height="70">
					<tr>
						<td id="Titel"/>
					</tr>
					<tr>
						<td/>
					</tr>
				</table>
				<table width="100%" border="0" height="130">
					<tr>
						<td id="Titel">Firmenname, Anschrift</td>
					</tr>
					<tr>
						<td>
							<table width="100%" border="0" height="130" id="Tabelle" cellspacing="1" cellpadding="1">
								<tr>
									<td>
										<!--  Namen	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Erzeuger/bgs:NameUndAdresse/lib:Name/lib:Name1'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Erzeuger/bgs:NameUndAdresse/lib:Name/lib:Name2'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Erzeuger/bgs:NameUndAdresse/lib:Name/lib:Name3'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Erzeuger/bgs:NameUndAdresse/lib:Name/lib:Name4'"/>
										</xsl:call-template>
										<br/>
										<!--  Strassen	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Erzeuger/bgs:NameUndAdresse/lib:Adresse/lib:Strasse_1'"/>
										</xsl:call-template>
								 		&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Erzeuger/bgs:NameUndAdresse/lib:Adresse/lib:Strasse_2'"/>
										</xsl:call-template>
								 		&#173;
										<!-- Hausnummer	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Erzeuger/bgs:NameUndAdresse/lib:Adresse/lib:Hausnummer'"/>
										</xsl:call-template>
										<br/>
										<!-- Postleitzahl	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Erzeuger/bgs:NameUndAdresse/lib:Adresse/lib:Postleitzahl'"/>
										</xsl:call-template>
										&#173;
										<!-- Orte	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Erzeuger/bgs:NameUndAdresse/lib:Adresse/lib:Ort_1'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Erzeuger/bgs:NameUndAdresse/lib:Adresse/lib:Ort_2'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
				<table width="100%" border="0" height="25">
					<tr>
						<td id="Titel">Unterschrift / Signatur</td>
					</tr>
					<tr>
						<td>
							<table width="100%" border="0" height="25" id="Tabelle" cellspacing="1" cellpadding="1">
								<tr>
									<td>
										<!-- Erzeuger Unterschrift	-->
										<xsl:call-template name="getUnterschrift">
											<xsl:with-param name="LayerName" select="'BGSERZLayer'"/>
											<xsl:with-param name="AtbRolle" select="'ERZ'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
				<xsl:choose>
					<xsl:when test="boolean(descendant::bgs:Daten/bgs:ATBListe/bgs:Erzeuger/bgs:IndicatorQuittungsbeleg)">
						<table width="100%" border="0" height="25">
							<tr>
								<td id="Titel" width="60%">Quittungsbeleg wurde verwendet:</td>
								<td id="Titel" width="30%">Unterschrieben</td>
								<td width="10%">
									<table id="Tabelle_indikator">
										<tr>
											<td>
												<xsl:call-template name="getBooleanValue">
													<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Erzeuger/bgs:IndicatorQuittungsbeleg'"/>
												</xsl:call-template>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</xsl:when>
					<xsl:otherwise>
						<table width="100%" border="0" height="25">
							<tr>
								<td id="Titel" width="100%">Quittungsbeleg wurde nicht verwendet</td>
							</tr>
						</table>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:if test="boolean(descendant::bgs:Daten/bgs:ATBListe/bgs:Entsorger/bgs:QBelVersicherung)">
					<table width="100%" border="0" height="25">
						<tr>
							<td id="Titel" width="100%"></td>
						</tr>
					</table>
				</xsl:if>
				<xsl:if test="boolean(descendant::bgs:Daten/bgs:ATBListe/bgs:Entsorger/bgs:IndicatorAnnahmeVerweigert)">
					<table width="100%" border="0" height="25">
						<tr>
							<td id="Titel" width="100%"></td>
						</tr>
					</table>
				</xsl:if>
			</td>
			<!-- Befoerderer 1-->
			<td id="Tabelle_links">
				<table width="100%" border="0" height="50">
					<tr>
						<td id="Titel">Bef&#246;rderernummer</td>
					</tr>
					<tr>
						<td>
							<!-- BehoerdlicheNummer	-->
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=1]/bgs:Nummer/lib:BehoerdlicheNr'"/>
							</xsl:call-template>
							&#173;
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=1]/bgs:Nummer/lib:Pruefziffer'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
				<table width="100%" border="0" height="50">
					<tr>
						<td id="Titel">Datum der &#220;bernahme</td>
					</tr>
					<tr>
						<td>
							<!-- Datum	-->
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=1]/bgs:Datum'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
				<table width="100%" border="0" height="70">
					<tr>
						<td id="Titel">Kfz-Kennzeichen</td>
					</tr>
					<tr>
						<td>
							<!-- Befoerderer 1  Kennzeichen Zugmaschine -->
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=1]/bgs:KfzKennzeichen/bgs:Zugmaschine'"/>
							</xsl:call-template>
							&#173;
							<!-- Befoerderer 1  Anhänger-Auflieger -->
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=1]/bgs:KfzKennzeichen/bgs:AnhaengerAuflieger'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
				<table width="100%" border="0" height="130">
					<tr>
						<td id="Titel">Firmenname, Anschrift</td>
					</tr>
					<tr>
						<td>
							<table width="100%" border="0" height="130" id="Tabelle" cellspacing="1" cellpadding="1">
								<tr>
									<td>
										<!--  Namen	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=1]/bgs:NameUndAdresse/lib:Name/lib:Name1'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=1]/bgs:NameUndAdresse/lib:Name/lib:Name2'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=1]/bgs:NameUndAdresse/lib:Name/lib:Name3'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=1]/bgs:NameUndAdresse/lib:Name/lib:Name4'"/>
										</xsl:call-template>
										<br/>
										<!--  Strassen	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=1]/bgs:NameUndAdresse/lib:Adresse/lib:Strasse_1'"/>
										</xsl:call-template>
								 		&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=1]/bgs:NameUndAdresse/lib:Adresse/lib:Strasse_2'"/>
										</xsl:call-template>
								 		&#173;
										<!-- Hausnummer	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=1]/bgs:NameUndAdresse/lib:Adresse/lib:Hausnummer'"/>
										</xsl:call-template>
										<br/>
										<!-- Postleitzahl	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=1]/bgs:NameUndAdresse/lib:Adresse/lib:Postleitzahl'"/>
										</xsl:call-template>
										&#173;
										<!-- Orte	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=1]/bgs:NameUndAdresse/lib:Adresse/lib:Ort_1'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=1]/bgs:NameUndAdresse/lib:Adresse/lib:Ort_2'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
				<table width="100%" border="0" height="25">
					<tr>
						<td id="Titel">Unterschrift / Signatur</td>
					</tr>
					<tr>
						<td>
							<table width="100%" border="0" height="25" id="Tabelle" cellspacing="1" cellpadding="1">
								<tr>
									<td>
										<!-- Befoerderer 1  Unterschrift	-->
										<xsl:call-template name="getUnterschrift">
											<xsl:with-param name="LayerName" select="'BGSBEFLayer'"/>
											<xsl:with-param name="AtbRolle" select="'BEF'"/>
											<xsl:with-param name="BefLfdNr" select="1"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
				<xsl:choose>
					<xsl:when test="boolean(descendant::bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=1]/bgs:IndicatorQuittungsbeleg)">
						<table width="100%" border="0" height="25">
							<tr>
								<td id="Titel" width="60%">Quittungsbeleg wurde verwendet:</td>
								<td id="Titel" width="30%">Unterschrieben</td>
								<td width="10%">
									<table id="Tabelle_indikator">
										<tr>
											<td>
												<xsl:call-template name="getBooleanValue">
													<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=1]/bgs:IndicatorQuittungsbeleg'"/>
												</xsl:call-template>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</xsl:when>
					<xsl:otherwise>
						<table width="100%" border="0" height="25">
							<tr>
								<td id="Titel" width="100%">Quittungsbeleg wurde nicht verwendet</td>
							</tr>
						</table>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:if test="boolean(descendant::bgs:Daten/bgs:ATBListe/bgs:Entsorger/bgs:QBelVersicherung)">
					<table width="100%" border="0" height="25">
						<tr>
							<td id="Titel" width="100%"></td>
						</tr>
					</table>
				</xsl:if>
				<xsl:if test="boolean(descendant::bgs:Daten/bgs:ATBListe/bgs:Entsorger/bgs:IndicatorAnnahmeVerweigert)">
					<table width="100%" border="0" height="25">
						<tr>
							<td id="Titel" width="100%"></td>
						</tr>
					</table>
				</xsl:if>
			</td>
			<td id="Tabelle_links">
				<!-- Entsorger -->
				<table width="100%" border="0" height="50">
					<tr>
						<td id="Titel">Entsorgernummer</td>
					</tr>
					<tr>
						<td>
							<!-- BehoerdlicheNummer	-->
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Entsorger/bgs:Nummer/lib:BehoerdlicheNr'"/>
							</xsl:call-template>
							&#173;
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Entsorger/bgs:Nummer/lib:Pruefziffer'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
				<table width="100%" border="0" height="50">
					<tr>
						<td id="Titel">Datum der Annahme</td>
					</tr>
					<tr>
						<td>
							<!-- Datum-->
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Entsorger/bgs:Datum'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
				<table width="100%" border="0" height="70">
					<tr>
						<td id="Titel"/>
					</tr>
					<tr>
						<td/>
					</tr>
				</table>
				<table width="100%" border="0" height="130">
					<tr>
						<td id="Titel">Firmenname, Anschrift</td>
					</tr>
					<tr>
						<td>
							<table width="100%" border="0" height="130" id="Tabelle" cellspacing="1" cellpadding="1">
								<tr>
									<td>
										<!--  Namen	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Entsorger/bgs:NameUndAdresse/lib:Name/lib:Name1'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Entsorger/bgs:NameUndAdresse/lib:Name/lib:Name2'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Entsorger/bgs:NameUndAdresse/lib:Name/lib:Name3'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Entsorger/bgs:NameUndAdresse/lib:Name/lib:Name4'"/>
										</xsl:call-template>
										<br/>
										<!--  Strassen	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Entsorger/bgs:NameUndAdresse/lib:Adresse/lib:Strasse_1'"/>
										</xsl:call-template>
								 		&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Entsorger/bgs:NameUndAdresse/lib:Adresse/lib:Strasse_2'"/>
										</xsl:call-template>
								 		&#173;
										<!-- Hausnummer	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Entsorger/bgs:NameUndAdresse/lib:Adresse/lib:Hausnummer'"/>
										</xsl:call-template>
										<br/>
										<!-- Postleitzahl	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Entsorger/bgs:NameUndAdresse/lib:Adresse/lib:Postleitzahl'"/>
										</xsl:call-template>
										&#173;
										<!-- Orte	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Entsorger/bgs:NameUndAdresse/lib:Adresse/lib:Ort_1'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Entsorger/bgs:NameUndAdresse/lib:Adresse/lib:Ort_2'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
				<table width="100%" border="0" height="25">
					<tr>
						<td id="Titel">Unterschrift / Signatur</td>
					</tr>
					<tr>
						<td>
							<table width="100%" border="0" height="25" id="Tabelle" cellspacing="1" cellpadding="1">
								<tr>
									<td>
										<!-- Entsorger Unterschrift	-->
										<xsl:call-template name="getUnterschrift">
											<xsl:with-param name="LayerName" select="'BGSENTLayer'"/>
											<xsl:with-param name="AtbRolle" select="'ENT'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
				<xsl:choose>
					<xsl:when test="boolean(descendant::bgs:Daten/bgs:ATBListe/bgs:Entsorger/bgs:IndicatorQuittungsbeleg)">
						<table width="100%" border="0" height="25">
							<tr>
								<td id="Titel" width="60%">Quittungsbeleg wurde verwendet:</td>
								<td id="Titel" width="30%">Unterschrieben</td>
								<td width="10%">
									<table id="Tabelle_indikator">
										<tr>
											<td>
												<xsl:call-template name="getBooleanValue">
													<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Entsorger/bgs:IndicatorQuittungsbeleg'"/>
												</xsl:call-template>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</xsl:when>
					<xsl:otherwise>
						<table width="100%" border="0" height="25">
							<tr>
								<td id="Titel" width="100%">Quittungsbeleg wurde nicht verwendet</td>
							</tr>
						</table>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:if test="boolean(descendant::bgs:Daten/bgs:ATBListe/bgs:Entsorger/bgs:QBelVersicherung)">
					<table width="100%" border="0" height="25">
						<tr>
							<td id="Titel" width="100%">Der Erzeuger und/oder der Beförderer haben nur auf einem Quittungsbeleg unterschrieben.</td>
						</tr>
					</table>
				</xsl:if>
				<xsl:if test="boolean(descendant::bgs:Daten/bgs:ATBListe/bgs:Entsorger/bgs:IndicatorAnnahmeVerweigert)">
					<table width="100%" border="0" height="25">
						<tr>
							<td id="Titel" width="60%">Die Annahme wurde verweigert:</td>
							<td width="40%">
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Entsorger/bgs:IndicatorAnnahmeVerweigert'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</xsl:if>
			</td>
		</table>
		<font id="noprint">
			<br/>
		</font>
	</xsl:template>
	<xsl:template name="BGSUNSVermerke">
		<!-- vierte Zeile im Dokument -->
		<table width="100%" border="0">
			<tr>
				<td id="Titel"> Frei für Vermerke </td>
			</tr>
			<tr>
				<td>
					<table width="100%" id="Tabelle" cellspacing="1" cellpadding="1">
						<tr>
							<td>
								<!--Vermerke 	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:Vermerke'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="BGSUNSWeitereAtb">
		<!-- fünfte Zeile im Dokument -->
		<table width="100%" border="0">
			<colgroup>
				<col width="33%"/>
				<col width="33%"/>
				<col width="33%"/>
			</colgroup>
			<div id="Ueberschrift3">
 			  Weitere an der Bef&#246;rderung beteiligte Firmen:
 			  </div>
			<tr>
				<!-- Befoerderer 2-->
				<td>
					<table width="100%" border="0" height="50">
						<tr>
							<td id="Titel">Bef&#246;rderernummer</td>
						</tr>
						<tr>
							<td>
								<!-- BehoerdlicheNummer	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=2]/bgs:Nummer/lib:BehoerdlicheNr'"/>
								</xsl:call-template>
								&#173;
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=2]/bgs:Nummer/lib:Pruefziffer'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table width="100%" border="0" height="50">
						<tr>
							<td id="Titel">Datum der &#220;bernahme</td>
						</tr>
						<tr>
							<td>
								<!-- Datum	-->
								<xsl:call-template name="getDateValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=2]/bgs:Datum'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table width="100%" border="0" height="70">
						<tr>
							<td id="Titel">Kfz-Kennzeichen</td>
						</tr>
						<tr>
							<td>
								<!-- Befoerderer 1  Kennzeichen Zugmaschine -->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=2]/bgs:KfzKennzeichen/bgs:Zugmaschine'"/>
								</xsl:call-template>
								&#173;
								<!-- Befoerderer 1  Anhänger-Auflieger -->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=2]/bgs:KfzKennzeichen/bgs:AnhaengerAuflieger'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table width="100%" border="0" height="130">
						<tr>
							<td id="Titel">Firmenname, Anschrift</td>
						</tr>
						<tr>
							<td>
								<table width="100%" border="0" height="130" id="Tabelle" cellspacing="1" cellpadding="1">
									<tr>
										<td>
											<!--  Namen	-->
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=2]/bgs:NameUndAdresse/lib:Name/lib:Name1'"/>
											</xsl:call-template>
											&#173;
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=2]/bgs:NameUndAdresse/lib:Name/lib:Name2'"/>
											</xsl:call-template>
											&#173;
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=2]/bgs:NameUndAdresse/lib:Name/lib:Name3'"/>
											</xsl:call-template>
											&#173;
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=2]/bgs:NameUndAdresse/lib:Name/lib:Name4'"/>
											</xsl:call-template>
											<br/>
											<!--  Strassen	-->
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=2]/bgs:NameUndAdresse/lib:Adresse/lib:Strasse_1'"/>
											</xsl:call-template>
									 		&#173;
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=2]/bgs:NameUndAdresse/lib:Adresse/lib:Strasse_2'"/>
											</xsl:call-template>
									 		&#173;
											<!-- Hausnummer	-->
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=2]/bgs:NameUndAdresse/lib:Adresse/lib:Hausnummer'"/>
											</xsl:call-template>
											<br/>
											<!-- Postleitzahl	-->
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=2]/bgs:NameUndAdresse/lib:Adresse/lib:Postleitzahl'"/>
											</xsl:call-template>
											&#173;
											<!-- Orte	-->
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=2]/bgs:NameUndAdresse/lib:Adresse/lib:Ort_1'"/>
											</xsl:call-template>
											&#173;
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=2]/bgs:NameUndAdresse/lib:Adresse/lib:Ort_2'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<table width="100%" border="0" height="25">
						<tr>
							<td id="Titel">Unterschrift / Signatur</td>
						</tr>
						<tr>
							<td>
								<table width="100%" border="0" height="25" id="Tabelle" cellspacing="1" cellpadding="1">
									<tr>
										<td>
											<!-- Befoerderer 2  Unterschrift	-->
											<xsl:call-template name="getUnterschrift">
												<xsl:with-param name="LayerName" select="'BGSBEFLayer'"/>
												<xsl:with-param name="AtbRolle" select="'BEF'"/>
												<xsl:with-param name="BefLfdNr" select="2"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<xsl:choose>
						<xsl:when test="boolean(descendant::bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=2]/bgs:IndicatorQuittungsbeleg)">
							<table width="100%" border="0" height="25">
								<tr>
									<td id="Titel" width="60%">Quittungsbeleg wurde verwendet:</td>
									<td id="Titel" width="30%">Unterschrieben</td>
									<td width="10%">
										<table id="Tabelle_indikator">
											<tr>
												<td>
													<xsl:call-template name="getBooleanValue">
														<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=2]/bgs:IndicatorQuittungsbeleg'"/>
													</xsl:call-template>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</xsl:when>
						<xsl:otherwise>
							<table width="100%" border="0" height="25">
								<tr>
									<td id="Titel" width="100%">Quittungsbeleg wurde nicht verwendet</td>
								</tr>
							</table>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<!-- Befoerderer 3-->
				<td id="Tabelle_links">
					<table width="100%" border="0" height="50">
						<tr>
							<td id="Titel">Bef&#246;rderernummer</td>
						</tr>
						<tr>
							<td>
								<!-- BehoerdlicheNummer	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=3]/bgs:Nummer/lib:BehoerdlicheNr'"/>
								</xsl:call-template>
								&#173;
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=3]/bgs:Nummer/lib:Pruefziffer'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table width="100%" border="0" height="50">
						<tr>
							<td id="Titel">Datum der &#220;bernahme</td>
						</tr>
						<tr>
							<td>
								<!-- Datum	-->
								<xsl:call-template name="getDateValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=3]/bgs:Datum'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table width="100%" border="0" height="70">
						<tr>
							<td id="Titel">Kfz-Kennzeichen</td>
						</tr>
						<tr>
							<td>
								<!-- Befoerderer 1  Kennzeichen Zugmaschine -->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=3]/bgs:KfzKennzeichen/bgs:Zugmaschine'"/>
								</xsl:call-template>
								&#173;
								<!-- Befoerderer 1  Anhänger-Auflieger -->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=3]/bgs:KfzKennzeichen/bgs:AnhaengerAuflieger'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table width="100%" border="0" height="130">
						<tr>
							<td id="Titel">Firmenname, Anschrift</td>
						</tr>
						<tr>
							<td>
								<table width="100%" border="0" height="130" id="Tabelle" cellspacing="1" cellpadding="1">
									<tr>
										<td>
											<!--  Namen	-->
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=3]/bgs:NameUndAdresse/lib:Name/lib:Name1'"/>
											</xsl:call-template>
											&#173;
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=3]/bgs:NameUndAdresse/lib:Name/lib:Name2'"/>
											</xsl:call-template>
											&#173;
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=3]/bgs:NameUndAdresse/lib:Name/lib:Name3'"/>
											</xsl:call-template>
											&#173;
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=3]/bgs:NameUndAdresse/lib:Name/lib:Name4'"/>
											</xsl:call-template>
											<br/>
											<!--  Strassen	-->
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=3]/bgs:NameUndAdresse/lib:Adresse/lib:Strasse_1'"/>
											</xsl:call-template>
									 		&#173;
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=3]/bgs:NameUndAdresse/lib:Adresse/lib:Strasse_2'"/>
											</xsl:call-template>
									 		&#173;
											<!-- Hausnummer	-->
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=3]/bgs:NameUndAdresse/lib:Adresse/lib:Hausnummer'"/>
											</xsl:call-template>
											<br/>
											<!-- Postleitzahl	-->
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=3]/bgs:NameUndAdresse/lib:Adresse/lib:Postleitzahl'"/>
											</xsl:call-template>
											&#173;
											<!-- Orte	-->
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=3]/bgs:NameUndAdresse/lib:Adresse/lib:Ort_1'"/>
											</xsl:call-template>
											&#173;
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=3]/bgs:NameUndAdresse/lib:Adresse/lib:Ort_2'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<table width="100%" border="0" height="25">
						<tr>
							<td id="Titel">Unterschrift / Signatur</td>
						</tr>
						<tr>
							<td>
								<table width="100%" border="0" height="25" id="Tabelle" cellspacing="1" cellpadding="1">
									<tr>
										<td>
											<!-- Befoerderer 3  Unterschrift	-->
											<xsl:call-template name="getUnterschrift">
												<xsl:with-param name="LayerName" select="'BGSBEFLayer'"/>
												<xsl:with-param name="AtbRolle" select="'BEF'"/>
												<xsl:with-param name="BefLfdNr" select="3"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<xsl:choose>
						<xsl:when test="boolean(descendant::bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=3]/bgs:IndicatorQuittungsbeleg)">
							<table width="100%" border="0" height="25">
								<tr>
									<td id="Titel" width="60%">Quittungsbeleg wurde verwendet:</td>
									<td id="Titel" width="30%">Unterschrieben</td>
									<td width="10%">
										<table id="Tabelle_indikator">
											<tr>
												<td>
													<xsl:call-template name="getBooleanValue">
														<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Befoerderer[bgs:LfdNrBefoerderer=3]/bgs:IndicatorQuittungsbeleg'"/>
													</xsl:call-template>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</xsl:when>
						<xsl:otherwise>
							<table width="100%" border="0" height="25">
								<tr>
									<td id="Titel" width="100%">Quittungsbeleg wurde nicht verwendet</td>
								</tr>
							</table>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<!-- Lager -->
				<td id="Tabelle_links">
					<table width="100%" border="0" height="50">
						<tr>
							<td id="Titel">Kurzfristige Lagerung / Umschlag</td>
						</tr>
						<tr>
							<td>
								<!-- BehoerdlicheNummer	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Lager/bgs:Nummer/lib:BehoerdlicheNr'"/>
								</xsl:call-template>
								&#173;
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Lager/bgs:Nummer/lib:Pruefziffer'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table width="100%" border="0" height="50">
						<tr>
							<td id="Titel">Datum der Annahme</td>
						</tr>
						<tr>
							<td>
								<!-- Datum-->
								<xsl:call-template name="getDateValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Lager/bgs:Datum'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table width="100%" border="0" height="70">
						<tr>
							<td id="Titel">Datum der Übergabe</td>
						</tr>
						<tr>
							<td>
								<!-- Datum-->
								<xsl:call-template name="getDateValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Lager/bgs:DatumUebergabe'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table width="100%" border="0" height="130">
						<tr>
							<td id="Titel">Firmenname, Anschrift</td>
						</tr>
						<tr>
							<td>
								<table width="100%" border="0" height="130" id="Tabelle" cellspacing="1" cellpadding="1">
									<tr>
										<td>
											<!--  Namen	-->
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Lager/bgs:NameUndAdresse/lib:Name/lib:Name1'"/>
											</xsl:call-template>
											&#173;
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Lager/bgs:NameUndAdresse/lib:Name/lib:Name2'"/>
											</xsl:call-template>
											&#173;
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Lager/bgs:NameUndAdresse/lib:Name/lib:Name3'"/>
											</xsl:call-template>
											&#173;
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Lager/bgs:NameUndAdresse/lib:Name/lib:Name4'"/>
											</xsl:call-template>
											<br/>
											<!--  Strassen	-->
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Lager/bgs:NameUndAdresse/lib:Adresse/lib:Strasse_1'"/>
											</xsl:call-template>
									 		&#173;
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Lager/bgs:NameUndAdresse/lib:Adresse/lib:Strasse_2'"/>
											</xsl:call-template>
									 		&#173;
											<!-- Hausnummer	-->
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Lager/bgs:NameUndAdresse/lib:Adresse/lib:Hausnummer'"/>
											</xsl:call-template>
											<br/>
											<!-- Postleitzahl	-->
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Lager/bgs:NameUndAdresse/lib:Adresse/lib:Postleitzahl'"/>
											</xsl:call-template>
											&#173;
											<!-- Orte	-->
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Lager/bgs:NameUndAdresse/lib:Adresse/lib:Ort_1'"/>
											</xsl:call-template>
											&#173;
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Lager/bgs:NameUndAdresse/lib:Adresse/lib:Ort_2'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<table width="100%" border="0" height="25">
						<tr>
							<td id="Titel">Unterschrift / Signatur</td>
						</tr>
						<tr>
							<td>
								<table width="100%" border="0" height="25" id="Tabelle" cellspacing="1" cellpadding="1">
									<tr>
										<td>
											<xsl:call-template name="getUnterschrift">
												<xsl:with-param name="LayerName" select="'BGSZWLLayer'"/>
												<xsl:with-param name="AtbRolle" select="'ZWL'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<xsl:choose>
						<xsl:when test="boolean(descendant::bgs:Daten/bgs:ATBListe/bgs:Lager/bgs:IndicatorQuittungsbeleg)">
							<table width="100%" border="0" height="25">
								<tr>
									<td id="Titel" width="60%">Quittungsbeleg wurde verwendet:</td>
									<td id="Titel" width="30%">Unterschrieben</td>
									<td width="10%">
										<table id="Tabelle_indikator">
											<tr>
												<td>
													<xsl:call-template name="getBooleanValue">
														<xsl:with-param name="TagName" select="'bgs:Daten/bgs:ATBListe/bgs:Lager/bgs:IndicatorQuittungsbeleg'"/>
													</xsl:call-template>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</xsl:when>
						<xsl:otherwise>
							<table width="100%" border="0" height="25">
								<tr>
									<td id="Titel" width="100%">Quittungsbeleg wurde nicht verwendet</td>
								</tr>
							</table>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Anhang">
		<br/>
		<br/>
		<br/>
		<br/>
		<p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p>
		<xsl:if test="boolean(../../../bgs:Dateianhang)">
			<table width="100%" id="Tabelle-Haupt" cellspacing="15" cellpadding="15">
				<tr>
					<td>
						<font id="Nummer2">Angeh&#228;ngt wurden:</font>
						<br/>
						<br/>
						<ul>
							<xsl:for-each select="../../../bgs:Dateianhang">
								<font id="Text">
									<li>
										<xsl:value-of select="@lib:dateiname"/>
									</li>
								</font>
							</xsl:for-each>
						</ul>
						<!--font id="noprint">
							<a href="javascript:save_file();">Um die Anhänge aus dem Dokument anzusehen, bitte hier klicken</a>
						</font-->
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>

	<xsl:template name="UNSNummern">
		<xsl:param name="index"/>
		<xsl:choose>
			<xsl:when test="boolean(bgs:Daten/bgs:UNSNummer[@lib:Index=$index])">
				<table width="20%">
					<xsl:for-each select="bgs:Daten/bgs:UNSNummer[@lib:Index=$index]">
						<tr>
							<td id="Aktuell">
								<xsl:value-of select="@lib:Index"/>
								&#173;
								<xsl:value-of select="lib:PaginierNr"/>
								&#173;
								<xsl:value-of select="lib:Pruefziffer"/>
							</td>
						</tr>
					</xsl:for-each>
				</table>
			</xsl:when>
			<xsl:when test="boolean(descendant::bgs:Daten/bgs:UNSNummer[@lib:Index=$index])">
				<table width="20%">
					<xsl:for-each select="descendant::bgs:UNSNummer[parent::bgs:Daten][@lib:Index=$index][last()]">
						<tr>
							<td id="Text">
								<xsl:value-of select="@lib:Index"/>
								&#173;
								<xsl:value-of select="lib:PaginierNr"/>
								&#173;
								<xsl:value-of select="lib:Pruefziffer"/>
							</td>
						</tr>
					</xsl:for-each>
				</table>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="WRITE_UNS">
		<xsl:param name="the_index" select="0"/>
		<xsl:param name="max_index"/>

		<xsl:call-template name="UNSNummern">
			<xsl:with-param name="index" select="$the_index"/>
		</xsl:call-template>
		
		<xsl:if test="not ($the_index = $max_index)">
			<xsl:call-template name="WRITE_UNS">
				<xsl:with-param name="the_index" select="$the_index + 1"/>
				<xsl:with-param name="max_index" select="$max_index"/>
			</xsl:call-template>
		</xsl:if>
	
	</xsl:template>

	<xsl:template name="Uebernahmenr_Abfallschl">
		<p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p>
		<xsl:if test="boolean(bgs:Daten/bgs:UNSNummer) or boolean(descendant::bgs:Daten/bgs:UNSNummer)">
			<!--xsl:variable name="MAX_INDEX">
				<xsl:for-each select="descendant::bgs:Daten/bgs:UNSNummer">
					<xsl:sort select="@lib:Index" data-type="number" order="descending"/>
					<xsl:if test="position() = 1">
						<xsl:value-of select="@lib:Index"/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable-->
			<xsl:variable name="sortedUNS">
				<xsl:for-each select="descendant::bgs:UNSNummer[parent::bgs:Daten]">
					<xsl:sort select="@lib:Index" data-type="number" order="ascending"/>
					<xsl:copy-of select="."/>
				</xsl:for-each>
			</xsl:variable>
			<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
				<tr>
					<td>
						<font id="Nummer2">Übernahmescheinnummern:</font>
					</td>
				</tr>
				<tr>
					<td>
						<!--xsl:call-template name="WRITE_UNS">
							<xsl:with-param name="max_index" select="$MAX_INDEX"/>
						</xsl:call-template-->
						<xsl:variable name="source" select="."/>
						<xsl:for-each select="xalan:nodeset($sortedUNS)/*">
							<!--xsl:message>Index:<xsl:value-of select="@lib:Index"/>, preceding Index:<xsl:value-of select="preceding-sibling::bgs:UNSNummer[1]/@lib:Index"/></xsl:message-->
								<xsl:if test="position()=1 or not(@lib:Index=preceding-sibling::bgs:UNSNummer[1]/@lib:Index)">
								<xsl:variable name="index" select="@lib:Index"/>
								<xsl:for-each select="$source">
									<xsl:call-template name="UNSNummern">
										<xsl:with-param name="index" select="$index"/>
									</xsl:call-template>
								</xsl:for-each>
							</xsl:if>
						</xsl:for-each>
						<!--xsl:choose>
							<xsl:when test="boolean(bgs:Daten/bgs:UNSNummer)">
								<table width="20%">
									<xsl:for-each select="bgs:Daten/bgs:UNSNummer">
										<tr>
											<td id="Aktuell">
												<xsl:value-of select="lib:PaginierNr"/>
											&#173;
											<xsl:value-of select="lib:Pruefziffer"/>
											</td>
										</tr>
									</xsl:for-each>
								</table>
							</xsl:when>
							<xsl:when test="boolean(descendant::bgs:Daten/bgs:UNSNummer)">
								<table width="20%">
									<xsl:for-each select="descendant::bgs:Daten/bgs:UNSNummer">
										<tr>
											<td id="Text">
												<xsl:value-of select="lib:PaginierNr"/>
											&#173;
											<xsl:value-of select="lib:Pruefziffer"/>
											</td>
										</tr>
									</xsl:for-each>
								</table>
							</xsl:when>
						</xsl:choose-->
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="boolean(bgs:Daten/bgs:WeitereAbfallschluessel) or boolean(descendant::bgs:Daten/bgs:WeitereAbfallschluessel)">
			<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
				<tr>
					<table width="20%">
						<tr>
							<td>
								<font id="Nummer2">Weitere Abfallschlüssel:</font>
							</td>
						</tr>
					</table>
					<xsl:choose>
						<xsl:when test="boolean(bgs:Daten/bgs:WeitereAbfallschluessel)">
							<table width="20%">
								<xsl:for-each select="bgs:Daten/bgs:WeitereAbfallschluessel">
									<tr>
										<td id="Aktuell">
											<xsl:value-of select="."/>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</xsl:when>
						<xsl:when test="boolean(descendant::bgs:Daten/bgs:WeitereAbfallschluessel)">
							<table width="20%">
								<xsl:for-each select="descendant::bgs:Daten/bgs:WeitereAbfallschluessel">
									<tr>
										<td id="Text">
											<xsl:value-of select="."/>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</xsl:when>
					</xsl:choose>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<xsl:template name="AndereVerordnungen">
		<p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p>
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr>
				<td>
					<font id="Nummer2">Andere Verordnungen:</font>
				</td>
			</tr>
			<tr>
				<td>
					<!--Andere Verordnungen-->
					<table width="100%" border="0">
						<tr>
							<td>
								<font id="Ueberschrift3">GGVS</font>
							</td>
						</tr>
						<tr width="100%">
							<td id="Titel"> Klasse </td>
							<td id="Titel"> Verpackungsgruppe</td>
							<td id="Titel"> Ausnahme-Nummer</td>
						</tr>
						<tr>
							<td width="33%">
								<!-- GGVS - Klasse	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:GGVS/bgs:Klasse'"/>
								</xsl:call-template>
							</td>
							<td width="33%">
								<!-- GGVS - Verpackungsgruppe	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:GGVS/bgs:Verpackungsgruppe'"/>
								</xsl:call-template>
							</td>
							<td width="33%">
								<!-- GGVS - AusnahmeNr	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:GGVS/bgs:AusnahmeNr'"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr width="100%">
							<td id="Titel"> Genehmigungs-Nummer </td>
							<td id="Titel"> UN-Nummer</td>
							<td id="Titel"> Gefahr-Nummer</td>
						</tr>
						<tr>
							<td width="33%">
								<!-- GGVS - Genehmigungs-Nummer	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:GGVS/bgs:GenehmigungsNr'"/>
								</xsl:call-template>
							</td>
							<td width="33%">
								<!-- GGVS - UNNr	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:GGVS/bgs:UNNr'"/>
								</xsl:call-template>
							</td>
							<td width="33%">
								<!-- GGVS - GefahrNr	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:GGVS/bgs:GefahrNr'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table width="100%" border="0">
						<tr>
							<td>
								<font id="Ueberschrift3">PCB AbfallV</font>
							</td>
						</tr>
						<tr width="100%">
							<td id="Titel"> PCB: Angaben in Vermerke</td>
							<td id="Titel"> Herkunft</td>
						</tr>
						<tr>
							<td width="20%">
								<!-- PCB	-->
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'bgs:AndereVerordnungen/bgs:PCBAbfallV/bgs:IndicatorVermerke'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td width="80%">
								<!-- Herkunft	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:PCBAbfallV/bgs:Herkunft'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table width="100%">
						<font id="Ueberschrift2">PCB Arten und -gehalte</font>
						<tr height="3">
							<th/>
						</tr>
						<tr>
							<td>
								<table id="Tabelle_unten" width="100%">
									<tr>
										<td id="Ueberschrift2" width="40%"> Bezeichnung	</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="10%"> 	Menge</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="3%"> Einheit	</td>
										<td id="Ueberschrift2" width="47%"/>
									</tr>
								</table>
								<xsl:choose>
									<xsl:when test="boolean(bgs:Daten/bgs:AndereVerordnungen/bgs:PCBAbfallV/bgs:PCBFraktion)">
										<xsl:for-each select="bgs:Daten/bgs:AndereVerordnungen/bgs:PCBAbfallV/bgs:PCBFraktion">
											<table id="Tabelle_unten" width="100%">
												<tr>
													<td id="Aktuell" valign="top" width="40%">
														<xsl:value-of select="bgs:PCBArt"/>
													</td>
													<td id="Aktuell" width="2%"/>
													<td id="Aktuell" valign="top" width="10%">
														<xsl:call-template name="formatDouble">
															<xsl:with-param name="wert" select="bgs:PCBGehalt"/>
														</xsl:call-template>
													</td>
													<td id="Aktuell" width="2%"/>
													<td id="Aktuell" valign="top" width="3%">
														<xsl:value-of select="bgs:PCBGehalt/@bgs:Einheit"/>
													</td>
													<td id="Aktuell" width="47%"/>
												</tr>
												<tr height="15">
													<th/>
												</tr>
											</table>
										</xsl:for-each>
									</xsl:when>
									<xsl:when test="boolean(descendant::bgs:Daten/bgs:AndereVerordnungen/bgs:PCBAbfallV/bgs:PCBFraktion)">
										<xsl:for-each select="descendant::bgs:Daten/bgs:AndereVerordnungen/bgs:PCBAbfallV/bgs:PCBFraktion">
											<table id="Tabelle_unten" width="100%">
												<tr>
													<td id="Text" valign="top" width="40%">
														<xsl:value-of select="bgs:PCBArt"/>
													</td>
													<td id="Text" width="2%"/>
													<td id="Text" valign="top" width="10%">
														<xsl:value-of select="bgs:PCBGehalt"/>
													</td>
													<td id="Text" width="2%"/>
													<td id="Text" valign="top" width="3%">
														<xsl:value-of select="bgs:PCBGehalt/@bgs:Einheit"/>
													</td>
													<td id="Text" width="47%"/>
												</tr>
												<tr height="15">
													<th/>
												</tr>
											</table>
										</xsl:for-each>
									</xsl:when>
								</xsl:choose>
							</td>
						</tr>
					</table>
					<table width="100%" border="0">
						<tr>
							<td height="5"/>
						</tr>
						<tr>
							<td>
								<font id="Ueberschrift3">Alt&#246;lV</font>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel">Art des Erkl&#228;rungspflichtigen</font>
							</td>
						</tr>
						<tr>
							<td>
								<!-- Art des Erklärungspflichtigen	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Erklaerungspflichtiger/bgs:Art'"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Ueberschrift2">Erkl&#228;rung des Erkl&#228;rungspflichtigen</font>
							</td>
						</tr>
						<tr width="100%">
							<td id="Titel"> Ort </td>
							<td id="Titel"> Datum</td>
							<td id="Titel"> Name</td>
						</tr>
						<tr>
							<td width="33%">
								<!-- Ort	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Erklaerungspflichtiger/bgs:Erklaerung/lib:Ort'"/>
								</xsl:call-template>
							</td>
							<td width="33%">
								<!-- Datum	-->
								<xsl:call-template name="getDateValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Erklaerungspflichtiger/bgs:Erklaerung/lib:Datum'"/>
								</xsl:call-template>
							</td>
							<td width="33%">
								<!-- Name	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Erklaerungspflichtiger/bgs:Erklaerung/lib:Name'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table width="100%" border="0">
						<tr>
							<td id="Ueberschrift2">Untersuchungspflichtiger, Anschrift</td>
						</tr>
						<tr>
							<td>
								<table width="100%" border="0">
									<tr>
										<td>
											<!--Untersuchungspflichtiger  Namen	-->
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Untersuchungspflichtiger/bgs:NameUndAdresse/lib:Name/lib:Name1'"/>
											</xsl:call-template>
											&#173;
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Untersuchungspflichtiger/bgs:NameUndAdresse/lib:Name/lib:Name2'"/>
											</xsl:call-template>
											&#173;
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Untersuchungspflichtiger/bgs:NameUndAdresse/lib:Name/lib:Name3'"/>
											</xsl:call-template>
											&#173;
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Untersuchungspflichtiger/bgs:NameUndAdresse/lib:Name/lib:Name4'"/>
											</xsl:call-template>
											<br/>
											<!--Untersuchungspflichtiger  Strasse1	-->
											<xsl:call-template name="getTextValuePostfach">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Untersuchungspflichtiger/bgs:NameUndAdresse/lib:Adresse/lib:Strasse_1'"/>
												<xsl:with-param name="TagNamePostfach" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Untersuchungspflichtiger/bgs:NameUndAdresse/lib:Postfach/lib:Postfach'"/>
											</xsl:call-template>
									 		&#173;
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Untersuchungspflichtiger/bgs:NameUndAdresse/lib:Adresse/lib:Strasse_2'"/>
											</xsl:call-template>
									 		&#173;
											<xsl:call-template name="getTextValue">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Untersuchungspflichtiger/bgs:NameUndAdresse/lib:Adresse/lib:Hausnummer'"/>
											</xsl:call-template>
											<br/>
											<!--Untersuchungspflichtiger Staat	-->
											<xsl:call-template name="getTextValuePostfach">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Untersuchungspflichtiger/bgs:NameUndAdresse/lib:Adresse/lib:Staat'"/>
												<xsl:with-param name="TagNamePostfach" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Untersuchungspflichtiger/bgs:NameUndAdresse/lib:Postfach/lib:Staat'"/>
											</xsl:call-template>
									 		&#173;
											<!--Untersuchungspflichtiger Postleitzahl	-->
											<xsl:call-template name="getTextValuePostfach">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Untersuchungspflichtiger/bgs:NameUndAdresse/lib:Adresse/lib:Postleitzahl'"/>
												<xsl:with-param name="TagNamePostfach" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Untersuchungspflichtiger/bgs:NameUndAdresse/lib:Postfach/lib:Postleitzahl'"/>
											</xsl:call-template>
											<!--Untersuchungspflichtiger Ort 1	-->
									 		&#173;
											<xsl:call-template name="getTextValuePostfach">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Untersuchungspflichtiger/bgs:NameUndAdresse/lib:Adresse/lib:Ort_1'"/>
												<xsl:with-param name="TagNamePostfach" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Untersuchungspflichtiger/bgs:NameUndAdresse/lib:Postfach/lib:Ort_1'"/>
											</xsl:call-template>
											<!--Untersuchungspflichtiger Ort 2	-->
									 		&#173;
											<xsl:call-template name="getTextValuePostfach">
												<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Untersuchungspflichtiger/bgs:NameUndAdresse/lib:Adresse/lib:Ort_2'"/>
												<xsl:with-param name="TagNamePostfach" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Untersuchungspflichtiger/bgs:NameUndAdresse/lib:Postfach/lib:Ort_2'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr width="100%">
							<td id="Titel"> PCB-Menge </td>
							<td id="Titel"> Gesamthalogen</td>
							<td id="Titel"> Analysedatum</td>
						</tr>
						<tr>
							<td width="33%">
								<!-- PCB-Menge 	-->
								<xsl:call-template name="getDoubleValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Untersuchungspflichtiger/bgs:PCB'"/>
								</xsl:call-template>
							</td>
							<td width="33%">
								<!-- Gesamthalogen 	-->
								<xsl:call-template name="getDoubleValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Untersuchungspflichtiger/bgs:Gesamthalogen'"/>
								</xsl:call-template>
							</td>
							<td width="33%">
								<!-- Datum	-->
								<xsl:call-template name="getDateValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Untersuchungspflichtiger/bgs:Analysedatum'"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Ueberschrift2">Erkl&#228;rung des Untersuchungspflichtigen</font>
							</td>
						</tr>
						<tr width="100%">
							<td id="Titel"> Ort </td>
							<td id="Titel"> Datum</td>
							<td id="Titel"> Name</td>
						</tr>
						<tr>
							<td width="33%">
								<!-- Ort	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Untersuchungspflichtiger/bgs:Erklaerung/lib:Ort'"/>
								</xsl:call-template>
							</td>
							<td width="33%">
								<!-- Datum	-->
								<xsl:call-template name="getDateValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Untersuchungspflichtiger/bgs:Erklaerung/lib:Datum'"/>
								</xsl:call-template>
							</td>
							<td width="33%">
								<!-- Name	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltoelV/bgs:Untersuchungspflichtiger/bgs:Erklaerung/lib:Name'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table width="100%" border="0">
						<tr>
							<td height="5"/>
						</tr>
						<tr>
							<td>
								<font id="Ueberschrift3">AltholzV</font>
							</td>
						</tr>
						<tr width="100%">
							<td id="Titel"> Anliefererart </td>
							<td id="Titel"> Herkunft</td>
						</tr>
						<tr>
							<td width="10%">
								<!-- Anliefererart	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltholzV/bgs:Anliefererart'"/>
								</xsl:call-template>
							</td>
							<td width="90%">
								<!-- Herkunft	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltholzV/bgs:Herkunft'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table width="100%" border="0">
						<tr>
							<td height="5"/>
						</tr>
						<tr>
							<td>
								<font id="Ueberschrift2">Ansprechpartner Anlieferer</font>
							</td>
						</tr>
						<tr width="100%">
							<td id="Titel"> Name </td>
							<td id="Titel"> Telefon</td>
							<td id="Titel"> Telefax</td>
							<td id="Titel"> E-Mail</td>
						</tr>
						<tr>
							<td width="30%">
								<!-- Name	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltholzV/bgs:AnsprechpartnerAnlieferer/lib:Name'"/>
								</xsl:call-template>
							</td>
							<td width="20%">
								<!-- Telefon	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltholzV/bgs:AnsprechpartnerAnlieferer/lib:Telefon'"/>
								</xsl:call-template>
							</td>
							<td width="20%">
								<!-- Telefax	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltholzV/bgs:AnsprechpartnerAnlieferer/lib:Telefax'"/>
								</xsl:call-template>
							</td>
							<td width="30%">
								<!-- EMail	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltholzV/bgs:AnsprechpartnerAnlieferer/lib:EMail'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table width="100%" border="0">
						<tr>
							<td height="5"/>
						</tr>
						<tr>
							<td>
								<font id="Ueberschrift2">Ansprechpartner Empf&#228;nger</font>
							</td>
						</tr>
						<tr width="100%">
							<td id="Titel"> Name </td>
							<td id="Titel"> Telefon</td>
							<td id="Titel"> Telefax</td>
							<td id="Titel"> E-Mail</td>
						</tr>
						<tr>
							<td width="30%">
								<!-- Name	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltholzV/bgs:AnsprechpartnerEmpfaenger/lib:Name'"/>
								</xsl:call-template>
							</td>
							<td width="20%">
								<!-- Telefon	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltholzV/bgs:AnsprechpartnerEmpfaenger/lib:Telefon'"/>
								</xsl:call-template>
							</td>
							<td width="20%">
								<!-- Telefax	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltholzV/bgs:AnsprechpartnerEmpfaenger/lib:Telefax'"/>
								</xsl:call-template>
							</td>
							<td width="30%">
								<!-- EMail	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'bgs:Daten/bgs:AndereVerordnungen/bgs:AltholzV/bgs:AnsprechpartnerEmpfaenger/lib:EMail'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
					<table width="100%">
						<font id="Ueberschrift2">Altholzsortiment</font>
						<tr height="3">
							<th/>
						</tr>
						<tr>
							<td>
								<table id="Tabelle_unten" width="100%">
									<tr>
										<td id="Ueberschrift2" width="25%"> Bezeichnung	</td>
										<td id="Ueberschrift2" width="1%"/>
										<td id="Ueberschrift2" width="25%"> sonstige Bezeichnung</td>
										<td id="Ueberschrift2" width="1%"/>
										<td id="Ueberschrift2" width="5%"> Kategorie	</td>
										<td id="Ueberschrift2" width="1%"/>
										<td id="Ueberschrift2" width="5%"> Menge	</td>
										<td id="Ueberschrift2" width="1%"/>
										<td id="Ueberschrift2" width="5%"> Volumen	</td>
										<td id="Ueberschrift2" width="1%"/>
										<td id="Ueberschrift2" width="30%"> Weitere Informationen	</td>
									</tr>
								</table>
								<xsl:choose>
									<xsl:when test="boolean(bgs:Daten/bgs:AndereVerordnungen/bgs:AltholzV/bgs:Sortiment)">
										<xsl:for-each select="bgs:Daten/bgs:AndereVerordnungen/bgs:AltholzV/bgs:Sortiment">
											<table id="Tabelle_unten" width="100%">
												<tr>
													<td id="Aktuell" valign="top" width="25%">
														<xsl:value-of select="bgs:Bezeichnung"/>
													</td>
													<td id="Aktuell" width="1%"/>
													<td id="Aktuell" valign="top" width="25%">
														<xsl:value-of select="bgs:BezeichungSonst"/>
													</td>
													<td id="Aktuell" width="1%"/>
													<td id="Aktuell" valign="top" width="5%">
														<xsl:value-of select="bgs:IstKategorie"/>
													</td>
													<td id="Aktuell" width="1%"/>
													<td id="Aktuell" valign="top" width="5%">
														<xsl:call-template name="formatDouble">
															<xsl:with-param name="wert" select="bgs:Menge"/>
														</xsl:call-template>
													</td>
													<td id="Aktuell" width="1%"/>
													<td id="Aktuell" valign="top" width="5%">
														<xsl:call-template name="formatDouble">
															<xsl:with-param name="wert" select="bgs:Volumen"/>
														</xsl:call-template>
													</td>
													<td id="Aktuell" width="1%"/>
													<td id="Aktuell" valign="top" width="30%">
														<xsl:value-of select="bgs:Informationen"/>
													</td>
												</tr>
												<tr height="15">
													<th/>
												</tr>
											</table>
										</xsl:for-each>
									</xsl:when>
									<xsl:when test="boolean(descendant::bgs:Daten/bgs:AndereVerordnungen/bgs:AltholzV/bgs:Sortiment)">
										<xsl:for-each select="descendant::bgs:Daten/bgs:AndereVerordnungen/bgs:AltholzV/bgs:Sortiment">
											<table id="Tabelle_unten" width="100%">
												<tr>
													<td id="Text" valign="top" width="25%">
														<xsl:value-of select="bgs:Bezeichnung"/>
													</td>
													<td id="Text" width="1%"/>
													<td id="Text" valign="top" width="25%">
														<xsl:value-of select="bgs:BezeichungSonst"/>
													</td>
													<td id="Text" width="1%"/>
													<td id="Text" valign="top" width="5%">
														<xsl:value-of select="bgs:IstKategorie"/>
													</td>
													<td id="Text" width="1%"/>
													<td id="Text" valign="top" width="5%">
														<xsl:call-template name="formatDouble">
															<xsl:with-param name="wert" select="bgs:Menge"/>
														</xsl:call-template>
													</td>
													<td id="Text" width="1%"/>
													<td id="Text" valign="top" width="5%">
														<xsl:call-template name="formatDouble">
															<xsl:with-param name="wert" select="bgs:Volumen"/>
														</xsl:call-template>
													</td>
													<td id="Text" width="1%"/>
													<td id="Text" valign="top" width="30%">
														<xsl:value-of select="bgs:Informationen"/>
													</td>
												</tr>
												<tr height="15">
													<th/>
												</tr>
											</table>
										</xsl:for-each>
									</xsl:when>
								</xsl:choose>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="getUnterschrift">
		<xsl:param name="LayerName"/>
		<xsl:param name="AtbRolle"/>
		<xsl:param name="BefLfdNr" select="0"/>
		<xsl:variable name="BGS_LAYER_ID">
			<xsl:choose>
				<xsl:when test="boolean(ancestor::bgs:UNSDokument)">
					<xsl:choose>
						<xsl:when test="starts-with(local-name(), 'UNS') and @lib:ATBRolle=$AtbRolle and count(ds:Signature) > 0">
							<xsl:value-of select="@lib:LayerID"/>
						</xsl:when>
						<xsl:when test="descendant::bgs:UNSErgaenzungsLayer[@lib:ATBRolle=$AtbRolle]/@lib:LayerID">
							<xsl:value-of select="descendant::bgs:UNSErgaenzungsLayer[@lib:ATBRolle=$AtbRolle]/@lib:LayerID"/>
						</xsl:when>
						<xsl:when test="descendant::bgs:UNSBasisLayer[@lib:ATBRolle=$AtbRolle]/@lib:LayerID">
							<xsl:value-of select="descendant::bgs:UNSBasisLayer[@lib:ATBRolle=$AtbRolle]/@lib:LayerID"/>
						</xsl:when>
						<xsl:when test="descendant::bgs:UNSVorlageLayer[@lib:ATBRolle=$AtbRolle]/@lib:LayerID">
							<xsl:value-of select="descendant::bgs:UNSVorlageLayer[@lib:ATBRolle=$AtbRolle]/@lib:LayerID"/>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="$BefLfdNr > 0">
							<xsl:choose>
								<xsl:when test="local-name()=$LayerName and @lib:ATBBefLfdNummer=$BefLfdNr and count(ds:Signature) > 0">
									<xsl:value-of select="@lib:LayerID"/>
								</xsl:when>
								<xsl:when test="local-name()='BGSErgaenzungsLayer' and @lib:ATBRolle=$AtbRolle and @lib:ATBBefLfdNummer=$BefLfdNr and (count(ds:Signature) > 0)">
									<xsl:value-of select="@lib:LayerID"/>
								</xsl:when>
								<xsl:when test="count(descendant::bgs:BGSErgaenzungsLayer[@lib:ATBRolle=$AtbRolle and @lib:ATBBefLfdNummer=$BefLfdNr]/ds:Signature) > 0">
									<xsl:value-of select="descendant::bgs:BGSErgaenzungsLayer[@lib:ATBRolle=$AtbRolle and @lib:ATBBefLfdNummer=$BefLfdNr]/ds:Signature/../@lib:LayerID"/>
								</xsl:when>
								<!--xsl:when test="local-name()='BGSVorlageLayer' and @lib:ATBRolle=$AtbRolle and @lib:ATBBefLfdNummer=$BefLfdNr and (count(ds:Signature) > 0)">
									<xsl:value-of select="@lib:LayerID"/>
								</xsl:when-->
								<xsl:when test="count(dyn:evaluate(concat('descendant::bgs:', $LayerName, '[@lib:ATBBefLfdNummer=', $BefLfdNr, ']', '/ds:Signature'))) > 0">
									<xsl:value-of select="dyn:evaluate(concat('descendant::bgs:', $LayerName, '[@lib:ATBBefLfdNummer=', $BefLfdNr, ']', '/ds:Signature/../@lib:LayerID'))"/>
								</xsl:when>
								<!--xsl:when test="count(descendant::bgs:BGSVorlageLayer[@lib:ATBRolle=$AtbRolle and @lib:ATBBefLfdNummer=$BefLfdNr]/ds:Signature) > 0">
									<xsl:value-of select="descendant::bgs:BGSVorlageLayer[@lib:ATBRolle=$AtbRolle and @lib:ATBBefLfdNummer=$BefLfdNr]/@lib:LayerID"/>
								</xsl:when-->
								<xsl:otherwise>
									<xsl:value-of select="dyn:evaluate(concat('descendant::bgs:', $LayerName, '[@lib:ATBBefLfdNummer=', $BefLfdNr, ']', '/@lib:LayerID'))"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="local-name()=$LayerName and count(ds:Signature) > 0">
									<xsl:value-of select="@lib:LayerID"/>
								</xsl:when>
								<xsl:when test="local-name()='BGSErgaenzungsLayer' and @lib:ATBRolle=$AtbRolle and count(ds:Signature) > 0">
									<xsl:value-of select="@lib:LayerID"/>
								</xsl:when>
								<xsl:when test="count(descendant::bgs:BGSErgaenzungsLayer[@lib:ATBRolle=$AtbRolle]/ds:Signature) > 0">
									<xsl:value-of select="descendant::bgs:BGSErgaenzungsLayer[@lib:ATBRolle=$AtbRolle]/ds:Signature/../@lib:LayerID"/>
								</xsl:when>
								<xsl:when test="count(dyn:evaluate(concat('descendant::bgs:', $LayerName,'/ds:Signature'))) > 0">
									<xsl:value-of select="dyn:evaluate(concat('descendant::bgs:', $LayerName,'/@lib:LayerID'))"/>
								</xsl:when>
								<!--xsl:when test="count(descendant::bgs:BGSVorlageLayer[@lib:ATBRolle=$AtbRolle]/ds:Signature) > 0">
									<xsl:value-of select="descendant::bgs:BGSVorlageLayer[@lib:ATBRolle=$AtbRolle]/@lib:LayerID"/>
								</xsl:when-->
								<xsl:otherwise>
									<xsl:value-of select="dyn:evaluate(concat('descendant::bgs:', $LayerName,'/@lib:LayerID'))"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!--xsl:message>Layer-Daten: <xsl:value-of select="local-name()"/>,<xsl:value-of select="@lib:ATBRolle"/>,<xsl:value-of select="@lib:ATBBefLfdNummer"/></xsl:message>
		<xsl:message>Param-Daten: <xsl:value-of select="$AtbRolle"/>,<xsl:value-of select="$BefLfdNr"/></xsl:message-->
		<!--xsl:message>BGS_LAYER_ID: <xsl:value-of select="$BGS_LAYER_ID"/></xsl:message-->
		<xsl:variable name="SIG_AKTUELL">
			<xsl:choose>
				<xsl:when test="boolean(ancestor::bgs:UNSDokument)">
					<xsl:choose>
						<xsl:when test="starts-with(local-name(), 'UNS') and @lib:ATBRolle=$AtbRolle and count(ds:Signature) > 0">
							<xsl:value-of select="true()"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="false()"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="$BefLfdNr > 0">
							<xsl:choose>
								<xsl:when test="((local-name()=$LayerName and @lib:ATBBefLfdNummer=$BefLfdNr) or (local-name()='BGSErgaenzungsLayer' and @lib:ATBRolle=$AtbRolle and @lib:ATBBefLfdNummer=$BefLfdNr)) and count(ds:Signature) > 0">
										<xsl:value-of select="true()"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="false()"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="(local-name()=$LayerName or (local-name()='BGSErgaenzungsLayer' and @lib:ATBRolle=$AtbRolle)) and count(ds:Signature) > 0">
										<xsl:value-of select="true()"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="false()"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!--xsl:message>SIG_AKTUELL: <xsl:value-of select="$SIG_AKTUELL"/></xsl:message-->
		<xsl:choose>
			<xsl:when test="$SIG_AKTUELL='true'">
				<xsl:choose>
					<xsl:when test="count(ds:Signature) > 0">
						<font id="Aktuell">
							<xsl:value-of select="x509:extractCommonName(b64:decode(ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
							<xsl:variable name="SIG_DATE">
								<xsl:call-template name="formatDate">
									<xsl:with-param name="date" select="ds:Signature[1]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
								</xsl:call-template>
							</xsl:variable>
 							<xsl:value-of select="concat(' (', $SIG_DATE, ')')"/>
							<!--xsl:message>Font: <xsl:value-of select="'Aktuell'"/></xsl:message-->
						</font>
					</xsl:when>
					<xsl:otherwise>
						
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="count(descendant::*[@lib:LayerID=$BGS_LAYER_ID]/ds:Signature) > 0">
					<font id="Text">
						<xsl:value-of select="x509:extractCommonName(b64:decode(descendant::*[@lib:LayerID=$BGS_LAYER_ID]/ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
							<xsl:variable name="SIG_DATE2">
								<xsl:call-template name="formatDate">
									<xsl:with-param name="date" select="descendant::*[@lib:LayerID=$BGS_LAYER_ID]/ds:Signature[1]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
								</xsl:call-template>
							</xsl:variable>
 							<xsl:value-of select="concat(' (', $SIG_DATE2, ')')"/>
						<!--xsl:message>Font: <xsl:value-of select="'Text'"/></xsl:message-->
					</font>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Fehler_Position">
		<xsl:for-each select="ancestor::*[local-name()='Layer']/descendant::*[(starts-with(local-name(), 'BGS')) and (contains(local-name(), 'Layer'))]">
			<xsl:if test="bgs:Fehlerprotokoll">
				<xsl:choose>
					<xsl:when test="position() > 9">
						<xsl:value-of select="concat(position(),'. ',local-name())"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('0',position(),'. ',local-name())"/>
					</xsl:otherwise>
				</xsl:choose> 
				<xsl:if test="position() != last()"> / </xsl:if>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="FehlerProtBGS">
		<p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p>
		<table width="100%" id="Tabelle-Haupt" cellspacing="15" cellpadding="15">
			<tr>
				<td>
					<!--Fehler-->
					<table cellspacing="6" cellpadding="6" width="100%">
						<font id="Nummer">Fehlerprotokoll:</font>
						<tr height="3">
							<th/>
						</tr>
						<tr>
							<td>
								<table id="Tabelle_unten" width="100%">
									<tr>
										<td id="Ueberschrift2" width="5%"> Adressat</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="5%"> Fehlerklasse</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="10%"> Fehler-Code</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="38%"> Fehler-Text</td>
										<td id="Ueberschrift2" width="2%"/>
										<td id="Ueberschrift2" width="34%"> Abhilfe</td>
									</tr>
								</table>
								<xsl:for-each select="bgs:Fehlerprotokoll/bgs:Fehler">
									<table id="Tabelle_unten" width="100%">
										<tr>
											<td id="Aktuell" valign="top" width="5%">
												<xsl:value-of select="@lib:ATBRolle"/>
												<xsl:value-of select="@lib:ATBBefLfdNummer"/>
											</td>
											<td width="2%"/>
											<td id="Aktuell" valign="top" width="5%">
												<xsl:value-of select="@lib:Fehlerklasse"/>
											</td>
											<td width="2%"/>
											<td id="Aktuell" valign="top" width="10%">
												<xsl:value-of select="lib:FehlerCode"/>
											</td>
											<td width="2%"/>
											<td id="Aktuell" valign="top" width="38%">
												<xsl:value-of select="lib:FehlerText"/>
											</td>
											<td width="2%"/>
											<td id="Aktuell" valign="top" width="34%">
												<xsl:value-of select="lib:FehlerAbhilfe"/>
											</td>
										</tr>
										<tr height="15">
											<th/>
										</tr>
									</table>
								</xsl:for-each>
							</td>
						</tr>
						<tr height="20">
							<th/>
						</tr>
					</table>
					<!--Ende Fehlerprotokoll-->
				</td>
			</tr>
		</table>
	</xsl:template>

</xsl:stylesheet>
