<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:dyn="http://exslt.org/dynamic" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#"
	xmlns:kop="uri:AnzeigeErlaubnis/Kopie_TypBibliothek"
	xmlns:abf="uri:AnzeigeErlaubnis/AbfAEV" 
	extension-element-prefixes="dyn"
	exclude-result-prefixes="xsl dyn lib ds en">
	<xsl:import href="ZKS-Library_fx.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>
	
	<xsl:variable name="MAX_ZEICHEN_MEMO" select="2400"/>

	<xsl:template match="/">
		<xsl:for-each select="//abf:ErlaubnisAntrag">
			<xsl:if test="position()=$positionsnummer">
				<html>
					<head>
						<title>Formblatt Antrag Erlaubnis nach § 54 KrWG</title>
						<!-- CSS - Datei -->
						<xsl:call-template name="Style"/>
					</head>
					<body>
						<xsl:call-template name="Kopf"/>
						<xsl:call-template name="ZeileErlaubnis"/>
						<!--xsl:call-template name="showSigLayer"/-->
					</body>
				</html>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="ZeileErlaubnis">
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr>
				<td/>
			</tr>
			<tr valign="bottom">
				<td>
					<div id="Titel" align="center">Seite 1</div>
					<!--div id="Titel" align="right">Formblatt Antrag Erlaubnis nach § 54 KrWG</div-->
				</td>
			</tr>
			<tr>
				<td>
					<xsl:call-template name="ErlaubnisKopf"/>
					<xsl:call-template name="Zeile1"/>
					<xsl:call-template name="Zeile2"/>
					<xsl:call-template name="Zeile3"/>
				</td>
			</tr>
		</table>
		<p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p>
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr valign="bottom">
				<td>
					<div id="Titel" align="center">Seite 2</div>
				</td>
			</tr>
			<tr>
				<td>
					<xsl:call-template name="Zeile4"/>
					<xsl:call-template name="Zeile5"/>
				</td>
			</tr>
		</table>
		<p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p>
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr valign="bottom">
				<td>
					<div id="Titel" align="center">Seite 3</div>
				</td>
			</tr>
			<tr>
				<td>
					<xsl:call-template name="Zeile6"/>
					<xsl:call-template name="Zeile7"/>
				</td>
			</tr>
		</table>
		<p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p>
		<!---optionale EB -->
		<xsl:if test="count(abf:Eingangsbestaetigung)>0 and abf:Eingangsbestaetigung/abf:IndicatorVollstaendig='true'">
			<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
				<tr>
					<td>
						<xsl:call-template name="ZeileEB"/>
					</td>
				</tr>
			</table>
			<p style="page-break-after:always">
				<br style="height:0; line-height:0"/>
			</p>
		</xsl:if>
		<!---optionaler Bescheid -->
		<xsl:if test="string-length(abf:Bescheid) > 0">
			<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
				<tr valign="bottom">
					<td>
						<div id="Titel" align="center">Seite 1</div>
					</td>
				</tr>
				<tr>
					<td>
						<xsl:call-template name="ZeileErl1"/>
					</td>
				</tr>
			</table>
			<p style="page-break-after:always">
				<br style="height:0; line-height:0"/>
			</p>
			<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
				<tr valign="bottom">
					<td>
						<div id="Titel" align="center">Seite 2</div>
					</td>
				</tr>
				<tr>
					<td>
						<xsl:call-template name="ZeileErl2"/>
					</td>
				</tr>
			</table>
			<p style="page-break-after:always">
				<br style="height:0; line-height:0"/>
			</p>
			<xsl:if test="count(abf:Bescheid/abf:Nebenbestimmung)>0">
				<xsl:variable name="ZEICHEN_NB">
						<xsl:for-each select="abf:Bescheid/abf:Nebenbestimmung">
							<xsl:value-of select="abf:Textbaustein"/>
						</xsl:for-each>
						<xsl:for-each select="abf:Bescheid/abf:Begruendung">
							<xsl:value-of select="abf:Textbaustein"/>
						</xsl:for-each>
				</xsl:variable>
				<xsl:if test="string-length($ZEICHEN_NB)>$MAX_ZEICHEN_MEMO">
					<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
						<tr valign="bottom">
							<td>
								<!--div id="Titel" align="center">Seite 2</div-->
							</td>
						</tr>
						<tr>
							<td>
								<xsl:call-template name="ZeileBeiblatt"/>
							</td>
						</tr>
					</table>
					<p style="page-break-after:always">
						<br style="height:0; line-height:0"/>
					</p>
				</xsl:if>
			</xsl:if>
			<xsl:if test="count(abf:Bescheid/abf:Kostenentscheid)>0">
				<xsl:variable name="ZEICHEN_NB">
						<xsl:for-each select="abf:Bescheid/abf:Kostenentscheid">
							<xsl:value-of select="abf:Textbaustein"/>
						</xsl:for-each>
				</xsl:variable>
				<xsl:if test="string-length($ZEICHEN_NB)>$MAX_ZEICHEN_MEMO">
					<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
						<tr valign="bottom">
							<td>
								<!--div id="Titel" align="center">Seite 2</div-->
							</td>
						</tr>
						<tr>
							<td>
								<xsl:call-template name="ZeileKosten"/>
							</td>
						</tr>
					</table>
					<p style="page-break-after:always">
						<br style="height:0; line-height:0"/>
					</p>
				</xsl:if>
			</xsl:if>
		</xsl:if>
		<!---optionale weitere Personen -->
		<xsl:if test="count(abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true'])>2 or count(abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')])>2">
			<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
				<tr>
					<td>
						<xsl:call-template name="ZeilePerson"/>
					</td>
				</tr>
			</table>
			<p style="page-break-after:always">
				<br style="height:0; line-height:0"/>
			</p>
		</xsl:if>
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr valign="bottom">
				<td>
					<!--div id="Titel" align="center">Seite 2</div-->
				</td>
			</tr>
			<tr>
				<td>
					<xsl:call-template name="ZeileMore"/>
				</td>
			</tr>
		</table>
		
		<!--p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p>
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr valign="bottom">
				<td>
					<div id="Titel" align="center"></div>
				</td>
			</tr>
			<tr>
				<td>
					<xsl:call-template name="ZeileGemeinde"/>
				</td>
			</tr>
		</table-->

	</xsl:template>

	<xsl:template name="ErlaubnisKopf">
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td>
					<font id="Nummer">
						Antrag auf Erteilung einer Erlaubnis für Sammler, Beförderer, Händler und Makler<br/>von gefährlichen Abfällen
					</font>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="3%"/>
							<col width="94%"/>
						</colgroup>
						<tr>
							<td/>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:IndicatorErstmaligerAntrag'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Erstmaliger Antrag</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="3%"/>
							<col width="34%"/>
							<col width="40%"/>
							<col width="20%"/>
						</colgroup>
						<tr>
							<td/>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:IndicatorAenderungsantrag'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Änderungsantrag</td>
							<td id="Titel_klein">Vorgangsnummer (sofern von der Behörde erteilt)</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Vorgangsnummer/abf:Vorgangsnummer"/>
								&#173;
								<xsl:value-of select="abf:Vorgangsnummer/abf:Pruefziffer"/>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile1">
		<table width="100%" id="tabelle_nicht_unten">
			<tr>
				<td>
					<table id="tabelle_ohne" width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="85%"/>
							<col width="15%"/>
						</colgroup>
						<tr>
							<td id="Titel">1</td>
							<td id="Titel">Antragsteller (Hauptsitz des Betriebes)</td>
							<td/>
						</tr>
						<tr>
							<td id="Titel_klein">1.1</td>
							<td id="Titel_klein">Firma / K&#246;rperschaft</td>
							<td/>
						</tr>
						<tr>
							<td/>
							<td id="Aktuell">
								<xsl:value-of select="abf:Antragsteller/kop:Name/kop:Name1"/>
								&#173;
								<xsl:value-of select="abf:Antragsteller/kop:Name/kop:Name2"/>
							</td>
							<td/>
						</tr>
						<tr>
							<td/>
							<td id="Aktuell">
								<xsl:value-of select="abf:Antragsteller/kop:Name/kop:Name3"/>
								&#173;
								<xsl:value-of select="abf:Antragsteller/kop:Name/kop:Name4"/>
							</td>
							<td/>
						</tr>
						<tr>
							<td id="Titel_klein">1.2</td>
							<td id="Titel_klein">Straße</td>
							<td id="Titel_klein">Hausnr.</td>
						</tr>
						<tr>
							<td/>
							<td id="Aktuell">
								<xsl:value-of select="abf:Antragsteller/kop:Adresse/kop:Strasse_1"/>
								&#173;
								<xsl:value-of select="abf:Antragsteller/kop:Adresse/kop:Strasse_2"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Antragsteller/kop:Adresse/kop:Hausnummer"/>
							</td>
						</tr>
					</table>
					<table id="tabelle_ohne" width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="20%"/>
							<col width="20%"/>
							<col width="57%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">1.3</td>
							<td id="Titel_klein">Bundesland (2-stellig)</td>
							<td id="Titel_klein">PLZ</td>
							<td id="Titel_klein">Ort</td>
							<td/>
						</tr>
						<tr>
							<td/>
							<td id="Aktuell">
								<xsl:value-of select="abf:Antragsteller/abf:BundeslandAntragsteller"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Antragsteller/kop:Adresse/kop:Postleitzahl"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Antragsteller/kop:Adresse/kop:Ort_1"/>
								&#173;
								<xsl:value-of select="abf:Antragsteller/kop:Adresse/kop:Ort_2"/>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">1.4</td>
							<td id="Titel_klein">Staat (2-stellig)</td>
							<td id="Titel_klein">Gemeindeschlüssel</td>
							<td id="Titel_klein">Gemeindebezeichnung</td>
						</tr>
						<tr>
							<td/>
							<td id="Aktuell">
								<xsl:value-of select="abf:Antragsteller/kop:Adresse/kop:Staat"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Antragsteller/abf:Gemeindeschluessel"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Antragsteller/abf:Gemeindename"/>
							</td>
						</tr>
					</table>
					<table id="tabelle_ohne" width="100%">
						<tr>
							<td width="3%" id="Titel_klein">1.5</td>
							<td width="97%" id="Titel_klein">Für Antragsteller, die keinen Hauptsitz im Inland haben: Ort der erstmaligen Sammler-, Beförderer-, Händler- oder Maklertätigkeit.</td>
							<td/>
						</tr>
					</table>
					<table id="tabelle_ohne" width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="20%"/>
							<col width="20%"/>
							<col width="57%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Titel_klein">Bundesland (2-stellig)</td>
							<td id="Titel_klein">PLZ</td>
							<td id="Titel_klein">Ort</td>
							<td/>
						</tr>
						<tr>
							<td/>
							<td id="Aktuell">
								<xsl:value-of select="abf:Antragsteller/abf:ErsteTaetigkeit/abf:Bundesland"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Antragsteller/abf:ErsteTaetigkeit/abf:Postleitzahl"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Antragsteller/abf:ErsteTaetigkeit/abf:Ort_1"/>
								&#173;
								<xsl:value-of select="abf:Antragsteller/abf:ErsteTaetigkeit/abf:Ort_2"/>
							</td>
						</tr>
					</table>
					<table id="tabelle_ohne" width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="20%"/>
							<col width="77%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Titel_klein">Gemeindeschlüssel</td>
							<td id="Titel_klein">Gemeindebezeichnung</td>
							<td/>
						</tr>
						<tr>
							<td/>
							<td id="Aktuell">
								<xsl:value-of select="abf:Antragsteller/abf:ErsteTaetigkeit/abf:Gemeindeschluessel"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Antragsteller/abf:ErsteTaetigkeit/abf:Gemeindename"/>
							</td>
						</tr>
					</table>
					<table id="tabelle_ohne" width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="40%"/>
							<col width="28%"/>
							<col width="29%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">1.6</td>
							<td id="Titel_klein">Telefon</td>
							<td id="Titel_klein">Telefax</td>
							<td id="Titel_klein">USt-Identnr.</td>
							<td/>
						</tr>
						<tr>
							<td/>
							<td id="Aktuell">
								<xsl:value-of select="abf:AntragstellerWeiteres/kop:Telefon"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:AntragstellerWeiteres/kop:Telefax"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:AntragstellerWeiteres/abf:UStIdentnummer"/>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">1.7</td>
							<td id="Titel_klein">Mobiltelefon</td>
							<td id="Titel_klein">E-Mail</td>
							<td id="Titel_klein"></td>
							<td/>
						</tr>
						<tr>
							<td/>
							<td id="Aktuell">
								<xsl:value-of select="abf:AntragstellerWeiteres/abf:Mobiltelefon"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:AntragstellerWeiteres/kop:EMail"/>
							</td>
						</tr>					
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile2">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="90%"/>
				<col width="10%"/>
			</colgroup>
			<tr>
				<td id="Titel">2</td>
				<td id="Titel">Folgende abfallwirtschaftliche Tätigkeiten werden beantragt:</td>
				<td/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="3%"/>
							<col width="10%"/>
							<col width="60%"/>
							<col width="24%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">2.1</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:Taetigkeiten/abf:IndicatorSammeln'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Sammeln.</td>
							<td id="Titel_klein">Sammler- oder Beförderenummer nach § 28 NachwV (sofern bereits erteilt)</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:BehoerdlicheNummern/abf:Sammlernummer/kop:BehoerdlicheNr"/>
								&#173;
								<xsl:value-of select="abf:BehoerdlicheNummern/abf:Sammlernummer/kop:Pruefziffer"/>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">2.2</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:Taetigkeiten/abf:IndicatorBefoerdern'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Befördern.</td>
							<td id="Titel_klein">Beförderenummer nach § 28 NachwV (sofern bereits erteilt)</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:BehoerdlicheNummern/abf:Befoerderernummer/kop:BehoerdlicheNr"/>
								&#173;
								<xsl:value-of select="abf:BehoerdlicheNummern/abf:Befoerderernummer/kop:Pruefziffer"/>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">2.3</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:Taetigkeiten/abf:IndicatorHandeln'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Handeln.</td>
							<td id="Titel_klein">Händlernummer nach § 28 NachwV (sofern bereits erteilt)</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:BehoerdlicheNummern/abf:Haendlernummer/kop:BehoerdlicheNr"/>
								&#173;
								<xsl:value-of select="abf:BehoerdlicheNummern/abf:Haendlernummer/kop:Pruefziffer"/>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">2.4</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:Taetigkeiten/abf:IndicatorMakeln'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Makeln.</td>
							<td id="Titel_klein">Maklernummer nach § 28 NachwV (sofern bereits erteilt)</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:BehoerdlicheNummern/abf:Maklernummer/kop:BehoerdlicheNr"/>
								&#173;
								<xsl:value-of select="abf:BehoerdlicheNummern/abf:Maklernummer/kop:Pruefziffer"/>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="Zeile3">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="97%"/>
			</colgroup>
			<tr>
				<td id="Titel">3</td>
				<td id="Titel">Folgende Unterlagen sind dem Antrag beigefügt bzw. bei der zuständigen Stelle angefordert:</td>
				<td/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben" width="100%">
			<tr>
				<td>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="3%"/>
							<col width="94%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">3.1</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:Unterlagen/abf:Gewerbeanmeldung/abf:IndicatorDokument'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">die Gewerbeanmeldung,</td>
						</tr>
						<tr>
							<td id="Titel_klein">3.2</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:Unterlagen/abf:Registerauszug/abf:IndicatorDokument'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">ein Auszug aus dem Handels-, Vereins- oder Genossenschaftsregisterauszug, sofern eine Eintragung erfolgt ist,</td>
						</tr>
						<tr>
							<td id="Titel_klein">3.3</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:Unterlagen/abf:IndicatorGewerbezentralregister'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">eine firmenbezogene Auskunft aus dem Gewerbezentralregister (Belegart 9), sofern es sich bei dem Unternehmen um eine<br/>juristische Person oder Personenvereinigung handelt,</td>
						</tr>
						<tr>
							<td id="Titel_klein">3.4</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:Unterlagen/abf:BetriebsUmweltHaftpflicht/abf:IndicatorDokument'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">der Nachweis einer Betriebshaftpflichtversicherung und einer auf die jeweilige Tätigkeit bezogenen Umwelthaftpflichtversicherung,<br/>sofern solche Versicherungen vorhanden sin,</td>
						</tr>
						<tr>
							<td id="Titel_klein">3.5</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:Unterlagen/abf:KfzHaftpflicht/abf:IndicatorDokument'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">der Nachweis der Kraftfahrzeug-Haftpflichtversicherung bei Sammlern und Beförderern von Abfällen, die gefährliche Abfälle<br/>auf öffentlichen Straßen befördern.</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Zeile4">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="90%"/>
				<col width="10%"/>
			</colgroup>
			<tr>
				<td id="Titel">4</td>
				<td id="Titel">Betriebsinhaber</td>
				<td/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="48%"/>
							<col width="49%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">4.1</td>
							<td id="Titel_klein">Name</td>
							<td id="Titel_klein">Vorname</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
									<xsl:if test="position()=1">
										<xsl:value-of select="abf:Name"/>
									</xsl:if>
								</xsl:for-each>
								&#173;
							</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
									<xsl:if test="position()=1">
										<xsl:value-of select="abf:Vorname"/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="15%"/>
							<col width="82%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">4.2</td>
							<td id="Titel_klein">Geburtsdatum</td>
							<td id="Titel_klein">Geburtsort</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
									<xsl:if test="position()=1">
										<xsl:call-template name="formatDate">
											<xsl:with-param name="date" select="abf:Geburtsdatum"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
								&#173;
							</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
									<xsl:if test="position()=1">
										<xsl:value-of select="abf:Geburtsort1"/>
										&#173;
										<xsl:value-of select="abf:Geburtsort2"/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="55%"/>
							<col width="10%"/>
							<col width="12%"/>
							<col width="20%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">4.3</td>
							<td id="Titel_klein">Führungszeugnis (Belegart OG)</td>
							<td id="Titel_klein">Beantragt am:</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
									<xsl:if test="position()=1">
										<xsl:call-template name="formatDate">
											<xsl:with-param name="date" select="abf:UnterlagenPerson/abf:DatumAntragFuehrungszeugnis"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
							</td>
							<td id="Titel_klein">Wird unmittelbar an<br/>die Behörde übersandt.</td>
						</tr>
						<tr>
							<td id="Titel_klein">4.4</td>
							<td id="Titel_klein">Personenbezogene Auskunft aus dem Gewerbezentralregister (Belegart 9)</td>
							<td id="Titel_klein">Beantragt am:</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
									<xsl:if test="position()=1">
										<xsl:call-template name="formatDate">
											<xsl:with-param name="date" select="abf:UnterlagenPerson/abf:DatumAntragGewerbezentralregister"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
							</td>
							<td id="Titel_klein">Wird unmittelbar an<br/>die Behörde übersandt.</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%" valign="top"/>
							<col width="65%" valign="top"/>
							<col width="32%" valign="top"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">4.5</td>
							<td id="Titel_klein">Ein Nachweis der Fachkunde ist beigefügt (sofern der Betriebsinhaber selbst die<br/>Leitung und Beaufsichtigung des Betriebes wahrnimmt.</td>
							<td id="Aktuell">
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
												<xsl:if test="position()=1">
													<xsl:call-template name="getBooleanValue">
														<xsl:with-param name="TagName" select="'abf:UnterlagenPerson/abf:DokumentFachkunde/abf:IndicatorDokument'"/>
													</xsl:call-template>
												</xsl:if>
											</xsl:for-each>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="48%"/>
							<col width="49%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Titel_klein">Weiterer Betriebsinhaber (sofern vorhanden)</td>
							<td id="Titel_klein"></td>
						</tr>
						<tr>
							<td id="Titel_klein">4.6</td>
							<td id="Titel_klein">Name</td>
							<td id="Titel_klein">Vorname</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
									<xsl:if test="position()=2">
										<xsl:value-of select="abf:Name"/>
									</xsl:if>
								</xsl:for-each>
								&#173;
							</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
									<xsl:if test="position()=2">
										<xsl:value-of select="abf:Vorname"/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="15%"/>
							<col width="82%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">4.7</td>
							<td id="Titel_klein">Geburtsdatum</td>
							<td id="Titel_klein">Geburtsort</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
									<xsl:if test="position()=2">
										<xsl:call-template name="formatDate">
											<xsl:with-param name="date" select="abf:Geburtsdatum"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
								&#173;
							</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
									<xsl:if test="position()=2">
										<xsl:value-of select="abf:Geburtsort1"/>
										&#173;
										<xsl:value-of select="abf:Geburtsort2"/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="55%"/>
							<col width="10%"/>
							<col width="12%"/>
							<col width="20%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">4.8</td>
							<td id="Titel_klein">Führungszeugnis (Belegart OG)</td>
							<td id="Titel_klein">Beantragt am:</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
									<xsl:if test="position()=2">
										<xsl:call-template name="formatDate">
											<xsl:with-param name="date" select="abf:UnterlagenPerson/abf:DatumAntragFuehrungszeugnis"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
							</td>
							<td id="Titel_klein">Wird unmittelbar an<br/>die Behörde übersandt.</td>
						</tr>
						<tr>
							<td id="Titel_klein">4.9</td>
							<td id="Titel_klein">Personenbezogene Auskunft aus dem Gewerbezentralregister (Belegart 9)</td>
							<td id="Titel_klein">Beantragt am:</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
									<xsl:if test="position()=2">
										<xsl:call-template name="formatDate">
											<xsl:with-param name="date" select="abf:UnterlagenPerson/abf:DatumAntragGewerbezentralregister"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
							</td>
							<td id="Titel_klein">Wird unmittelbar an<br/>die Behörde übersandt.</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%" valign="top"/>
							<col width="65%" valign="top"/>
							<col width="32%" valign="top"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">4.10</td>
							<td id="Titel_klein">Ein Nachweis der Fachkunde ist beigefügt (sofern der Betriebsinhaber selbst die<br/>Leitung und Beaufsichtigung des Betriebes wahrnimmt.</td>
							<td id="Aktuell">
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
												<xsl:if test="position()=2">
													<xsl:call-template name="getBooleanValue">
														<xsl:with-param name="TagName" select="'abf:UnterlagenPerson/abf:DokumentFachkunde/abf:IndicatorDokument'"/>
													</xsl:call-template>
												</xsl:if>
											</xsl:for-each>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	
	</xsl:template>

	<xsl:template name="Zeile5">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="90%"/>
				<col width="10%"/>
			</colgroup>
			<tr>
				<td id="Titel">5</td>
				<td>
					<font id="Titel">
						<xsl:value-of select="'Für die Leitung und Beaufsichtigung des Betriebes verantwortliche Person'"/>
					</font>
					&#173;
					<font id="Titel_winzig">
						<xsl:value-of select="'(sofern nicht mit dem Betriebsinhaber identisch)'"/>
					</font>
				</td>
				<td/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="48%"/>
							<col width="49%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">5.1</td>
							<td id="Titel_klein">Name</td>
							<td id="Titel_klein">Vorname</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
									<xsl:if test="position()=1">
										<xsl:value-of select="abf:Name"/>
									</xsl:if>
								</xsl:for-each>
								&#173;
							</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
									<xsl:if test="position()=1">
										<xsl:value-of select="abf:Vorname"/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="15%"/>
							<col width="82%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">5.2</td>
							<td id="Titel_klein">Geburtsdatum</td>
							<td id="Titel_klein">Geburtsort</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
									<xsl:if test="position()=1">
										<xsl:call-template name="formatDate">
											<xsl:with-param name="date" select="abf:Geburtsdatum"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
								&#173;
							</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
									<xsl:if test="position()=1">
										<xsl:value-of select="abf:Geburtsort1"/>
										&#173;
										<xsl:value-of select="abf:Geburtsort2"/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="55%"/>
							<col width="10%"/>
							<col width="12%"/>
							<col width="20%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">5.3</td>
							<td id="Titel_klein">Führungszeugnis (Belegart OG)</td>
							<td id="Titel_klein">Beantragt am:</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
									<xsl:if test="position()=1">
										<xsl:call-template name="formatDate">
											<xsl:with-param name="date" select="abf:UnterlagenPerson/abf:DatumAntragFuehrungszeugnis"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
							</td>
							<td id="Titel_klein">Wird unmittelbar an<br/>die Behörde übersandt.</td>
						</tr>
						<tr>
							<td id="Titel_klein">5.4</td>
							<td id="Titel_klein">Personenbezogene Auskunft aus dem Gewerbezentralregister (Belegart 9)</td>
							<td id="Titel_klein">Beantragt am:</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
									<xsl:if test="position()=1">
										<xsl:call-template name="formatDate">
											<xsl:with-param name="date" select="abf:UnterlagenPerson/abf:DatumAntragGewerbezentralregister"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
							</td>
							<td id="Titel_klein">Wird unmittelbar an<br/>die Behörde übersandt.</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="65%"/>
							<col width="32%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">5.5</td>
							<td id="Titel_klein">Ein Nachweis der Fachkunde ist beigefügt.</td>
							<td id="Aktuell">
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
												<xsl:if test="position()=1">
													<xsl:call-template name="getBooleanValue">
														<xsl:with-param name="TagName" select="'abf:UnterlagenPerson/abf:DokumentFachkunde/abf:IndicatorDokument'"/>
													</xsl:call-template>
												</xsl:if>
											</xsl:for-each>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		
		<table id="Tabelle" width="100%">
			<tr>
				<td>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="97%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Titel_klein">Weitere für die Leitung und Beaufsichtigung des Betriebes verantwortliche Person (sofern vorhanden)</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="48%"/>
							<col width="49%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">5.6</td>
							<td id="Titel_klein">Name</td>
							<td id="Titel_klein">Vorname</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
									<xsl:if test="position()=2">
										<xsl:value-of select="abf:Name"/>
									</xsl:if>
								</xsl:for-each>
								&#173;
							</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
									<xsl:if test="position()=2">
										<xsl:value-of select="abf:Vorname"/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="15%"/>
							<col width="82%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">5.7</td>
							<td id="Titel_klein">Geburtsdatum</td>
							<td id="Titel_klein">Geburtsort</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
									<xsl:if test="position()=2">
										<xsl:call-template name="formatDate">
											<xsl:with-param name="date" select="abf:Geburtsdatum"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
								&#173;
							</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
									<xsl:if test="position()=2">
										<xsl:value-of select="abf:Geburtsort1"/>
										&#173;
										<xsl:value-of select="abf:Geburtsort2"/>
									</xsl:if>
								</xsl:for-each>
							</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="55%"/>
							<col width="10%"/>
							<col width="12%"/>
							<col width="20%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">5.8</td>
							<td id="Titel_klein">Führungszeugnis (Belegart OG)</td>
							<td id="Titel_klein">Beantragt am:</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
									<xsl:if test="position()=2">
										<xsl:call-template name="formatDate">
											<xsl:with-param name="date" select="abf:UnterlagenPerson/abf:DatumAntragFuehrungszeugnis"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
							</td>
							<td id="Titel_klein">Wird unmittelbar an<br/>die Behörde übersandt.</td>
						</tr>
						<tr>
							<td id="Titel_klein">5.9</td>
							<td id="Titel_klein">Personenbezogene Auskunft aus dem Gewerbezentralregister (Belegart 9)</td>
							<td id="Titel_klein">Beantragt am:</td>
							<td id="Aktuell">
								<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
									<xsl:if test="position()=2">
										<xsl:call-template name="formatDate">
											<xsl:with-param name="date" select="abf:UnterlagenPerson/abf:DatumAntragGewerbezentralregister"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
							</td>
							<td id="Titel_klein">Wird unmittelbar an<br/>die Behörde übersandt.</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="65%"/>
							<col width="32%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">5.10</td>
							<td id="Titel_klein">Ein Nachweis der Fachkunde ist beigefügt.</td>
							<td id="Aktuell">
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
												<xsl:if test="position()=2">
													<xsl:call-template name="getBooleanValue">
														<xsl:with-param name="TagName" select="'abf:UnterlagenPerson/abf:DokumentFachkunde/abf:IndicatorDokument'"/>
													</xsl:call-template>
												</xsl:if>
											</xsl:for-each>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	
	</xsl:template>

	<xsl:template name="Zeile6">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="97%"/>
			</colgroup>
			<tr>
				<td id="Titel">6</td>
				<td>
					<font id="Titel">
						<xsl:value-of select="'Frei für Vermerke des Anzeigenden'"/>
					</font>
					&#173;
					<font id="Titel_winzig">
						<xsl:value-of select="'(Angaben freiwillig)'"/>
					</font>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="97%" valign="top"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">6.1</td>
				<td height="200">
					<font id="Aktuell">
						<xsl:value-of select="abf:Vermerke"/>
					</font>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="Zeile7">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="97%" valign="top"/>
			</colgroup>
			<tr>
				<td id="Titel">7</td>
				<td>
					<font id="Titel">
						<xsl:value-of select="'Versicherung und Unterschift'"/>
					</font>
				</td>
			</tr>
			<tr>
				<td id="Titel_klein">7.1</td>
				<td>
					<font id="Titel_klein">Es wird versichert, dass</font>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="1%" valign="top"/>
				<col width="96%" valign="top"/>
			</colgroup>
			<tr>
				<td/>
				<td id="Titel_klein">-</td>
				<td>
					<font id="Titel_klein">der Antrag nach bestem Wissen ausgefüllt wurde,</font>
				</td>
			</tr>
			<tr>
				<td/>
				<td id="Titel_klein">-</td>
				<td>
					<font id="Titel_klein">bei der Tätigkeit des Sammelns, Beförderns, Handelns oder Makelns von Abfällen alle einschlägigen Vorschriften, insbesondere die<br/>Vorgaben des Kreislaufwirtschaftsgesetzes und der auf Grund dieses Gesetzes ergangenen Rechtsverordnungen, eingehalten werden,</font>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="47%"/>
				<col width="50%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">7.2</td>
				<td id="Titel_klein">Ort</td>
				<td id="Titel_klein">Unterschrift</td>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Aktuell">
					<xsl:value-of select="abf:Versicherung/abf:Ort"/>
				</td>
				<td/>
			</tr>
			<tr>
				<td id="Titel_klein">7.3</td>
				<td id="Titel_klein">Datum (TT.MM.JJJJ)</td>
				<td id="Titel_klein"></td>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="abf:Versicherung/abf:Datum"/>
					</xsl:call-template>
				</td>
				<td/>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="ZeileErl1">
		<table id="Tabelle" width="100%">
			<tr>
				<td>
					<font id="Nummer">Erlaubnis für Sammler, Beförderer, Händler und Makler von gefährlichen Abfällen</font>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="47%" valign="top"/>
				<col width="3%" valign="top"/>
				<col width="47%" valign="top"/>
			</colgroup>
			<tr>
				<td height="10"/>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Erlaubnisinhaber</td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Erlaubnis erteilende Behörde</td>
			</tr>
			<tr>
				<td/>
				<td id="Aktuell">
					<xsl:value-of select="abf:Antragsteller/kop:Name/kop:Name1"/>
					&#173;
					<xsl:value-of select="abf:Antragsteller/kop:Name/kop:Name2"/>
					<br/>
					<xsl:value-of select="abf:Antragsteller/kop:Name/kop:Name3"/>
					&#173;
					<xsl:value-of select="abf:Antragsteller/kop:Name/kop:Name4"/>
					<br/>
					<xsl:value-of select="abf:Antragsteller/kop:Adresse/kop:Strasse_1"/>
					&#173;
					<xsl:value-of select="abf:Antragsteller/kop:Adresse/kop:Strasse_2"/>
					&#173;
					<xsl:value-of select="abf:Antragsteller/kop:Adresse/kop:Hausnummer"/>
					<br/>
					<xsl:value-of select="abf:Antragsteller/kop:Adresse/kop:Postleitzahl"/>
					&#173;
					<xsl:value-of select="abf:Antragsteller/kop:Adresse/kop:Ort_1"/>
					&#173;
					<xsl:value-of select="abf:Antragsteller/kop:Adresse/kop:Ort_2"/>
				</td>
				<td id="Titel"></td>
				<td id="Aktuell">
					<xsl:value-of select="abf:Bescheid/abf:Behoerde/abf:Adresse/kop:Name/kop:Name1"/>
					&#173;
					<xsl:value-of select="abf:Bescheid/abf:Behoerde/abf:Adresse/kop:Name/kop:Name2"/>
					<br/>
					<xsl:value-of select="abf:Bescheid/abf:Behoerde/abf:Adresse/kop:Name/kop:Name3"/>
					&#173;
					<xsl:value-of select="abf:Bescheid/abf:Behoerde/abf:Adresse/kop:Name/kop:Name4"/>
					<br/>
					<xsl:value-of select="abf:Bescheid/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Strasse_1"/>
					&#173;
					<xsl:value-of select="abf:Bescheid/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Strasse_2"/>
					&#173;
					<xsl:value-of select="abf:Bescheid/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Hausnummer"/>
					<br/>
					<xsl:value-of select="abf:Bescheid/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Postleitzahl"/>
					&#173;
					<xsl:value-of select="abf:Bescheid/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Ort_1"/>
					&#173;
					<xsl:value-of select="abf:Bescheid/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Ort_2"/>
					<xsl:if test="string-length(abf:Bescheid/abf:Behoerde/abf:Ansprechpartner/kop:Name)>0">
						<br/>
						<br/>
						<xsl:value-of select="abf:Bescheid/abf:Behoerde/abf:Ansprechpartner/kop:Name"/>
						<br/>
						<xsl:value-of select="abf:Bescheid/abf:Behoerde/abf:Ansprechpartner/kop:Telefon"/>
						<br/>
						<xsl:value-of select="abf:Bescheid/abf:Behoerde/abf:Ansprechpartner/kop:EMail"/>
					</xsl:if>
				</td>
			</tr>
			<tr>
				<td height="10"/>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein"></td>
				<td>
					<font id="Titel_klein">Vorgangsnummer:</font>
					&#173;&#173;
					<font id="Aktuell">
						<xsl:value-of select="abf:Vorgangsnummer/abf:Vorgangsnummer"/>
						&#173;
						<xsl:value-of select="abf:Vorgangsnummer/abf:Pruefziffer"/>
					</font>
				</td>
			</tr>
			<tr>
				<td height="10"/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td id="Titel">1. Erlaubniserteilung</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="25%"/>
				<col width="10%"/>
				<col width="65%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">Auf Grund des Antrags vom</td>
				<td id="Aktuell">
						<xsl:call-template name="formatDate">
							<xsl:with-param name="date" select="abf:Verwaltungsinformationen/abf:Eingangsdatum"/>
						</xsl:call-template>
				</td>
				<td id="Titel_klein">(TT.MM.JJJJ) wird Ihnen gemäß $ 54 Absatz 1 Satz 1 KrWG die Erlaubnis erteilt zum</td>
			</tr>
		</table>

		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="10%"/>
				<col width="10%"/>
				<col width="57%"/>
				<col width="20%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein">1.1</td>
				<td id="Titel_klein">Sammeln.</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'abf:Taetigkeiten/abf:IndicatorSammeln'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel_klein">Es wird folgende Sammlernummer nach § 28 NachwV erteilt:</td>
				<td id="Aktuell">
					<xsl:value-of select="abf:BehoerdlicheNummern/abf:Sammlernummer/kop:BehoerdlicheNr"/>
					&#173;
					<xsl:value-of select="abf:BehoerdlicheNummern/abf:Sammlernummer/kop:Pruefziffer"/>
				</td>
			</tr>
			<tr>
				<td id="Titel_klein">1.2</td>
				<td id="Titel_klein">Befördern.</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'abf:Taetigkeiten/abf:IndicatorBefoerdern'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel_klein">Es wird folgende Beförderernummer nach § 28 NachwV erteilt:</td>
				<td id="Aktuell">
					<xsl:value-of select="abf:BehoerdlicheNummern/abf:Befoerderernummer/kop:BehoerdlicheNr"/>
					&#173;
					<xsl:value-of select="abf:BehoerdlicheNummern/abf:Befoerderernummer/kop:Pruefziffer"/>
				</td>
			</tr>
			<tr>
				<td id="Titel_klein">1.3</td>
				<td id="Titel_klein">Handeln</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'abf:Taetigkeiten/abf:IndicatorHandeln'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel_klein">Es wird folgende Händlernummer nach § 28 NachwV erteilt:</td>
				<td id="Aktuell">
					<xsl:value-of select="abf:BehoerdlicheNummern/abf:Haendlernummer/kop:BehoerdlicheNr"/>
					&#173;
					<xsl:value-of select="abf:BehoerdlicheNummern/abf:Haendlernummer/kop:Pruefziffer"/>
				</td>
			</tr>
			<tr>
				<td id="Titel_klein">1.4</td>
				<td id="Titel_klein">Makeln</td>
				<td>
					<table id="Tabelle_indikator">
						<tr>
							<td>
								<xsl:call-template name="getBooleanValue">
									<xsl:with-param name="TagName" select="'abf:Taetigkeiten/abf:IndicatorMakeln'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td id="Titel_klein">Es wird folgende Maklernummer nach § 28 NachwV erteilt:</td>
				<td id="Aktuell">
					<xsl:value-of select="abf:BehoerdlicheNummern/abf:Maklernummer/kop:BehoerdlicheNr"/>
					&#173;
					<xsl:value-of select="abf:BehoerdlicheNummern/abf:Maklernummer/kop:Pruefziffer"/>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td id="Titel">2. Beschränkungen und Nebenbestimmungen</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="97%" valign="top"/>
			</colgroup>
			<xsl:choose>
				<xsl:when test="count(abf:Bescheid/abf:Nebenbestimmung)>0">
					<xsl:variable name="ZEICHEN_NB">
							<xsl:for-each select="abf:Bescheid/abf:Nebenbestimmung">
								<xsl:value-of select="abf:Textbaustein"/>
							</xsl:for-each>
							<xsl:for-each select="abf:Bescheid/abf:Begruendung">
								<xsl:value-of select="abf:Textbaustein"/>
							</xsl:for-each>
					</xsl:variable>
					<xsl:message>Zeichen NB: 
						<xsl:value-of select="string-length($ZEICHEN_NB)"/>
					</xsl:message>
					<xsl:choose>
						<xsl:when test="string-length($ZEICHEN_NB)>$MAX_ZEICHEN_MEMO">
							<tr>
								<td id="Titel"></td>
								<td height="275" id="Aktuell">siehe Beiblatt
								</td>
							</tr>
						</xsl:when>
						<xsl:otherwise>
							<tr>
								<td id="Titel"></td>
								<td height="275">
									<font id="Titel_klein">Nebenbestimmungen:</font><br/>
									<font id="Aktuell_klein">
										<xsl:for-each select="abf:Bescheid/abf:Nebenbestimmung">
											<xsl:value-of select="@kop:Index"/>.
											&#173;
											<xsl:value-of select="abf:Textbaustein"/>
											<br/>
										</xsl:for-each>
									</font>
									<font id="Titel_klein">Begründungen:</font><br/>
									<xsl:for-each select="abf:Bescheid/abf:Begruendung">
										<font id="Aktuell_klein">
											<xsl:value-of select="@kop:Index"/>.
										</font>
										&#173;
										<font id="Titel_klein">
											<xsl:if test="abf:ZuNB"> zu Nebenbestimmung </xsl:if>
										</font>
										<font id="Aktuell_klein">
											<xsl:value-of select="abf:ZuNB"/>: <xsl:value-of select="abf:Textbaustein"/>
										</font>
										<br/>
									</xsl:for-each>
								</td>
							</tr>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td height="275"/>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td id="Titel">3. Kostenentscheidungen</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="97%" valign="top"/>
			</colgroup>
			<xsl:choose>
				<xsl:when test="count(abf:Bescheid/abf:Kostenentscheid)>0">
					<xsl:variable name="ZEICHEN_NB">
							<xsl:for-each select="abf:Bescheid/abf:Kostenentscheid">
								<xsl:value-of select="abf:Textbaustein"/>
							</xsl:for-each>
					</xsl:variable>
					<xsl:message>Zeichen NB: 
						<xsl:value-of select="string-length($ZEICHEN_NB)"/>
					</xsl:message>
					<xsl:choose>
						<xsl:when test="string-length($ZEICHEN_NB)>$MAX_ZEICHEN_MEMO">
							<tr>
								<td id="Titel"></td>
								<td height="275" id="Aktuell">siehe Beiblatt
								</td>
							</tr>
						</xsl:when>
						<xsl:otherwise>
							<tr>
								<td id="Titel"></td>
								<td height="275" id="Aktuell_klein">
									<xsl:for-each select="abf:Bescheid/abf:Kostenentscheid">
										<xsl:value-of select="position()"/>.
										&#173;
										<xsl:value-of select="abf:Textbaustein"/>
										<br/>
									</xsl:for-each>
								</td>
							</tr>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td height="275"/>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
		</table>
	</xsl:template>
	
	<xsl:template name="ZeileErl2">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="97%" valign="top"/>
			</colgroup>
			<tr>
				<td id="Titel">4.</td>
				<td id="Titel">Rechtsbehelfsbelehrung</td>
			</tr>
			<tr>
				<td id="Aktuell">&#173;</td>
				<td height="300" id="Aktuell">
					<xsl:value-of select="abf:Bescheid/abf:Rechtsbehelf"/>
				</td>
			</tr>
			<tr>
				<td id="Titel">5</td>
				<td id="Titel">Hinweise</td>
				<td/>
			</tr>
			<tr>
				<td id="Titel_klein">5.1</td>
				<td id="Titel_klein">Sammler und Beförderer von gefährlichen Abfällen haben bei Ausübung ihrer Tätigkeit eine Kopie oder einen Ausdruck dieser Erlaubnis<br/> mitzuführen.</td>
			</tr>
			<tr>
				<td id="Titel_klein">5.2</td>
				<td id="Titel_klein">Ändern sich wesentliche Angaben, so ist die Anzeige erneut zu beantragen.<br/>Wesentliche Angaben sind die Felder 1.1 bis 1.4 und 2 bis 6.</td>
			</tr>
			<tr>
				<td id="Titel_klein">5.3</td>
				<td id="Titel_klein">Ändern sich die im Antrag in Feld 5 angegebenen für die Leitung und Beaufsichtigung des Betriebs verantwortlichen Personen, ist dies<br/>der Behörde unverzüglich anzuzeigen.</td>
			</tr>
			<tr>
				<td id="Titel_klein">5.4</td>
				<td id="Titel_klein">Frei für Hinweise der Behörde</td>
			</tr>
			<xsl:choose>
				<xsl:when test="count(abf:Bescheid/abf:Hinweis)>0">
					<tr>
						<td id="Titel"></td>
						<td height="300" id="Aktuell_klein">
							<xsl:for-each select="abf:Bescheid/abf:Hinweis">
								<xsl:value-of select="position()"/>.
								&#173;
								<xsl:value-of select="abf:Textbaustein"/>
								<br/>
							</xsl:for-each>
						</td>
					</tr>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td height="300" id="Titel"></td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
		</table>
		<table id="Tabelle_nicht_oben" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="47%" valign="top"/>
				<col width="3%" valign="top"/>
				<col width="47%" valign="top"/>
			</colgroup>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Ort</td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Unterschrift</td>
			</tr>
			<tr>
				<td id="Aktuell">&#173;</td>
				<td id="Aktuell">
					<xsl:value-of select="abf:Bescheid/abf:Bestaetigung/abf:Ort"/>
				</td>
				<td id="Titel_klein"></td>
				<td id="Aktuell">
					<xsl:value-of select="abf:Bescheid/abf:Bestaetigung/abf:Name"/>
				</td>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Datum (TT.MM.JJJJ)</td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein"></td>
			</tr>
			<tr>
				<td id="Aktuell">&#173;</td>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="abf:Bescheid/abf:Bestaetigung/abf:Datum"/>
					</xsl:call-template>
				</td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein"></td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="ZeileEB">
		<table id="Tabelle" width="100%">
			<tr>
				<td>
					<font id="Nummer">Bestätigung des Eingangs des vollständigen Antrags auf Erteilung einer<br/>Erlaubnis für Sammler, Beförderer, Händler und Makler von gefährlichen Abfällen</font>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="47%" valign="top"/>
				<col width="3%" valign="top"/>
				<col width="47%" valign="top"/>
			</colgroup>
			<tr>
				<td height="10"/>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Antragsteller</td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Zuständige Behörde</td>
			</tr>
			<tr>
				<td/>
				<td id="Aktuell">
					<xsl:value-of select="abf:Antragsteller/kop:Name/kop:Name1"/>
					&#173;
					<xsl:value-of select="abf:Antragsteller/kop:Name/kop:Name2"/>
					<br/>
					<xsl:value-of select="abf:Antragsteller/kop:Name/kop:Name3"/>
					&#173;
					<xsl:value-of select="abf:Antragsteller/kop:Name/kop:Name4"/>
					<br/>
					<xsl:value-of select="abf:Antragsteller/kop:Adresse/kop:Strasse_1"/>
					&#173;
					<xsl:value-of select="abf:Antragsteller/kop:Adresse/kop:Strasse_2"/>
					&#173;
					<xsl:value-of select="abf:Antragsteller/kop:Adresse/kop:Hausnummer"/>
					<br/>
					<xsl:value-of select="abf:Antragsteller/kop:Adresse/kop:Postleitzahl"/>
					&#173;
					<xsl:value-of select="abf:Antragsteller/kop:Adresse/kop:Ort_1"/>
					&#173;
					<xsl:value-of select="abf:Antragsteller/kop:Adresse/kop:Ort_2"/>
				</td>
				<td id="Titel"></td>
				<td id="Aktuell">
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Adresse/kop:Name/kop:Name1"/>
					&#173;
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Adresse/kop:Name/kop:Name2"/>
					<br/>
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Adresse/kop:Name/kop:Name3"/>
					&#173;
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Adresse/kop:Name/kop:Name4"/>
					<br/>
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Strasse_1"/>
					&#173;
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Strasse_2"/>
					&#173;
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Hausnummer"/>
					<br/>
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Postleitzahl"/>
					&#173;
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Ort_1"/>
					&#173;
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Adresse/kop:Adresse/kop:Ort_2"/>
					<xsl:if test="string-length(abf:Eingangsbestaetigung/abf:Behoerde/abf:Ansprechpartner/kop:Name)>0">
						<br/>
						<br/>
						<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Ansprechpartner/kop:Name"/>
						<br/>
						<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Ansprechpartner/kop:Telefon"/>
						<br/>
						<xsl:value-of select="abf:Eingangsbestaetigung/abf:Behoerde/abf:Ansprechpartner/kop:EMail"/>
					</xsl:if>
				</td>
			</tr>
			<tr>
				<td height="10"/>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein"></td>
				<td>
					<font id="Titel_klein">Vorgangsnummer:</font>
					&#173;&#173;
					<font id="Aktuell">
						<xsl:value-of select="abf:Vorgangsnummer/abf:Vorgangsnummer"/>
						&#173;
						<xsl:value-of select="abf:Vorgangsnummer/abf:Pruefziffer"/>
					</font>
				</td>
			</tr>
			<tr>
				<td height="10"/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="45%"/>
				<col width="10%"/>
				<col width="42%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Hiermit bestätige ich Ihnen den Eingang Ihres Antrags vom</td>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="abf:Versicherung/abf:Datum"/>
					</xsl:call-template>
				</td>
				<td id="Titel_klein">auf Erteilung einer Erlaubnis Ihrer abfallwirtschaftlichen</td>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Tätigkeit bezogen auf gefährliche Abfälle. Der Antrag ist hier am</td>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="abf:Verwaltungsinformationen/abf:Eingangsdatum"/>
					</xsl:call-template>
				</td>
				<td id="Titel_klein">eingegangen und liegt vollständig vor.</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="97%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Sollten Sie von hier aus keine weitere Nachricht erhalten, gilt die Erlaubnis nach Ablauf von drei Monaten nach Antragseingang als erteilt (§ 54<br/>Absatz 6 Satz 2 des Kreislaufwirtschaftsgesetzes in Verbindung mit § 42a des Verwaltungsverfahrensgesetzes).</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="27%"/>
				<col width="15%"/>
				<col width="30%"/>
				<col width="25%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Die dreimonatige Frist hat am</td>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="abf:Eingangsbestaetigung/abf:Frist"/>
					</xsl:call-template>
				</td>
				<td id="Titel_klein">begonnen und endet am</td>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="abf:Eingangsbestaetigung/abf:DreiMonatsFrist"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="97%" valign="top"/>
			</colgroup>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Sollte Ihr Antrag auf Erlaubnis abgelehnt werden, dann stehen Ihnen folgende Rechtsbehelfe zur Verfügung:</td>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Aktuell" height="300">
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Rechtsbehelf"/>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="47%"/>
				<col width="3%"/>
				<col width="47%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Ort</td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Unterschrift</td>
			</tr>
			<tr>
				<td id="Aktuell">&#173;</td>
				<td id="Aktuell">
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Bestaetigung/abf:Ort"/>
				</td>
				<td id="Titel_klein"></td>
				<td id="Aktuell">
					<xsl:value-of select="abf:Eingangsbestaetigung/abf:Bestaetigung/abf:Name"/>
				</td>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Datum (TT.MM.JJJJ)</td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein"></td>
			</tr>
			<tr>
				<td id="Aktuell">&#173;</td>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="abf:Eingangsbestaetigung/abf:Bestaetigung/abf:Datum"/>
					</xsl:call-template>
				</td>
				<td id="Titel_klein"></td>
				<td id="Titel_klein"></td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben" width="100%">
			<tbody>
				<tr>
					<th></th>
				</tr>
			</tbody>
		</table>
	</xsl:template>
	
	<xsl:template name="ZeileMore">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="97%"/>
			</colgroup>
			<tr>
				<td id="Titel"></td>
				<td>
					<font id="Titel">Befristung oder Widerruf durch die Behörde</font>
				</td>
			</tr>
			<tr>
				<td height="10"/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="30%"/>
				<col width="15%"/>
				<col width="26%"/>
				<col width="36%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Erlaubnis gültig von</td>
				<td id="Titel_klein">bis</td>
				<td id="Titel_klein">Gültigkeit widerrufen am</td>
				<td id="Titel_klein"></td>
			</tr>
			<tr>
				<td/>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="abf:Bescheid/abf:Befristung/abf:GueltigVon"/>
					</xsl:call-template>
					&#173;
				</td>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="abf:Bescheid/abf:Befristung/abf:GueltigBis"/>
					</xsl:call-template>
				</td>
				<td id="Aktuell">
					<xsl:call-template name="formatDate">
						<xsl:with-param name="date" select="abf:Bescheid/abf:Befristung/abf:Widerruf"/>
					</xsl:call-template>
				</td>
				<td id="Aktuell">
				</td>
			</tr>
		</table>
	</xsl:template>

	<!--xsl:template name="ZeileGemeinde">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="97%"/>
			</colgroup>
			<tr>
				<td id="Titel"></td>
				<td>
					<font id="Titel">Informationen zur Gemeinde</font>
				</td>
			</tr>
			<tr>
				<td height="10"/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="30%"/>
				<col width="67%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Gemeindeschlüssel</td>
				<td id="Titel_klein">Gemeindebezeichnung</td>
			</tr>
			<tr>
				<td/>
				<td id="Aktuell">
					<xsl:value-of select="abf:Antragsteller/abf:Gemeindeschluessel"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="abf:Antragsteller/abf:Gemeindename"/>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="97%"/>
			</colgroup>
			<tr>
				<td height="15"/>
			</tr>
			<tr>
				<td id="Titel_klein"></td>
				<td>
					<font id="Titel_klein">1.5 Für Antragsteller, die keinen Hauptsitz im Inland haben: Ort der erstmaligen Sammler-, Beförderer-, Händler- oder Maklertätigkeit</font>
				</td>
			</tr>
			<tr>
				<td height="10"/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="30%"/>
				<col width="67%"/>
			</colgroup>
			<tr>
				<td id="Titel_klein"></td>
				<td id="Titel_klein">Gemeindeschlüssel</td>
				<td id="Titel_klein">Gemeindebezeichnung</td>
			</tr>
			<tr>
				<td/>
				<td id="Aktuell">
					<xsl:value-of select="abf:Antragsteller/abf:ErsteTaetigkeit/abf:Gemeindeschluessel"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="abf:Antragsteller/abf:ErsteTaetigkeit/abf:Gemeindename"/>
				</td>
			</tr>
		</table>
	</xsl:template-->
	
	<xsl:template name="ZeileBeiblatt">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="97%"/>
			</colgroup>
			<tr>
				<td id="Titel"></td>
				<td>
					<font id="Titel">Beiblatt Beschränkungen und Nebenbestimmungen</font>
				</td>
			</tr>
			<tr>
				<td height="10"/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="97%" valign="top"/>
			</colgroup>
			<xsl:if test="count(abf:Bescheid/abf:Nebenbestimmung)>0">
				<xsl:variable name="ZEICHEN_NB">
						<xsl:for-each select="abf:Bescheid/abf:Nebenbestimmung">
							<xsl:value-of select="abf:Textbaustein"/>
						</xsl:for-each>
						<xsl:for-each select="abf:Bescheid/abf:Begruendung">
							<xsl:value-of select="abf:Textbaustein"/>
						</xsl:for-each>
				</xsl:variable>
				<xsl:if test="string-length($ZEICHEN_NB)>$MAX_ZEICHEN_MEMO">
					<tr>
						<td id="Titel_klein"></td>
						<td id="Titel_klein">Nebenbestimmungen:</td>
					</tr>
					<tr>
						<td id="Titel"></td>
						<td id="Aktuell_klein">
							<xsl:for-each select="abf:Bescheid/abf:Nebenbestimmung">
								<xsl:value-of select="@kop:Index"/>.
								&#173;
								<xsl:value-of select="abf:Textbaustein"/>
								<br/>
							</xsl:for-each>
						</td>
					</tr>
					<xsl:if test="count(abf:Bescheid/abf:Begruendung)>0">
						<tr>
							<td id="Titel_klein"></td>
							<td id="Titel_klein">Begründungen:</td>
						</tr>
						<tr>
							<td id="Titel"></td>
							<td>
								<xsl:for-each select="abf:Bescheid/abf:Begruendung">
									<font id="Aktuell_klein">
										<xsl:value-of select="@kop:Index"/>.
									</font>
									&#173;
									<font id="Titel_klein">
										<xsl:if test="abf:ZuNB"> zu Nebenbestimmung </xsl:if>
									</font>
									<font id="Aktuell_klein">
										<xsl:value-of select="abf:ZuNB"/>: <xsl:value-of select="abf:Textbaustein"/>
									</font>
									<br/>
								</xsl:for-each>
							</td>
						</tr>
					</xsl:if>
				</xsl:if>
			</xsl:if>
		</table>
	</xsl:template>

	<xsl:template name="ZeileKosten">
		<table id="Tabelle_nicht_unten" width="100%">
			<colgroup>
				<col width="3%"/>
				<col width="97%"/>
			</colgroup>
			<tr>
				<td id="Titel"></td>
				<td>
					<font id="Titel">Beiblatt Kostenentscheidung</font>
				</td>
			</tr>
			<tr>
				<td height="10"/>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben" width="100%">
			<colgroup>
				<col width="3%" valign="top"/>
				<col width="97%" valign="top"/>
			</colgroup>
			<xsl:if test="count(abf:Bescheid/abf:Kostenentscheid)>0">
				<xsl:variable name="ZEICHEN_NB">
						<xsl:for-each select="abf:Bescheid/abf:Kostenentscheid">
							<xsl:value-of select="abf:Textbaustein"/>
						</xsl:for-each>
				</xsl:variable>
				<xsl:if test="string-length($ZEICHEN_NB)>$MAX_ZEICHEN_MEMO">
					<tr>
						<td id="Titel"></td>
						<td id="Aktuell_klein">
							<xsl:for-each select="abf:Bescheid/abf:Kostenentscheid">
								<xsl:value-of select="position()"/>.
								&#173;
								<xsl:value-of select="abf:Textbaustein"/>
								<br/>
							</xsl:for-each>
						</td>
					</tr>
				</xsl:if>
			</xsl:if>
		</table>
	</xsl:template>

	<xsl:template name="ZeilePerson">
		<xsl:if test="count(abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true'])>2">
			<table id="Tabelle_nicht_unten" width="100%">
				<colgroup>
					<col width="3%"/>
					<col width="90%"/>
					<col width="10%"/>
				</colgroup>
				<tr>
					<td id="Titel"></td>
					<td id="Titel">Weiterer Betriebsinhaber</td>
					<td/>
				</tr>
			</table>
			<xsl:for-each select="abf:BetriebsinhVerantwPerson[abf:IndicatorBetriebsinhaber='true']">
				<xsl:if test="position()>2">
					<xsl:call-template name="ONE_PERSON"/>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
		<xsl:choose>
			<xsl:when test="count(abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')])>2">
				<table id="Tabelle_nicht_unten" width="100%">
					<colgroup>
						<col width="3%"/>
						<col width="90%"/>
						<col width="10%"/>
					</colgroup>
					<tr>
						<td id="Titel"></td>
						<td id="Titel">Weitere für die Leitung und Beaufsichtigung des Betriebes verantwortliche Person</td>
						<td/>
					</tr>
				</table>
				<xsl:for-each select="abf:BetriebsinhVerantwPerson[not(abf:IndicatorBetriebsinhaber='true')]">
					<xsl:if test="position()>2">
						<xsl:call-template name="ONE_PERSON"/>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<table id="Tabelle_nicht_oben" width="100%">
					<tbody>
						<tr>
							<th></th>
						</tr>
					</tbody>
				</table>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>	
	
	<xsl:template name="ONE_PERSON">
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="48%"/>
							<col width="49%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Titel_klein">Name</td>
							<td id="Titel_klein">Vorname</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Name"/>
								&#173;
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Vorname"/>
							</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="15%"/>
							<col width="82%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Titel_klein">Geburtsdatum</td>
							<td id="Titel_klein">Geburtsort</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Aktuell">
								<xsl:call-template name="formatDate">
									<xsl:with-param name="date" select="abf:Geburtsdatum"/>
								</xsl:call-template>
								&#173;
							</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Geburtsort1"/>
								&#173;
								<xsl:value-of select="abf:Geburtsort2"/>
							</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="55%"/>
							<col width="10%"/>
							<col width="12%"/>
							<col width="20%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Titel_klein">Führungszeugnis (Belegart OG)</td>
							<td id="Titel_klein">Beantragt am:</td>
							<td id="Aktuell">
								<xsl:call-template name="formatDate">
									<xsl:with-param name="date" select="abf:UnterlagenPerson/abf:DatumAntragFuehrungszeugnis"/>
								</xsl:call-template>
							</td>
							<td id="Titel_klein">Wird unmittelbar an<br/>die Behörde übersandt.</td>
						</tr>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Titel_klein">Personenbezogene Auskunft aus dem Gewerbezentralregister (Belegart 9)</td>
							<td id="Titel_klein">Beantragt am:</td>
							<td id="Aktuell">
								<xsl:call-template name="formatDate">
									<xsl:with-param name="date" select="abf:UnterlagenPerson/abf:DatumAntragGewerbezentralregister"/>
								</xsl:call-template>
							</td>
							<td id="Titel_klein">Wird unmittelbar an<br/>die Behörde übersandt.</td>
						</tr>
					</table>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="65%"/>
							<col width="32%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein"></td>
							<td id="Titel_klein">Ein Nachweis der Fachkunde ist beigefügt.</td>
							<td id="Aktuell">
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:UnterlagenPerson/abf:DokumentFachkunde/abf:IndicatorDokument'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>
