<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
    xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
    xmlns:osci="http://www.osci.de/2002/04/osci" 
    xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/" 
    xmlns:xenc="http://www.w3.org/2001/04/xmlenc#" 
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
    xsi:schemaLocation="http://schemas.xmlsoap.org/soap/envelope/ soapResponseToStoreDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd"
	xmlns:b64="xalan://de.itu.util.Base64" 
	xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
	xmlns:x509="xalan://de.itu.util.X509CertHelper"
	extension-element-prefixes="b64 crc32 x509" 
	exclude-result-prefixes="xsl ds b64 crc32 x509">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<xsl:param name="positionsnummer"/>
	<xsl:param name="register" select="0"/>
	<xsl:param name="nameXML"/>
	<xsl:template match="/">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="soap:Envelope">
		<html>
			<head>
				<title>OSCI-Quittung</title>
				<!-- CSS - Datei   -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf">
         			</xsl:call-template>
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr>
						<th>
							<xsl:for-each select="soap:Header">
								<xsl:call-template name="Zeile0"/>
								<xsl:call-template name="Zeile1"/>
								<xsl:call-template name="Zeile2"/>
								<xsl:call-template name="Zeile3"/>
								<!--xsl:call-template name="Zeile4"/-->
							</xsl:for-each>
						</th>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="Zeile0">
		<table width="100%" border="0">
			<tr>
				<td>
					<font id="Nummer">
				OSCI-Quittung
				</font>
				</td>
			</tr>
			<tr height="3%">
				<td/>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile1">
		<table width="100%" border="0">
			<tr height="10">
				<td>
			
			</td>
			</tr>
			<tr width="100%">
					<td width="20%" id="Titel">Conversation ID</td>
					<td width="80%" id="Aktuell_notu"><xsl:value-of select="osci:ControlBlock/@ConversationId"/></td>
			</tr>
			<!--tr width="100%">
					<td width="20%" id="Titel">osci:Response</td>
					<xsl:variable name="msgID" select="osci:ControlBlock/osci:Response"/>
					<xsl:variable name="msgIDDC">
						<xsl:if test="string-length($msgID)>0">
							<xsl:value-of select="b64:decodeToString($msgID)"/>
						</xsl:if>
					</xsl:variable>
					<td width="80%" id="Aktuell_notu"><xsl:value-of select="$msgIDDC"/></td>
			</tr-->
			<tr width="100%">
					<td width="20%" id="Titel">Message ID</td>
					<xsl:variable name="msgID" select="osci:responseToStoreDelivery/osci:ProcessCardBundle/osci:MessageId"/>
					<xsl:variable name="msgIDDC">
						<xsl:if test="string-length($msgID)>0">
							<xsl:value-of select="b64:decodeToString($msgID)"/>
						</xsl:if>
					</xsl:variable>
					<td width="80%" id="Aktuell_notu"><xsl:value-of select="$msgIDDC"/></td>
			</tr>
			<tr width="100%">
					<td width="20%" id="Titel">Betreff (Subject)</td>
					<td width="80%" id="Aktuell_notu"><xsl:value-of select="//osci:Subject"/></td>
			</tr>
			<tr width="100%">
					<td width="20%" id="Titel">Absender (aus Subject)</td>
					<td width="80%" id="Aktuell_notu">
						<xsl:value-of select="substring(//osci:Subject,17,9)"/>
							&#173;
						<xsl:value-of select="substring(//osci:Subject,26,1)"/>
							&#173;
						<xsl:value-of select="substring(//osci:Subject,27,6)"/>
					</td>
			</tr>
			<tr width="100%">
					<td width="20%" id="Titel">Empfänger (aus Subject)</td>
					<td width="80%" id="Aktuell_notu">
						<xsl:value-of select="substring(//osci:Subject,1,9)"/>
							&#173;
						<xsl:value-of select="substring(//osci:Subject,10,1)"/>
							&#173;
						<xsl:value-of select="substring(//osci:Subject,11,6)"/>
					</td>
			</tr>
			<tr width="100%">
					<td width="20%" id="Titel">Nachrichtentyp (aus Subject)</td>
					<td width="80%" id="Aktuell_notu">
						<xsl:value-of select="substring(//osci:Subject,33,3)"/>
							&#173;
						<xsl:value-of select="substring(//osci:Subject,36,14)"/>
							&#173;
						<xsl:value-of select="substring(//osci:Subject,50,1)"/>
							&#173;
						<xsl:value-of select="substring(//osci:Subject,51)"/>
					</td>
			</tr>
			<tr width="100%">
					<td width="20%" id="Titel">Datum (osci:Creation)</td>
					<td width="80%" id="Aktuell_notu">
						<xsl:call-template name="formatDate">
							<xsl:with-param name="date" select="osci:responseToStoreDelivery/osci:ProcessCardBundle/osci:ProcessCard/osci:Creation/osci:Plain"/>
						</xsl:call-template>
						&#173;
						<xsl:call-template name="formatTime">
							<xsl:with-param name="date" select="osci:responseToStoreDelivery/osci:ProcessCardBundle/osci:ProcessCard/osci:Creation/osci:Plain"/>
						</xsl:call-template>
					</td>
			</tr>
			<tr width="100%">
					<td width="20%" id="Titel">Datum (RecentModification)</td>
					<td width="80%" id="Aktuell_notu">
						<xsl:call-template name="formatDate">
							<xsl:with-param name="date" select="osci:responseToStoreDelivery/osci:ProcessCardBundle/osci:ProcessCard/@RecentModification"/>
						</xsl:call-template>
						&#173;
						<xsl:call-template name="formatTime">
							<xsl:with-param name="date" select="osci:responseToStoreDelivery/osci:ProcessCardBundle/osci:ProcessCard/@RecentModification"/>
						</xsl:call-template>
					</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile2">
		<!--table width="100%" border="0"-->
			<table width="100%" border="0">
				<tr height="10">
					<td/>
				</tr>
				<tr>
					<td>
						<font id="Nummer2">
					Transport-Zertifikate (osci:Inspection)
					</font>
					&#173;
						<font id="Titel">
					(aus der OSCI-Quittung geht nicht hervor, welches das Empfänger- und welches das Absender-Zertifikat ist)
					</font>
					</td>
				</tr>
			</table>
			<table width="100%" border="0">
				<tr width="100%">
						<td width="20%" id="Titel">Name laut Zertifikat</td>
						<td width="20%" id="Titel">Organisation laut Zertifikat</td>
						<td width="20%" id="Titel">Herausgeber des Zertifikats</td>
						<td width="18%" id="Titel">Zeitpunkt der Prüfung</td>
						<td width="8%" id="Titel">Signaturprüfung</td>
						<td width="8%" id="Titel">Offlineprüfung</td>
						<td width="7%" id="Titel">Onlineprüfung</td>
						<!--td width="8%" id="Titel">Seriennummer</td-->
				</tr>
				<xsl:for-each select="//osci:Inspection">
					<tr width="100%">
							<td width="20%" id="Aktuell_notu">
								<xsl:variable name="sName">
									<xsl:value-of select="substring-before(substring-after(osci:X509SubjectName,'CN='),'=')"/>
								</xsl:variable>
								<xsl:if test="string-length($sName)>0">
									<xsl:variable name="sName1">
										<xsl:value-of select="substring($sName,1, string-length($sName)-2)"/>
									</xsl:variable>
									<xsl:choose>
										<xsl:when test="substring($sName1,string-length($sName1))=','">
											<xsl:value-of select="substring($sName1,1, string-length($sName1)-1)"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$sName1"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:if>
								<!--xsl:value-of select="substring-before(substring-after(osci:X509SubjectName,'CN='),',')"/-->
							</td>
							<td width="20%" id="Aktuell_notu">
								<xsl:variable name="sName">
									<xsl:value-of select="substring-before(substring-after(osci:X509SubjectName,'O='),'=')"/>
								</xsl:variable>
								<xsl:if test="string-length($sName)>0">
									<xsl:variable name="sName1">
										<xsl:value-of select="substring($sName,1, string-length($sName)-2)"/>
									</xsl:variable>
									<xsl:choose>
										<xsl:when test="substring($sName1,string-length($sName1))=','">
											<xsl:value-of select="substring($sName1,1, string-length($sName1)-1)"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$sName1"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:if>
								<!--xsl:value-of select="substring-before(substring-after(osci:X509SubjectName,'O='),',')"/-->
							</td>
							<td width="20%" id="Aktuell_notu">
								<xsl:variable name="sName">
									<xsl:value-of select="substring-before(substring-after(osci:X509IssuerName,'CN='),'=')"/>
								</xsl:variable>
								<xsl:if test="string-length($sName)>0">
									<xsl:variable name="sName1">
										<xsl:value-of select="substring($sName,1, string-length($sName)-2)"/>
									</xsl:variable>
									<xsl:choose>
										<xsl:when test="substring($sName1,string-length($sName1))=','">
											<xsl:value-of select="substring($sName1,1, string-length($sName1)-1)"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$sName1"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:if>
								<!--xsl:value-of select="substring-before(substring-after(osci:X509IssuerName,'CN='),',')"/-->
							</td>
							<td width="18%" id="Aktuell_notu">
								<xsl:call-template name="formatDate">
									<xsl:with-param name="date" select="osci:Timestamp/osci:Plain"/>
								</xsl:call-template>
								&#173;
								<xsl:call-template name="formatTime">
									<xsl:with-param name="date" select="osci:Timestamp/osci:Plain"/>
								</xsl:call-template>
							</td>
							<td width="8%" id="Aktuell_notu"><xsl:value-of select="osci:MathResult/@Result"/></td>
							<td width="8%" id="Aktuell_notu"><xsl:value-of select="osci:OfflineResult/@Result"/></td>
							<td width="7%" id="Aktuell_notu"><xsl:value-of select="osci:OnlineResult/@Result"/></td>
							<!--td width="8%" id="Aktuell_notu"><xsl:value-of select="osci:X509SerialNumber"/></td-->
					</tr>
				</xsl:for-each>
			</table>
		<!--/table-->
	</xsl:template>
	<xsl:template name="Zeile3">
		<!--table width="100%" border="0"-->
			<table width="100%" border="0">
				<tr height="10">
					<td/>
				</tr>
				<tr>
					<td>
						<font id="Nummer2">
					Meldungen (osci:Entry)
					</font>
					</td>
				</tr>
			</table>
			<table width="100%" border="0">
				<tr width="100%">
						<td width="10%" id="Titel">Code</td>
						<td width="90%" id="Titel">Text</td>
				</tr>
				<xsl:for-each select="//osci:Entry">
					<tr width="100%">
							<td width="10%" id="Aktuell_notu"><xsl:value-of select="osci:Code"/></td>
							<td width="90%" id="Aktuell_notu"><xsl:value-of select="osci:Text"/></td>
					</tr>
				</xsl:for-each>
			</table>
		<!--/table-->
	</xsl:template>
	<xsl:template name="Zeile4">
		<!--table width="100%" border="0"-->
			<table width="100%" border="0">
				<tr height="10">
					<td/>
				</tr>
				<tr>
					<td>
						<font id="Nummer2">
					Signiert durch fortgeschrittenes OSCI-Manager-Zertifikat
					</font>
					</td>
				</tr>
			</table>
			<table width="100%" border="0">
				<tr width="100%">
						<td width="20%" id="Titel">Name aus Zertifikat</td>
						<td width="80%" id="Aktuell_notu"><xsl:value-of select="x509:extractCommonName(b64:decode(osci:IntermediaryCertificates/osci:SignatureCertificateIntermediary/ds:X509Data/ds:X509Certificate))"/></td>
				</tr>
			</table>
		<!--/table-->
	</xsl:template>
</xsl:stylesheet>
