<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
 	xmlns:msg="uri:BMU_Waste_Interface/Message" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns:reg="uri:BMU_Waste_Interface/Reg" 
	xmlns:bgs="uri:BMU_Waste_Interface/BGS" 
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:xades="http://uri.etsi.org/01903/v1.3.2#"
	xmlns:b64="xalan://de.itu.util.Base64" 
	xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
	xmlns:x509="xalan://de.itu.util.X509CertHelper" 
	extension-element-prefixes="b64 crc32 x509" 
	exclude-result-prefixes="xsl lib ds reg b64 crc32 x509 xades">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:import href="bgs_exzerpt_ra.xsl"/>
	<xsl:import href="bgs_ra.xsl"/>
	<xsl:output method="html"/>
	<xsl:param name="positionsnummer" select="1"/>
    <xsl:param name="positionsnummerCharge" select="0"/>
    <xsl:param name="positionsnummerUNS" select="0"/>
	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="msg:Nachricht">
				<xsl:for-each select="msg:Nachricht/msg:Nutzdaten">
					<xsl:apply-templates/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
    <xsl:template match="reg:RegisterAuszug">
	   <xsl:choose>
           <xsl:when test="$positionsnummerCharge=-1">
               <xsl:choose>
                   <xsl:when test="count(descendant::reg:BGSExzerpt) > 0 or count(descendant::reg:UNSExzerpt) > 0">
                       <xsl:call-template name="BGSExzerptAll"/>
                   </xsl:when>
                   <xsl:otherwise>
                       <xsl:call-template name="BGSOrgDokAll"/>
                   </xsl:otherwise>
               </xsl:choose>
           </xsl:when>
	       <xsl:when test="$positionsnummerCharge=0">
			<html>
				<head>
					<title>Registerauszug</title>
					<!-- CSS - Datei   -->
					<xsl:call-template name="Style"/>
				</head>
				<body>
					<xsl:call-template name="Kopf"/>
					<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
						<tr>
							<th>
								<xsl:for-each select="//reg:RegisterAuszug">
									<xsl:call-template name="ZeileRA1"/>
									<xsl:call-template name="ZeileRAD"/>
									<xsl:for-each select="reg:RegisterAnforderung">
										<xsl:call-template name="Zeile0"/>
										<xsl:call-template name="Zeile1"/>
										<xsl:call-template name="Zeile2"/>
										<xsl:call-template name="Zeile3"/>
										<xsl:call-template name="Zeile4"/>
										<xsl:call-template name="Zeile5"/>
										<xsl:call-template name="Zeile6"/>
										<xsl:call-template name="Zeile7"/>
									</xsl:for-each>
								</xsl:for-each>
							</th>
						</tr>
					</table>
				</body>
			</html>
           </xsl:when>
           <xsl:otherwise>
			   <xsl:for-each select="descendant::reg:Charge[$positionsnummerCharge]">
				   <xsl:choose>
						<xsl:when test="$positionsnummerUNS = 0">
							<xsl:choose>
								<xsl:when test="reg:BGSmitUNS">
									<xsl:for-each select="reg:BGSmitUNS/reg:BGS">
										<xsl:choose>
											<xsl:when test="contains(local-name(*), 'Exzerpt')">
												<xsl:call-template name="BGSExzerpt"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:call-template name="BGSOrgDok"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:for-each>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="contains(local-name(*/*), 'Exzerpt')">
											<xsl:call-template name="BGSExzerpt"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:call-template name="BGSOrgDok"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="reg:BGSmitUNS">
									<xsl:for-each select="descendant::reg:UNS[$positionsnummerUNS]">
										<xsl:choose>
											<xsl:when test="contains(local-name(*), 'Exzerpt')">
												<xsl:call-template name="BGSExzerpt"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:call-template name="BGSOrgDok"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:for-each>
								</xsl:when>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
			   </xsl:for-each>
           </xsl:otherwise>		
        </xsl:choose>
	</xsl:template>
	<xsl:template name="ZeileRA1">
		<table width="100%" border="0">
			<tr>
				<td>
					<font id="Nummer">
				Registerauszug
				</font>
				</td>
			</tr>
			<tr height="3%">
				<td/>
			</tr>
		</table>
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr>
				<td id="Titel" width="25%"> Nummer Teilauszug: </td>
				<td width="25%">
					<font id="Aktuell">
						<xsl:value-of select="reg:LfdNrTeilauszug"/>
					</font>
				</td>
				<td id="Titel" width="25%"> Anzahl der Teilauszüge: </td>
				<td width="25%">
					<font id="Aktuell">
						<xsl:value-of select="reg:AnzahlTeilauszuege"/>
					</font>
				</td>
			</tr>
		</table>
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr>
				<td id="Titel" width="25%"> Anzahl BGS mit UNS: </td>
				<td width="25%">
					<font id="Aktuell">
						<xsl:value-of select="count(reg:Auszug/reg:Charge/reg:BGSmitUNS)"/>
					</font>
				</td>
				<td id="Titel" width="25%"> Anzahl der UNS zu den BGS: </td>
				<td width="25%">
					<font id="Aktuell">
						<xsl:value-of select="count(reg:Auszug/reg:Charge/reg:BGSmitUNS/reg:UNS)"/>
					</font>
				</td>
			</tr>
		</table>
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr>
				<td id="Titel" width="25%"> Anzahl nur BGS: </td>
				<td width="75%">
					<font id="Aktuell">
						<xsl:value-of select="count(reg:Auszug/reg:Charge/reg:BGSsolo)"/>
					</font>
				</td>
			</tr>
		</table>
		<table id="tabelle" width="100%" border="0">
			<tr>
				<td id="Titel" width="25%"> Anzahl nur UNS: </td>
				<td width="75%">
					<font id="Aktuell">
						<xsl:value-of select="count(reg:Auszug/reg:Charge/reg:UNSsolo)"/>
					</font>
				</td>
			</tr>
		</table>
		<table>
			<tr height="2">
				<td/>
			</tr>
		</table>
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr>
				<td id="Titel" width="50%"> Rechtsverbindliche Unterschrift (1. Signatur) </td>
				<td id="Titel" width="50%"> Rechtsverbindliche Unterschrift (2. Signatur) </td>
			</tr>
		</table>
		<table id="tabelle_nicht_oben" width="100%" border="0">
			<tr>
				<td width="50%">
					<font id="Aktuell">
						<xsl:if test="ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate">
 							<xsl:value-of select="x509:extractCommonName(b64:decode(ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
							<xsl:variable name="SIG_DATE">
								<xsl:call-template name="formatDate">
									<xsl:with-param name="date" select="ds:Signature[1]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
								</xsl:call-template>
							</xsl:variable>
 							<xsl:value-of select="concat(' (', $SIG_DATE, ')')"/>
							<!--xsl:value-of select="concat(x509:extractCommonName(b64:decode(ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate)), &#173;, ' (', $SIG_DATE, ')')"/-->
						</xsl:if>
					</font>
				</td>
				<td width="50%">
					<font id="Aktuell">
						<xsl:if test="ds:Signature[2]/ds:KeyInfo/ds:X509Data/ds:X509Certificate">
							<xsl:value-of select="x509:extractCommonName(b64:decode(ds:Signature[2]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
							<xsl:variable name="SIG_DATE">
								<xsl:call-template name="formatDate">
									<xsl:with-param name="date" select="ds:Signature[2]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
								</xsl:call-template>
							</xsl:variable>
 							<xsl:value-of select="concat(' (', $SIG_DATE, ')')"/>
						</xsl:if>
					</font>
				</td>
			</tr>
		</table>


	</xsl:template>
	<xsl:template name="ZeileRAD">
		<table width="100%" border="0">
			<tr>
				<td>
					<font id="Nummer">
				Deckblatttyp
				</font>
				</td>
			</tr>
			<tr height="3%">
				<td/>
			</tr>
		</table>
		<xsl:choose>
			<xsl:when test="reg:Auszug/reg:Deckblatt/en:ENSNDokument">
				<table id="tabelle" width="100%" border="0">
					<tr>
						<td id="Nummer2" width="100%"> Einzelner Entsorgungsnachweis (EN oder SN) - (ENSNDokument)</td>
					</tr>
				</table>
			</xsl:when>
			<xsl:when test="reg:Auszug/reg:Deckblatt/reg:ENSNExzerpt">
				<table id="tabelle" width="100%" border="0">
					<tr>
						<td id="Nummer2" width="100%"> Auszug aus der obersten Sicht eines Nachweises (ENSNExzerpt)</td>
					</tr>
					<xsl:for-each select="reg:Auszug/reg:Deckblatt/reg:ENSNExzerpt">
						<tr>
							<td>
								<font id="Titel">Nachweisnummer: </font>
								&#173;
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'en:ENSNNummer/lib:NachweisNr'"/>
								</xsl:call-template>
								&#173;
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'en:ENSNNummer/lib:Pruefziffer'"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel">Gültigkeitszeitraum: </font>
								&#173;
								<font id="titel">von: </font>
								<xsl:call-template name="getDateValue">
									<xsl:with-param name="TagName" select="'en:ZeitraumGueltig/en:GueltigVon'"/>
								</xsl:call-template>
								&#173;
								<font id="titel">bis: </font>
								<xsl:call-template name="getDateValue">
									<xsl:with-param name="TagName" select="'en:ZeitraumGueltig/en:GueltigBis'"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel">Erzeugernummer: </font>
								&#173;
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'en:ErzeugerNrVE/lib:BehoerdlicheNr'"/>
								</xsl:call-template>
								&#173;
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'en:ErzeugerNrVE/lib:Pruefziffer'"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel">Abfallschlüssel: </font>
								&#173;
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'en:Abfall'"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel">Genehmigte Menge: </font>
								&#173;
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'en:MengeGenehmigt'"/>
								</xsl:call-template>
								&#173;
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'en:MengeGenehmigt'"/>
									<xsl:with-param name="TagAttr" select="'@lib:Einheit'"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Titel">Entsorgernummer: </font>
								&#173;
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'en:EntsorgerNrAE/lib:BehoerdlicheNr'"/>
								</xsl:call-template>
								&#173;
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'en:EntsorgerNrAE/lib:Pruefziffer'"/>
								</xsl:call-template>
							</td>
						</tr>
					</xsl:for-each>
				</table>
			</xsl:when>
			<xsl:when test="reg:Auszug/reg:Deckblatt/en:ENSNVorlageLayerRE">
				<table id="tabelle" width="100%" border="0">
					<tr>
						<td id="Nummer2" width="100%"> Spezielles freies Layer für Register (ENSNVorlageLayerRE)</td>
					</tr>
				</table>
			</xsl:when>
			<xsl:when test="reg:Auszug/reg:Deckblatt/reg:IndikatorAbfallartKleinmenge">
				<table id="tabelle" width="100%" border="0">
					<tr>
						<td id="Nummer2" width="100%"> Kleinmengenregister ohne Deckblatt (§24 Abs. 3 NachwV) </td>
					</tr>
				</table>
			</xsl:when>
			<xsl:when test="reg:Auszug/reg:Deckblatt/reg:AbfallartUNSvonSammler ">
				<table id="tabelle" width="100%" border="0">
					<tr>
						<td id="Nummer2" width="100%"> UNS liegen aus Sammelentsorgung vor (nur für Erzeuger), kein Deckblatt ($24 Abs. 3 NachwV) </td>
					</tr>
				</table>
			</xsl:when>
			<xsl:when test="reg:Auszug/reg:Deckblatt/reg:IndicatorRegisterPapier ">
				<table id="tabelle" width="100%" border="0">
					<tr>
						<td id="Nummer2" width="100%"> Der angeforderte Auszug des Registers wird ganz oder teilweise in Papierform an die Behörde übermittelt </td>
					</tr>
				</table>
			</xsl:when>
			<xsl:when test="reg:Auszug/reg:Deckblatt/reg:IndicatorKeinAbfallstromVorhanden">
				<table id="tabelle" width="100%" border="0">
					<tr>
						<td id="Nummer2" width="100%"> Zur Registeranfrage liegt kein Abfallstrom vor </td>
					</tr>
				</table>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Zeile0">
		<table width="100%" border="0">
			<tr>
				<td>
					<font id="Nummer">
				Registeranforderung
				</font>
				</td>
			</tr>
			<tr height="3%">
				<td/>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile1">
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr>
				<td id="Titel"> Nummer Teilanforderung </td>
				<td id="Titel"> Registerauszugsnummer </td>
				<td id="Titel"> Zeitraum</td>
			</tr>
			<tr>
				<td>
					<font id="Aktuell">
						<xsl:value-of select="reg:LfdNrTeilanforderung"/>
					</font>
				</td>
				<td>
					<font id="Aktuell">
						<xsl:value-of select="reg:Registerauszugsnummer"/>
					</font>
				</td>
				<td>
					<font id="Text_kleiner ">von: </font>
					<font id="Aktuell">
						<xsl:call-template name="formatDate">
							<xsl:with-param name="date">
								<xsl:value-of select="reg:Zeitraum/reg:Anfang"/>
							</xsl:with-param>
						</xsl:call-template>
					</font>
					<font id="Text_kleiner ">      bis: </font>
					<font id="Aktuell">
						<xsl:call-template name="formatDate">
							<xsl:with-param name="date">
								<xsl:value-of select="reg:Zeitraum/reg:Ende"/>
							</xsl:with-param>
						</xsl:call-template>
					</font>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile2">
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr height="10">
				<td/>
			</tr>
			<tr align="left">
				<td id="Ueberschrift2"> Adressat </td>
			</tr>
			<tr width="100%">
				<td width="20%" id="Titel"> Beh&#246;rdlicheNummer </td>
				<td width="80%" id="Titel"></td>
			</tr>
			<tr width="100%">
				<td width="20%">
					<font id="Aktuell">
						<xsl:value-of select="reg:Addressat/reg:BehoerdlicheNummer"/>
						<xsl:value-of select="' '"/>
						<xsl:value-of select="reg:Addressat/reg:BehoerdlicheNummer/@lib:ATBRolle"/>
					</font>
				</td>
				<td width="80%">
					<font id="Aktuell">
					</font>
				</td>
			</tr>
		</table>
		<xsl:call-template name="NameUndAdresse">
			<xsl:with-param name="prefix" select="reg:Addressat/reg:NameUndAdresse"/>
			<xsl:with-param name="table_width" select="40"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="Zeile3">
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr height="10">
				<td/>
			</tr>
			<tr align="left">
				<td id="Ueberschrift2"> Filterkriterien </td>
				<xsl:for-each select="reg:FilterKriterien">
					<xsl:choose>
						<xsl:when test="reg:AND">
							<xsl:call-template name="Filterkriterien">
								<xsl:with-param name="parameter" select="'and'"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="reg:OR">
							<xsl:call-template name="Filterkriterien">
								<xsl:with-param name="parameter" select="'or'"/>
							</xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</xsl:for-each>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile4">
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr height="10">
				<td/>
			</tr>
			<tr>
				<td id="Titel"> Lieferfrist </td>
				<td id="Titel"> Exzerpte </td>
			</tr>
			<tr>
				<td>
					<font id="Aktuell">
						<xsl:call-template name="formatDate">
							<xsl:with-param name="date">
								<xsl:value-of select="reg:Lieferfrist"/>
							</xsl:with-param>
						</xsl:call-template>
					</font>
				</td>
				<td>
					<font id="Aktuell">
						<xsl:if test="reg:IndicatorVerzeichnisNachwpfl = 'true'">
						ja
						</xsl:if>
						<xsl:if test="reg:IndicatorVerzeichnisNachwpfl = 'false'">
						nein
						</xsl:if>
					</font>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile5">
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr height="10">
				<td/>
			</tr>
			<tr align="left">
				<td id="Ueberschrift2"> Behörde </td>
			</tr>
		</table>
		<xsl:call-template name="NameUndAdresse">
			<xsl:with-param name="prefix" select="reg:Behoerde/reg:NameUndAdresse"/>
			<xsl:with-param name="table_width" select="40"/>
		</xsl:call-template>
		<xsl:call-template name="Ansprechpartner">
			<xsl:with-param name="prefix" select="reg:Behoerde/reg:Ansprechpartner"/>
			<xsl:with-param name="table_width" select="40"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="Zeile6">
	</xsl:template>
	<xsl:template name="Zeile7">
		<xsl:if test="reg:Rechtsbehelfsbelehrung or reg:Erklaerung">
			<table id="tabelle_nicht_oben_unten" width="100%" border="0">
				<tr height="10">
					<td/>
				</tr>
				<xsl:if test="reg:Rechtsbehelfsbelehrung">
					<table id="tabelle" width="100%" border="0">
						<tr width="100%">
							<td width="100%" id="Titel"> Rechtsbehelfsbelehrung </td>
						</tr>
						<tr width="100%">
							<td width="100%">
								<font id="Aktuell">
									<xsl:value-of select="reg:Rechtsbehelfsbelehrung"/>
								</font>
							</td>
						</tr>
					</table>
				</xsl:if>
				<xsl:if test="reg:Erklaerung">
					<table id="tabelle_nicht_oben" width="100%" border="0">
						<tr width="100%">
							<td width="33%" id="Titel"> Ort </td>
							<td width="33%" id="Titel"> Datum </td>
							<td width="33%" id="Titel"> Name </td>
						</tr>
						<tr width="100%">
							<td width="33%">
								<font id="Aktuell">
									<xsl:value-of select="reg:Erklaerung/lib:Ort"/>
								</font>
							</td>
							<td width="33%">
								<font id="Aktuell">
									<xsl:call-template name="formatDate">
										<xsl:with-param name="date">
											<xsl:value-of select="reg:Erklaerung/lib:Datum"/>
										</xsl:with-param>
									</xsl:call-template>
								</font>
							</td>
							<td width="33%">
								<font id="Aktuell">
									<xsl:value-of select="reg:Erklaerung/lib:Name"/>
								</font>
							</td>
						</tr>
					</table>
				</xsl:if>
			</table>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Filterkriterien">
		<xsl:param name="parameter"/>
		<xsl:choose>
			<xsl:when test="$parameter = 'and'">
				<tr width="100%">
					<td valign="top" width="20%" id="Text_kleiner">UND-Verknüpfung:</td>
					<td width="80%" align="left">
						<xsl:call-template name="ausgabe_AND"/>
					</td>
				</tr>
				<xsl:for-each select="reg:AND">
					<xsl:if test="reg:OR">
						<xsl:call-template name="Filterkriterien">
							<xsl:with-param name="parameter" select="'or'"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="reg:AND">
						<xsl:call-template name="Filterkriterien">
							<xsl:with-param name="parameter" select="'and'"/>
						</xsl:call-template>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="$parameter = 'or'">
				<tr width="100%">
					<td valign="top" width="20%" id="Text_kleiner">ODER-Verknüpfung:</td>
					<td width="80%" align="left">
						<xsl:call-template name="ausgabe_OR"/>
					</td>
				</tr>
				<xsl:for-each select="reg:OR">
					<xsl:if test="reg:OR">
						<xsl:call-template name="Filterkriterien">
							<xsl:with-param name="parameter" select="'or'"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="reg:AND">
						<xsl:call-template name="Filterkriterien">
							<xsl:with-param name="parameter" select="'and'"/>
						</xsl:call-template>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="ausgabe_AND">
		<xsl:for-each select="reg:AND/reg:NachweisNummer">
			<font id="Aktuell"> 
					Nachweis Nummer: <xsl:value-of select="."/>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:for-each select="reg:AND/reg:BehoerdlicheNummerEntsorger">
			<font id="Aktuell"> 
					Beh&#246;rdliche Nummer Entsorger: <xsl:value-of select="."/>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:for-each select="reg:AND/reg:BehoerdlicheNummerBefoerderer">
			<font id="Aktuell"> 
					Beh&#246;rdliche Nummer Bef&#252;rderer: <xsl:value-of select="."/>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:for-each select="reg:AND/reg:BehoerdlicheNummerErzeuger">
			<font id="Aktuell"> 
					Beh&#246;rdliche Nummer Erzeuger: <xsl:value-of select="."/>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:for-each select="reg:AND/reg:BGSUNSNummer">
			<font id="Aktuell">
				<xsl:if test="reg:BGSNummer">
					BGS Nummer:  <xsl:value-of select="reg:BGSNummer"/>
				</xsl:if>
				<xsl:if test="reg:UNSNummer">
					UNS Nummer:  <xsl:value-of select="reg:UNSNummer"/>
				</xsl:if>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:for-each select="reg:AND/reg:Abfallschluesselnummer">
			<font id="Aktuell"> 
					Abfallschl&#252;sselnummer: <xsl:value-of select="."/>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:if test="reg:AND/reg:IndicatorGefaehrlich">
			<font id="Aktuell">
					Gef&#228;hrlich
			</font>
			<br/>
		</xsl:if>
		<xsl:if test="reg:AND/reg:IndicatorNichtGefaehrlich">
			<font id="Aktuell">
					Nicht Gef&#228;hrlich
			</font>
			<br/>
		</xsl:if>
		<xsl:if test="reg:AND/reg:IndicatorNachweispflichtig">
			<font id="Aktuell"> 
					Nachweispflichtig
			</font>
			<br/>
		</xsl:if>
		<xsl:if test="reg:AND/reg:IndicatorNichtNachweispflichtig">
			<font id="Aktuell"> 
					Nicht Nachweispflichtig
			</font>
			<br/>
		</xsl:if>
		<br/>
	</xsl:template>
	<xsl:template name="ausgabe_OR">
		<xsl:for-each select="reg:OR/reg:NachweisNummer">
			<font id="Aktuell"> 
					Nachweis Nummer: <xsl:value-of select="."/>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:for-each select="reg:OR/reg:BehoerdlicheNummerEntsorger">
			<font id="Aktuell"> 
					Beh&#246;rdliche Nummer Entsorger: <xsl:value-of select="."/>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:for-each select="reg:OR/reg:BehoerdlicheNummerBefoerderer">
			<font id="Aktuell"> 
					Beh&#246;rdliche Nummer Bef&#252;rderer: <xsl:value-of select="."/>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:for-each select="reg:OR/reg:BehoerdlicheNummerErzeuger">
			<font id="Aktuell"> 
					Beh&#246;rdliche Nummer Erzeuger: <xsl:value-of select="."/>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:for-each select="reg:OR/reg:BGSUNSNummer">
			<font id="Aktuell">
				<xsl:if test="reg:BGSNummer">
					BGS Nummer:  <xsl:value-of select="reg:BGSNummer"/>
				</xsl:if>
				<xsl:if test="reg:UNSNummer">
					UNS Nummer:  <xsl:value-of select="reg:UNSNummer"/>
				</xsl:if>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:for-each select="reg:OR/reg:Abfallschluesselnummer">
			<font id="Aktuell"> 
					Abfallschl&#252;sselnummer: <xsl:value-of select="."/>
			</font>
			<br/>
		</xsl:for-each>
		<xsl:if test="reg:OR/reg:IndicatorGefaehrlich">
			<font id="Aktuell">
					Gef&#228;hrlich
			</font>
			<br/>
		</xsl:if>
		<xsl:if test="reg:OR/reg:IndicatorNichtGefaehrlich">
			<font id="Aktuell">
					Nicht Gef&#228;hrlich
			</font>
			<br/>
		</xsl:if>
		<xsl:if test="reg:OR/reg:IndicatorNachweispflichtig">
			<font id="Aktuell"> 
					Nachweispflichtig
			</font>
			<br/>
		</xsl:if>
		<xsl:if test="reg:OR/reg:IndicatorNichtNachweispflichtig">
			<font id="Aktuell"> 
					Nicht Nachweispflichtig
			</font>
			<br/>
		</xsl:if>
		<br/>
	</xsl:template>
</xsl:stylesheet>
