/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.schema;

import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.schema.BMUSchemaResourceResolver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaValidator {
    private static final Log LOGGER = LogFactory.getLog(SchemaValidator.class);
    private static final int BUFFER_SIZE = 4096;
    private static final String SCHEMA_104A_FILE_PATH = "/de/consist/bmu/schema-1.04a/";
    private static final String SCHEMA_DT_FILE_PATH = "/de/consist/bmu/schema-dt/";
    private final String[] _schemaFileNames = new String[]{"Kataloge.xsd", "TypenBibliothek.xsd", "Begleitschein.xsd", "EN.xsd", "AGS.xsd", "ZKS.xsd", "Register.xsd", "Notifizierung.xsd", "Nachricht.xsd", "Regantrag_BetriebUmhang.xsd", "DA_XSD/DA_Teil_2_Anhang_E.xsd", "Eudin_XSD/user/maindoc/EUDINNotificationDocument-2.1.xsd", "Eudin_XSD/user/maindoc/EUDINCertificateOfWasteReceiptDocument-2.1.xsd", "Eudin_XSD/user/maindoc/EUDINCertificateOfWasteRecoveryDisposalDocument-2.1.xsd", "Eudin_XSD/user/maindoc/EUDINConfirmationOfMessageReceipt-2.1.xsd", "Eudin_XSD/user/maindoc/EUDINWasteMovementDocument-2.1.xsd", "Eudin_XSD/user/maindoc/EUDINWasteTransportStatement-2.1.xsd", "xmldsig-more-ecdsa.xsd", "xmldsig11-schema.xsd", "waste-shipment-guidelines-11/message.xsd", "waste-shipment-guidelines-11/notification.xsd", "waste-shipment-guidelines-11/wastemovement.xsd", "waste-shipment-guidelines-11/annex7.xsd", "waste-shipment-guidelines-11/basetypes.xsd", "waste-shipment-guidelines-11/codelists.xsd", "waste-shipment-guidelines-11/statement.xsd"};
    private final String _schemaDTFileName = "din-91379-datatypes.xsd";
    private static SchemaValidator _instance = new SchemaValidator();
    private Schema _schema_104a = null;
    private Schema _schema_dt = null;

    public SchemaValidator() {
        try {
            Source[] sources104a = new Source[this._schemaFileNames.length];
            for (int i = 0; i < this._schemaFileNames.length; ++i) {
                sources104a[i] = this.loadSchema(SCHEMA_104A_FILE_PATH, this._schemaFileNames[i]);
            }
            Source[] sourcesDt = new Source[this._schemaFileNames.length + 1];
            for (int i = 0; i < this._schemaFileNames.length; ++i) {
                sourcesDt[i] = this.loadSchema(SCHEMA_DT_FILE_PATH, this._schemaFileNames[i]);
            }
            sourcesDt[this._schemaFileNames.length] = this.loadSchema(SCHEMA_DT_FILE_PATH, "din-91379-datatypes.xsd");
            SchemaFactory schema104aFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema", "org.apache.xerces.jaxp.validation.XMLSchemaFactory", null);
            LOGGER.debug((Object)("Schema104aFactory: " + schema104aFactory.getClass().getName()));
            schema104aFactory.setResourceResolver(new BMUSchemaResourceResolver(SCHEMA_104A_FILE_PATH));
            schema104aFactory.setErrorHandler(new ValidationErrorHandler());
            SchemaFactory schemaDtFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema", "org.apache.xerces.jaxp.validation.XMLSchemaFactory", null);
            LOGGER.debug((Object)("SchemaDtFactory: " + schemaDtFactory.getClass().getName()));
            schemaDtFactory.setResourceResolver(new BMUSchemaResourceResolver(SCHEMA_DT_FILE_PATH));
            schemaDtFactory.setErrorHandler(new ValidationErrorHandler());
            try {
                DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                DOMImplementation impl = registry.getDOMImplementation("XML 1.0 LS");
                if (impl == null) {
                    LOGGER.error((Object)"DOM3 implementation not found!");
                } else {
                    LOGGER.debug((Object)("DOMImplementation: " + impl.getClass().getName()));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Fehler beim Initialisieren des Schemavalidator", (Throwable)e);
            }
            this._schema_104a = schema104aFactory.newSchema(sources104a);
            this._schema_dt = schemaDtFactory.newSchema(sourcesDt);
        }
        catch (SAXException e) {
            LOGGER.error((Object)"Error creating SchemaValidator", (Throwable)e);
        }
        catch (BMUException e) {
            LOGGER.error((Object)"Error creating SchemaValidator", (Throwable)e);
        }
    }

    public static SchemaValidator getInstance() throws BMUException {
        if (_instance == null) {
            _instance = new SchemaValidator();
        }
        return _instance;
    }

    public Schema getSchema() {
        return this._schema_104a;
    }

    public final ValidationErrorHandler validate(Element document) throws BMUException {
        return this.validate104a(document);
    }

    public final ValidationErrorHandler validate104a(Element document) throws BMUException {
        return this.validate(this._schema_104a, document);
    }

    public final ValidationErrorHandler validateDt(Element document) throws BMUException {
        return this.validate(this._schema_dt, document);
    }

    private final ValidationErrorHandler validate(Schema schema, Element document) throws BMUException {
        ValidationErrorHandler handler = null;
        try {
            Validator validator = schema.newValidator();
            LOGGER.debug((Object)("Validator: " + validator.getClass().getName()));
            handler = new ValidationErrorHandler();
            validator.setErrorHandler(handler);
            validator.validate(new DOMSource(document));
        }
        catch (SAXException e) {
            throw new BMUException("Schema validation error", e);
        }
        catch (IOException e) {
            throw new BMUException("Error loading schema", e);
        }
        return handler;
    }

    protected final Source loadSchema(String pathName, String schemaFileName) throws BMUException {
        StreamSource schemaSource = null;
        URL url = this.getClass().getResource(pathName + schemaFileName);
        if (url != null) {
            byte[] lResult = null;
            try {
                InputStream in;
                block6: {
                    in = this.getClass().getResourceAsStream(pathName + schemaFileName);
                    ByteArrayOutputStream baos = null;
                    try {
                        baos = new ByteArrayOutputStream();
                        byte[] buffer = new byte[4096];
                        int r = 0;
                        while ((r = in.read(buffer, 0, buffer.length)) > 0) {
                            baos.write(buffer, 0, r);
                        }
                        baos.flush();
                        baos.close();
                        lResult = baos.toByteArray();
                        schemaSource = new StreamSource(new ByteArrayInputStream(lResult));
                    }
                    catch (IOException e) {
                        if (baos == null) break block6;
                        baos.close();
                    }
                }
                in.close();
            }
            catch (IOException e) {
                throw new BMUException("Error loading schema", e);
            }
        }
        throw new BMUException("Schema not found: " + schemaFileName);
        return schemaSource;
    }

    public static String exceptionToString(SAXException e) {
        Object retVal = "";
        if (e instanceof SAXParseException) {
            SAXParseException e2 = (SAXParseException)e;
            retVal = e2.getMessage() + " (line " + Integer.toString(e2.getLineNumber()) + ", column " + Integer.toString(e2.getColumnNumber()) + ")";
        } else {
            retVal = e.getMessage();
        }
        return retVal;
    }

    public static class ValidationErrorHandler
    implements ErrorHandler {
        private static final int INT_10 = 10;
        private List<SAXParseException> _errorList = new ArrayList<SAXParseException>();
        private List<SAXParseException> _warningList = new ArrayList<SAXParseException>();

        public final List<SAXParseException> getErrorList() {
            return this._errorList;
        }

        public final List<SAXParseException> getWarningList() {
            return this._warningList;
        }

        @Override
        public final void error(SAXParseException arg0) throws SAXException {
            this._errorList.add(arg0);
            if (this._errorList.size() <= 10 && LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("<error>: " + SchemaValidator.exceptionToString(arg0)));
            }
        }

        @Override
        public final void fatalError(SAXParseException arg0) throws SAXException {
            LOGGER.info((Object)("<fatalError>: " + SchemaValidator.exceptionToString(arg0)), (Throwable)arg0);
            throw arg0;
        }

        @Override
        public final void warning(SAXParseException arg0) throws SAXException {
            this._warningList.add(arg0);
            if (this._warningList.size() <= 10 && LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("<warning>: " + SchemaValidator.exceptionToString(arg0)));
            }
        }
    }
}

