/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 08:24:11 +0000 (Fri, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplEncoding extends RuleImpl {

    private static final long serialVersionUID = 1L;
    
    private static final Log LOGGER = LogFactory.getLog(RuleImplEncoding.class);
    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplEncoding(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Input-Encoding: " + bmuDok.getDocument().getInputEncoding());
            LOGGER.debug("Xml-Encoding: " + bmuDok.getDocument().getXmlEncoding());
        }
        if (!"UTF-8".equalsIgnoreCase(bmuDok.getDocument().getXmlEncoding()) 
                || !"UTF-8".equalsIgnoreCase(bmuDok.getDocument().getInputEncoding())) {
            ruleResultList.add(new RuleResultImpl(getRuleDef(), 1, null));
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        return "Das Input-Encoding des Dokumentes muss 'UTF-8' sein.";
    }

}
