/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-01-19 01:50:18 +0100 (Sa, 19 Jan 2013) $ $Rev: 978 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.SignatureVerificationResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplSignatureECCProfile extends RuleImpl {

    private static final long serialVersionUID = 1L;

    /**
     * XPath fuer dsf:XPath.
     */
    private static final String XPATH_ECDSAKEYVALUE = "/descendant::" + Namespace.xmldsig_more.getPrefix() + ":ECDSAKeyValue";
    
    /**
     * Auswertung, ob ein Element ecsda:ExplicitParams vorhanden ist.
     */
    private static final String XPATH_ECDSAEXPLICITPARAMS = "count (/descendant::" + Namespace.xmldsig_more.getPrefix() + ":ExplicitParams) > 0";

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplSignatureECCProfile(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        NodeList nodeList;
        XPathFassade xpf = XPathFassade.getInstance();
        try {
            nodeList = xpf.evaluateNodeList(
                    bmuDok.getDocument(), XPATH_ECDSAKEYVALUE);
            
            int index = 1;
            for (int i = 0; i < nodeList.getLength(); i++) {
                Element keyNode = (Element) nodeList.item(i);
                String sigID = XPathFassade.getInstance().evaluate(keyNode, "ancestor::ds:Signature/@Id");
                SignatureVerificationResult svr = bmuDok.getMessageType()
                        .getSignatureVerificationResult(sigID);
                if (svr != null && svr.isEnabled(getRuleDef())) {
                    if (XPathFassade.getInstance().evalBool(
                            bmuDok.getDocument().getDocumentElement(),
                            XPATH_ECDSAEXPLICITPARAMS)) {
                        ruleResultList.add(new RuleResultImpl(
                                getRuleDef(), index++, sigID));
                    }
                }
            }
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        return ruleResultList;
    }
    
    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPath fr die Ermittlung der zu prfenden Inhalte: ");
        builder.append(XPATH_ECDSAKEYVALUE);
        return builder.toString();
    }

}
