/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 08:24:11 +0000 (Fri, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.SignatureVerificationResult;
import de.consist.bmu.rule.SignatureVerificationResult.VerificationStatus;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.xmlsec.XmlSecFassade;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * Pruefregel fuer die Signaturpruefung.
 * 
 * @author srossbroich
 * 
 */
public final class RuleImplSignatureVerificationRA extends RuleImpl {

    private static final long serialVersionUID = 1L;

    private static final Log LOGGER = LogFactory
            .getLog(RuleImplSignatureVerificationRA.class);

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplSignatureVerificationRA(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        RuleResult ruleResult = null;
        boolean valid = true;
        NodeList nodeList;
        try {
            nodeList = XPathFassade.getInstance().evaluateNodeList(
                    bmuDok.getDocument(),
                    "/descendant::reg:RegisterAuszug/ds:Signature");
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        int index = 1;
        for (int i = 0; i < nodeList.getLength(); i++) {
            Node sigNode = nodeList.item(i);
            String sigId = sigNode.getAttributes().getNamedItem("Id")
                    .getTextContent();
            try {
                valid = XmlSecFassade.getInstance().verifySignature(
                        bmuDok.getDocument(), sigId);
                SignatureVerificationResult svr = bmuDok.getMessageType()
                        .getSignatureVerificationResult(sigId);
                if (!valid) {
                    if (svr != null) {
                        svr.setVerificationStatus(VerificationStatus.INVALID);
                    }
                    ruleResult = new RuleResultImpl(this.getRuleDef(), index++,
                            sigId);
                    ruleResultList.add(ruleResult);
                } else if (svr != null) {
                    svr.setVerificationStatus(VerificationStatus.VALID);
                }
            } catch (Exception e) {
                LOGGER.error("Fehler bei der Prfung der Signaturen", e);
                ruleResult = new RuleResultImpl(this.getRuleDef(), index++,
                        sigId);
                ruleResultList.add(ruleResult);
            }
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        return "Die umschliessenden Signaturen des Registerauszugs werden mit der xmlsec-Implementierung von apache auf mathematische Unversehrtheit geprft.";
    }

}
